/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.cleaners;

import junit.framework.Assert;
import no.priv.garshol.duke.cleaners.NorwegianAddressCleaner;
import org.junit.Before;
import org.junit.Test;

public class NorwegianAddressCleanerTest {
    private NorwegianAddressCleaner cleaner;

    @Before
    public void setup() {
        this.cleaner = new NorwegianAddressCleaner();
    }

    @Test
    public void testEmpty() {
        this.test("", "");
    }

    @Test
    public void testVeienVeien() {
        this.test("grefsenveien 132", "grefsenveien 132");
    }

    @Test
    public void testVeienVnDot() {
        this.test("grefsenvn. 132", "grefsenveien 132");
    }

    @Test
    public void testVnVnDot() {
        this.test("grefsenvn. 132", "grefsenvn 132");
    }

    @Test
    public void testVeienVn() {
        this.test("grefsenvn. 132", "grefsenveien 132");
    }

    @Test
    public void testGtGata() {
        this.test("kanalgt 3", "kanalgata 3");
    }

    @Test
    public void testGtDotGata() {
        this.test("kanalgt. 3", "kanalgata 3");
    }

    @Test
    public void testGataGata() {
        this.test("kanalgata 3", "kanalgata 3");
    }

    @Test
    public void testGtDotGaten() {
        this.test("enerhauggt. 5", "enerhauggaten 5");
    }

    @Test
    public void testSpaceGtGate() {
        this.test("christian kroghs gt 42", "christian kroghs gate 42");
    }

    @Test
    public void testSpaceGtDotGate() {
        this.test("christian kroghs gt. 42", "christian kroghs gate 42");
    }

    @Test
    public void testBoksPostboks() {
        this.test("boks 367", "postboks 367");
    }

    @Test
    public void testBoksPostboksComma() {
        this.test("boks 1353 vika", "postboks 1353,vika");
    }

    @Test
    public void testPostboksPb() {
        this.test("postboks 2623 m\u00f8hlenpris", "pb 2623 m\u00f8hlenpris");
    }

    @Test
    public void testPostboksPbDot() {
        this.test("postboks 6258 etterstad", "pb. 6258 etterstad");
    }

    @Test
    public void testBoksCommaBoks() {
        this.test("boks 24, grefsen", "boks 24 grefsen");
    }

    @Test
    public void testPostboksDashPostboks() {
        this.test("postboks 124 - bryn", "postboks 124 bryn");
    }

    @Test
    public void testVeienVndotnospace() {
        this.test("\u00d8kernveien 38 b", "\u00d8kernvn.38 b");
    }

    @Test
    public void testNumberletterNumberspaceletter() {
        this.test("ammerudveien 31d", "ammerudveien 31 d");
    }

    @Test
    public void testSpaceVSpaceDigit() {
        this.test("cecilie thoresens v 5", "cecilie thoresens vei 5");
    }

    @Test
    public void testSpaceVDotSpaceDigit() {
        this.test("cecilie thoresens v. 5", "cecilie thoresens vei 5");
    }

    @Test
    public void testVDotSpaceDigit() {
        this.test("varnav. 32a", "varnaveien 32a");
    }

    @Test
    public void testSpaceGDotSpaceDigit() {
        this.test("eilert sundts g. 37", "eilert sundts gate 37");
    }

    @Test
    public void testSpaceGSpaceDigit() {
        this.test("eilert sundts g 37", "eilert sundts gate 37");
    }

    @Test
    public void testCareOfBackslash() {
        this.test("c/o advokat s. niik", "c\\o advokat s. niik");
    }

    @Test
    public void testCareOfEndslash() {
        this.test("c/o advokat s. niik", "co/ advokat s. niik");
    }

    private void test(String s1, String s2) {
        Assert.assertEquals((String)this.cleaner.clean(s1), (String)this.cleaner.clean(s2));
    }
}

