/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import no.priv.garshol.duke.DukeException;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;

public class XMLPrettyPrinter
implements DocumentHandler {
    private static final String NL = System.getProperty("line.separator");
    protected Writer writer;
    protected String encoding;
    protected boolean[] subelements;
    protected char[] startline;
    protected int offset;
    protected int level;
    protected int encodeCharsFrom = -1;
    protected boolean dropControlChars = true;

    public XMLPrettyPrinter(OutputStream stream) throws UnsupportedEncodingException {
        this(stream, "utf-8");
    }

    public XMLPrettyPrinter(OutputStream stream, String encoding) throws UnsupportedEncodingException {
        this(new OutputStreamWriter(stream, encoding), encoding);
    }

    public XMLPrettyPrinter(Writer writer, String encoding) {
        this.writer = writer;
        this.encoding = encoding;
        this.makeSubelements(20);
        this.makeStartLineBuffer(100);
    }

    @Override
    public void startDocument() {
        if (this.encoding != null) {
            this.write(this.writer, "<?xml version=\"1.0\" encoding=\"");
            this.write(this.writer, this.encoding);
            this.write(this.writer, "\" standalone=\"yes\"?>" + NL);
        }
        this.level = 0;
    }

    @Override
    public void startElement(String name, AttributeList atts) {
        if (this.level > 0) {
            this.indent();
        }
        this.write(this.writer, '<');
        this.write(this.writer, name);
        if (atts != null) {
            for (int i = 0; i < atts.getLength(); ++i) {
                this.write(this.writer, ' ');
                this.write(this.writer, atts.getName(i));
                this.write(this.writer, "=\"");
                this.escapeAttrValue(atts.getValue(i), this.writer);
                this.write(this.writer, "\"");
            }
        }
        this.write(this.writer, '>');
        ++this.level;
        if (this.offset + this.level * 2 > this.startline.length) {
            this.makeStartLineBuffer((this.offset + this.level * 2) * 2);
        }
        if (this.level >= this.subelements.length) {
            this.makeSubelements(this.level * 2);
        }
        if (this.level > 0) {
            this.subelements[this.level - 1] = true;
        }
        this.subelements[this.level] = false;
    }

    @Override
    public void endElement(String name) {
        if (this.subelements[this.level--]) {
            this.indent();
        }
        this.write(this.writer, "</");
        this.write(this.writer, name);
        this.write(this.writer, '>');
    }

    public void text(String text) {
        this.characters(text.toCharArray(), 0, text.length());
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        block5: for (int i = start; i < start + length; ++i) {
            switch (ch[i]) {
                case '&': {
                    this.write(this.writer, "&amp;");
                    continue block5;
                }
                case '<': {
                    this.write(this.writer, "&lt;");
                    continue block5;
                }
                case '>': {
                    this.write(this.writer, "&gt;");
                    continue block5;
                }
                default: {
                    if (ch[i] > '\u001f' || ch[i] == '\n' || ch[i] == '\t' || ch[i] == '\r') {
                        if (this.encodeCharsFrom > 0 && ch[i] >= this.encodeCharsFrom) {
                            this.write(this.writer, "&#");
                            this.write(this.writer, Integer.toString(ch[i]));
                            this.write(this.writer, ';');
                            continue block5;
                        }
                        this.write(this.writer, ch[i]);
                        continue block5;
                    }
                    if (this.dropControlChars) continue block5;
                    this.write(this.writer, "&#");
                    this.write(this.writer, Integer.toString(ch[i]));
                    this.write(this.writer, ';');
                }
            }
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    @Override
    public void processingInstruction(String target, String data) {
        this.write(this.writer, "<?");
        this.write(this.writer, target);
        this.write(this.writer, ' ');
        this.write(this.writer, data);
        this.write(this.writer, "?>");
    }

    @Override
    public void endDocument() {
        this.write(this.writer, NL);
        this.flush(this.writer);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    public void setEncodeCharactersFrom(int charnumber) {
        this.encodeCharsFrom = charnumber;
    }

    public void setDropControlCharacters(boolean dropControlChars) {
        this.dropControlChars = dropControlChars;
    }

    public void addUnescaped(String content) {
        this.write(this.writer, content);
    }

    protected void write(Writer writer, String s) {
        try {
            writer.write(s);
        }
        catch (IOException e) {
            throw new DukeException(e);
        }
    }

    protected void write(Writer writer, char c) {
        try {
            writer.write(c);
        }
        catch (IOException e) {
            throw new DukeException(e);
        }
    }

    protected void write(Writer writer, char[] c, int off, int len) {
        try {
            writer.write(c, off, len);
        }
        catch (IOException e) {
            throw new DukeException(e);
        }
    }

    protected void flush(Writer writer) {
        try {
            writer.flush();
        }
        catch (IOException e) {
            throw new DukeException(e);
        }
    }

    protected void indent() {
        this.write(this.writer, this.startline, 0, this.offset + this.level * 2);
    }

    protected void escapeAttrValue(String attrval, Writer writer) {
        int len = attrval.length();
        block5: for (int i = 0; i < len; ++i) {
            char c = attrval.charAt(i);
            switch (c) {
                case '&': {
                    this.write(writer, "&amp;");
                    continue block5;
                }
                case '<': {
                    this.write(writer, "&lt;");
                    continue block5;
                }
                case '\"': {
                    this.write(writer, "&quot;");
                    continue block5;
                }
                default: {
                    if (c > '\u001f' || c == '\n' || c == '\t' || c == '\r') {
                        if (this.encodeCharsFrom > 0 && c >= this.encodeCharsFrom) {
                            this.write(writer, "&#");
                            this.write(writer, Integer.toString(c));
                            this.write(writer, ';');
                            continue block5;
                        }
                        this.write(writer, c);
                        continue block5;
                    }
                    if (this.dropControlChars) continue block5;
                    this.write(writer, "&#");
                    this.write(writer, Integer.toString(c));
                    this.write(writer, ';');
                }
            }
        }
    }

    protected void makeStartLineBuffer(int size) {
        int ix;
        this.startline = new char[size];
        this.offset = NL.length();
        for (ix = 0; ix < this.offset; ++ix) {
            this.startline[ix] = NL.charAt(ix);
        }
        while (ix < size) {
            this.startline[ix] = 32;
            ++ix;
        }
    }

    protected void makeSubelements(int size) {
        boolean[] subs = new boolean[size];
        if (this.subelements != null) {
            System.arraycopy(this.subelements, 0, subs, 0, this.subelements.length);
        }
        this.subelements = subs;
    }
}

