/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import no.priv.garshol.duke.DukeException;
import no.priv.garshol.duke.StatementHandler;

public class NTriplesParser {
    private Reader src;
    private StatementHandler handler;
    private int lineno;
    private int pos;
    private String line;

    public static void parse(Reader src, StatementHandler handler) throws IOException {
        new NTriplesParser(src, handler).parse();
    }

    private NTriplesParser(Reader src, StatementHandler handler) {
        this.src = src;
        this.handler = handler;
    }

    public NTriplesParser(StatementHandler handler) {
        this(null, handler);
    }

    public void parseLine(String line) {
        this.line = line;
        this.parseLine();
    }

    private void parse() throws IOException {
        BufferedReader in = new BufferedReader(this.src);
        this.line = in.readLine();
        while (this.line != null) {
            ++this.lineno;
            this.parseLine();
            this.line = in.readLine();
        }
    }

    private void parseLine() {
        String object;
        String subject;
        this.pos = 0;
        this.skipws();
        if (this.pos >= this.line.length() || this.line.charAt(this.pos) == '#') {
            return;
        }
        if (this.line.charAt(this.pos) == '<') {
            subject = this.parseuri();
        } else if (this.line.charAt(this.pos) == '_') {
            subject = this.parsebnode();
        } else {
            throw new DukeException("Subject in line " + this.lineno + " is neither URI nor bnode: " + this.line);
        }
        this.skipws();
        if (this.pos >= this.line.length()) {
            throw new DukeException("Line ends before predicate on line " + this.lineno);
        }
        if (this.line.charAt(this.pos) != '<') {
            throw new DukeException("Predicate does not start with '<', nearby: '" + this.line.substring(this.pos - 5, this.pos + 5) + "', at position: " + this.pos + " in line " + this.lineno);
        }
        String property = this.parseuri();
        this.skipws();
        boolean literal = false;
        if (this.pos >= this.line.length()) {
            throw new DukeException("Line ends before object on line " + this.lineno);
        }
        if (this.line.charAt(this.pos) == '<') {
            object = this.parseuri();
        } else if (this.line.charAt(this.pos) == '\"') {
            object = NTriplesParser.unescape(this.parseliteral());
            literal = true;
        } else if (this.line.charAt(this.pos) == '_') {
            object = this.parsebnode();
        } else {
            throw new DukeException("Illegal object on line " + this.lineno + ": " + this.line.substring(this.pos));
        }
        this.skipws();
        if (this.pos >= this.line.length() || this.line.charAt(this.pos++) != '.') {
            throw new DukeException("Statement did not end with period; line: '" + this.line + "', line number: " + this.lineno);
        }
        this.skipws();
        if (this.pos + 1 < this.line.length()) {
            throw new DukeException("Garbage after period on line " + this.lineno);
        }
        this.handler.statement(subject, property, object, literal);
    }

    private static String unescape(String literal) {
        char[] buf = new char[literal.length()];
        int pos = 0;
        for (int ix = 0; ix < literal.length(); ++ix) {
            if (literal.charAt(ix) == '\\') {
                char ch;
                if ((ch = literal.charAt(++ix)) == 'n') {
                    buf[pos++] = 10;
                    continue;
                }
                if (ch == 'r') {
                    buf[pos++] = 13;
                    continue;
                }
                if (ch == 't') {
                    buf[pos++] = 9;
                    continue;
                }
                if (ch == '\\') {
                    buf[pos++] = 92;
                    continue;
                }
                if (ch == '\"') {
                    buf[pos++] = 34;
                    continue;
                }
                if (ch == 'u') {
                    if (!(literal.length() >= ++ix + 4 && NTriplesParser.hexchar(literal.charAt(ix)) && NTriplesParser.hexchar(literal.charAt(ix + 1)) && NTriplesParser.hexchar(literal.charAt(ix + 2)) && NTriplesParser.hexchar(literal.charAt(ix + 3)))) {
                        throw new DukeException("Bad Unicode escape: '" + literal.substring(ix - 2, ix + 4) + "'");
                    }
                    buf[pos++] = NTriplesParser.unhex(literal, ix);
                    ix += 3;
                    continue;
                }
                throw new DukeException("Unknown escaped character: '" + ch + "' in '" + literal + "'");
            }
            buf[pos++] = literal.charAt(ix);
        }
        return new String(buf, 0, pos);
    }

    private static boolean hexchar(char ch) {
        return ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'F' || ch >= 'a' && ch <= 'f';
    }

    private static char unhex(String literal, int pos) {
        int charno = 0;
        for (int ix = pos; ix < pos + 4; ++ix) {
            char ch = literal.charAt(ix);
            int digit = ch >= '0' && ch <= '9' ? ch - 48 : (ch >= 'a' && ch <= 'f' ? ch - 97 + 10 : ch - 65 + 10);
            charno = charno * 16 + digit;
        }
        return (char)charno;
    }

    private String parseuri() {
        int start = this.pos + 1;
        while (this.pos < this.line.length() && this.line.charAt(this.pos) != '>') {
            ++this.pos;
        }
        if (this.pos >= this.line.length()) {
            throw new DukeException("Line ends in URI at line " + this.lineno);
        }
        ++this.pos;
        return this.line.substring(start, this.pos - 1);
    }

    private String parseliteral() {
        ++this.pos;
        int start = this.pos;
        while (this.line.charAt(this.pos) != '\"') {
            if (this.line.charAt(this.pos) == '\\') {
                ++this.pos;
            }
            ++this.pos;
        }
        int end = this.pos++;
        if (this.line.charAt(this.pos) == '^') {
            this.parsedatatype();
        } else if (this.line.charAt(this.pos) == '@') {
            this.parselangtag();
        }
        return this.line.substring(start, end);
    }

    private void parsedatatype() {
        ++this.pos;
        if (this.line.charAt(this.pos++) != '^') {
            throw new DukeException("Incorrect start of datatype");
        }
        if (this.line.charAt(this.pos) != '<') {
            throw new DukeException("Datatype URI does not start with '<'");
        }
        this.parseuri();
    }

    private void parselangtag() {
        ++this.pos;
        char ch = this.line.charAt(this.pos);
        while (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') {
            ch = this.line.charAt(++this.pos);
        }
        if (this.line.charAt(this.pos) != '-') {
            return;
        }
        ++this.pos;
        ch = this.line.charAt(this.pos);
        while (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9') {
            ch = this.line.charAt(this.pos++);
        }
    }

    private String parsebnode() {
        int start = this.pos++;
        if (this.line.charAt(this.pos++) != ':') {
            throw new DukeException("Incorrect start of blank node");
        }
        char ch = this.line.charAt(this.pos++);
        while (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9') {
            ch = this.line.charAt(this.pos++);
        }
        return this.line.substring(start, this.pos - 1);
    }

    private void skipws() {
        char ch;
        while (this.pos < this.line.length() && ((ch = this.line.charAt(this.pos)) == ' ' || ch == '\t')) {
            ++this.pos;
        }
    }
}

