/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import no.priv.garshol.duke.Configuration;
import no.priv.garshol.duke.DataSource;
import no.priv.garshol.duke.Property;
import no.priv.garshol.duke.utils.XMLPrettyPrinter;
import org.xml.sax.helpers.AttributeListImpl;

public class ConfigWriter {
    private final XMLPrettyPrinter pp;

    public ConfigWriter(OutputStream fos) throws FileNotFoundException, UnsupportedEncodingException {
        this.pp = new XMLPrettyPrinter(fos);
    }

    public void write(Configuration config) throws IOException {
        this.pp.startDocument();
        this.pp.startElement("duke", null);
        this.pp.startElement("schema", null);
        this.writeElement("threshold", "" + config.getThreshold());
        if (config.getMaybeThreshold() != 0.0) {
            this.writeElement("maybe-threshold", "" + config.getMaybeThreshold());
        }
        for (Property p : config.getProperties()) {
            this.writeProperty(p);
        }
        this.pp.endElement("schema");
        String dbclass = config.getDatabase(false).getClass().getName();
        AttributeListImpl atts = new AttributeListImpl();
        atts.addAttribute("class", "CDATA", dbclass);
        this.pp.startElement("database", atts);
        this.pp.endElement("database");
        if (config.isDeduplicationMode()) {
            for (DataSource src : config.getDataSources()) {
                this.writeDataSource(src);
            }
        } else {
            this.pp.startElement("group", null);
            for (DataSource src : config.getDataSources(1)) {
                this.writeDataSource(src);
            }
            this.pp.endElement("group");
            this.pp.startElement("group", null);
            for (DataSource src : config.getDataSources(2)) {
                this.writeDataSource(src);
            }
            this.pp.endElement("group");
        }
        this.pp.endElement("duke");
        this.pp.endDocument();
    }

    public void writeParam(String name, String value) {
        if (value == null) {
            return;
        }
        AttributeListImpl atts = new AttributeListImpl();
        atts.addAttribute("name", "CDATA", name);
        atts.addAttribute("value", "CDATA", value);
        this.pp.startElement("param", atts);
        this.pp.endElement("param");
    }

    public void writeParam(String name, int value) {
        this.writeParam(name, "" + value);
    }

    public void writeParam(String name, char value) {
        this.writeParam(name, "" + value);
    }

    public void writeParam(String name, boolean value) {
        this.writeParam(name, "" + value);
    }

    private void writeElement(String name, String value) {
        if (value == null) {
            return;
        }
        this.pp.startElement(name, null);
        this.pp.text(value);
        this.pp.endElement(name);
    }

    private void writeProperty(Property prop) {
        AttributeListImpl atts = new AttributeListImpl();
        if (prop.isIdProperty()) {
            atts.addAttribute("type", "CDATA", "id");
        } else if (prop.isIgnoreProperty()) {
            atts.addAttribute("type", "CDATA", "ignore");
        }
        if (!prop.isIdProperty() && prop.getLookupBehaviour() != Property.Lookup.DEFAULT) {
            String value = prop.getLookupBehaviour().toString().toLowerCase();
            atts.addAttribute("lookup", "CDATA", value);
        }
        this.pp.startElement("property", atts);
        this.writeElement("name", prop.getName());
        if (prop.getComparator() != null) {
            this.writeElement("comparator", prop.getComparator().getClass().getName());
        }
        if (prop.getLowProbability() != 0.0) {
            this.writeElement("low", "" + prop.getLowProbability());
        }
        if (prop.getHighProbability() != 0.0) {
            this.writeElement("high", "" + prop.getHighProbability());
        }
        this.pp.endElement("property");
    }

    private void writeDataSource(DataSource src) {
        src.writeConfig(this);
    }

    public void writeStartElement(String name, AttributeListImpl atts) {
        this.pp.startElement(name, atts);
    }

    public void writeEndElement(String name) {
        this.pp.endElement(name);
    }
}

