"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import avikom.camunda.variable_pb2
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class ExternalTask(google.protobuf.message.Message):
    """*
    A storable representation of an external task published by the BPM engine (Camunda).
    The field description has been derived from the official REST-API documentation.
    @author Alexander Neumann <alneuman@techfak.uni-bielefeld.de>
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACTIVITY_ID_FIELD_NUMBER: builtins.int
    ACTIVITY_INSTANCE_ID_FIELD_NUMBER: builtins.int
    ERROR_MESSAGE_FIELD_NUMBER: builtins.int
    EXECUTION_ID_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    LOCK_EXPIRATION_TIME_FIELD_NUMBER: builtins.int
    PROCESS_DEFINITION_ID_FIELD_NUMBER: builtins.int
    PROCESS_DEFINITION_KEY_FIELD_NUMBER: builtins.int
    PROCESS_INSTANCE_ID_FIELD_NUMBER: builtins.int
    TENANT_ID_FIELD_NUMBER: builtins.int
    RETRIES_FIELD_NUMBER: builtins.int
    WORKER_ID_FIELD_NUMBER: builtins.int
    PRIORITY_FIELD_NUMBER: builtins.int
    TOPIC_NAME_FIELD_NUMBER: builtins.int
    VARIABLES_FIELD_NUMBER: builtins.int
    activity_id: builtins.str
    """/ id of the activity that this external task belongs to"""
    activity_instance_id: builtins.str
    """/ id of the activity instance that the external task belongs to"""
    error_message: builtins.str
    """/ error message that was supplied when the last failure of this task was reported"""
    execution_id: builtins.str
    """/ id of the execution that the external task belongs to"""
    id: builtins.str
    """/ external task's id"""
    lock_expiration_time: builtins.str
    """/ date that the task's most recent lock expires or has expired"""
    process_definition_id: builtins.str
    """/ id of the process definition the external task is defined in"""
    process_definition_key: builtins.str
    """/ key of the process definition the external task is defined in"""
    process_instance_id: builtins.str
    """/ id of the process instance the external task belongs to"""
    tenant_id: builtins.str
    """/ id of the tenant the external task belongs to"""
    retries: builtins.int
    """/ number of retries the task currently has left"""
    worker_id: builtins.str
    """/ id of the worker that posesses or posessed the most recent lock"""
    priority: builtins.int
    """/ priority of the external task"""
    topic_name: builtins.str
    """/ external task's topic name"""
    @property
    def variables(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[avikom.camunda.variable_pb2.Variable]:
        """/ a set of local and global variables passed to the external service"""
    def __init__(
        self,
        *,
        activity_id: builtins.str = ...,
        activity_instance_id: builtins.str = ...,
        error_message: builtins.str = ...,
        execution_id: builtins.str = ...,
        id: builtins.str = ...,
        lock_expiration_time: builtins.str = ...,
        process_definition_id: builtins.str = ...,
        process_definition_key: builtins.str = ...,
        process_instance_id: builtins.str = ...,
        tenant_id: builtins.str = ...,
        retries: builtins.int = ...,
        worker_id: builtins.str = ...,
        priority: builtins.int = ...,
        topic_name: builtins.str = ...,
        variables: collections.abc.Iterable[avikom.camunda.variable_pb2.Variable] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["activity_id", b"activity_id", "activity_instance_id", b"activity_instance_id", "error_message", b"error_message", "execution_id", b"execution_id", "id", b"id", "lock_expiration_time", b"lock_expiration_time", "priority", b"priority", "process_definition_id", b"process_definition_id", "process_definition_key", b"process_definition_key", "process_instance_id", b"process_instance_id", "retries", b"retries", "tenant_id", b"tenant_id", "topic_name", b"topic_name", "variables", b"variables", "worker_id", b"worker_id"]) -> None: ...

global___ExternalTask = ExternalTask
