"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import avikom.assistance.assistance_level_pb2
import avikom.assistance.task_step_pb2
import avikom.generic.user_pb2
import builtins
import google.protobuf.descriptor
import google.protobuf.message
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class StepProficiency(google.protobuf.message.Message):
    """*
    A message to describe the step proficiency of a user. 
    This includes the currently required assistance level but also parameters to determine when or if AVIKOM will attempt to reduce the assistance level.
    @author: Alexander Neumann <alneuma@techfak.uni-bielefeld.de>
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REQUIRED_ASSISTANCE_FIELD_NUMBER: builtins.int
    USER_FIELD_NUMBER: builtins.int
    STEP_FIELD_NUMBER: builtins.int
    TENDENCY_FIELD_NUMBER: builtins.int
    ASSISTANCE_DECREASE_FIELD_NUMBER: builtins.int
    MINIMAL_ASSISTANCE_FIELD_NUMBER: builtins.int
    required_assistance: avikom.assistance.assistance_level_pb2.AssistanceLevel.ValueType
    """/ currently required assistance"""
    @property
    def user(self) -> avikom.generic.user_pb2.User:
        """/ user requiring assistance"""
    @property
    def step(self) -> avikom.assistance.task_step_pb2.TaskStep:
        """/ task step to assist"""
    tendency: builtins.float
    """/ tendency of the current assistance level; raning from -1 to +1"""
    assistance_decrease: builtins.float
    """/ factor to reduce `tendency` when a task was conducted successfully"""
    minimal_assistance: avikom.assistance.assistance_level_pb2.AssistanceLevel.ValueType
    """/ when this level is reached, assistance will not decay any further"""
    def __init__(
        self,
        *,
        required_assistance: avikom.assistance.assistance_level_pb2.AssistanceLevel.ValueType = ...,
        user: avikom.generic.user_pb2.User | None = ...,
        step: avikom.assistance.task_step_pb2.TaskStep | None = ...,
        tendency: builtins.float = ...,
        assistance_decrease: builtins.float = ...,
        minimal_assistance: avikom.assistance.assistance_level_pb2.AssistanceLevel.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["step", b"step", "user", b"user"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["assistance_decrease", b"assistance_decrease", "minimal_assistance", b"minimal_assistance", "required_assistance", b"required_assistance", "step", b"step", "tendency", b"tendency", "user", b"user"]) -> None: ...

global___StepProficiency = StepProficiency
