"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import avikom.assistance.instruction_media_pb2
import avikom.assistance.instruction_text_pb2
import avikom.generic.peer_pb2
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class EnvironmentalFactorsUpdate(google.protobuf.message.Message):
    """*
    A message to update current environmental factors such as brightness and/or volume for a user session or a scene.
    @author Alexander Neumann <alneuman@techfak.uni-bielefeld.de>
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SCENE_NAME_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    SESSION_ID_FIELD_NUMBER: builtins.int
    BRIGHTNESS_FIELD_NUMBER: builtins.int
    VOLUME_FIELD_NUMBER: builtins.int
    scene_name: builtins.str
    """/ scene/location name where data has been tracked"""
    user_id: builtins.int
    """/ when set, relates info to the current session of the user"""
    session_id: builtins.str
    """/ when set, relates info the this specific session"""
    brightness: builtins.float
    """/ environmental lightning/brightness in lumen"""
    volume: builtins.float
    """/ environmental loudness/volume in dbA"""
    def __init__(
        self,
        *,
        scene_name: builtins.str = ...,
        user_id: builtins.int = ...,
        session_id: builtins.str = ...,
        brightness: builtins.float = ...,
        volume: builtins.float = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["brightness", b"brightness", "scene_name", b"scene_name", "session_id", b"session_id", "user_id", b"user_id", "volume", b"volume"]) -> None: ...

global___EnvironmentalFactorsUpdate = EnvironmentalFactorsUpdate

@typing_extensions.final
class SessionEvent(google.protobuf.message.Message):
    """
    An event triggered by a peer to be escalated to the BPM engine (Camunda)
    @author Alexander Neumann <alneuman@techfak.uni-bielefeld.de>
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SESSION_ID_FIELD_NUMBER: builtins.int
    EVENT_NAME_FIELD_NUMBER: builtins.int
    SENDER_FIELD_NUMBER: builtins.int
    session_id: builtins.str
    """/ session of the event"""
    event_name: builtins.str
    """/ the unique event name"""
    @property
    def sender(self) -> avikom.generic.peer_pb2.Peer:
        """/ who triggered the event"""
    def __init__(
        self,
        *,
        session_id: builtins.str = ...,
        event_name: builtins.str = ...,
        sender: avikom.generic.peer_pb2.Peer | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["sender", b"sender"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["event_name", b"event_name", "sender", b"sender", "session_id", b"session_id"]) -> None: ...

global___SessionEvent = SessionEvent

@typing_extensions.final
class TaskEvent(google.protobuf.message.Message):
    """
    An event that should be processed by the BPM engine (Camunda) and/or AVIKOM services.
    @author Alexander Neumann <alneuman@techfak.uni-bielefeld.de>
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TASK_ID_FIELD_NUMBER: builtins.int
    RESULT_FIELD_NUMBER: builtins.int
    task_id: builtins.str
    """/ the ID of the current service task/RTS in which the event was triggered"""
    result: builtins.str
    """/ the event result/outcome; in cases of a failed task this might me an error decription"""
    def __init__(
        self,
        *,
        task_id: builtins.str = ...,
        result: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["result", b"result", "task_id", b"task_id"]) -> None: ...

global___TaskEvent = TaskEvent

@typing_extensions.final
class InstructionList(google.protobuf.message.Message):
    """
    A list of instructions with resolved fields.
    @author Alexander Neumann <alneuman@techfak.uni-bielefeld.de>
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTRUCTIONS_FIELD_NUMBER: builtins.int
    MEDIA_FIELD_NUMBER: builtins.int
    @property
    def instructions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[avikom.assistance.instruction_text_pb2.InstructionText]:
        """/ textual instructions for this task step"""
    @property
    def media(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[avikom.assistance.instruction_media_pb2.InstructionMedia]:
        """/ media content for this task step; includes prefabs and world objects"""
    def __init__(
        self,
        *,
        instructions: collections.abc.Iterable[avikom.assistance.instruction_text_pb2.InstructionText] | None = ...,
        media: collections.abc.Iterable[avikom.assistance.instruction_media_pb2.InstructionMedia] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["instructions", b"instructions", "media", b"media"]) -> None: ...

global___InstructionList = InstructionList
