"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import avikom.assistance.runtime_task_step_pb2
import avikom.assistance.scene_pb2
import avikom.assistance.task_pb2
import avikom.generic.modality_pb2
import avikom.generic.peer_pb2
import avikom.generic.user_profile_pb2
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class Session(google.protobuf.message.Message):
    """
    A (serializable) version of a session.
    Data should only be stored in json format if the represented data cannot be generalized.
    Note that sessions might contain temporal data that cannot be stored because of their short-times lifespan or due to serializiation limitations.
    For these cases, separate setup and tear down strategies should be considered.
    @author Alexander Neumann <alneuman@techfak.uni-bielefeld.de>
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    SCENE_FIELD_NUMBER: builtins.int
    PEERS_FIELD_NUMBER: builtins.int
    CURRENT_FIELD_NUMBER: builtins.int
    PROFILE_FIELD_NUMBER: builtins.int
    TASK_FIELD_NUMBER: builtins.int
    MODAL_AFFINITY_FIELD_NUMBER: builtins.int
    JSON_DATA_FIELD_NUMBER: builtins.int
    id: builtins.str
    """/ session ID; generated by `SessionService`"""
    @property
    def scene(self) -> avikom.assistance.scene_pb2.Scene:
        """/ current scene; only the scene unique identifier (name) must be provided"""
    @property
    def peers(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[avikom.generic.peer_pb2.Peer]:
        """/ a list of peers available in the session; only the unique identifier (name) must be provided"""
    @property
    def current(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[avikom.assistance.runtime_task_step_pb2.RuntimeTaskStep]:
        """/ list of currently eligible `RuntimeTaskSteps`"""
    @property
    def profile(self) -> avikom.generic.user_profile_pb2.UserProfile:
        """/ profile of the session's user"""
    @property
    def task(self) -> avikom.assistance.task_pb2.Task:
        """/ currently conducted task"""
    @property
    def modal_affinity(self) -> avikom.generic.modality_pb2.Modality:
        """/ environmental factors of the session's context"""
    json_data: builtins.str
    """/ used for session/task-specific data;"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        scene: avikom.assistance.scene_pb2.Scene | None = ...,
        peers: collections.abc.Iterable[avikom.generic.peer_pb2.Peer] | None = ...,
        current: collections.abc.Iterable[avikom.assistance.runtime_task_step_pb2.RuntimeTaskStep] | None = ...,
        profile: avikom.generic.user_profile_pb2.UserProfile | None = ...,
        task: avikom.assistance.task_pb2.Task | None = ...,
        modal_affinity: avikom.generic.modality_pb2.Modality | None = ...,
        json_data: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["modal_affinity", b"modal_affinity", "profile", b"profile", "scene", b"scene", "task", b"task"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["current", b"current", "id", b"id", "json_data", b"json_data", "modal_affinity", b"modal_affinity", "peers", b"peers", "profile", b"profile", "scene", b"scene", "task", b"task"]) -> None: ...

global___Session = Session
