"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import avikom.assistance.instruction_meta_pb2
import avikom.assistance.instruction_text_value_pb2
import builtins
import google.protobuf.descriptor
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _ContentStyle:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ContentStyleEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ContentStyle.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    STYLE_UNKNOWN: _ContentStyle.ValueType  # 0
    """/ no content info available"""
    STYLE_INFO: _ContentStyle.ValueType  # 1
    """/ used for default instructions"""
    STYLE_WARNING: _ContentStyle.ValueType  # 2
    """/ used when caution is advises"""
    STYLE_CRITICAL: _ContentStyle.ValueType  # 3
    """/ used when extreme caution is advises"""
    STYLE_SUCESS: _ContentStyle.ValueType  # 4
    """/ a positive success message"""
    STYLE_ERROR: _ContentStyle.ValueType  # 5
    """/ used for reporting errors"""

class ContentStyle(_ContentStyle, metaclass=_ContentStyleEnumTypeWrapper):
    """*
    Defines the content style of a textual instruction. This should be used to transport contextual semantics such as urgency.
    @author: Alexander Neumann <alneuman@techfak.uni-bielefeld.de>
    """

STYLE_UNKNOWN: ContentStyle.ValueType  # 0
"""/ no content info available"""
STYLE_INFO: ContentStyle.ValueType  # 1
"""/ used for default instructions"""
STYLE_WARNING: ContentStyle.ValueType  # 2
"""/ used when caution is advises"""
STYLE_CRITICAL: ContentStyle.ValueType  # 3
"""/ used when extreme caution is advises"""
STYLE_SUCESS: ContentStyle.ValueType  # 4
"""/ a positive success message"""
STYLE_ERROR: ContentStyle.ValueType  # 5
"""/ used for reporting errors"""
global___ContentStyle = ContentStyle

@typing_extensions.final
class InstructionText(google.protobuf.message.Message):
    """*
    This message should be used for textual instruction that can be displayed or spoken.
    @author: Alexander Neumann <alneuman@techfak.uni-bielefeld.de>
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    META_FIELD_NUMBER: builtins.int
    CONTENT_STYLE_FIELD_NUMBER: builtins.int
    CONTENT_FIELD_NUMBER: builtins.int
    PREVIEW_FIELD_NUMBER: builtins.int
    @property
    def meta(self) -> avikom.assistance.instruction_meta_pb2.InstructionMeta:
        """/ context information for the instruction"""
    content_style: global___ContentStyle.ValueType
    """/ styling hints for the text instruction"""
    @property
    def content(self) -> avikom.assistance.instruction_text_value_pb2.InstructionTextValue:
        """/ the runtime value of an instruction, can include moustache fields"""
    @property
    def preview(self) -> avikom.assistance.instruction_text_value_pb2.InstructionTextValue:
        """/ optional field which will be shown during step preview; must not contain dynamic content"""
    def __init__(
        self,
        *,
        meta: avikom.assistance.instruction_meta_pb2.InstructionMeta | None = ...,
        content_style: global___ContentStyle.ValueType = ...,
        content: avikom.assistance.instruction_text_value_pb2.InstructionTextValue | None = ...,
        preview: avikom.assistance.instruction_text_value_pb2.InstructionTextValue | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["content", b"content", "meta", b"meta", "preview", b"preview"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["content", b"content", "content_style", b"content_style", "meta", b"meta", "preview", b"preview"]) -> None: ...

global___InstructionText = InstructionText
