
[![Python package](https://github.com/danielnachumdev/danielutils/actions/workflows/python-package.yml/badge.svg)](https://github.com/danielnachumdev/danielutils/actions/workflows/python-package.yml)
[![Pylint](https://github.com/danielnachumdev/danielutils/actions/workflows/pylint.yml/badge.svg)](https://github.com/danielnachumdev/danielutils/actions/workflows/pylint.yml)
[![Python 3.10.11](https://img.shields.io/badge/python-3.10.11-blue.svg)](https://www.python.org/downloads/release/python-31011/)
[![gitleaks](https://github.com/danielnachumdev/danielutils/actions/workflows/gitleaks.yml/badge.svg)](https://github.com/danielnachumdev/danielutils/actions/workflows/gitleaks.yml)
[![CodeQL](https://github.com/danielnachumdev/danielutils/actions/workflows/github-code-scanning/codeql/badge.svg)](https://github.com/danielnachumdev/danielutils/actions/workflows/github-code-scanning/codeql)
# danielutils v=0.9.80
A utils library for things that I find useful for my coding workflow.\
Feel free to use and / or contribute / improve my code :)

THIS PACKAGE IS IN DEVELOPMENT AND SUBJECT TO CHANGE, USE AT YOUR OWN RISK!

**Tested python versions**: `3.8.0`*, `3.9.0`, `3.10.13` 

Versions marked with * are partially working
# Showcase
In [this](./READMES/) folder you can check out some more in depth showcase of some of the topics I have covered in this package

### [`isoftype`](./READMES/isoftype.md)
-- _"Boost your type checking game with `isoftype`: Effortlessly verify object types and subtypes, handle complex data structures, and tackle union types in Python!"_

**Support for Parametrized Generics**
### [`@overload`](./READMES/overload.md)
-- _"Manage function overloads with ease: Introducing `@overload` to handle specific resolutions and simplify function overloading in Python!"_

**Support for function overloading**
### [`@validate`](./READMES/validate.md)
-- _"Safeguard your code with `@validate`: Protecting against type-related disasters and ensuring type safety in Python functions!"_

**Runtime argument type validation for functions**
### [`tlist`](./READMES/tlist.md)
-- _"Elevate your list safety with `tlist`: Empower your code with runtime type safety, seamless list operations, and enhanced control over list elements!"_

**Like `list` but with runtime type validation**
### [`Interface`](./READMES/Interface.md)
-- _"Unlock the Power of Interfaces in Python: Create Your Own Metaclass for Interface-Like Behavior and Enhance Your Object-Oriented Programming Skills!"_

**Learning `metaclasses` by implementing an `Interface` (and `Abstract Classes`) for python in python**
