"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WindowsComponents = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("../common");
const common_2 = require("./common");
/**
 * Components for Windows that can be used with AWS Image Builder based builders. These cannot be used by {@link CodeBuildImageBuilder}.
 */
class WindowsComponents {
    static cloudwatchAgent(scope, id) {
        return new common_2.ImageBuilderComponent(scope, id, {
            platform: 'Windows',
            displayName: 'CloudWatch agent',
            description: 'Install latest version of CloudWatch agent for sending logs to CloudWatch',
            commands: [
                '$ErrorActionPreference = \'Stop\'',
                'Start-Process msiexec.exe -Wait -ArgumentList \'/i https://s3.amazonaws.com/amazoncloudwatch-agent/windows/amd64/latest/amazon-cloudwatch-agent.msi /qn\'',
            ],
        });
    }
    static awsCli(scope, id) {
        return new common_2.ImageBuilderComponent(scope, id, {
            platform: 'Windows',
            displayName: 'AWS CLI',
            description: 'Install latest version of AWS CLI',
            commands: [
                '$ErrorActionPreference = \'Stop\'',
                'Start-Process msiexec.exe -Wait -ArgumentList \'/i https://awscli.amazonaws.com/AWSCLIV2.msi /qn\'',
            ],
        });
    }
    static githubCli(scope, id) {
        return new common_2.ImageBuilderComponent(scope, id, {
            platform: 'Windows',
            displayName: 'GitHub CLI',
            description: 'Install latest version of gh',
            commands: [
                '$ErrorActionPreference = \'Stop\'',
                '$ProgressPreference = \'SilentlyContinue\'',
                'cmd /c curl -w "%{redirect_url}" -fsS https://github.com/cli/cli/releases/latest > $Env:TEMP\\latest-gh',
                '$LatestUrl = Get-Content $Env:TEMP\\latest-gh',
                '$GH_VERSION = ($LatestUrl -Split \'/\')[-1].substring(1)',
                '$ProgressPreference = \'SilentlyContinue\'',
                'Invoke-WebRequest -UseBasicParsing -Uri "https://github.com/cli/cli/releases/download/v${GH_VERSION}/gh_${GH_VERSION}_windows_amd64.msi" -OutFile gh.msi',
                'Start-Process msiexec.exe -Wait -ArgumentList \'/i gh.msi /qn\'',
                'del gh.msi',
            ],
        });
    }
    static git(scope, id) {
        return new common_2.ImageBuilderComponent(scope, id, {
            platform: 'Windows',
            displayName: 'Git',
            description: 'Install latest version of git',
            commands: [
                '$ErrorActionPreference = \'Stop\'',
                '$ProgressPreference = \'SilentlyContinue\'',
                'cmd /c curl -w "%{redirect_url}" -fsS https://github.com/git-for-windows/git/releases/latest > $Env:TEMP\\latest-git',
                '$LatestUrl = Get-Content $Env:TEMP\\latest-git',
                '$GIT_VERSION = ($LatestUrl -Split \'/\')[-1].substring(1)',
                '$GIT_VERSION_SHORT = ($GIT_VERSION -Split \'.windows.\')[0]',
                'Invoke-WebRequest -UseBasicParsing -Uri https://github.com/git-for-windows/git/releases/download/v${GIT_VERSION}/Git-${GIT_VERSION_SHORT}-64-bit.exe -OutFile git-setup.exe',
                'Start-Process git-setup.exe -Wait -ArgumentList \'/VERYSILENT\'',
                'del git-setup.exe',
            ],
        });
    }
    static githubRunner(scope, id, runnerVersion) {
        let runnerCommands;
        if (runnerVersion.is(common_1.RunnerVersion.latest())) {
            runnerCommands = [
                'cmd /c curl -w "%{redirect_url}" -fsS https://github.com/actions/runner/releases/latest > $Env:TEMP\\latest-gha',
                '$LatestUrl = Get-Content $Env:TEMP\\latest-gha',
                '$RUNNER_VERSION = ($LatestUrl -Split \'/\')[-1].substring(1)',
            ];
        }
        else {
            runnerCommands = [`$RUNNER_VERSION = '${runnerVersion.version}'`];
        }
        return new common_2.ImageBuilderComponent(scope, id, {
            platform: 'Windows',
            displayName: 'GitHub Actions Runner',
            description: 'Install latest version of GitHub Actions Runner',
            commands: [
                '$ErrorActionPreference = \'Stop\'',
                '$ProgressPreference = \'SilentlyContinue\'',
            ].concat(runnerCommands, [
                'Invoke-WebRequest -UseBasicParsing -Uri "https://github.com/actions/runner/releases/download/v${RUNNER_VERSION}/actions-runner-win-x64-${RUNNER_VERSION}.zip" -OutFile actions.zip',
                'Expand-Archive actions.zip -DestinationPath C:\\actions',
                'del actions.zip',
            ]),
        });
    }
    static docker(scope, id) {
        return new common_2.ImageBuilderComponent(scope, id, {
            platform: 'Windows',
            displayName: 'Docker',
            description: 'Install latest version of Docker',
            commands: [
                '$ErrorActionPreference = \'Stop\'',
                '$ProgressPreference = \'SilentlyContinue\'',
                'Invoke-WebRequest -UseBasicParsing -Uri https://desktop.docker.com/win/main/amd64/Docker%20Desktop%20Installer.exe -OutFile docker-setup.exe',
                'Start-Process \'docker-setup.exe\' -Wait -ArgumentList \'/install --quiet --accept-license\'',
                'del docker-setup.exe',
                'cmd /c curl -w "%{redirect_url}" -fsS https://github.com/docker/compose/releases/latest > $Env:TEMP\\latest-docker-compose',
                '$LatestUrl = Get-Content $Env:TEMP\\latest-docker-compose',
                '$LatestDockerCompose = ($LatestUrl -Split \'/\')[-1]',
                'Invoke-WebRequest -UseBasicParsing -Uri  "https://github.com/docker/compose/releases/download/${LatestDockerCompose}/docker-compose-Windows-x86_64.exe" -OutFile $Env:ProgramFiles\\Docker\\docker-compose.exe',
                'copy $Env:ProgramFiles\\Docker\\docker-compose.exe $Env:ProgramFiles\\Docker\\cli-plugins\\docker-compose.exe',
            ],
        });
    }
}
exports.WindowsComponents = WindowsComponents;
_a = JSII_RTTI_SYMBOL_1;
WindowsComponents[_a] = { fqn: "@cloudsnorkel/cdk-github-runners.WindowsComponents", version: "0.7.0" };
//# sourceMappingURL=data:application/json;base64,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