import { Construct } from 'constructs';
import { RunnerVersion } from '../common';
import { ImageBuilderComponent } from './common';
/**
 * Components for Windows that can be used with AWS Image Builder based builders. These cannot be used by {@link CodeBuildImageBuilder}.
 */
export declare class WindowsComponents {
    static cloudwatchAgent(scope: Construct, id: string): ImageBuilderComponent;
    static awsCli(scope: Construct, id: string): ImageBuilderComponent;
    static githubCli(scope: Construct, id: string): ImageBuilderComponent;
    static git(scope: Construct, id: string): ImageBuilderComponent;
    static githubRunner(scope: Construct, id: string, runnerVersion: RunnerVersion): ImageBuilderComponent;
    static docker(scope: Construct, id: string): ImageBuilderComponent;
}
