# PyBlockWorld

Eine an Minecraft angelehnte Welt aus Blöcken.

## Installation

Die Installation erfolgt über ``pip install pyblockworld``.

## API

```python
    from pyblockworld import World

    #
    # BEISPIEL 1
    #
    
    # Eine Funktion, die beim Drücken der B-Taste aufgerufen werden soll
    def b_key_pressed(world:World):
        print("B pressed. Player at", world.player_position())
        
    # Erstellen einer neuen Welt
    world = World()
    # Die Funktion für die build-Taste (b) wird zugewiesen
    world.build_key_pressed = b_key_pressed
    # Die Welt wird gestartet
    world.run()

    #
    # BEISPIEL 2
    #

    # Nun werden beim Drücken der Taste ein paar Blöcke platziert.
    def b_key_pressed(world:World):
        # Neue Blöcke können mit setBlock gesetzt werden.
        # Verfügbare Materialien stehen in World.MATERIALS und umfassen
        # air, default:brick, default:stone, default:sand, default:grass
        print("Block types", World.MATERIALS)
        x,y,z = world.player_position()
        # Einen Block platzieren
        world.setBlock(x,y,z, "default:brick")

        # Mehrere Blöcke auf einmal abseits des Spielers platzieren
        x,y,z = x,y,z+3
        world.setBlocks(x,y,z, x+3,y+3,z+3, "default:grass")
        
    world = World()
    world.build_key_pressed = b_key_pressed
    world.run()
```

## Quellen

Der Quellcode basiert auf dem Code von [SensorCraft](https://github.com/AFRL-RY/SensorCraft),
der wiederum auf dem Code von [Craft](https://github.com/fogleman/Craft/) basiert.


## Changelog

* 0.3.5 
    * Changelog eingeührt
    * Support für Python 3.8

* 0.3.7
    * PeristentWorld als speicherbare Welt hinzugefügt.
    * Doku aktualisiert: Abschnitt Start entfernt.
    * World.player_position hat das Attribut as_int, um ein Int-Tuple zu erzeugen
