"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Action = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const events = require("@aws-cdk/aws-events");
const core_1 = require("@aws-cdk/core");
/**
 * (experimental) Low-level class for generic CodePipeline Actions.
 *
 * WARNING: this class should not be externally exposed, but is currently visible
 * because of a limitation of jsii (https://github.com/aws/jsii/issues/524).
 *
 * This class will disappear in a future release and should not be used.
 *
 * @experimental
 */
class Action {
    /**
     * @experimental
     */
    constructor(actionProperties) {
        this.variableReferenced = false;
        this.customerProvidedNamespace = actionProperties.variablesNamespace;
        this.namespaceOrToken = core_1.Lazy.string({
            produce: () => {
                // make sure the action was bound (= added to a pipeline)
                if (this.actualNamespace !== undefined) {
                    return this.customerProvidedNamespace !== undefined
                        // if a customer passed a namespace explicitly, always use that
                        ? this.customerProvidedNamespace
                        // otherwise, only return a namespace if any variable was referenced
                        : (this.variableReferenced ? this.actualNamespace : undefined);
                }
                else {
                    throw new Error(`Cannot reference variables of action '${this.actionProperties.actionName}', ` +
                        'as that action was never added to a pipeline');
                }
            },
        });
        this.actionProperties = {
            ...actionProperties,
            variablesNamespace: this.namespaceOrToken,
        };
    }
    /**
     * @experimental
     */
    bind(scope, stage, options) {
        this._pipeline = stage.pipeline;
        this._stage = stage;
        this._scope = scope;
        this.actualNamespace = this.customerProvidedNamespace === undefined
            // default a namespace name, based on the stage and action names
            ? `${stage.stageName}_${this.actionProperties.actionName}_NS`
            : this.customerProvidedNamespace;
        return this.bound(scope, stage, options);
    }
    /**
     * @experimental
     */
    onStateChange(name, target, options) {
        const rule = new events.Rule(this.scope, name, options);
        rule.addTarget(target);
        rule.addEventPattern({
            detailType: ['CodePipeline Action Execution State Change'],
            source: ['aws.codepipeline'],
            resources: [this.pipeline.pipelineArn],
            detail: {
                stage: [this.stage.stageName],
                action: [this.actionProperties.actionName],
            },
        });
        return rule;
    }
    /**
     * @experimental
     */
    variableExpression(variableName) {
        this.variableReferenced = true;
        return `#{${this.namespaceOrToken}.${variableName}}`;
    }
    get pipeline() {
        if (this._pipeline) {
            return this._pipeline;
        }
        else {
            throw new Error('Action must be added to a stage that is part of a pipeline before using onStateChange');
        }
    }
    get stage() {
        if (this._stage) {
            return this._stage;
        }
        else {
            throw new Error('Action must be added to a stage that is part of a pipeline before using onStateChange');
        }
    }
    /**
     * Retrieves the Construct scope of this Action.
     * Only available after the Action has been added to a Stage,
     * and that Stage to a Pipeline.
     */
    get scope() {
        if (this._scope) {
            return this._scope;
        }
        else {
            throw new Error('Action must be added to a stage that is part of a pipeline first');
        }
    }
}
exports.Action = Action;
_a = JSII_RTTI_SYMBOL_1;
Action[_a] = { fqn: "@aws-cdk/aws-codepipeline-actions.Action", version: "1.95.0" };
//# sourceMappingURL=data:application/json;base64,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