# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['tidypy',
 'tidypy.extenders',
 'tidypy.plugin',
 'tidypy.reports',
 'tidypy.tools']

package_data = \
{'': ['*']}

install_requires = \
['bandit>=1.4,<2',
 'basicserial>=0.1,<2.0',
 'check-manifest>=0.42,<0.48',
 'click>=6,<9',
 'demjson3>3,<4',
 'dennis>=0.9,<1',
 'detect-secrets>=1,<2',
 'dlint>=0.8,<0.13',
 'eradicate>=2,<3',
 'mccabe>=0.6,<0.7',
 'pep8-naming>=0.4,<0.13',
 'pycodestyle>=2.4,<2.9',
 'pydiatra>=0.12.2,<0.13',
 'pydocstyle>=4,<7',
 'pyflakes>=1.5,<2.5',
 'pylint>=2,<2.12',
 'pyroma>=2.2,<4',
 'pyyaml>=3.12,<7',
 'requests>=2,<3',
 'restructuredtext-lint>=1.1,<2',
 'toml>=0.10,<0.11',
 'tqdm>=4.11,<5',
 'vulture>=2.2,<3',
 'yamllint>=1.8,<2']

entry_points = \
{'console_scripts': ['tidypy = tidypy.cli:main'],
 'nose.plugins.0.10': ['tidypy = tidypy.plugin.nose:TidyPy'],
 'pytest11': ['tidypy = tidypy.plugin.pytest'],
 'tidypy.extenders': ['bitbucket = '
                      'tidypy.extenders.bitbucket:BitbucketExtender',
                      'bitbucket-snippet = '
                      'tidypy.extenders.bitbucket_snippet:BitbucketSnippetExtender',
                      'github = tidypy.extenders.github:GithubExtender',
                      'github-gist = '
                      'tidypy.extenders.github_gist:GithubGistExtender',
                      'gitlab = tidypy.extenders.gitlab:GitlabExtender',
                      'gitlab-snippet = '
                      'tidypy.extenders.gitlab_snippet:GitlabSnippetExtender',
                      'pastebin = tidypy.extenders.pastebin:PastebinExtender'],
 'tidypy.reports': ['console = tidypy.reports.console:ConsoleReport',
                    'csv = tidypy.reports.structured:CsvReport',
                    'custom = tidypy.reports.custom:CustomReport',
                    'json = tidypy.reports.structured:JsonReport',
                    'null = tidypy.reports.null:NullReport',
                    'pycodestyle = '
                    'tidypy.reports.pycodestyle:PyCodeStyleReport',
                    'pylint = tidypy.reports.pylint:PyLintReport',
                    'pylint-parseable = '
                    'tidypy.reports.pylint:PyLintParseableReport',
                    'toml = tidypy.reports.structured:TomlReport',
                    'yaml = tidypy.reports.structured:YamlReport'],
 'tidypy.tools': ['bandit = tidypy.tools.bandit:BanditTool',
                  'dlint = tidypy.tools.dlint:DlintTool',
                  'eradicate = tidypy.tools.eradicate:EradicateTool',
                  'jsonlint = tidypy.tools.jsonlint:JsonLintTool',
                  'manifest = tidypy.tools.manifest:CheckManifestTool',
                  'mccabe = tidypy.tools.mccabe:McCabeTool',
                  'polint = tidypy.tools.polint:PoLintTool',
                  'pycodestyle = tidypy.tools.pycodestyle:PyCodeStyleTool',
                  'pydiatra = tidypy.tools.pydiatra:PyDiatraTool',
                  'pydocstyle = tidypy.tools.pydocstyle:PyDocStyleTool',
                  'pyflakes = tidypy.tools.pyflakes:PyFlakesTool',
                  'pylint = tidypy.tools.pylint:PyLintTool',
                  'pyroma = tidypy.tools.pyroma:PyromaTool',
                  'rstlint = tidypy.tools.rstlint:RstLintTool',
                  'secrets = tidypy.tools.secrets:DetectSecretsTool',
                  'vulture = tidypy.tools.vulture:VultureTool',
                  'yamllint = tidypy.tools.yamllint:YamlLintTool']}

setup_kwargs = {
    'name': 'tidypy',
    'version': '0.22.0',
    'description': 'A tool that executes a suite of static analysis tools upon a Python project.',
    'long_description': '******\nTidyPy\n******\n\n.. image:: https://img.shields.io/pypi/v/tidypy.svg\n   :target: https://pypi.org/project/tidypy\n.. image:: https://img.shields.io/pypi/l/tidypy.svg\n   :target: https://pypi.org/project/tidypy\n.. image:: https://readthedocs.org/projects/tidypy/badge/?version=latest\n   :target: https://tidypy.readthedocs.io\n.. image:: https://github.com/jayclassless/tidypy/workflows/Test/badge.svg\n   :target: https://github.com/jayclassless/tidypy/actions\n.. image:: https://github.com/jayclassless/tidypy/workflows/Publish%20Docker%20Image/badge.svg\n   :target: https://hub.docker.com/r/tidypy/tidypy\n\n\n.. contents:: Contents\n\n\nOverview\n--------\nTidyPy is a tool that encapsulates a number of other static analysis tools and\nmakes it easy to configure, execute, and review their results.\n\n\nFeatures\n--------\n* It\'s a consolidated tool for performing static analysis on an entire Python\n  project -- not just your ``*.py`` source files. In addition to executing a\n  number of different `tools`_ on your code, it can also check your YAML, JSON,\n  PO, POT, and RST files.\n\n* Rather than putting yet another specialized configuration file in your\n  project, TidyPy uses the ``pyproject.toml`` file defined by `PEP 518`_. All\n  options for all the tools TidyPy uses are declared in one place, rather than\n  requiring that you configure each tool in a different way.\n\n  .. _PEP 518: https://www.python.org/dev/peps/pep-0518/\n\n* Honors the pseudo-standard ``# noqa`` comment in your Python source to easily\n  ignore issues reported by any tool.\n\n* Includes a number of `integrations`_ so you can use it with your favorite\n  toolchain.\n\n* Includes a variety of `reporters`_ that allow you to view or use the results\n  of TidyPy\'s analysis in whatever way works best for you.\n\n* Provides a simple API for you to implement your own tool or reporter and\n  include it in the analysis of your project.\n\n* Supports both Python 2 and 3, as well as PyPy. Even runs on Windows.\n\n\nUsage\n-----\nWhen TidyPy is installed (``pip install tidypy``), the ``tidypy`` command\nshould become available in your environment::\n\n    $ tidypy --help\n    Usage: tidypy [OPTIONS] COMMAND [ARGS]...\n\n      A tool that executes several static analysis tools upon a Python project\n      and aggregates the results.\n\n    Options:\n      --version  Show the version and exit.\n      --help     Show this message and exit.\n\n    Commands:\n      check               Executes the tools upon the project files.\n      default-config      Outputs a default configuration that can be used to\n                          bootstrap your own configuration file.\n      extensions          Outputs a listing of all available TidyPy extensions.\n      install-vcs         Installs TidyPy as a pre-commit hook into the specified\n                          VCS.\n      list-codes          Outputs a listing of all known issue codes that tools\n                          may report.\n      purge-config-cache  Deletes the cache of configurations retrieved from\n                          outside the primary configuration.\n      remove-vcs          Removes the TidyPy pre-commit hook from the specified\n                          VCS.\n\nTo have TidyPy analyze your project, use the ``check`` subcommand::\n\n    $ tidypy check --help\n    Usage: tidypy check [OPTIONS] [PATH]\n\n      Executes the tools upon the project files.\n\n      Accepts one argument, which is the path to the base of the Python project.\n      If not specified, defaults to the current working directory.\n\n    Options:\n      -x, --exclude REGEX             Specifies a regular expression matched\n                                      against paths that you want to exclude from\n                                      the examination. Can be specified multiple\n                                      times. Overrides the expressions specified\n                                      in the configuration file.\n      -t, --tool [bandit|dlint|eradicate|jsonlint|manifest|mccabe|polint|pycodestyle|pydiatra|pydocstyle|pyflakes|pylint|pyroma|rstlint|secrets|vulture|yamllint]\n                                      Specifies the name of a tool to use during\n                                      the examination. Can be specified multiple\n                                      times. Overrides the configuration file.\n      -r, --report [console,csv,custom,json,null,pycodestyle,pylint,pylint-parseable,toml,yaml][:filename]\n                                      Specifies the name of a report to execute\n                                      after the examination. Can specify an\n                                      optional output file name using the form -r\n                                      report:filename. If filename is unset, the\n                                      report will be written on stdout. Can be\n                                      specified multiple times. Overrides the\n                                      configuration file.\n      -c, --config FILENAME           Specifies the path to the TidyPy\n                                      configuration file to use instead of the\n                                      configuration found in the project\'s\n                                      pyproject.toml.\n      --workers NUM_WORKERS           The number of workers to use to concurrently\n                                      execute the tools. Overrides the\n                                      configuration file.\n      --disable-merge                 Disable the merging of issues from various\n                                      tools when TidyPy considers them equivalent.\n                                      Overrides the configuration file.\n      --disable-progress              Disable the display of the progress bar.\n      --disable-noqa                  Disable the ability to ignore issues using\n                                      the "# noqa" comment in Python files.\n      --disable-config-cache          Disable the use of the cache when retrieving\n                                      configurations referenced by the "extends"\n                                      option.\n      --help                          Show this message and exit.\n\nIf you need to generate a skeleton configuration file with the default options,\nuse the ``default-config`` subcommand::\n\n    $ tidypy default-config --help\n    Usage: tidypy default-config [OPTIONS]\n\n      Outputs a default configuration that can be used to bootstrap your own\n      configuration file.\n\n    Options:\n      --pyproject  Output the config so that it can be used in a pyproject.toml\n                   file.\n      --help       Show this message and exit.\n\nIf you\'d like to see a list of the possible issue codes that could be returned,\nuse the ``list-codes`` subcommand::\n\n    $ tidypy list-codes --help\n    Usage: tidypy list-codes [OPTIONS]\n\n      Outputs a listing of all known issue codes that tools may report.\n\n    Options:\n      -t, --tool [bandit|dlint|eradicate|jsonlint|manifest|mccabe|polint|pycodestyle|pydiatra|pydocstyle|pyflakes|pylint|pyroma|rstlint|secrets|vulture|yamllint]\n                                      Specifies the name of a tool whose codes\n                                      should be output. If not specified, defaults\n                                      to all tools.\n      -f, --format [toml|json|yaml|csv]\n                                      Specifies the format in which the tools\n                                      should be output. If not specified, defaults\n                                      to TOML.\n      --help                          Show this message and exit.\n\nIf you want to install or remove TidyPy as a pre-commit hook in your project\'s\nVCS, use the ``install-vcs``/``remove-vcs`` subcommands::\n\n    $ tidypy install-vcs --help\n    Usage: tidypy install-vcs [OPTIONS] VCS [PATH]\n\n      Installs TidyPy as a pre-commit hook into the specified VCS.\n\n      Accepts two arguments:\n\n        VCS: The version control system to install the hook into. Choose from:\n        git, hg\n\n        PATH: The path to the base of the repository to install the hook into.\n        If not specified, defaults to the current working directory.\n\n    Options:\n      --strict  Whether or not the hook should prevent the commit if TidyPy finds\n                issues.\n      --help    Show this message and exit.\n\n    $ tidypy remove-vcs --help\n    Usage: tidypy remove-vcs [OPTIONS] VCS [PATH]\n\n      Removes the TidyPy pre-commit hook from the specified VCS.\n\n      Accepts two arguments:\n\n        VCS: The version control system to remove the hook from. Choose from:\n        git, hg\n\n        PATH: The path to the base of the repository to remove the hook from. If\n        not specified, defaults to the current working directory.\n\n    Options:\n      --help  Show this message and exit.\n\nIf you\'d like to enable bash completion for TidyPy, run the following in your\nshell (or put it in your bash startup scripts)::\n\n    $ eval "$(_TIDYPY_COMPLETE=source tidypy)"\n\n\nDocker\n------\nIf you don\'t want to install TidyPy locally on your system or in your\nvirtualenv, you can use the `published Docker\n<https://hub.docker.com/r/tidypy/tidypy>`_ image::\n\n   $ docker run --rm --tty --volume=`pwd`:/project tidypy/tidypy\n\nThe command above will run ``tidypy check`` on the contents of the current\ndirectory. If you want to run it on a different directory, then change the\n```pwd``` to whatever path you need (the goal being to mount your project\ndirectory to the container\'s ``/project`` volume).\n\nRunning TidyPy in this manner has a few limitiations, mostly around the fact\nthat since TidyPy is running in its own, isolated Python environment, tools\nlike pylint won\'t be able to introspect the packages your project installed\nlocally, so it may report false positives around "import-error",\n"no-name-in-module", "no-member", etc.\n\nIf you want to run a command other than ``check``, just pass that along when\nyou invoke docker::\n\n   $ docker run --rm --tty --volume=`pwd`:/project tidypy/tidypy tidypy list-codes\n\n\nConfiguration\n-------------\nTODO\n\n\nIgnoring Issues\n---------------\nIn addition to ignoring entire files, tools, or specific issue types from tools\nvia your configuration file, you can also use comments in your Python source\nfiles to ignore issues on specific lines. Some tools have their own built-in\nsupport and notation for doing this:\n\n* `pylint will respect <https://pylint.readthedocs.io/en/latest/faq.html\n  #message-control>`_ comments that look like: ``# pylint``\n* `bandit will respect <https://github.com/openstack/bandit#exclusions>`_\n  comments that look like: ``# nosec``\n* `pycodestyle will respect <http://pycodestyle.pycqa.org/en/latest/intro.html\n  #error-codes>`_ comments that look like: ``# noqa``\n* `pydocstyle will also respect <http://www.pydocstyle.org/en/2.1.1/\n  usage.html#in-file-configuration>`_ comments that look like: ``# noqa``\n* `detect-secrets will respect <https://github.com/Yelp/detect-secrets\n  #inline-whitelisting>`_ comments that look like: ``# pragma: whitelist\n  secret``\n\nTidyPy goes beyond these tool-specific flags to implement ``# noqa`` on a\nglobal scale for Python source files. It will ignore issues for lines that have\nthe ``# noqa`` comment, regardless of what tools raise the issues. If you only\nwant to ignore a particular type of issue on a line, you can use syntax like\nthe following::\n\n    # noqa: CODE1,CODE2\n\nOr, if a particular code is used in multiple tools, you can specify the exact\ntool in the comment::\n\n    # noqa: pycodestyle:CODE1,pylint:CODE2\n\nOr, if you want to ignore any issue a specific tool raises on a line, you can\nspecify the tool::\n\n    # noqa: @pycodestyle,@pylint\n\nYou can, of course, mix and match all three notations in a single comment if\nyou need to::\n\n    # noqa: CODE1,pylint:CODE2,@pycodestyle\n\nYou can disable TidyPy\'s NOQA behavior by specifying the ``--disable-noqa``\noption on the command line, or by setting the ``noqa`` option to ``false`` in\nyour configuration file. A caveat, though: currently pycodestyle and pydocstyle\ndo not respect this option and will always honor any ``# noqa`` comments they\nfind.\n\n\n.. _tools:\n\nIncluded Tools\n--------------\nOut of the box, TidyPy includes support for a number of tools:\n\npylint\n    `Pylint`_ is a Python source code analyzer which looks for programming\n    errors, helps enforcing a coding standard and sniffs for some code smells.\n\n    .. _Pylint: https://github.com/PyCQA/pylint\n\npycodestyle\n    `pycodestyle`_ is a tool to check your Python code against some of the\n    style conventions in `PEP 8`_.\n\n    .. _pycodestyle: https://github.com/PyCQA/pycodestyle\n    .. _PEP 8: https://www.python.org/dev/peps/pep-0008/\n\npydocstyle\n    `pydocstyle`_ is a static analysis tool for checking compliance with Python\n    docstring conventions (e.g., `PEP 257`_).\n\n    .. _pydocstyle: https://github.com/PyCQA/pydocstyle\n    .. _PEP 257: https://www.python.org/dev/peps/pep-0257/\n\npyroma\n    `Pyroma`_ tests your project\'s packaging friendliness.\n\n    .. _Pyroma: https://github.com/regebro/pyroma\n\nvulture\n    `Vulture`_ finds unused code in Python programs.\n\n    .. _Vulture: https://github.com/jendrikseipp/vulture\n\nbandit\n    `Bandit`_ is a security linter for Python source code.\n\n    .. _Bandit: https://wiki.openstack.org/wiki/Security/Projects/Bandit\n\neradicate\n    `Eradicate`_ finds commented-out code in Python files.\n\n    .. _Eradicate: https://github.com/myint/eradicate\n\npyflakes\n    `Pyflakes`_ is a simple program which checks Python source files for\n    errors.\n\n    .. _Pyflakes: https://github.com/PyCQA/pyflakes\n\nmccabe\n    Ned Batchelder\'s script to check the `McCabe`_ cyclomatic complexity of\n    Python code.\n\n    .. _McCabe: https://github.com/pycqa/mccabe\n\njsonlint\n    A part of the `demjson`_ package, this tool validates your JSON documents\n    for strict conformance to the JSON specification, and to detect potential\n    data portability issues.\n\n    .. _demjson: https://github.com/dmeranda/demjson\n\nyamllint\n    The `yamllint`_ tool, as its name implies, is a linter for YAML files.\n\n    .. _yamllint: https://github.com/adrienverge/yamllint\n\nrstlint\n    The `restructuredtext-lint`_ tool, as its name implies, is a linter for\n    reStructuredText files.\n\n    .. _restructuredtext-lint: https://github.com/twolfson/restructuredtext-lint\n\npolint\n    A part of the `dennis`_ package, this tool lints PO and POT files for\n    problems.\n\n    .. _dennis: https://github.com/willkg/dennis\n\nmanifest\n    Uses the `check-manifest`_ script to detect discrepancies or problems with\n    your project\'s MANIFEST.in file.\n\n    .. _check-manifest: https://github.com/mgedmin/check-manifest\n\npydiatra\n    `pydiatra`_ is yet another static checker for Python code.\n\n    .. _pydiatra: https://github.com/jwilk/pydiatra\n\nsecrets\n    The `detect-secrets`_ tool attempts to find secrets (keys, passwords, etc)\n    within a code base.\n\n    .. _detect-secrets: https://github.com/Yelp/detect-secrets\n\ndlint\n    `Dlint`_ is a tool for encouraging best coding practices and helping ensure\n    we\'re writing secure Python code.\n\n    .. _Dlint: https://github.com/duo-labs/dlint\n\n.. _reporters:\n\nIncluded Reporters\n------------------\nTidyPy includes a number of different methods to present and/or export the\nresults of the analysis of a project. Out of the box, it provides the\nfollowing:\n\nconsole\n    The default reporter. Prints a colored report to the console that groups\n    issues by the file they were found in.\n\npylint\n    Prints a report to the console that is in the same format as `Pylint`_\'s\n    default output.\n\npylint-parseable\n    Prints a report to the console that is in roughly the same format as\n    `Pylint`_\'s "parseable" output.\n\npycodestyle\n    Prints a report to the console that is in the same format as\n    `pycodestyle`_\'s default output.\n\njson\n    Generates a JSON-serialized object that contains the results of the\n    analysis.\n\nyaml\n    Generates a YAML-serialized object that contains the results of the\n    analysis.\n\ntoml\n    Generates a TOML-serialized object that contains the results of the\n    analysis.\n\ncsv\n    Generates a set of CSV records that contains the results of the analysis.\n\ncustom\n    Prints ouput to the console that is in the format defined by a template\n    string specified in the project configuration. The template string is\n    expected to be one allowed by the `str.format()`_ Python method. It will\n    receive the following arguments: ``filename``, ``line``, ``character``,\n    ``tool``, ``code``, ``message``.\n\n    .. _str.format(): https://docs.python.org/3/library/stdtypes.html#str.format\n\n\n.. _integrations:\n\nIncluded Integrations\n---------------------\nTidyPy includes a handful of plugins/integrations that hook it into other\ntools.\n\npytest\n    TidyPy can be run during execution of your `pytest`_ test suite. To enable\n    it, you need to specify ``--tidypy`` on the command line when you run\n    pytest, or include it as part of the ``addopts`` property in your pytest\n    config.\n\n    .. _pytest: https://docs.pytest.org\n\nnose\n    TidyPy can be run during execution of your `nose`_ test suite. To enable\n    it, you can either specify ``--with-tidypy`` on the command line when you\n    run nose, or set the ``with-tidypy`` property to ``1`` in your\n    ``setup.cfg``.\n\n    .. _nose: https://nose.readthedocs.io\n\npbbt\n    TidyPy can be included in your `PBBT`_ scripts using the ``tidypy`` test.\n    To enable it, you can either specify ``--extend=tidypy.plugin.pbbt`` on the\n    command line when you run PBBT, or set the ``extend`` property in your\n    ``setup.cfg`` or ``pbbt.yaml`` to ``tidypy.plugin.pbbt``.\n\n    .. _PBBT: https://bitbucket.org/prometheus/pbbt\n\n\nExtending TidyPy\n----------------\nA simple interface exists for extending TidyPy to include more and different\ntools and reporters. To add a tool, create a class that extends `tidypy.Tool`_,\nand in your ``setup.py``, declare an ``entry_point`` for ``tidypy.tools`` that\npoints to your class::\n\n    entry_points={\n        \'tidypy.tools\': [\n            \'mycooltool = path.to.model:MyCoolToolClassName\',\n        ],\n    }\n\nTo add a reporter, the process is nearly identical, except that you extend\n`tidypy.Report`_ and declare an ``entry_point`` for ``tidypy.reports``.\n\n.. _tidypy.Tool: https://tidypy.readthedocs.io/en/stable/api.html#tidypy.Tool\n.. _tidypy.Report: https://tidypy.readthedocs.io/en/stable/api.html#tidypy.Report\n\n\nFAQs\n----\nAren\'t there already tools like this?\n    Yup. There\'s `prospector`_, `pylama`_, `flake8`_, and `ciocheck`_ just to\n    name a few. But, as is customary in the world of software development, if\n    the wheel isn\'t as round as you\'d like it to be, you must spend countless\n    hours to reinvent it. I\'ve tried a number of these tools (and even\n    contributed to some), but in the end, I always found something lacking or\n    annoying. Thus, TidyPy was born.\n\n    .. _prospector: https://github.com/landscapeio/prospector\n    .. _pylama: https://github.com/klen/pylama\n    .. _flake8: https://gitlab.com/pycqa/flake8\n    .. _ciocheck: https://github.com/ContinuumIO/ciocheck\n\nHow do I run TidyPy on a single file?\n    The short answer is, you don\'t (at the moment, anyway). It wasn\'t designed\n    with that use case in mind. TidyPy was built to analyze a whole project,\n    and show you everything.\n\nI tried TidyPy out on my project and it reported hundreds/thousands of issues. My ego is now bruised.\n    Yea, that happens. The philosophy I chose to follow with this tool is that\n    I didn\'t want it to hide anything from me. I wanted its default behavior to\n    execute every tool in its suite using their most obnoxious setting. Then,\n    when I can see the full scope of damage, I can then decide to disable\n    specific tools or issues via a project-level configuration. I figured if\n    someone took the time to implement a check for a particular issue, they\n    must think it has some value. If my tooling hides that from me by default,\n    then I won\'t be able to gain any benefits from it.\n\n    In general, I don\'t recommend starting to use linters or other sorts of\n    static analyzers when you think you\'re "done". You should incorporate them\n    into your workflow right at the beginning of a project -- just as you would\n    (or should) your unit tests. That way you find things early and learn from\n    them (or disable them). It\'s much less daunting a task to deal with when\n    you address them incrementally.\n\n\nContributing\n------------\nContributions are most welcome. Particularly if they\'re bug fixes! To hack on\nthis code, simply clone it, and then run ``make setup``. This will create a\nvirtualenv with all the tools you\'ll need. The ``Makefile`` also has a ``test``\ntarget for running the pytest suite, and a ``lint`` target for running TidyPy\non itself.\n\n\nLicense\n-------\nTidyPy is released under the terms of the `MIT License`_.\n\n.. _MIT License: https://opensource.org/licenses/MIT\n\n',
    'author': 'Jason Simeone',
    'author_email': 'jay@classless.net',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/jayclassless/tidypy',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
