# Configuration file for the Sphinx documentation builder.
#
# This file only contains a selection of the most common options. For a full
# list see the documentation:
# https://www.sphinx-doc.org/en/master/usage/configuration.html

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
import os
import sys
sys.path.insert(0, os.path.abspath('.'))
sys.path.insert(0, os.path.abspath('../'))

import mock 
 

MOCK_MODULES = ['numpy', 'netCDF4','prompt_toolkit.shortcuts','scipy','pyart.aux_io','matplotlib', 'matplotlib.pyplot', 'scipy.interpolate','pyart','pyspark','imageio','prompt_toolkit','matplotlib.colors','scipy.spatial',

'sklearn','scipy.stats','scipy.ndimage','dask','pandas','yaml','sklearn.ensemble','scipy.signal','shapefile','scipy.spatial.distance',

'dask.dataframe','dateutil','pyart.map','pyspark.sql','prompt_toolkit.formatted_text','pyart.retrieve','pyart.map.polar_to_cartesian',

'xmltodict','pyart.util','pyart.map.polar_to_cartesian','pyart.correct','numpy.ma.core','scipy.ndimage.interpolation','prompt_toolkit.styles','pysteps']
for mod_name in MOCK_MODULES:
     sys.modules[mod_name] = mock.MagicMock()


# -- Project information -----------------------------------------------------

project = 'Rainforest QPE library'
copyright = '2020, Daniel Wolfensherger'
author = 'Daniel Wolfensherger'


# -- General configuration ---------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = ['sphinx.ext.napoleon']
master_doc = 'index'

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = []

autoclass_content = 'both'
# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = 'sphinx_rtd_theme'
html_theme_options = {'navigation_depth':5, 'collapse_navigation':False}
# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']
