import datetime
import os

import numpy as np

limits = {
    "603717.XSHG": np.array(
        [
            (datetime.date(2022, 3, 7), 16.32, 13.36),
            (datetime.date(2022, 3, 8), 16.38, 13.4),
            (datetime.date(2022, 3, 9), 16.2, 13.26),
            (datetime.date(2022, 3, 10), 15.07, 12.33),
        ],
        dtype=[("frame", "O"), ("high_limit", "<f4"), ("low_limit", "<f4")],
    ),
    "002537.XSHE": np.array(
        [
            (datetime.date(2022, 3, 9), 10.03, 8.21),
            (datetime.date(2022, 3, 10), 9.68, 7.92),
        ],
        dtype=[("frame", "O"), ("high_limit", "<f8"), ("low_limit", "<f8")],
    ),
}


# 海联金汇, 2022-3-10, 涨停板
bars_match = {
    "002537.XSHE": np.array(
        [
            (datetime.datetime(2022, 3, 9, 9, 31), 9.08, 5.28190e06),
            (datetime.datetime(2022, 3, 9, 9, 32), 8.96, 1.28050e06),
            (datetime.datetime(2022, 3, 9, 9, 33), 8.92, 2.65970e06),
            (datetime.datetime(2022, 3, 9, 9, 34), 8.83, 3.97250e06),
            (datetime.datetime(2022, 3, 9, 9, 35), 8.79, 2.86700e06),
            (datetime.datetime(2022, 3, 9, 9, 36), 8.9, 1.98960e06),
            (datetime.datetime(2022, 3, 9, 9, 37), 8.88, 1.79190e06),
            (datetime.datetime(2022, 3, 9, 9, 38), 8.94, 1.23830e06),
            (datetime.datetime(2022, 3, 9, 9, 39), 8.97, 1.06560e06),
            (datetime.datetime(2022, 3, 9, 9, 40), 8.95, 7.94000e05),
            (datetime.datetime(2022, 3, 9, 9, 41), 8.98, 8.92700e05),
            (datetime.datetime(2022, 3, 9, 9, 42), 8.96, 7.46000e05),
            (datetime.datetime(2022, 3, 9, 9, 43), 9.0, 7.25000e05),
            (datetime.datetime(2022, 3, 9, 9, 44), 8.98, 9.83000e05),
            (datetime.datetime(2022, 3, 9, 9, 45), 8.95, 5.84400e05),
            (datetime.datetime(2022, 3, 9, 9, 46), 8.91, 8.38700e05),
            (datetime.datetime(2022, 3, 9, 9, 47), 8.9, 1.21820e06),
            (datetime.datetime(2022, 3, 9, 9, 48), 8.86, 5.93700e05),
            (datetime.datetime(2022, 3, 9, 9, 49), 8.87, 1.26650e06),
            (datetime.datetime(2022, 3, 9, 9, 50), 8.86, 9.90000e05),
            (datetime.datetime(2022, 3, 9, 9, 51), 8.91, 9.13200e05),
            (datetime.datetime(2022, 3, 9, 9, 52), 8.87, 5.90600e05),
            (datetime.datetime(2022, 3, 9, 9, 53), 8.86, 4.81200e05),
            (datetime.datetime(2022, 3, 9, 9, 54), 8.81, 7.80700e05),
            (datetime.datetime(2022, 3, 9, 9, 55), 8.77, 2.15890e06),
            (datetime.datetime(2022, 3, 9, 9, 56), 8.8, 9.83100e05),
            (datetime.datetime(2022, 3, 9, 9, 57), 8.83, 9.60900e05),
            (datetime.datetime(2022, 3, 9, 9, 58), 8.76, 1.26690e06),
            (datetime.datetime(2022, 3, 9, 9, 59), 8.78, 1.98210e06),
            (datetime.datetime(2022, 3, 9, 10, 0), 8.79, 9.18500e05),
            (datetime.datetime(2022, 3, 9, 10, 1), 8.76, 1.03510e06),
            (datetime.datetime(2022, 3, 9, 10, 2), 8.74, 2.18600e06),
            (datetime.datetime(2022, 3, 9, 10, 3), 8.73, 1.04690e06),
            (datetime.datetime(2022, 3, 9, 10, 4), 8.72, 7.59000e05),
            (datetime.datetime(2022, 3, 9, 10, 5), 8.7, 1.69830e06),
            (datetime.datetime(2022, 3, 9, 10, 6), 8.76, 1.14050e06),
            (datetime.datetime(2022, 3, 9, 10, 7), 8.75, 5.29200e05),
            (datetime.datetime(2022, 3, 9, 10, 8), 8.75, 8.74300e05),
            (datetime.datetime(2022, 3, 9, 10, 9), 8.74, 3.84100e05),
            (datetime.datetime(2022, 3, 9, 10, 10), 8.72, 5.80400e05),
            (datetime.datetime(2022, 3, 9, 10, 11), 8.79, 1.00760e06),
            (datetime.datetime(2022, 3, 9, 10, 12), 8.79, 9.84700e05),
            (datetime.datetime(2022, 3, 9, 10, 13), 8.77, 4.41800e05),
            (datetime.datetime(2022, 3, 9, 10, 14), 8.82, 5.72900e05),
            (datetime.datetime(2022, 3, 9, 10, 15), 8.78, 5.90800e05),
            (datetime.datetime(2022, 3, 9, 10, 16), 8.78, 3.44800e05),
            (datetime.datetime(2022, 3, 9, 10, 17), 8.79, 3.23200e05),
            (datetime.datetime(2022, 3, 9, 10, 18), 8.81, 3.47900e05),
            (datetime.datetime(2022, 3, 9, 10, 19), 8.8, 3.02900e05),
            (datetime.datetime(2022, 3, 9, 10, 20), 8.76, 4.50100e05),
            (datetime.datetime(2022, 3, 9, 10, 21), 8.74, 3.95500e05),
            (datetime.datetime(2022, 3, 9, 10, 22), 8.75, 4.48600e05),
            (datetime.datetime(2022, 3, 9, 10, 23), 8.76, 3.22000e05),
            (datetime.datetime(2022, 3, 9, 10, 24), 8.73, 3.91100e05),
            (datetime.datetime(2022, 3, 9, 10, 25), 8.72, 3.80100e05),
            (datetime.datetime(2022, 3, 9, 10, 26), 8.74, 4.74000e05),
            (datetime.datetime(2022, 3, 9, 10, 27), 8.74, 2.93700e05),
            (datetime.datetime(2022, 3, 9, 10, 28), 8.72, 2.63100e05),
            (datetime.datetime(2022, 3, 9, 10, 29), 8.7, 1.42900e06),
            (datetime.datetime(2022, 3, 9, 10, 30), 8.68, 5.64300e05),
            (datetime.datetime(2022, 3, 9, 10, 31), 8.71, 5.86400e05),
            (datetime.datetime(2022, 3, 9, 10, 32), 8.75, 2.31700e05),
            (datetime.datetime(2022, 3, 9, 10, 33), 8.71, 4.87200e05),
            (datetime.datetime(2022, 3, 9, 10, 34), 8.71, 1.72300e05),
            (datetime.datetime(2022, 3, 9, 10, 35), 8.72, 2.96500e05),
            (datetime.datetime(2022, 3, 9, 10, 36), 8.7, 4.94400e05),
            (datetime.datetime(2022, 3, 9, 10, 37), 8.69, 3.33200e05),
            (datetime.datetime(2022, 3, 9, 10, 38), 8.68, 6.20100e05),
            (datetime.datetime(2022, 3, 9, 10, 39), 8.64, 1.35280e06),
            (datetime.datetime(2022, 3, 9, 10, 40), 8.62, 1.43840e06),
            (datetime.datetime(2022, 3, 9, 10, 41), 8.68, 5.21400e05),
            (datetime.datetime(2022, 3, 9, 10, 42), 8.6, 1.06960e06),
            (datetime.datetime(2022, 3, 9, 10, 43), 8.62, 9.02200e05),
            (datetime.datetime(2022, 3, 9, 10, 44), 8.62, 4.84700e05),
            (datetime.datetime(2022, 3, 9, 10, 45), 8.57, 7.61800e05),
            (datetime.datetime(2022, 3, 9, 10, 46), 8.62, 1.53950e06),
            (datetime.datetime(2022, 3, 9, 10, 47), 8.68, 6.09800e05),
            (datetime.datetime(2022, 3, 9, 10, 48), 8.67, 6.53700e05),
            (datetime.datetime(2022, 3, 9, 10, 49), 8.68, 2.21800e05),
            (datetime.datetime(2022, 3, 9, 10, 50), 8.65, 2.37100e05),
            (datetime.datetime(2022, 3, 9, 10, 51), 8.66, 2.79300e05),
            (datetime.datetime(2022, 3, 9, 10, 52), 8.65, 2.04900e05),
            (datetime.datetime(2022, 3, 9, 10, 53), 8.61, 3.09500e05),
            (datetime.datetime(2022, 3, 9, 10, 54), 8.61, 3.07000e05),
            (datetime.datetime(2022, 3, 9, 10, 55), 8.56, 3.32500e05),
            (datetime.datetime(2022, 3, 9, 10, 56), 8.57, 6.64000e05),
            (datetime.datetime(2022, 3, 9, 10, 57), 8.6, 2.70400e05),
            (datetime.datetime(2022, 3, 9, 10, 58), 8.61, 2.88800e05),
            (datetime.datetime(2022, 3, 9, 10, 59), 8.56, 2.45900e05),
            (datetime.datetime(2022, 3, 9, 11, 0), 8.58, 4.80200e05),
            (datetime.datetime(2022, 3, 9, 11, 1), 8.6, 4.73000e05),
            (datetime.datetime(2022, 3, 9, 11, 2), 8.62, 3.69900e05),
            (datetime.datetime(2022, 3, 9, 11, 3), 8.6, 2.37000e05),
            (datetime.datetime(2022, 3, 9, 11, 4), 8.6, 2.36700e05),
            (datetime.datetime(2022, 3, 9, 11, 5), 8.61, 3.28300e05),
            (datetime.datetime(2022, 3, 9, 11, 6), 8.6, 2.71400e05),
            (datetime.datetime(2022, 3, 9, 11, 7), 8.57, 4.19300e05),
            (datetime.datetime(2022, 3, 9, 11, 8), 8.58, 2.54100e05),
            (datetime.datetime(2022, 3, 9, 11, 9), 8.58, 2.44300e05),
            (datetime.datetime(2022, 3, 9, 11, 10), 8.56, 3.75000e05),
            (datetime.datetime(2022, 3, 9, 11, 11), 8.57, 5.04900e05),
            (datetime.datetime(2022, 3, 9, 11, 12), 8.6, 3.67700e05),
            (datetime.datetime(2022, 3, 9, 11, 13), 8.56, 6.78000e05),
            (datetime.datetime(2022, 3, 9, 11, 14), 8.52, 8.29300e05),
            (datetime.datetime(2022, 3, 9, 11, 15), 8.55, 3.25400e05),
            (datetime.datetime(2022, 3, 9, 11, 16), 8.53, 3.19000e05),
            (datetime.datetime(2022, 3, 9, 11, 17), 8.54, 2.64700e05),
            (datetime.datetime(2022, 3, 9, 11, 18), 8.53, 4.60600e05),
            (datetime.datetime(2022, 3, 9, 11, 19), 8.58, 4.07500e05),
            (datetime.datetime(2022, 3, 9, 11, 20), 8.57, 3.02800e05),
            (datetime.datetime(2022, 3, 9, 11, 21), 8.55, 1.94100e05),
            (datetime.datetime(2022, 3, 9, 11, 22), 8.58, 2.41600e05),
            (datetime.datetime(2022, 3, 9, 11, 23), 8.6, 2.20000e05),
            (datetime.datetime(2022, 3, 9, 11, 24), 8.56, 2.34700e05),
            (datetime.datetime(2022, 3, 9, 11, 25), 8.56, 1.93700e05),
            (datetime.datetime(2022, 3, 9, 11, 26), 8.58, 1.63600e05),
            (datetime.datetime(2022, 3, 9, 11, 27), 8.57, 4.33700e05),
            (datetime.datetime(2022, 3, 9, 11, 28), 8.56, 1.58400e05),
            (datetime.datetime(2022, 3, 9, 11, 29), 8.57, 2.61400e05),
            (datetime.datetime(2022, 3, 9, 11, 30), 8.54, 2.05800e05),
            (datetime.datetime(2022, 3, 9, 13, 1), 8.56, 1.19660e06),
            (datetime.datetime(2022, 3, 9, 13, 2), 8.57, 1.44600e05),
            (datetime.datetime(2022, 3, 9, 13, 3), 8.54, 2.13200e05),
            (datetime.datetime(2022, 3, 9, 13, 4), 8.48, 8.30600e05),
            (datetime.datetime(2022, 3, 9, 13, 5), 8.53, 1.40070e06),
            (datetime.datetime(2022, 3, 9, 13, 6), 8.52, 2.46200e05),
            (datetime.datetime(2022, 3, 9, 13, 7), 8.51, 3.25800e05),
            (datetime.datetime(2022, 3, 9, 13, 8), 8.56, 1.00050e06),
            (datetime.datetime(2022, 3, 9, 13, 9), 8.56, 4.46000e05),
            (datetime.datetime(2022, 3, 9, 13, 10), 8.56, 2.67600e05),
            (datetime.datetime(2022, 3, 9, 13, 11), 8.54, 2.09600e05),
            (datetime.datetime(2022, 3, 9, 13, 12), 8.59, 3.65100e05),
            (datetime.datetime(2022, 3, 9, 13, 13), 8.65, 8.78300e05),
            (datetime.datetime(2022, 3, 9, 13, 14), 8.63, 2.54800e05),
            (datetime.datetime(2022, 3, 9, 13, 15), 8.62, 2.98400e05),
            (datetime.datetime(2022, 3, 9, 13, 16), 8.6, 5.14200e05),
            (datetime.datetime(2022, 3, 9, 13, 17), 8.55, 2.62300e05),
            (datetime.datetime(2022, 3, 9, 13, 18), 8.57, 2.12600e05),
            (datetime.datetime(2022, 3, 9, 13, 19), 8.6, 2.94300e05),
            (datetime.datetime(2022, 3, 9, 13, 20), 8.57, 1.63300e05),
            (datetime.datetime(2022, 3, 9, 13, 21), 8.59, 2.29600e05),
            (datetime.datetime(2022, 3, 9, 13, 22), 8.58, 6.66000e05),
            (datetime.datetime(2022, 3, 9, 13, 23), 8.55, 3.44800e05),
            (datetime.datetime(2022, 3, 9, 13, 24), 8.52, 2.24200e05),
            (datetime.datetime(2022, 3, 9, 13, 25), 8.48, 4.41100e05),
            (datetime.datetime(2022, 3, 9, 13, 26), 8.52, 4.70800e05),
            (datetime.datetime(2022, 3, 9, 13, 27), 8.53, 2.72400e05),
            (datetime.datetime(2022, 3, 9, 13, 28), 8.52, 2.88200e05),
            (datetime.datetime(2022, 3, 9, 13, 29), 8.5, 3.50200e05),
            (datetime.datetime(2022, 3, 9, 13, 30), 8.46, 5.46600e05),
            (datetime.datetime(2022, 3, 9, 13, 31), 8.49, 5.41800e05),
            (datetime.datetime(2022, 3, 9, 13, 32), 8.45, 2.85800e05),
            (datetime.datetime(2022, 3, 9, 13, 33), 8.43, 6.09500e05),
            (datetime.datetime(2022, 3, 9, 13, 34), 8.4, 1.08060e06),
            (datetime.datetime(2022, 3, 9, 13, 35), 8.45, 7.55900e05),
            (datetime.datetime(2022, 3, 9, 13, 36), 8.49, 3.45300e05),
            (datetime.datetime(2022, 3, 9, 13, 37), 8.5, 3.80900e05),
            (datetime.datetime(2022, 3, 9, 13, 38), 8.48, 3.63000e05),
            (datetime.datetime(2022, 3, 9, 13, 39), 8.48, 2.11900e05),
            (datetime.datetime(2022, 3, 9, 13, 40), 8.44, 3.35800e05),
            (datetime.datetime(2022, 3, 9, 13, 41), 8.47, 6.40200e05),
            (datetime.datetime(2022, 3, 9, 13, 42), 8.49, 2.14700e05),
            (datetime.datetime(2022, 3, 9, 13, 43), 8.44, 2.71400e05),
            (datetime.datetime(2022, 3, 9, 13, 44), 8.44, 5.76100e05),
            (datetime.datetime(2022, 3, 9, 13, 45), 8.39, 6.28400e05),
            (datetime.datetime(2022, 3, 9, 13, 46), 8.35, 9.78000e05),
            (datetime.datetime(2022, 3, 9, 13, 47), 8.36, 6.39100e05),
            (datetime.datetime(2022, 3, 9, 13, 48), 8.29, 1.79050e06),
            (datetime.datetime(2022, 3, 9, 13, 49), 8.23, 2.13330e06),
            (datetime.datetime(2022, 3, 9, 13, 50), 8.36, 1.27630e06),
            (datetime.datetime(2022, 3, 9, 13, 51), 8.44, 9.15500e05),
            (datetime.datetime(2022, 3, 9, 13, 52), 8.42, 6.28900e05),
            (datetime.datetime(2022, 3, 9, 13, 53), 8.42, 4.58300e05),
            (datetime.datetime(2022, 3, 9, 13, 54), 8.39, 3.56400e05),
            (datetime.datetime(2022, 3, 9, 13, 55), 8.35, 3.23100e05),
            (datetime.datetime(2022, 3, 9, 13, 56), 8.44, 6.15800e05),
            (datetime.datetime(2022, 3, 9, 13, 57), 8.45, 8.24400e05),
            (datetime.datetime(2022, 3, 9, 13, 58), 8.5, 7.48100e05),
            (datetime.datetime(2022, 3, 9, 13, 59), 8.5, 6.23700e05),
            (datetime.datetime(2022, 3, 9, 14, 0), 8.46, 5.45200e05),
            (datetime.datetime(2022, 3, 9, 14, 1), 8.49, 6.24800e05),
            (datetime.datetime(2022, 3, 9, 14, 2), 8.48, 3.35100e05),
            (datetime.datetime(2022, 3, 9, 14, 3), 8.46, 4.76900e05),
            (datetime.datetime(2022, 3, 9, 14, 4), 8.48, 4.38600e05),
            (datetime.datetime(2022, 3, 9, 14, 5), 8.51, 4.78900e05),
            (datetime.datetime(2022, 3, 9, 14, 6), 8.46, 4.79500e05),
            (datetime.datetime(2022, 3, 9, 14, 7), 8.45, 2.49000e05),
            (datetime.datetime(2022, 3, 9, 14, 8), 8.48, 1.20500e05),
            (datetime.datetime(2022, 3, 9, 14, 9), 8.5, 3.55600e05),
            (datetime.datetime(2022, 3, 9, 14, 10), 8.52, 2.35200e05),
            (datetime.datetime(2022, 3, 9, 14, 11), 8.56, 3.75100e05),
            (datetime.datetime(2022, 3, 9, 14, 12), 8.55, 5.94500e05),
            (datetime.datetime(2022, 3, 9, 14, 13), 8.58, 6.16300e05),
            (datetime.datetime(2022, 3, 9, 14, 14), 8.63, 7.57900e05),
            (datetime.datetime(2022, 3, 9, 14, 15), 8.59, 5.11000e05),
            (datetime.datetime(2022, 3, 9, 14, 16), 8.59, 3.31600e05),
            (datetime.datetime(2022, 3, 9, 14, 17), 8.61, 3.04100e05),
            (datetime.datetime(2022, 3, 9, 14, 18), 8.62, 4.37300e05),
            (datetime.datetime(2022, 3, 9, 14, 19), 8.62, 3.03900e05),
            (datetime.datetime(2022, 3, 9, 14, 20), 8.6, 3.39500e05),
            (datetime.datetime(2022, 3, 9, 14, 21), 8.57, 3.25300e05),
            (datetime.datetime(2022, 3, 9, 14, 22), 8.56, 4.69600e05),
            (datetime.datetime(2022, 3, 9, 14, 23), 8.58, 2.27700e05),
            (datetime.datetime(2022, 3, 9, 14, 24), 8.69, 8.85900e05),
            (datetime.datetime(2022, 3, 9, 14, 25), 8.64, 4.40500e05),
            (datetime.datetime(2022, 3, 9, 14, 26), 8.63, 3.82200e05),
            (datetime.datetime(2022, 3, 9, 14, 27), 8.65, 3.16700e05),
            (datetime.datetime(2022, 3, 9, 14, 28), 8.68, 4.22900e05),
            (datetime.datetime(2022, 3, 9, 14, 29), 8.7, 6.75500e05),
            (datetime.datetime(2022, 3, 9, 14, 30), 8.72, 6.82500e05),
            (datetime.datetime(2022, 3, 9, 14, 31), 8.75, 8.01900e05),
            (datetime.datetime(2022, 3, 9, 14, 32), 8.72, 5.18100e05),
            (datetime.datetime(2022, 3, 9, 14, 33), 8.73, 3.92100e05),
            (datetime.datetime(2022, 3, 9, 14, 34), 8.72, 3.12500e05),
            (datetime.datetime(2022, 3, 9, 14, 35), 8.76, 4.05700e05),
            (datetime.datetime(2022, 3, 9, 14, 36), 8.78, 6.91800e05),
            (datetime.datetime(2022, 3, 9, 14, 37), 8.78, 9.26600e05),
            (datetime.datetime(2022, 3, 9, 14, 38), 8.8, 1.09970e06),
            (datetime.datetime(2022, 3, 9, 14, 39), 8.81, 5.55600e05),
            (datetime.datetime(2022, 3, 9, 14, 40), 8.8, 3.94700e05),
            (datetime.datetime(2022, 3, 9, 14, 41), 8.78, 6.68100e05),
            (datetime.datetime(2022, 3, 9, 14, 42), 8.79, 3.99400e05),
            (datetime.datetime(2022, 3, 9, 14, 43), 8.82, 6.09900e05),
            (datetime.datetime(2022, 3, 9, 14, 44), 8.77, 6.28600e05),
            (datetime.datetime(2022, 3, 9, 14, 45), 8.8, 4.50600e05),
            (datetime.datetime(2022, 3, 9, 14, 46), 8.81, 3.17400e05),
            (datetime.datetime(2022, 3, 9, 14, 47), 8.78, 6.15300e05),
            (datetime.datetime(2022, 3, 9, 14, 48), 8.77, 5.65500e05),
            (datetime.datetime(2022, 3, 9, 14, 49), 8.76, 3.57300e05),
            (datetime.datetime(2022, 3, 9, 14, 50), 8.77, 4.57000e05),
            (datetime.datetime(2022, 3, 9, 14, 51), 8.78, 5.97400e05),
            (datetime.datetime(2022, 3, 9, 14, 52), 8.73, 1.06560e06),
            (datetime.datetime(2022, 3, 9, 14, 53), 8.74, 7.95600e05),
            (datetime.datetime(2022, 3, 9, 14, 54), 8.74, 5.07300e05),
            (datetime.datetime(2022, 3, 9, 14, 55), 8.73, 8.07600e05),
            (datetime.datetime(2022, 3, 9, 14, 56), 8.77, 6.39300e05),
            (datetime.datetime(2022, 3, 9, 14, 57), 8.82, 9.47700e05),
            (datetime.datetime(2022, 3, 9, 14, 58), 8.83, 8.13000e04),
            (datetime.datetime(2022, 3, 9, 14, 59), 8.83, 0.00000e00),
            (datetime.datetime(2022, 3, 9, 15, 0), 8.8, 1.73880e06),
            (datetime.datetime(2022, 3, 10, 9, 31), 9.1, 1.48753e07),
            (datetime.datetime(2022, 3, 10, 9, 32), 9.18, 3.68150e06),
            (datetime.datetime(2022, 3, 10, 9, 33), 9.09, 5.09130e06),
            (datetime.datetime(2022, 3, 10, 9, 34), 8.99, 4.61780e06),
            (datetime.datetime(2022, 3, 10, 9, 35), 9.12, 3.16130e06),
            (datetime.datetime(2022, 3, 10, 9, 36), 9.03, 1.75680e06),
            (datetime.datetime(2022, 3, 10, 9, 37), 9.38, 5.65370e06),
            (datetime.datetime(2022, 3, 10, 9, 38), 9.44, 8.93160e06),
            (datetime.datetime(2022, 3, 10, 9, 39), 9.46, 6.31950e06),
            (datetime.datetime(2022, 3, 10, 9, 40), 9.44, 6.82940e06),
            (datetime.datetime(2022, 3, 10, 9, 41), 9.35, 4.76490e06),
            (datetime.datetime(2022, 3, 10, 9, 42), 9.43, 3.18200e06),
            (datetime.datetime(2022, 3, 10, 9, 43), 9.36, 2.12860e06),
            (datetime.datetime(2022, 3, 10, 9, 44), 9.37, 2.28320e06),
            (datetime.datetime(2022, 3, 10, 9, 45), 9.36, 1.49010e06),
            (datetime.datetime(2022, 3, 10, 9, 46), 9.31, 1.86440e06),
            (datetime.datetime(2022, 3, 10, 9, 47), 9.34, 1.27320e06),
            (datetime.datetime(2022, 3, 10, 9, 48), 9.43, 1.70690e06),
            (datetime.datetime(2022, 3, 10, 9, 49), 9.46, 2.22950e06),
            (datetime.datetime(2022, 3, 10, 9, 50), 9.68, 1.54392e07),
            (datetime.datetime(2022, 3, 10, 9, 51), 9.68, 2.94000e06),
            (datetime.datetime(2022, 3, 10, 9, 52), 9.68, 1.23460e06),
            (datetime.datetime(2022, 3, 10, 9, 53), 9.68, 5.39500e05),
            (datetime.datetime(2022, 3, 10, 9, 54), 9.68, 3.39300e05),
            (datetime.datetime(2022, 3, 10, 9, 55), 9.68, 3.92300e05),
            (datetime.datetime(2022, 3, 10, 9, 56), 9.68, 2.87800e05),
            (datetime.datetime(2022, 3, 10, 9, 57), 9.68, 2.82000e05),
            (datetime.datetime(2022, 3, 10, 9, 58), 9.68, 1.89700e05),
            (datetime.datetime(2022, 3, 10, 9, 59), 9.68, 2.14200e05),
            (datetime.datetime(2022, 3, 10, 10, 0), 9.68, 3.91900e05),
            (datetime.datetime(2022, 3, 10, 10, 1), 9.68, 1.92000e05),
            (datetime.datetime(2022, 3, 10, 10, 2), 9.68, 1.12000e05),
            (datetime.datetime(2022, 3, 10, 10, 3), 9.68, 9.43000e04),
            (datetime.datetime(2022, 3, 10, 10, 4), 9.68, 1.14400e05),
            (datetime.datetime(2022, 3, 10, 10, 5), 9.68, 1.19700e05),
            (datetime.datetime(2022, 3, 10, 10, 6), 9.68, 8.77000e04),
            (datetime.datetime(2022, 3, 10, 10, 7), 9.68, 9.25000e04),
            (datetime.datetime(2022, 3, 10, 10, 8), 9.68, 6.95000e04),
            (datetime.datetime(2022, 3, 10, 10, 9), 9.68, 4.31000e04),
            (datetime.datetime(2022, 3, 10, 10, 10), 9.68, 4.28000e04),
            (datetime.datetime(2022, 3, 10, 10, 11), 9.68, 1.15800e05),
            (datetime.datetime(2022, 3, 10, 10, 12), 9.68, 6.91000e04),
            (datetime.datetime(2022, 3, 10, 10, 13), 9.68, 3.35000e04),
            (datetime.datetime(2022, 3, 10, 10, 14), 9.68, 1.02300e05),
            (datetime.datetime(2022, 3, 10, 10, 15), 9.68, 6.79000e04),
            (datetime.datetime(2022, 3, 10, 10, 16), 9.68, 5.11000e04),
            (datetime.datetime(2022, 3, 10, 10, 17), 9.68, 4.59000e04),
            (datetime.datetime(2022, 3, 10, 10, 18), 9.68, 3.50000e04),
            (datetime.datetime(2022, 3, 10, 10, 19), 9.68, 4.55000e04),
            (datetime.datetime(2022, 3, 10, 10, 20), 9.68, 6.05000e04),
            (datetime.datetime(2022, 3, 10, 10, 21), 9.68, 5.69000e04),
            (datetime.datetime(2022, 3, 10, 10, 22), 9.68, 5.53000e04),
            (datetime.datetime(2022, 3, 10, 10, 23), 9.68, 2.62000e04),
            (datetime.datetime(2022, 3, 10, 10, 24), 9.68, 2.05000e04),
            (datetime.datetime(2022, 3, 10, 10, 25), 9.68, 1.23000e04),
            (datetime.datetime(2022, 3, 10, 10, 26), 9.68, 3.88000e04),
            (datetime.datetime(2022, 3, 10, 10, 27), 9.68, 9.34000e04),
            (datetime.datetime(2022, 3, 10, 10, 28), 9.68, 5.93000e04),
            (datetime.datetime(2022, 3, 10, 10, 29), 9.68, 3.42000e04),
            (datetime.datetime(2022, 3, 10, 10, 30), 9.68, 3.87000e04),
            (datetime.datetime(2022, 3, 10, 10, 31), 9.68, 9.30000e03),
            (datetime.datetime(2022, 3, 10, 10, 32), 9.68, 4.82000e04),
            (datetime.datetime(2022, 3, 10, 10, 33), 9.68, 2.34000e04),
            (datetime.datetime(2022, 3, 10, 10, 34), 9.68, 5.80000e03),
            (datetime.datetime(2022, 3, 10, 10, 35), 9.68, 3.12000e04),
            (datetime.datetime(2022, 3, 10, 10, 36), 9.68, 1.60000e04),
            (datetime.datetime(2022, 3, 10, 10, 37), 9.68, 4.62000e04),
            (datetime.datetime(2022, 3, 10, 10, 38), 9.68, 5.12000e04),
            (datetime.datetime(2022, 3, 10, 10, 39), 9.68, 1.91000e04),
            (datetime.datetime(2022, 3, 10, 10, 40), 9.68, 4.05000e04),
            (datetime.datetime(2022, 3, 10, 10, 41), 9.68, 2.23000e04),
            (datetime.datetime(2022, 3, 10, 10, 42), 9.68, 3.78000e04),
            (datetime.datetime(2022, 3, 10, 10, 43), 9.68, 1.49000e04),
            (datetime.datetime(2022, 3, 10, 10, 44), 9.68, 5.63000e04),
            (datetime.datetime(2022, 3, 10, 10, 45), 9.68, 1.09000e04),
            (datetime.datetime(2022, 3, 10, 10, 46), 9.68, 5.80000e03),
            (datetime.datetime(2022, 3, 10, 10, 47), 9.68, 1.30000e04),
            (datetime.datetime(2022, 3, 10, 10, 48), 9.68, 4.08000e04),
            (datetime.datetime(2022, 3, 10, 10, 49), 9.68, 1.49000e04),
            (datetime.datetime(2022, 3, 10, 10, 50), 9.68, 8.30000e03),
            (datetime.datetime(2022, 3, 10, 10, 51), 9.68, 7.30000e03),
            (datetime.datetime(2022, 3, 10, 10, 52), 9.68, 1.81000e04),
            (datetime.datetime(2022, 3, 10, 10, 53), 9.68, 6.50000e03),
            (datetime.datetime(2022, 3, 10, 10, 54), 9.68, 1.14000e04),
            (datetime.datetime(2022, 3, 10, 10, 55), 9.68, 1.19000e04),
            (datetime.datetime(2022, 3, 10, 10, 56), 9.68, 2.00000e03),
            (datetime.datetime(2022, 3, 10, 10, 57), 9.68, 8.70000e03),
            (datetime.datetime(2022, 3, 10, 10, 58), 9.68, 1.73000e04),
            (datetime.datetime(2022, 3, 10, 10, 59), 9.68, 1.35000e04),
            (datetime.datetime(2022, 3, 10, 11, 0), 9.68, 3.47000e04),
            (datetime.datetime(2022, 3, 10, 11, 1), 9.68, 5.34000e04),
            (datetime.datetime(2022, 3, 10, 11, 2), 9.68, 9.28000e04),
            (datetime.datetime(2022, 3, 10, 11, 3), 9.68, 2.85000e04),
            (datetime.datetime(2022, 3, 10, 11, 4), 9.68, 1.12000e04),
            (datetime.datetime(2022, 3, 10, 11, 5), 9.68, 1.93000e04),
            (datetime.datetime(2022, 3, 10, 11, 6), 9.68, 3.74000e04),
            (datetime.datetime(2022, 3, 10, 11, 7), 9.68, 2.16000e04),
            (datetime.datetime(2022, 3, 10, 11, 8), 9.68, 1.15000e04),
            (datetime.datetime(2022, 3, 10, 11, 9), 9.68, 1.75000e04),
            (datetime.datetime(2022, 3, 10, 11, 10), 9.68, 2.14000e04),
            (datetime.datetime(2022, 3, 10, 11, 11), 9.68, 1.45000e04),
            (datetime.datetime(2022, 3, 10, 11, 12), 9.68, 1.90000e04),
            (datetime.datetime(2022, 3, 10, 11, 13), 9.68, 1.13000e04),
            (datetime.datetime(2022, 3, 10, 11, 14), 9.68, 5.80000e03),
            (datetime.datetime(2022, 3, 10, 11, 15), 9.68, 3.30000e03),
            (datetime.datetime(2022, 3, 10, 11, 16), 9.68, 4.86000e04),
            (datetime.datetime(2022, 3, 10, 11, 17), 9.68, 5.40000e03),
            (datetime.datetime(2022, 3, 10, 11, 18), 9.68, 1.76000e04),
            (datetime.datetime(2022, 3, 10, 11, 19), 9.68, 6.20000e04),
            (datetime.datetime(2022, 3, 10, 11, 20), 9.68, 1.40000e04),
            (datetime.datetime(2022, 3, 10, 11, 21), 9.68, 1.32000e04),
            (datetime.datetime(2022, 3, 10, 11, 22), 9.68, 6.90000e03),
            (datetime.datetime(2022, 3, 10, 11, 23), 9.68, 1.70000e04),
            (datetime.datetime(2022, 3, 10, 11, 24), 9.68, 4.17000e04),
            (datetime.datetime(2022, 3, 10, 11, 25), 9.68, 6.50000e03),
            (datetime.datetime(2022, 3, 10, 11, 26), 9.68, 2.80000e03),
            (datetime.datetime(2022, 3, 10, 11, 27), 9.68, 9.60000e03),
            (datetime.datetime(2022, 3, 10, 11, 28), 9.68, 7.10000e03),
            (datetime.datetime(2022, 3, 10, 11, 29), 9.68, 2.11000e04),
            (datetime.datetime(2022, 3, 10, 11, 30), 9.68, 9.60000e03),
            (datetime.datetime(2022, 3, 10, 13, 1), 9.68, 8.12000e04),
            (datetime.datetime(2022, 3, 10, 13, 2), 9.68, 1.74000e04),
            (datetime.datetime(2022, 3, 10, 13, 3), 9.68, 1.38000e04),
            (datetime.datetime(2022, 3, 10, 13, 4), 9.68, 1.69000e04),
            (datetime.datetime(2022, 3, 10, 13, 5), 9.68, 2.47000e04),
            (datetime.datetime(2022, 3, 10, 13, 6), 9.68, 2.06000e04),
            (datetime.datetime(2022, 3, 10, 13, 7), 9.68, 3.08000e04),
            (datetime.datetime(2022, 3, 10, 13, 8), 9.68, 2.86000e04),
            (datetime.datetime(2022, 3, 10, 13, 9), 9.68, 4.71000e04),
            (datetime.datetime(2022, 3, 10, 13, 10), 9.68, 6.35000e04),
            (datetime.datetime(2022, 3, 10, 13, 11), 9.68, 1.04000e04),
            (datetime.datetime(2022, 3, 10, 13, 12), 9.68, 2.12000e04),
            (datetime.datetime(2022, 3, 10, 13, 13), 9.68, 1.55000e04),
            (datetime.datetime(2022, 3, 10, 13, 14), 9.68, 3.13000e04),
            (datetime.datetime(2022, 3, 10, 13, 15), 9.68, 4.38000e04),
            (datetime.datetime(2022, 3, 10, 13, 16), 9.68, 2.97000e04),
            (datetime.datetime(2022, 3, 10, 13, 17), 9.68, 2.39000e04),
            (datetime.datetime(2022, 3, 10, 13, 18), 9.68, 3.66000e04),
            (datetime.datetime(2022, 3, 10, 13, 19), 9.68, 4.76000e04),
            (datetime.datetime(2022, 3, 10, 13, 20), 9.68, 5.67000e04),
            (datetime.datetime(2022, 3, 10, 13, 21), 9.68, 4.86000e04),
            (datetime.datetime(2022, 3, 10, 13, 22), 9.68, 4.90000e03),
            (datetime.datetime(2022, 3, 10, 13, 23), 9.68, 1.03000e04),
            (datetime.datetime(2022, 3, 10, 13, 24), 9.68, 1.93000e04),
            (datetime.datetime(2022, 3, 10, 13, 25), 9.68, 3.16000e04),
            (datetime.datetime(2022, 3, 10, 13, 26), 9.68, 5.60000e03),
            (datetime.datetime(2022, 3, 10, 13, 27), 9.68, 1.75000e04),
            (datetime.datetime(2022, 3, 10, 13, 28), 9.68, 1.69000e04),
            (datetime.datetime(2022, 3, 10, 13, 29), 9.68, 1.02000e04),
            (datetime.datetime(2022, 3, 10, 13, 30), 9.68, 1.13000e04),
            (datetime.datetime(2022, 3, 10, 13, 31), 9.68, 1.09000e04),
            (datetime.datetime(2022, 3, 10, 13, 32), 9.68, 5.10000e03),
            (datetime.datetime(2022, 3, 10, 13, 33), 9.68, 1.72000e04),
            (datetime.datetime(2022, 3, 10, 13, 34), 9.68, 8.45000e04),
            (datetime.datetime(2022, 3, 10, 13, 35), 9.68, 2.28000e04),
            (datetime.datetime(2022, 3, 10, 13, 36), 9.68, 1.11700e05),
            (datetime.datetime(2022, 3, 10, 13, 37), 9.68, 1.18000e04),
            (datetime.datetime(2022, 3, 10, 13, 38), 9.68, 1.11000e04),
            (datetime.datetime(2022, 3, 10, 13, 39), 9.68, 5.60000e03),
            (datetime.datetime(2022, 3, 10, 13, 40), 9.68, 4.36000e04),
            (datetime.datetime(2022, 3, 10, 13, 41), 9.68, 1.79000e04),
            (datetime.datetime(2022, 3, 10, 13, 42), 9.68, 6.13000e04),
            (datetime.datetime(2022, 3, 10, 13, 43), 9.68, 4.50000e03),
            (datetime.datetime(2022, 3, 10, 13, 44), 9.68, 7.00000e03),
            (datetime.datetime(2022, 3, 10, 13, 45), 9.68, 3.50000e03),
            (datetime.datetime(2022, 3, 10, 13, 46), 9.68, 5.90000e03),
            (datetime.datetime(2022, 3, 10, 13, 47), 9.68, 8.20000e03),
            (datetime.datetime(2022, 3, 10, 13, 48), 9.68, 1.38000e04),
            (datetime.datetime(2022, 3, 10, 13, 49), 9.68, 4.00000e03),
            (datetime.datetime(2022, 3, 10, 13, 50), 9.68, 8.30000e03),
            (datetime.datetime(2022, 3, 10, 13, 51), 9.68, 5.30000e03),
            (datetime.datetime(2022, 3, 10, 13, 52), 9.68, 9.90000e03),
            (datetime.datetime(2022, 3, 10, 13, 53), 9.68, 3.40000e03),
            (datetime.datetime(2022, 3, 10, 13, 54), 9.68, 2.46000e04),
            (datetime.datetime(2022, 3, 10, 13, 55), 9.68, 2.50000e03),
            (datetime.datetime(2022, 3, 10, 13, 56), 9.68, 2.50000e03),
            (datetime.datetime(2022, 3, 10, 13, 57), 9.68, 1.44000e04),
            (datetime.datetime(2022, 3, 10, 13, 58), 9.68, 3.90000e03),
            (datetime.datetime(2022, 3, 10, 13, 59), 9.68, 1.07000e04),
            (datetime.datetime(2022, 3, 10, 14, 0), 9.68, 1.74000e04),
            (datetime.datetime(2022, 3, 10, 14, 1), 9.68, 1.33000e04),
            (datetime.datetime(2022, 3, 10, 14, 2), 9.68, 1.82000e04),
            (datetime.datetime(2022, 3, 10, 14, 3), 9.68, 1.80000e03),
            (datetime.datetime(2022, 3, 10, 14, 4), 9.68, 5.70000e03),
            (datetime.datetime(2022, 3, 10, 14, 5), 9.68, 2.49000e04),
            (datetime.datetime(2022, 3, 10, 14, 6), 9.68, 3.47000e04),
            (datetime.datetime(2022, 3, 10, 14, 7), 9.68, 1.30000e03),
            (datetime.datetime(2022, 3, 10, 14, 8), 9.68, 7.50000e03),
            (datetime.datetime(2022, 3, 10, 14, 9), 9.68, 1.08000e04),
            (datetime.datetime(2022, 3, 10, 14, 10), 9.68, 3.40000e03),
            (datetime.datetime(2022, 3, 10, 14, 11), 9.68, 2.33000e04),
            (datetime.datetime(2022, 3, 10, 14, 12), 9.68, 3.00000e03),
            (datetime.datetime(2022, 3, 10, 14, 13), 9.68, 1.40000e03),
            (datetime.datetime(2022, 3, 10, 14, 14), 9.68, 1.20000e03),
            (datetime.datetime(2022, 3, 10, 14, 15), 9.68, 1.26000e04),
            (datetime.datetime(2022, 3, 10, 14, 16), 9.68, 8.60000e03),
            (datetime.datetime(2022, 3, 10, 14, 17), 9.68, 2.60000e03),
            (datetime.datetime(2022, 3, 10, 14, 18), 9.68, 5.90000e03),
            (datetime.datetime(2022, 3, 10, 14, 19), 9.68, 7.40000e03),
            (datetime.datetime(2022, 3, 10, 14, 20), 9.68, 1.17000e04),
            (datetime.datetime(2022, 3, 10, 14, 21), 9.68, 1.22000e04),
            (datetime.datetime(2022, 3, 10, 14, 22), 9.68, 3.70000e03),
            (datetime.datetime(2022, 3, 10, 14, 23), 9.68, 1.09000e04),
            (datetime.datetime(2022, 3, 10, 14, 24), 9.68, 2.40000e03),
            (datetime.datetime(2022, 3, 10, 14, 25), 9.68, 2.00000e02),
            (datetime.datetime(2022, 3, 10, 14, 26), 9.68, 7.30000e03),
            (datetime.datetime(2022, 3, 10, 14, 27), 9.68, 1.80000e03),
            (datetime.datetime(2022, 3, 10, 14, 28), 9.68, 9.00000e02),
            (datetime.datetime(2022, 3, 10, 14, 29), 9.68, 1.00000e04),
            (datetime.datetime(2022, 3, 10, 14, 30), 9.68, 8.20000e03),
            (datetime.datetime(2022, 3, 10, 14, 31), 9.68, 4.40000e03),
            (datetime.datetime(2022, 3, 10, 14, 32), 9.68, 7.60000e03),
            (datetime.datetime(2022, 3, 10, 14, 33), 9.68, 2.53000e04),
            (datetime.datetime(2022, 3, 10, 14, 34), 9.68, 3.30000e03),
            (datetime.datetime(2022, 3, 10, 14, 35), 9.68, 1.61000e04),
            (datetime.datetime(2022, 3, 10, 14, 36), 9.68, 2.50000e04),
            (datetime.datetime(2022, 3, 10, 14, 37), 9.68, 2.70000e04),
            (datetime.datetime(2022, 3, 10, 14, 38), 9.68, 3.40000e03),
            (datetime.datetime(2022, 3, 10, 14, 39), 9.68, 6.80000e03),
            (datetime.datetime(2022, 3, 10, 14, 40), 9.68, 3.70000e03),
            (datetime.datetime(2022, 3, 10, 14, 41), 9.68, 1.18000e05),
            (datetime.datetime(2022, 3, 10, 14, 42), 9.68, 6.40000e03),
            (datetime.datetime(2022, 3, 10, 14, 43), 9.68, 4.71000e04),
            (datetime.datetime(2022, 3, 10, 14, 44), 9.68, 3.36000e04),
            (datetime.datetime(2022, 3, 10, 14, 45), 9.68, 4.55000e04),
            (datetime.datetime(2022, 3, 10, 14, 46), 9.68, 6.41000e04),
            (datetime.datetime(2022, 3, 10, 14, 47), 9.68, 4.94000e04),
            (datetime.datetime(2022, 3, 10, 14, 48), 9.68, 1.32000e04),
            (datetime.datetime(2022, 3, 10, 14, 49), 9.68, 2.78000e04),
            (datetime.datetime(2022, 3, 10, 14, 50), 9.68, 1.69000e04),
            (datetime.datetime(2022, 3, 10, 14, 51), 9.68, 1.57000e04),
            (datetime.datetime(2022, 3, 10, 14, 52), 9.68, 8.52000e04),
            (datetime.datetime(2022, 3, 10, 14, 53), 9.68, 4.83000e04),
            (datetime.datetime(2022, 3, 10, 14, 54), 9.68, 2.37000e05),
            (datetime.datetime(2022, 3, 10, 14, 55), 9.68, 4.38900e05),
            (datetime.datetime(2022, 3, 10, 14, 56), 9.68, 1.51800e05),
            (datetime.datetime(2022, 3, 10, 14, 57), 9.68, 8.68000e04),
            (datetime.datetime(2022, 3, 10, 14, 58), 9.68, 3.30000e03),
            (datetime.datetime(2022, 3, 10, 14, 59), 9.68, 0.00000e00),
            (datetime.datetime(2022, 3, 10, 15, 0), 9.68, 2.32700e05),
        ],
        dtype=[("frame", "O"), ("close", "<f8"), ("volume", "<f8")],
    ),
    "603717.XSHG": np.array(
        [
            (datetime.datetime(2022, 3, 7, 9, 31), 14.86, 1.890e04),
            (datetime.datetime(2022, 3, 7, 9, 32), 14.88, 4.100e03),
            (datetime.datetime(2022, 3, 7, 9, 33), 14.88, 5.100e03),
            (datetime.datetime(2022, 3, 7, 9, 34), 14.9, 9.800e03),
            (datetime.datetime(2022, 3, 7, 9, 35), 14.91, 1.260e04),
            (datetime.datetime(2022, 3, 7, 9, 36), 14.88, 3.420e04),
            (datetime.datetime(2022, 3, 7, 9, 37), 14.86, 1.450e04),
            (datetime.datetime(2022, 3, 7, 9, 38), 14.81, 5.700e03),
            (datetime.datetime(2022, 3, 7, 9, 39), 14.85, 3.900e03),
            (datetime.datetime(2022, 3, 7, 9, 40), 14.82, 8.100e03),
            (datetime.datetime(2022, 3, 7, 9, 41), 14.84, 2.300e03),
            (datetime.datetime(2022, 3, 7, 9, 42), 14.81, 2.400e03),
            (datetime.datetime(2022, 3, 7, 9, 43), 14.81, 0.000e00),
            (datetime.datetime(2022, 3, 7, 9, 44), 14.8, 6.900e03),
            (datetime.datetime(2022, 3, 7, 9, 45), 14.8, 4.000e02),
            (datetime.datetime(2022, 3, 7, 9, 46), 14.82, 3.400e03),
            (datetime.datetime(2022, 3, 7, 9, 47), 14.81, 2.700e03),
            (datetime.datetime(2022, 3, 7, 9, 48), 14.81, 2.400e03),
            (datetime.datetime(2022, 3, 7, 9, 49), 14.8, 2.900e03),
            (datetime.datetime(2022, 3, 7, 9, 50), 14.8, 6.300e03),
            (datetime.datetime(2022, 3, 7, 9, 51), 14.8, 8.500e03),
            (datetime.datetime(2022, 3, 7, 9, 52), 14.8, 1.620e04),
            (datetime.datetime(2022, 3, 7, 9, 53), 14.83, 9.200e03),
            (datetime.datetime(2022, 3, 7, 9, 54), 14.83, 0.000e00),
            (datetime.datetime(2022, 3, 7, 9, 55), 14.8, 5.100e03),
            (datetime.datetime(2022, 3, 7, 9, 56), 14.79, 1.160e04),
            (datetime.datetime(2022, 3, 7, 9, 57), 14.8, 3.700e03),
            (datetime.datetime(2022, 3, 7, 9, 58), 14.8, 3.900e03),
            (datetime.datetime(2022, 3, 7, 9, 59), 14.82, 1.500e03),
            (datetime.datetime(2022, 3, 7, 10, 0), 14.79, 2.300e03),
            (datetime.datetime(2022, 3, 7, 10, 1), 14.78, 4.700e03),
            (datetime.datetime(2022, 3, 7, 10, 2), 14.8, 1.900e03),
            (datetime.datetime(2022, 3, 7, 10, 3), 14.8, 1.300e03),
            (datetime.datetime(2022, 3, 7, 10, 4), 14.8, 2.200e03),
            (datetime.datetime(2022, 3, 7, 10, 5), 14.8, 6.400e03),
            (datetime.datetime(2022, 3, 7, 10, 6), 14.88, 2.600e04),
            (datetime.datetime(2022, 3, 7, 10, 7), 14.95, 3.990e04),
            (datetime.datetime(2022, 3, 7, 10, 8), 14.97, 9.970e04),
            (datetime.datetime(2022, 3, 7, 10, 9), 14.98, 2.720e04),
            (datetime.datetime(2022, 3, 7, 10, 10), 14.99, 7.240e04),
            (datetime.datetime(2022, 3, 7, 10, 11), 14.97, 4.190e04),
            (datetime.datetime(2022, 3, 7, 10, 12), 14.98, 8.800e03),
            (datetime.datetime(2022, 3, 7, 10, 13), 14.97, 1.540e04),
            (datetime.datetime(2022, 3, 7, 10, 14), 14.98, 8.490e04),
            (datetime.datetime(2022, 3, 7, 10, 15), 15.0, 3.850e04),
            (datetime.datetime(2022, 3, 7, 10, 16), 15.05, 4.700e04),
            (datetime.datetime(2022, 3, 7, 10, 17), 15.07, 3.660e04),
            (datetime.datetime(2022, 3, 7, 10, 18), 15.08, 3.860e04),
            (datetime.datetime(2022, 3, 7, 10, 19), 15.11, 2.830e04),
            (datetime.datetime(2022, 3, 7, 10, 20), 15.1, 9.400e03),
            (datetime.datetime(2022, 3, 7, 10, 21), 15.15, 5.500e04),
            (datetime.datetime(2022, 3, 7, 10, 22), 15.15, 5.540e04),
            (datetime.datetime(2022, 3, 7, 10, 23), 15.11, 1.730e04),
            (datetime.datetime(2022, 3, 7, 10, 24), 15.12, 9.130e04),
            (datetime.datetime(2022, 3, 7, 10, 25), 15.17, 5.130e04),
            (datetime.datetime(2022, 3, 7, 10, 26), 15.3, 7.030e04),
            (datetime.datetime(2022, 3, 7, 10, 27), 15.25, 1.071e05),
            (datetime.datetime(2022, 3, 7, 10, 28), 15.25, 7.600e03),
            (datetime.datetime(2022, 3, 7, 10, 29), 15.21, 7.340e04),
            (datetime.datetime(2022, 3, 7, 10, 30), 15.17, 1.990e04),
            (datetime.datetime(2022, 3, 7, 10, 31), 15.14, 9.390e04),
            (datetime.datetime(2022, 3, 7, 10, 32), 15.13, 9.050e04),
            (datetime.datetime(2022, 3, 7, 10, 33), 15.15, 9.460e04),
            (datetime.datetime(2022, 3, 7, 10, 34), 15.15, 5.000e02),
            (datetime.datetime(2022, 3, 7, 10, 35), 15.14, 7.900e03),
            (datetime.datetime(2022, 3, 7, 10, 36), 15.08, 1.300e04),
            (datetime.datetime(2022, 3, 7, 10, 37), 15.05, 4.200e03),
            (datetime.datetime(2022, 3, 7, 10, 38), 15.05, 9.000e02),
            (datetime.datetime(2022, 3, 7, 10, 39), 15.03, 1.550e04),
            (datetime.datetime(2022, 3, 7, 10, 40), 15.04, 1.000e03),
            (datetime.datetime(2022, 3, 7, 10, 41), 15.0, 4.900e03),
            (datetime.datetime(2022, 3, 7, 10, 42), 15.0, 5.000e02),
            (datetime.datetime(2022, 3, 7, 10, 43), 15.0, 0.000e00),
            (datetime.datetime(2022, 3, 7, 10, 44), 14.91, 4.900e03),
            (datetime.datetime(2022, 3, 7, 10, 45), 14.92, 8.300e03),
            (datetime.datetime(2022, 3, 7, 10, 46), 14.92, 1.700e03),
            (datetime.datetime(2022, 3, 7, 10, 47), 14.95, 3.700e03),
            (datetime.datetime(2022, 3, 7, 10, 48), 14.97, 9.000e02),
            (datetime.datetime(2022, 3, 7, 10, 49), 14.9, 2.940e04),
            (datetime.datetime(2022, 3, 7, 10, 50), 14.92, 3.500e03),
            (datetime.datetime(2022, 3, 7, 10, 51), 14.92, 1.000e02),
            (datetime.datetime(2022, 3, 7, 10, 52), 14.9, 3.000e03),
            (datetime.datetime(2022, 3, 7, 10, 53), 14.92, 9.000e02),
            (datetime.datetime(2022, 3, 7, 10, 54), 14.89, 4.240e04),
            (datetime.datetime(2022, 3, 7, 10, 55), 14.86, 1.300e03),
            (datetime.datetime(2022, 3, 7, 10, 56), 14.86, 9.100e03),
            (datetime.datetime(2022, 3, 7, 10, 57), 14.88, 1.300e03),
            (datetime.datetime(2022, 3, 7, 10, 58), 14.85, 6.400e03),
            (datetime.datetime(2022, 3, 7, 10, 59), 14.84, 1.040e04),
            (datetime.datetime(2022, 3, 7, 11, 0), 14.84, 2.000e02),
            (datetime.datetime(2022, 3, 7, 11, 1), 14.86, 1.300e03),
            (datetime.datetime(2022, 3, 7, 11, 2), 14.82, 2.040e04),
            (datetime.datetime(2022, 3, 7, 11, 3), 14.83, 1.040e04),
            (datetime.datetime(2022, 3, 7, 11, 4), 14.85, 5.300e03),
            (datetime.datetime(2022, 3, 7, 11, 5), 14.87, 1.430e04),
            (datetime.datetime(2022, 3, 7, 11, 6), 14.91, 7.080e04),
            (datetime.datetime(2022, 3, 7, 11, 7), 14.91, 4.100e03),
            (datetime.datetime(2022, 3, 7, 11, 8), 14.93, 1.050e04),
            (datetime.datetime(2022, 3, 7, 11, 9), 14.92, 7.400e03),
            (datetime.datetime(2022, 3, 7, 11, 10), 14.92, 2.100e03),
            (datetime.datetime(2022, 3, 7, 11, 11), 14.92, 6.600e03),
            (datetime.datetime(2022, 3, 7, 11, 12), 14.92, 5.200e03),
            (datetime.datetime(2022, 3, 7, 11, 13), 14.95, 2.090e04),
            (datetime.datetime(2022, 3, 7, 11, 14), 14.96, 1.780e04),
            (datetime.datetime(2022, 3, 7, 11, 15), 14.96, 5.600e03),
            (datetime.datetime(2022, 3, 7, 11, 16), 14.97, 6.500e03),
            (datetime.datetime(2022, 3, 7, 11, 17), 14.95, 7.940e04),
            (datetime.datetime(2022, 3, 7, 11, 18), 14.98, 5.360e04),
            (datetime.datetime(2022, 3, 7, 11, 19), 14.95, 9.880e04),
            (datetime.datetime(2022, 3, 7, 11, 20), 14.95, 1.170e05),
            (datetime.datetime(2022, 3, 7, 11, 21), 14.93, 1.065e05),
            (datetime.datetime(2022, 3, 7, 11, 22), 14.91, 1.060e04),
            (datetime.datetime(2022, 3, 7, 11, 23), 14.91, 5.700e03),
            (datetime.datetime(2022, 3, 7, 11, 24), 14.91, 1.900e03),
            (datetime.datetime(2022, 3, 7, 11, 25), 14.91, 6.000e03),
            (datetime.datetime(2022, 3, 7, 11, 26), 14.91, 3.900e03),
            (datetime.datetime(2022, 3, 7, 11, 27), 14.9, 1.200e04),
            (datetime.datetime(2022, 3, 7, 11, 28), 14.87, 3.090e04),
            (datetime.datetime(2022, 3, 7, 11, 29), 14.89, 4.500e03),
            (datetime.datetime(2022, 3, 7, 11, 30), 14.87, 1.700e03),
            (datetime.datetime(2022, 3, 7, 13, 1), 14.87, 9.000e03),
            (datetime.datetime(2022, 3, 7, 13, 2), 14.91, 2.500e03),
            (datetime.datetime(2022, 3, 7, 13, 3), 14.91, 9.300e03),
            (datetime.datetime(2022, 3, 7, 13, 4), 14.85, 7.400e03),
            (datetime.datetime(2022, 3, 7, 13, 5), 14.85, 5.000e02),
            (datetime.datetime(2022, 3, 7, 13, 6), 14.86, 2.000e02),
            (datetime.datetime(2022, 3, 7, 13, 7), 14.86, 3.000e02),
            (datetime.datetime(2022, 3, 7, 13, 8), 14.9, 1.300e03),
            (datetime.datetime(2022, 3, 7, 13, 9), 14.86, 8.000e02),
            (datetime.datetime(2022, 3, 7, 13, 10), 14.86, 0.000e00),
            (datetime.datetime(2022, 3, 7, 13, 11), 14.86, 0.000e00),
            (datetime.datetime(2022, 3, 7, 13, 12), 14.89, 2.400e03),
            (datetime.datetime(2022, 3, 7, 13, 13), 14.89, 2.600e03),
            (datetime.datetime(2022, 3, 7, 13, 14), 14.9, 1.400e04),
            (datetime.datetime(2022, 3, 7, 13, 15), 14.89, 3.500e03),
            (datetime.datetime(2022, 3, 7, 13, 16), 14.89, 2.000e03),
            (datetime.datetime(2022, 3, 7, 13, 17), 14.89, 3.000e02),
            (datetime.datetime(2022, 3, 7, 13, 18), 14.86, 8.000e03),
            (datetime.datetime(2022, 3, 7, 13, 19), 14.89, 5.000e02),
            (datetime.datetime(2022, 3, 7, 13, 20), 14.9, 7.400e03),
            (datetime.datetime(2022, 3, 7, 13, 21), 14.87, 1.200e03),
            (datetime.datetime(2022, 3, 7, 13, 22), 14.87, 4.700e03),
            (datetime.datetime(2022, 3, 7, 13, 23), 14.88, 2.000e02),
            (datetime.datetime(2022, 3, 7, 13, 24), 14.91, 5.200e03),
            (datetime.datetime(2022, 3, 7, 13, 25), 14.94, 4.000e02),
            (datetime.datetime(2022, 3, 7, 13, 26), 14.88, 1.300e03),
            (datetime.datetime(2022, 3, 7, 13, 27), 14.93, 1.600e03),
            (datetime.datetime(2022, 3, 7, 13, 28), 14.93, 2.000e02),
            (datetime.datetime(2022, 3, 7, 13, 29), 14.91, 8.000e02),
            (datetime.datetime(2022, 3, 7, 13, 30), 14.9, 6.200e03),
            (datetime.datetime(2022, 3, 7, 13, 31), 14.9, 1.000e03),
            (datetime.datetime(2022, 3, 7, 13, 32), 14.9, 6.600e03),
            (datetime.datetime(2022, 3, 7, 13, 33), 14.91, 3.000e02),
            (datetime.datetime(2022, 3, 7, 13, 34), 14.94, 1.780e04),
            (datetime.datetime(2022, 3, 7, 13, 35), 14.92, 3.600e03),
            (datetime.datetime(2022, 3, 7, 13, 36), 14.9, 4.800e03),
            (datetime.datetime(2022, 3, 7, 13, 37), 14.9, 4.900e03),
            (datetime.datetime(2022, 3, 7, 13, 38), 14.9, 1.000e02),
            (datetime.datetime(2022, 3, 7, 13, 39), 14.94, 3.000e02),
            (datetime.datetime(2022, 3, 7, 13, 40), 14.94, 1.600e03),
            (datetime.datetime(2022, 3, 7, 13, 41), 14.9, 1.650e04),
            (datetime.datetime(2022, 3, 7, 13, 42), 14.89, 1.600e03),
            (datetime.datetime(2022, 3, 7, 13, 43), 14.87, 7.000e03),
            (datetime.datetime(2022, 3, 7, 13, 44), 14.89, 1.600e03),
            (datetime.datetime(2022, 3, 7, 13, 45), 14.89, 1.100e03),
            (datetime.datetime(2022, 3, 7, 13, 46), 14.86, 5.200e03),
            (datetime.datetime(2022, 3, 7, 13, 47), 14.86, 0.000e00),
            (datetime.datetime(2022, 3, 7, 13, 48), 14.89, 1.000e03),
            (datetime.datetime(2022, 3, 7, 13, 49), 14.89, 0.000e00),
            (datetime.datetime(2022, 3, 7, 13, 50), 14.89, 0.000e00),
            (datetime.datetime(2022, 3, 7, 13, 51), 14.89, 0.000e00),
            (datetime.datetime(2022, 3, 7, 13, 52), 14.86, 1.000e02),
            (datetime.datetime(2022, 3, 7, 13, 53), 14.89, 7.000e02),
            (datetime.datetime(2022, 3, 7, 13, 54), 14.85, 1.040e04),
            (datetime.datetime(2022, 3, 7, 13, 55), 14.82, 1.470e04),
            (datetime.datetime(2022, 3, 7, 13, 56), 14.85, 8.200e03),
            (datetime.datetime(2022, 3, 7, 13, 57), 14.88, 9.600e03),
            (datetime.datetime(2022, 3, 7, 13, 58), 14.85, 3.800e03),
            (datetime.datetime(2022, 3, 7, 13, 59), 14.84, 1.000e02),
            (datetime.datetime(2022, 3, 7, 14, 0), 14.85, 5.300e03),
            (datetime.datetime(2022, 3, 7, 14, 1), 14.84, 5.030e04),
            (datetime.datetime(2022, 3, 7, 14, 2), 14.84, 5.000e02),
            (datetime.datetime(2022, 3, 7, 14, 3), 14.84, 5.300e03),
            (datetime.datetime(2022, 3, 7, 14, 4), 14.83, 6.200e03),
            (datetime.datetime(2022, 3, 7, 14, 5), 14.81, 2.000e03),
            (datetime.datetime(2022, 3, 7, 14, 6), 14.81, 6.000e03),
            (datetime.datetime(2022, 3, 7, 14, 7), 14.8, 2.100e03),
            (datetime.datetime(2022, 3, 7, 14, 8), 14.81, 4.400e03),
            (datetime.datetime(2022, 3, 7, 14, 9), 14.81, 1.400e03),
            (datetime.datetime(2022, 3, 7, 14, 10), 14.82, 6.200e03),
            (datetime.datetime(2022, 3, 7, 14, 11), 14.82, 0.000e00),
            (datetime.datetime(2022, 3, 7, 14, 12), 14.8, 2.200e03),
            (datetime.datetime(2022, 3, 7, 14, 13), 14.8, 2.000e02),
            (datetime.datetime(2022, 3, 7, 14, 14), 14.8, 5.000e02),
            (datetime.datetime(2022, 3, 7, 14, 15), 14.79, 2.510e04),
            (datetime.datetime(2022, 3, 7, 14, 16), 14.78, 2.430e04),
            (datetime.datetime(2022, 3, 7, 14, 17), 14.79, 4.000e02),
            (datetime.datetime(2022, 3, 7, 14, 18), 14.78, 7.000e02),
            (datetime.datetime(2022, 3, 7, 14, 19), 14.77, 1.400e03),
            (datetime.datetime(2022, 3, 7, 14, 20), 14.78, 5.100e03),
            (datetime.datetime(2022, 3, 7, 14, 21), 14.79, 3.960e04),
            (datetime.datetime(2022, 3, 7, 14, 22), 14.79, 4.500e03),
            (datetime.datetime(2022, 3, 7, 14, 23), 14.8, 3.500e03),
            (datetime.datetime(2022, 3, 7, 14, 24), 14.8, 3.900e03),
            (datetime.datetime(2022, 3, 7, 14, 25), 14.78, 1.170e04),
            (datetime.datetime(2022, 3, 7, 14, 26), 14.78, 8.300e03),
            (datetime.datetime(2022, 3, 7, 14, 27), 14.77, 5.000e02),
            (datetime.datetime(2022, 3, 7, 14, 28), 14.77, 1.800e03),
            (datetime.datetime(2022, 3, 7, 14, 29), 14.79, 2.500e03),
            (datetime.datetime(2022, 3, 7, 14, 30), 14.79, 3.600e03),
            (datetime.datetime(2022, 3, 7, 14, 31), 14.78, 5.400e03),
            (datetime.datetime(2022, 3, 7, 14, 32), 14.8, 2.200e03),
            (datetime.datetime(2022, 3, 7, 14, 33), 14.79, 1.270e04),
            (datetime.datetime(2022, 3, 7, 14, 34), 14.78, 1.400e03),
            (datetime.datetime(2022, 3, 7, 14, 35), 14.77, 1.680e04),
            (datetime.datetime(2022, 3, 7, 14, 36), 14.78, 5.700e03),
            (datetime.datetime(2022, 3, 7, 14, 37), 14.78, 4.000e03),
            (datetime.datetime(2022, 3, 7, 14, 38), 14.77, 1.300e03),
            (datetime.datetime(2022, 3, 7, 14, 39), 14.77, 2.400e03),
            (datetime.datetime(2022, 3, 7, 14, 40), 14.77, 1.100e03),
            (datetime.datetime(2022, 3, 7, 14, 41), 14.78, 1.730e04),
            (datetime.datetime(2022, 3, 7, 14, 42), 14.76, 3.260e04),
            (datetime.datetime(2022, 3, 7, 14, 43), 14.76, 1.330e04),
            (datetime.datetime(2022, 3, 7, 14, 44), 14.76, 1.400e04),
            (datetime.datetime(2022, 3, 7, 14, 45), 14.75, 7.090e04),
            (datetime.datetime(2022, 3, 7, 14, 46), 14.75, 8.500e03),
            (datetime.datetime(2022, 3, 7, 14, 47), 14.75, 6.400e03),
            (datetime.datetime(2022, 3, 7, 14, 48), 14.76, 2.030e04),
            (datetime.datetime(2022, 3, 7, 14, 49), 14.77, 4.680e04),
            (datetime.datetime(2022, 3, 7, 14, 50), 14.77, 1.620e04),
            (datetime.datetime(2022, 3, 7, 14, 51), 14.79, 1.590e04),
            (datetime.datetime(2022, 3, 7, 14, 52), 14.78, 4.300e03),
            (datetime.datetime(2022, 3, 7, 14, 53), 14.8, 3.140e04),
            (datetime.datetime(2022, 3, 7, 14, 54), 14.82, 3.780e04),
            (datetime.datetime(2022, 3, 7, 14, 55), 14.84, 2.540e04),
            (datetime.datetime(2022, 3, 7, 14, 56), 14.87, 3.000e04),
            (datetime.datetime(2022, 3, 7, 14, 57), 14.88, 2.740e04),
            (datetime.datetime(2022, 3, 7, 14, 58), 14.88, 5.000e02),
            (datetime.datetime(2022, 3, 7, 14, 59), 14.88, 0.000e00),
            (datetime.datetime(2022, 3, 7, 15, 0), 14.89, 4.010e04),
            (datetime.datetime(2022, 3, 8, 9, 31), 14.8, 2.280e04),
            (datetime.datetime(2022, 3, 8, 9, 32), 14.79, 4.030e04),
            (datetime.datetime(2022, 3, 8, 9, 33), 14.89, 4.010e04),
            (datetime.datetime(2022, 3, 8, 9, 34), 14.76, 2.300e04),
            (datetime.datetime(2022, 3, 8, 9, 35), 14.73, 5.800e04),
            (datetime.datetime(2022, 3, 8, 9, 36), 14.71, 4.150e04),
            (datetime.datetime(2022, 3, 8, 9, 37), 14.64, 4.180e04),
            (datetime.datetime(2022, 3, 8, 9, 38), 14.55, 3.260e04),
            (datetime.datetime(2022, 3, 8, 9, 39), 14.56, 3.570e04),
            (datetime.datetime(2022, 3, 8, 9, 40), 14.54, 2.570e04),
            (datetime.datetime(2022, 3, 8, 9, 41), 14.56, 3.770e04),
            (datetime.datetime(2022, 3, 8, 9, 42), 14.7, 4.000e03),
            (datetime.datetime(2022, 3, 8, 9, 43), 14.68, 6.700e03),
            (datetime.datetime(2022, 3, 8, 9, 44), 14.7, 7.900e03),
            (datetime.datetime(2022, 3, 8, 9, 45), 14.8, 9.300e03),
            (datetime.datetime(2022, 3, 8, 9, 46), 14.79, 1.790e04),
            (datetime.datetime(2022, 3, 8, 9, 47), 14.85, 1.100e03),
            (datetime.datetime(2022, 3, 8, 9, 48), 14.79, 1.000e02),
            (datetime.datetime(2022, 3, 8, 9, 49), 14.8, 5.000e02),
            (datetime.datetime(2022, 3, 8, 9, 50), 14.82, 2.500e03),
            (datetime.datetime(2022, 3, 8, 9, 51), 14.82, 1.400e03),
            (datetime.datetime(2022, 3, 8, 9, 52), 14.82, 3.000e03),
            (datetime.datetime(2022, 3, 8, 9, 53), 14.79, 4.300e03),
            (datetime.datetime(2022, 3, 8, 9, 54), 14.85, 1.010e04),
            (datetime.datetime(2022, 3, 8, 9, 55), 14.8, 6.000e02),
            (datetime.datetime(2022, 3, 8, 9, 56), 14.88, 4.300e03),
            (datetime.datetime(2022, 3, 8, 9, 57), 14.89, 2.800e03),
            (datetime.datetime(2022, 3, 8, 9, 58), 14.86, 5.000e02),
            (datetime.datetime(2022, 3, 8, 9, 59), 14.87, 2.500e03),
            (datetime.datetime(2022, 3, 8, 10, 0), 14.81, 7.700e03),
            (datetime.datetime(2022, 3, 8, 10, 1), 14.89, 1.460e04),
            (datetime.datetime(2022, 3, 8, 10, 2), 14.89, 2.400e03),
            (datetime.datetime(2022, 3, 8, 10, 3), 14.9, 5.800e03),
            (datetime.datetime(2022, 3, 8, 10, 4), 14.85, 8.800e03),
            (datetime.datetime(2022, 3, 8, 10, 5), 14.8, 6.200e03),
            (datetime.datetime(2022, 3, 8, 10, 6), 14.77, 1.000e03),
            (datetime.datetime(2022, 3, 8, 10, 7), 14.81, 1.370e04),
            (datetime.datetime(2022, 3, 8, 10, 8), 14.81, 1.500e03),
            (datetime.datetime(2022, 3, 8, 10, 9), 14.79, 3.800e03),
            (datetime.datetime(2022, 3, 8, 10, 10), 14.77, 2.000e03),
            (datetime.datetime(2022, 3, 8, 10, 11), 14.84, 1.590e04),
            (datetime.datetime(2022, 3, 8, 10, 12), 14.86, 8.000e02),
            (datetime.datetime(2022, 3, 8, 10, 13), 14.9, 7.100e03),
            (datetime.datetime(2022, 3, 8, 10, 14), 14.82, 2.090e04),
            (datetime.datetime(2022, 3, 8, 10, 15), 14.8, 2.000e02),
            (datetime.datetime(2022, 3, 8, 10, 16), 14.8, 1.300e03),
            (datetime.datetime(2022, 3, 8, 10, 17), 14.85, 1.100e03),
            (datetime.datetime(2022, 3, 8, 10, 18), 14.83, 1.080e04),
            (datetime.datetime(2022, 3, 8, 10, 19), 14.78, 1.520e04),
            (datetime.datetime(2022, 3, 8, 10, 20), 14.75, 1.010e04),
            (datetime.datetime(2022, 3, 8, 10, 21), 14.76, 1.000e02),
            (datetime.datetime(2022, 3, 8, 10, 22), 14.77, 8.000e02),
            (datetime.datetime(2022, 3, 8, 10, 23), 14.72, 5.130e04),
            (datetime.datetime(2022, 3, 8, 10, 24), 14.72, 2.000e02),
            (datetime.datetime(2022, 3, 8, 10, 25), 14.72, 1.900e03),
            (datetime.datetime(2022, 3, 8, 10, 26), 14.74, 1.200e03),
            (datetime.datetime(2022, 3, 8, 10, 27), 14.69, 1.960e04),
            (datetime.datetime(2022, 3, 8, 10, 28), 14.63, 3.910e04),
            (datetime.datetime(2022, 3, 8, 10, 29), 14.63, 1.000e03),
            (datetime.datetime(2022, 3, 8, 10, 30), 14.64, 2.200e03),
            (datetime.datetime(2022, 3, 8, 10, 31), 14.67, 5.800e03),
            (datetime.datetime(2022, 3, 8, 10, 32), 14.67, 2.000e02),
            (datetime.datetime(2022, 3, 8, 10, 33), 14.69, 7.500e03),
            (datetime.datetime(2022, 3, 8, 10, 34), 14.68, 1.800e03),
            (datetime.datetime(2022, 3, 8, 10, 35), 14.67, 3.100e03),
            (datetime.datetime(2022, 3, 8, 10, 36), 14.68, 6.500e03),
            (datetime.datetime(2022, 3, 8, 10, 37), 14.69, 1.610e04),
            (datetime.datetime(2022, 3, 8, 10, 38), 14.66, 1.100e04),
            (datetime.datetime(2022, 3, 8, 10, 39), 14.67, 9.200e03),
            (datetime.datetime(2022, 3, 8, 10, 40), 14.68, 8.700e03),
            (datetime.datetime(2022, 3, 8, 10, 41), 14.65, 1.140e04),
            (datetime.datetime(2022, 3, 8, 10, 42), 14.62, 3.120e04),
            (datetime.datetime(2022, 3, 8, 10, 43), 14.6, 2.830e04),
            (datetime.datetime(2022, 3, 8, 10, 44), 14.62, 3.200e03),
            (datetime.datetime(2022, 3, 8, 10, 45), 14.59, 7.300e03),
            (datetime.datetime(2022, 3, 8, 10, 46), 14.59, 1.310e04),
            (datetime.datetime(2022, 3, 8, 10, 47), 14.58, 2.600e03),
            (datetime.datetime(2022, 3, 8, 10, 48), 14.57, 8.700e03),
            (datetime.datetime(2022, 3, 8, 10, 49), 14.57, 1.730e04),
            (datetime.datetime(2022, 3, 8, 10, 50), 14.55, 9.900e03),
            (datetime.datetime(2022, 3, 8, 10, 51), 14.53, 1.030e04),
            (datetime.datetime(2022, 3, 8, 10, 52), 14.54, 5.100e03),
            (datetime.datetime(2022, 3, 8, 10, 53), 14.53, 1.110e04),
            (datetime.datetime(2022, 3, 8, 10, 54), 14.53, 8.600e03),
            (datetime.datetime(2022, 3, 8, 10, 55), 14.55, 2.300e03),
            (datetime.datetime(2022, 3, 8, 10, 56), 14.58, 1.460e04),
            (datetime.datetime(2022, 3, 8, 10, 57), 14.59, 2.900e03),
            (datetime.datetime(2022, 3, 8, 10, 58), 14.58, 1.200e03),
            (datetime.datetime(2022, 3, 8, 10, 59), 14.56, 2.900e03),
            (datetime.datetime(2022, 3, 8, 11, 0), 14.52, 4.210e04),
            (datetime.datetime(2022, 3, 8, 11, 1), 14.5, 8.110e04),
            (datetime.datetime(2022, 3, 8, 11, 2), 14.52, 4.530e04),
            (datetime.datetime(2022, 3, 8, 11, 3), 14.53, 5.000e03),
            (datetime.datetime(2022, 3, 8, 11, 4), 14.53, 2.010e04),
            (datetime.datetime(2022, 3, 8, 11, 5), 14.53, 1.410e04),
            (datetime.datetime(2022, 3, 8, 11, 6), 14.53, 1.850e04),
            (datetime.datetime(2022, 3, 8, 11, 7), 14.52, 7.500e03),
            (datetime.datetime(2022, 3, 8, 11, 8), 14.51, 9.000e02),
            (datetime.datetime(2022, 3, 8, 11, 9), 14.49, 2.000e02),
            (datetime.datetime(2022, 3, 8, 11, 10), 14.52, 1.500e03),
            (datetime.datetime(2022, 3, 8, 11, 11), 14.54, 8.100e03),
            (datetime.datetime(2022, 3, 8, 11, 12), 14.52, 3.000e03),
            (datetime.datetime(2022, 3, 8, 11, 13), 14.53, 1.500e03),
            (datetime.datetime(2022, 3, 8, 11, 14), 14.51, 2.500e03),
            (datetime.datetime(2022, 3, 8, 11, 15), 14.49, 5.500e03),
            (datetime.datetime(2022, 3, 8, 11, 16), 14.48, 5.300e03),
            (datetime.datetime(2022, 3, 8, 11, 17), 14.48, 1.500e03),
            (datetime.datetime(2022, 3, 8, 11, 18), 14.46, 1.740e04),
            (datetime.datetime(2022, 3, 8, 11, 19), 14.41, 1.040e04),
            (datetime.datetime(2022, 3, 8, 11, 20), 14.45, 3.000e03),
            (datetime.datetime(2022, 3, 8, 11, 21), 14.41, 1.320e04),
            (datetime.datetime(2022, 3, 8, 11, 22), 14.38, 8.200e03),
            (datetime.datetime(2022, 3, 8, 11, 23), 14.37, 3.530e04),
            (datetime.datetime(2022, 3, 8, 11, 24), 14.4, 9.800e03),
            (datetime.datetime(2022, 3, 8, 11, 25), 14.41, 9.500e03),
            (datetime.datetime(2022, 3, 8, 11, 26), 14.36, 3.600e03),
            (datetime.datetime(2022, 3, 8, 11, 27), 14.41, 4.900e03),
            (datetime.datetime(2022, 3, 8, 11, 28), 14.3, 1.353e05),
            (datetime.datetime(2022, 3, 8, 11, 29), 14.33, 3.840e04),
            (datetime.datetime(2022, 3, 8, 11, 30), 14.35, 1.160e04),
            (datetime.datetime(2022, 3, 8, 13, 1), 14.46, 3.320e04),
            (datetime.datetime(2022, 3, 8, 13, 2), 14.55, 1.500e04),
            (datetime.datetime(2022, 3, 8, 13, 3), 14.58, 8.600e03),
            (datetime.datetime(2022, 3, 8, 13, 4), 14.61, 1.940e04),
            (datetime.datetime(2022, 3, 8, 13, 5), 14.63, 2.250e04),
            (datetime.datetime(2022, 3, 8, 13, 6), 14.68, 2.180e04),
            (datetime.datetime(2022, 3, 8, 13, 7), 14.68, 5.600e03),
            (datetime.datetime(2022, 3, 8, 13, 8), 14.68, 4.500e03),
            (datetime.datetime(2022, 3, 8, 13, 9), 14.7, 4.500e03),
            (datetime.datetime(2022, 3, 8, 13, 10), 14.73, 1.470e04),
            (datetime.datetime(2022, 3, 8, 13, 11), 14.66, 6.600e03),
            (datetime.datetime(2022, 3, 8, 13, 12), 14.67, 1.900e03),
            (datetime.datetime(2022, 3, 8, 13, 13), 14.65, 1.890e04),
            (datetime.datetime(2022, 3, 8, 13, 14), 14.64, 2.000e03),
            (datetime.datetime(2022, 3, 8, 13, 15), 14.64, 2.900e03),
            (datetime.datetime(2022, 3, 8, 13, 16), 14.66, 9.000e03),
            (datetime.datetime(2022, 3, 8, 13, 17), 14.65, 8.000e02),
            (datetime.datetime(2022, 3, 8, 13, 18), 14.68, 9.500e03),
            (datetime.datetime(2022, 3, 8, 13, 19), 14.68, 1.040e04),
            (datetime.datetime(2022, 3, 8, 13, 20), 14.67, 2.600e03),
            (datetime.datetime(2022, 3, 8, 13, 21), 14.69, 3.100e03),
            (datetime.datetime(2022, 3, 8, 13, 22), 14.65, 2.100e03),
            (datetime.datetime(2022, 3, 8, 13, 23), 14.65, 6.200e03),
            (datetime.datetime(2022, 3, 8, 13, 24), 14.65, 3.000e02),
            (datetime.datetime(2022, 3, 8, 13, 25), 14.65, 0.000e00),
            (datetime.datetime(2022, 3, 8, 13, 26), 14.65, 3.200e03),
            (datetime.datetime(2022, 3, 8, 13, 27), 14.64, 1.300e03),
            (datetime.datetime(2022, 3, 8, 13, 28), 14.68, 5.100e03),
            (datetime.datetime(2022, 3, 8, 13, 29), 14.72, 7.400e03),
            (datetime.datetime(2022, 3, 8, 13, 30), 14.72, 9.700e03),
            (datetime.datetime(2022, 3, 8, 13, 31), 14.72, 2.830e04),
            (datetime.datetime(2022, 3, 8, 13, 32), 14.69, 1.350e04),
            (datetime.datetime(2022, 3, 8, 13, 33), 14.7, 2.530e04),
            (datetime.datetime(2022, 3, 8, 13, 34), 14.73, 1.220e04),
            (datetime.datetime(2022, 3, 8, 13, 35), 14.73, 5.300e03),
            (datetime.datetime(2022, 3, 8, 13, 36), 14.73, 1.600e03),
            (datetime.datetime(2022, 3, 8, 13, 37), 14.71, 1.170e04),
            (datetime.datetime(2022, 3, 8, 13, 38), 14.7, 1.820e04),
            (datetime.datetime(2022, 3, 8, 13, 39), 14.73, 1.420e04),
            (datetime.datetime(2022, 3, 8, 13, 40), 14.75, 2.070e04),
            (datetime.datetime(2022, 3, 8, 13, 41), 14.77, 1.560e04),
            (datetime.datetime(2022, 3, 8, 13, 42), 14.78, 3.400e03),
            (datetime.datetime(2022, 3, 8, 13, 43), 14.79, 2.780e04),
            (datetime.datetime(2022, 3, 8, 13, 44), 14.79, 5.800e03),
            (datetime.datetime(2022, 3, 8, 13, 45), 14.8, 2.780e04),
            (datetime.datetime(2022, 3, 8, 13, 46), 14.79, 5.000e02),
            (datetime.datetime(2022, 3, 8, 13, 47), 14.76, 4.040e04),
            (datetime.datetime(2022, 3, 8, 13, 48), 14.82, 2.251e05),
            (datetime.datetime(2022, 3, 8, 13, 49), 14.81, 7.530e04),
            (datetime.datetime(2022, 3, 8, 13, 50), 14.82, 1.580e04),
            (datetime.datetime(2022, 3, 8, 13, 51), 14.84, 2.980e04),
            (datetime.datetime(2022, 3, 8, 13, 52), 14.86, 3.050e04),
            (datetime.datetime(2022, 3, 8, 13, 53), 14.86, 1.920e04),
            (datetime.datetime(2022, 3, 8, 13, 54), 14.86, 6.240e04),
            (datetime.datetime(2022, 3, 8, 13, 55), 14.85, 5.600e03),
            (datetime.datetime(2022, 3, 8, 13, 56), 14.86, 6.040e04),
            (datetime.datetime(2022, 3, 8, 13, 57), 14.87, 7.690e04),
            (datetime.datetime(2022, 3, 8, 13, 58), 14.87, 2.880e04),
            (datetime.datetime(2022, 3, 8, 13, 59), 14.88, 4.960e04),
            (datetime.datetime(2022, 3, 8, 14, 0), 14.88, 3.570e04),
            (datetime.datetime(2022, 3, 8, 14, 1), 14.86, 1.250e04),
            (datetime.datetime(2022, 3, 8, 14, 2), 14.83, 3.420e04),
            (datetime.datetime(2022, 3, 8, 14, 3), 14.83, 1.730e04),
            (datetime.datetime(2022, 3, 8, 14, 4), 14.83, 5.000e03),
            (datetime.datetime(2022, 3, 8, 14, 5), 14.82, 1.250e04),
            (datetime.datetime(2022, 3, 8, 14, 6), 14.81, 1.830e04),
            (datetime.datetime(2022, 3, 8, 14, 7), 14.79, 1.630e04),
            (datetime.datetime(2022, 3, 8, 14, 8), 14.79, 2.200e03),
            (datetime.datetime(2022, 3, 8, 14, 9), 14.79, 1.390e04),
            (datetime.datetime(2022, 3, 8, 14, 10), 14.8, 5.000e03),
            (datetime.datetime(2022, 3, 8, 14, 11), 14.78, 1.500e03),
            (datetime.datetime(2022, 3, 8, 14, 12), 14.78, 2.000e02),
            (datetime.datetime(2022, 3, 8, 14, 13), 14.76, 2.040e04),
            (datetime.datetime(2022, 3, 8, 14, 14), 14.76, 4.100e03),
            (datetime.datetime(2022, 3, 8, 14, 15), 14.75, 6.300e03),
            (datetime.datetime(2022, 3, 8, 14, 16), 14.75, 8.600e03),
            (datetime.datetime(2022, 3, 8, 14, 17), 14.74, 1.180e04),
            (datetime.datetime(2022, 3, 8, 14, 18), 14.74, 5.100e03),
            (datetime.datetime(2022, 3, 8, 14, 19), 14.74, 1.170e04),
            (datetime.datetime(2022, 3, 8, 14, 20), 14.73, 4.900e03),
            (datetime.datetime(2022, 3, 8, 14, 21), 14.73, 0.000e00),
            (datetime.datetime(2022, 3, 8, 14, 22), 14.72, 9.000e03),
            (datetime.datetime(2022, 3, 8, 14, 23), 14.71, 1.010e04),
            (datetime.datetime(2022, 3, 8, 14, 24), 14.73, 9.200e03),
            (datetime.datetime(2022, 3, 8, 14, 25), 14.73, 4.100e03),
            (datetime.datetime(2022, 3, 8, 14, 26), 14.74, 1.020e04),
            (datetime.datetime(2022, 3, 8, 14, 27), 14.73, 3.400e03),
            (datetime.datetime(2022, 3, 8, 14, 28), 14.73, 3.900e03),
            (datetime.datetime(2022, 3, 8, 14, 29), 14.72, 1.020e04),
            (datetime.datetime(2022, 3, 8, 14, 30), 14.72, 0.000e00),
            (datetime.datetime(2022, 3, 8, 14, 31), 14.72, 0.000e00),
            (datetime.datetime(2022, 3, 8, 14, 32), 14.68, 3.740e04),
            (datetime.datetime(2022, 3, 8, 14, 33), 14.68, 7.800e03),
            (datetime.datetime(2022, 3, 8, 14, 34), 14.67, 7.300e03),
            (datetime.datetime(2022, 3, 8, 14, 35), 14.63, 6.210e04),
            (datetime.datetime(2022, 3, 8, 14, 36), 14.59, 4.810e04),
            (datetime.datetime(2022, 3, 8, 14, 37), 14.59, 3.500e03),
            (datetime.datetime(2022, 3, 8, 14, 38), 14.58, 3.980e04),
            (datetime.datetime(2022, 3, 8, 14, 39), 14.6, 1.390e04),
            (datetime.datetime(2022, 3, 8, 14, 40), 14.62, 3.270e04),
            (datetime.datetime(2022, 3, 8, 14, 41), 14.62, 8.580e04),
            (datetime.datetime(2022, 3, 8, 14, 42), 14.68, 1.290e04),
            (datetime.datetime(2022, 3, 8, 14, 43), 14.69, 1.460e04),
            (datetime.datetime(2022, 3, 8, 14, 44), 14.67, 3.200e04),
            (datetime.datetime(2022, 3, 8, 14, 45), 14.68, 2.260e04),
            (datetime.datetime(2022, 3, 8, 14, 46), 14.68, 9.500e03),
            (datetime.datetime(2022, 3, 8, 14, 47), 14.68, 8.400e03),
            (datetime.datetime(2022, 3, 8, 14, 48), 14.68, 2.200e04),
            (datetime.datetime(2022, 3, 8, 14, 49), 14.7, 1.030e04),
            (datetime.datetime(2022, 3, 8, 14, 50), 14.7, 8.300e03),
            (datetime.datetime(2022, 3, 8, 14, 51), 14.72, 3.030e04),
            (datetime.datetime(2022, 3, 8, 14, 52), 14.73, 2.390e04),
            (datetime.datetime(2022, 3, 8, 14, 53), 14.76, 2.690e04),
            (datetime.datetime(2022, 3, 8, 14, 54), 14.74, 4.130e04),
            (datetime.datetime(2022, 3, 8, 14, 55), 14.75, 4.530e04),
            (datetime.datetime(2022, 3, 8, 14, 56), 14.74, 3.860e04),
            (datetime.datetime(2022, 3, 8, 14, 57), 14.77, 6.550e04),
            (datetime.datetime(2022, 3, 8, 14, 58), 14.77, 0.000e00),
            (datetime.datetime(2022, 3, 8, 14, 59), 14.77, 0.000e00),
            (datetime.datetime(2022, 3, 8, 15, 0), 14.73, 5.800e04),
            (datetime.datetime(2022, 3, 9, 9, 31), 14.74, 3.530e04),
            (datetime.datetime(2022, 3, 9, 9, 32), 14.7, 1.170e04),
            (datetime.datetime(2022, 3, 9, 9, 33), 14.71, 9.300e03),
            (datetime.datetime(2022, 3, 9, 9, 34), 14.68, 1.140e04),
            (datetime.datetime(2022, 3, 9, 9, 35), 14.65, 5.190e04),
            (datetime.datetime(2022, 3, 9, 9, 36), 14.66, 3.950e04),
            (datetime.datetime(2022, 3, 9, 9, 37), 14.72, 3.030e04),
            (datetime.datetime(2022, 3, 9, 9, 38), 14.69, 1.600e04),
            (datetime.datetime(2022, 3, 9, 9, 39), 14.7, 1.500e03),
            (datetime.datetime(2022, 3, 9, 9, 40), 14.7, 4.200e03),
            (datetime.datetime(2022, 3, 9, 9, 41), 14.71, 1.900e03),
            (datetime.datetime(2022, 3, 9, 9, 42), 14.7, 4.000e03),
            (datetime.datetime(2022, 3, 9, 9, 43), 14.69, 3.100e03),
            (datetime.datetime(2022, 3, 9, 9, 44), 14.72, 5.200e03),
            (datetime.datetime(2022, 3, 9, 9, 45), 14.72, 1.800e03),
            (datetime.datetime(2022, 3, 9, 9, 46), 14.7, 7.000e03),
            (datetime.datetime(2022, 3, 9, 9, 47), 14.7, 2.500e03),
            (datetime.datetime(2022, 3, 9, 9, 48), 14.67, 2.200e03),
            (datetime.datetime(2022, 3, 9, 9, 49), 14.67, 5.200e03),
            (datetime.datetime(2022, 3, 9, 9, 50), 14.67, 1.250e04),
            (datetime.datetime(2022, 3, 9, 9, 51), 14.66, 9.100e03),
            (datetime.datetime(2022, 3, 9, 9, 52), 14.66, 9.400e03),
            (datetime.datetime(2022, 3, 9, 9, 53), 14.65, 1.000e04),
            (datetime.datetime(2022, 3, 9, 9, 54), 14.63, 4.900e03),
            (datetime.datetime(2022, 3, 9, 9, 55), 14.62, 9.100e03),
            (datetime.datetime(2022, 3, 9, 9, 56), 14.61, 1.980e04),
            (datetime.datetime(2022, 3, 9, 9, 57), 14.62, 3.300e03),
            (datetime.datetime(2022, 3, 9, 9, 58), 14.63, 1.030e04),
            (datetime.datetime(2022, 3, 9, 9, 59), 14.63, 8.100e03),
            (datetime.datetime(2022, 3, 9, 10, 0), 14.62, 5.200e03),
            (datetime.datetime(2022, 3, 9, 10, 1), 14.63, 9.100e03),
            (datetime.datetime(2022, 3, 9, 10, 2), 14.63, 8.200e03),
            (datetime.datetime(2022, 3, 9, 10, 3), 14.61, 6.600e03),
            (datetime.datetime(2022, 3, 9, 10, 4), 14.63, 4.700e03),
            (datetime.datetime(2022, 3, 9, 10, 5), 14.64, 6.800e03),
            (datetime.datetime(2022, 3, 9, 10, 6), 14.64, 9.200e03),
            (datetime.datetime(2022, 3, 9, 10, 7), 14.63, 4.300e03),
            (datetime.datetime(2022, 3, 9, 10, 8), 14.61, 6.500e03),
            (datetime.datetime(2022, 3, 9, 10, 9), 14.6, 1.060e04),
            (datetime.datetime(2022, 3, 9, 10, 10), 14.61, 1.800e03),
            (datetime.datetime(2022, 3, 9, 10, 11), 14.61, 1.800e03),
            (datetime.datetime(2022, 3, 9, 10, 12), 14.63, 6.000e03),
            (datetime.datetime(2022, 3, 9, 10, 13), 14.62, 4.300e03),
            (datetime.datetime(2022, 3, 9, 10, 14), 14.61, 8.100e03),
            (datetime.datetime(2022, 3, 9, 10, 15), 14.61, 9.000e02),
            (datetime.datetime(2022, 3, 9, 10, 16), 14.6, 3.580e04),
            (datetime.datetime(2022, 3, 9, 10, 17), 14.6, 1.110e04),
            (datetime.datetime(2022, 3, 9, 10, 18), 14.62, 4.000e03),
            (datetime.datetime(2022, 3, 9, 10, 19), 14.62, 5.000e02),
            (datetime.datetime(2022, 3, 9, 10, 20), 14.61, 2.200e03),
            (datetime.datetime(2022, 3, 9, 10, 21), 14.61, 2.800e03),
            (datetime.datetime(2022, 3, 9, 10, 22), 14.61, 1.430e04),
            (datetime.datetime(2022, 3, 9, 10, 23), 14.59, 1.650e04),
            (datetime.datetime(2022, 3, 9, 10, 24), 14.6, 2.260e04),
            (datetime.datetime(2022, 3, 9, 10, 25), 14.62, 3.150e04),
            (datetime.datetime(2022, 3, 9, 10, 26), 14.64, 3.020e04),
            (datetime.datetime(2022, 3, 9, 10, 27), 14.66, 3.340e04),
            (datetime.datetime(2022, 3, 9, 10, 28), 14.64, 8.960e04),
            (datetime.datetime(2022, 3, 9, 10, 29), 14.68, 7.180e04),
            (datetime.datetime(2022, 3, 9, 10, 30), 14.68, 6.150e04),
            (datetime.datetime(2022, 3, 9, 10, 31), 14.69, 7.670e04),
            (datetime.datetime(2022, 3, 9, 10, 32), 14.68, 6.270e04),
            (datetime.datetime(2022, 3, 9, 10, 33), 14.68, 6.350e04),
            (datetime.datetime(2022, 3, 9, 10, 34), 14.65, 2.990e04),
            (datetime.datetime(2022, 3, 9, 10, 35), 14.64, 1.060e04),
            (datetime.datetime(2022, 3, 9, 10, 36), 14.66, 6.670e04),
            (datetime.datetime(2022, 3, 9, 10, 37), 14.67, 4.760e04),
            (datetime.datetime(2022, 3, 9, 10, 38), 14.67, 5.230e04),
            (datetime.datetime(2022, 3, 9, 10, 39), 14.63, 7.680e04),
            (datetime.datetime(2022, 3, 9, 10, 40), 14.64, 9.350e04),
            (datetime.datetime(2022, 3, 9, 10, 41), 14.64, 1.249e05),
            (datetime.datetime(2022, 3, 9, 10, 42), 14.62, 4.970e04),
            (datetime.datetime(2022, 3, 9, 10, 43), 14.62, 1.690e04),
            (datetime.datetime(2022, 3, 9, 10, 44), 14.6, 1.050e04),
            (datetime.datetime(2022, 3, 9, 10, 45), 14.58, 1.078e05),
            (datetime.datetime(2022, 3, 9, 10, 46), 14.57, 3.300e03),
            (datetime.datetime(2022, 3, 9, 10, 47), 14.58, 1.900e03),
            (datetime.datetime(2022, 3, 9, 10, 48), 14.57, 5.700e03),
            (datetime.datetime(2022, 3, 9, 10, 49), 14.55, 2.960e04),
            (datetime.datetime(2022, 3, 9, 10, 50), 14.52, 8.520e04),
            (datetime.datetime(2022, 3, 9, 10, 51), 14.51, 2.600e04),
            (datetime.datetime(2022, 3, 9, 10, 52), 14.5, 2.690e04),
            (datetime.datetime(2022, 3, 9, 10, 53), 14.5, 1.000e05),
            (datetime.datetime(2022, 3, 9, 10, 54), 14.51, 2.000e04),
            (datetime.datetime(2022, 3, 9, 10, 55), 14.49, 3.240e04),
            (datetime.datetime(2022, 3, 9, 10, 56), 14.49, 3.000e04),
            (datetime.datetime(2022, 3, 9, 10, 57), 14.48, 1.820e04),
            (datetime.datetime(2022, 3, 9, 10, 58), 14.48, 1.440e04),
            (datetime.datetime(2022, 3, 9, 10, 59), 14.49, 2.120e04),
            (datetime.datetime(2022, 3, 9, 11, 0), 14.5, 6.700e03),
            (datetime.datetime(2022, 3, 9, 11, 1), 14.5, 9.800e03),
            (datetime.datetime(2022, 3, 9, 11, 2), 14.53, 3.860e04),
            (datetime.datetime(2022, 3, 9, 11, 3), 14.53, 7.100e03),
            (datetime.datetime(2022, 3, 9, 11, 4), 14.51, 1.350e04),
            (datetime.datetime(2022, 3, 9, 11, 5), 14.52, 1.440e04),
            (datetime.datetime(2022, 3, 9, 11, 6), 14.52, 5.900e03),
            (datetime.datetime(2022, 3, 9, 11, 7), 14.52, 1.660e04),
            (datetime.datetime(2022, 3, 9, 11, 8), 14.53, 7.900e03),
            (datetime.datetime(2022, 3, 9, 11, 9), 14.53, 4.900e03),
            (datetime.datetime(2022, 3, 9, 11, 10), 14.53, 4.500e03),
            (datetime.datetime(2022, 3, 9, 11, 11), 14.54, 3.900e03),
            (datetime.datetime(2022, 3, 9, 11, 12), 14.53, 4.200e03),
            (datetime.datetime(2022, 3, 9, 11, 13), 14.54, 2.000e03),
            (datetime.datetime(2022, 3, 9, 11, 14), 14.53, 6.100e03),
            (datetime.datetime(2022, 3, 9, 11, 15), 14.52, 7.600e03),
            (datetime.datetime(2022, 3, 9, 11, 16), 14.49, 2.230e04),
            (datetime.datetime(2022, 3, 9, 11, 17), 14.55, 5.700e03),
            (datetime.datetime(2022, 3, 9, 11, 18), 14.5, 1.700e03),
            (datetime.datetime(2022, 3, 9, 11, 19), 14.5, 6.700e03),
            (datetime.datetime(2022, 3, 9, 11, 20), 14.51, 4.500e03),
            (datetime.datetime(2022, 3, 9, 11, 21), 14.51, 2.300e03),
            (datetime.datetime(2022, 3, 9, 11, 22), 14.51, 9.800e03),
            (datetime.datetime(2022, 3, 9, 11, 23), 14.51, 2.800e03),
            (datetime.datetime(2022, 3, 9, 11, 24), 14.51, 1.100e03),
            (datetime.datetime(2022, 3, 9, 11, 25), 14.5, 2.500e03),
            (datetime.datetime(2022, 3, 9, 11, 26), 14.51, 1.290e04),
            (datetime.datetime(2022, 3, 9, 11, 27), 14.52, 3.500e03),
            (datetime.datetime(2022, 3, 9, 11, 28), 14.52, 1.400e03),
            (datetime.datetime(2022, 3, 9, 11, 29), 14.53, 4.100e03),
            (datetime.datetime(2022, 3, 9, 11, 30), 14.52, 1.830e04),
            (datetime.datetime(2022, 3, 9, 13, 1), 14.48, 1.110e05),
            (datetime.datetime(2022, 3, 9, 13, 2), 14.49, 2.370e04),
            (datetime.datetime(2022, 3, 9, 13, 3), 14.53, 6.230e04),
            (datetime.datetime(2022, 3, 9, 13, 4), 14.53, 1.070e04),
            (datetime.datetime(2022, 3, 9, 13, 5), 14.52, 1.070e04),
            (datetime.datetime(2022, 3, 9, 13, 6), 14.5, 3.000e03),
            (datetime.datetime(2022, 3, 9, 13, 7), 14.41, 2.250e04),
            (datetime.datetime(2022, 3, 9, 13, 8), 14.49, 2.980e04),
            (datetime.datetime(2022, 3, 9, 13, 9), 14.44, 7.950e04),
            (datetime.datetime(2022, 3, 9, 13, 10), 14.46, 4.360e04),
            (datetime.datetime(2022, 3, 9, 13, 11), 14.46, 1.500e04),
            (datetime.datetime(2022, 3, 9, 13, 12), 14.47, 1.000e03),
            (datetime.datetime(2022, 3, 9, 13, 13), 14.48, 1.040e04),
            (datetime.datetime(2022, 3, 9, 13, 14), 14.48, 2.020e04),
            (datetime.datetime(2022, 3, 9, 13, 15), 14.48, 1.560e04),
            (datetime.datetime(2022, 3, 9, 13, 16), 14.48, 8.600e03),
            (datetime.datetime(2022, 3, 9, 13, 17), 14.48, 1.140e04),
            (datetime.datetime(2022, 3, 9, 13, 18), 14.46, 9.300e03),
            (datetime.datetime(2022, 3, 9, 13, 19), 14.47, 8.600e03),
            (datetime.datetime(2022, 3, 9, 13, 20), 14.46, 7.500e03),
            (datetime.datetime(2022, 3, 9, 13, 21), 14.47, 5.700e03),
            (datetime.datetime(2022, 3, 9, 13, 22), 14.46, 6.900e03),
            (datetime.datetime(2022, 3, 9, 13, 23), 14.46, 1.050e04),
            (datetime.datetime(2022, 3, 9, 13, 24), 14.47, 1.050e04),
            (datetime.datetime(2022, 3, 9, 13, 25), 14.44, 1.260e04),
            (datetime.datetime(2022, 3, 9, 13, 26), 14.4, 5.100e04),
            (datetime.datetime(2022, 3, 9, 13, 27), 14.34, 2.100e04),
            (datetime.datetime(2022, 3, 9, 13, 28), 14.35, 4.840e04),
            (datetime.datetime(2022, 3, 9, 13, 29), 14.41, 1.060e04),
            (datetime.datetime(2022, 3, 9, 13, 30), 14.41, 8.300e03),
            (datetime.datetime(2022, 3, 9, 13, 31), 14.42, 1.470e04),
            (datetime.datetime(2022, 3, 9, 13, 32), 14.43, 1.270e04),
            (datetime.datetime(2022, 3, 9, 13, 33), 14.39, 1.520e04),
            (datetime.datetime(2022, 3, 9, 13, 34), 14.35, 2.990e04),
            (datetime.datetime(2022, 3, 9, 13, 35), 14.4, 1.180e04),
            (datetime.datetime(2022, 3, 9, 13, 36), 14.39, 1.710e04),
            (datetime.datetime(2022, 3, 9, 13, 37), 14.4, 5.400e03),
            (datetime.datetime(2022, 3, 9, 13, 38), 14.41, 1.100e04),
            (datetime.datetime(2022, 3, 9, 13, 39), 14.37, 1.860e04),
            (datetime.datetime(2022, 3, 9, 13, 40), 14.38, 1.500e04),
            (datetime.datetime(2022, 3, 9, 13, 41), 14.33, 1.680e04),
            (datetime.datetime(2022, 3, 9, 13, 42), 14.33, 1.160e04),
            (datetime.datetime(2022, 3, 9, 13, 43), 14.37, 2.210e04),
            (datetime.datetime(2022, 3, 9, 13, 44), 14.22, 7.760e04),
            (datetime.datetime(2022, 3, 9, 13, 45), 14.32, 8.710e04),
            (datetime.datetime(2022, 3, 9, 13, 46), 14.24, 3.140e04),
            (datetime.datetime(2022, 3, 9, 13, 47), 14.27, 2.410e04),
            (datetime.datetime(2022, 3, 9, 13, 48), 14.26, 2.980e04),
            (datetime.datetime(2022, 3, 9, 13, 49), 14.07, 3.530e04),
            (datetime.datetime(2022, 3, 9, 13, 50), 14.07, 3.030e04),
            (datetime.datetime(2022, 3, 9, 13, 51), 14.03, 2.082e05),
            (datetime.datetime(2022, 3, 9, 13, 52), 14.18, 5.220e04),
            (datetime.datetime(2022, 3, 9, 13, 53), 14.24, 1.580e04),
            (datetime.datetime(2022, 3, 9, 13, 54), 14.12, 8.800e03),
            (datetime.datetime(2022, 3, 9, 13, 55), 14.22, 1.770e04),
            (datetime.datetime(2022, 3, 9, 13, 56), 14.19, 5.200e03),
            (datetime.datetime(2022, 3, 9, 13, 57), 14.18, 1.330e04),
            (datetime.datetime(2022, 3, 9, 13, 58), 14.22, 3.460e04),
            (datetime.datetime(2022, 3, 9, 13, 59), 14.22, 2.610e04),
            (datetime.datetime(2022, 3, 9, 14, 0), 14.18, 2.020e04),
            (datetime.datetime(2022, 3, 9, 14, 1), 14.11, 1.770e04),
            (datetime.datetime(2022, 3, 9, 14, 2), 14.09, 1.320e04),
            (datetime.datetime(2022, 3, 9, 14, 3), 14.1, 2.610e04),
            (datetime.datetime(2022, 3, 9, 14, 4), 14.1, 1.590e04),
            (datetime.datetime(2022, 3, 9, 14, 5), 14.07, 4.960e04),
            (datetime.datetime(2022, 3, 9, 14, 6), 14.03, 2.150e04),
            (datetime.datetime(2022, 3, 9, 14, 7), 14.05, 8.570e04),
            (datetime.datetime(2022, 3, 9, 14, 8), 14.0, 2.640e04),
            (datetime.datetime(2022, 3, 9, 14, 9), 14.05, 9.720e04),
            (datetime.datetime(2022, 3, 9, 14, 10), 13.9, 6.520e04),
            (datetime.datetime(2022, 3, 9, 14, 11), 13.92, 7.310e04),
            (datetime.datetime(2022, 3, 9, 14, 12), 13.9, 9.480e04),
            (datetime.datetime(2022, 3, 9, 14, 13), 13.97, 1.190e05),
            (datetime.datetime(2022, 3, 9, 14, 14), 13.94, 1.620e04),
            (datetime.datetime(2022, 3, 9, 14, 15), 13.94, 5.900e04),
            (datetime.datetime(2022, 3, 9, 14, 16), 13.92, 1.980e04),
            (datetime.datetime(2022, 3, 9, 14, 17), 13.92, 3.450e04),
            (datetime.datetime(2022, 3, 9, 14, 18), 13.9, 2.890e04),
            (datetime.datetime(2022, 3, 9, 14, 19), 13.88, 1.050e04),
            (datetime.datetime(2022, 3, 9, 14, 20), 13.86, 1.900e04),
            (datetime.datetime(2022, 3, 9, 14, 21), 13.83, 4.030e04),
            (datetime.datetime(2022, 3, 9, 14, 22), 13.83, 2.640e04),
            (datetime.datetime(2022, 3, 9, 14, 23), 13.85, 2.690e04),
            (datetime.datetime(2022, 3, 9, 14, 24), 13.83, 5.260e04),
            (datetime.datetime(2022, 3, 9, 14, 25), 13.82, 2.190e04),
            (datetime.datetime(2022, 3, 9, 14, 26), 13.82, 1.500e04),
            (datetime.datetime(2022, 3, 9, 14, 27), 13.85, 2.670e04),
            (datetime.datetime(2022, 3, 9, 14, 28), 13.85, 1.610e04),
            (datetime.datetime(2022, 3, 9, 14, 29), 13.85, 4.500e03),
            (datetime.datetime(2022, 3, 9, 14, 30), 13.83, 2.140e04),
            (datetime.datetime(2022, 3, 9, 14, 31), 13.8, 1.240e04),
            (datetime.datetime(2022, 3, 9, 14, 32), 13.8, 5.270e04),
            (datetime.datetime(2022, 3, 9, 14, 33), 13.77, 6.050e04),
            (datetime.datetime(2022, 3, 9, 14, 34), 13.77, 9.310e04),
            (datetime.datetime(2022, 3, 9, 14, 35), 13.78, 1.041e05),
            (datetime.datetime(2022, 3, 9, 14, 36), 13.95, 9.540e04),
            (datetime.datetime(2022, 3, 9, 14, 37), 13.85, 1.070e05),
            (datetime.datetime(2022, 3, 9, 14, 38), 13.91, 9.820e04),
            (datetime.datetime(2022, 3, 9, 14, 39), 13.89, 5.420e04),
            (datetime.datetime(2022, 3, 9, 14, 40), 13.7, 3.150e04),
            (datetime.datetime(2022, 3, 9, 14, 41), 13.9, 4.780e04),
            (datetime.datetime(2022, 3, 9, 14, 42), 13.81, 2.390e04),
            (datetime.datetime(2022, 3, 9, 14, 43), 13.85, 4.040e04),
            (datetime.datetime(2022, 3, 9, 14, 44), 13.83, 1.309e05),
            (datetime.datetime(2022, 3, 9, 14, 45), 13.91, 4.970e04),
            (datetime.datetime(2022, 3, 9, 14, 46), 13.85, 5.220e04),
            (datetime.datetime(2022, 3, 9, 14, 47), 13.8, 7.930e04),
            (datetime.datetime(2022, 3, 9, 14, 48), 13.8, 5.730e04),
            (datetime.datetime(2022, 3, 9, 14, 49), 13.83, 6.780e04),
            (datetime.datetime(2022, 3, 9, 14, 50), 13.8, 5.200e04),
            (datetime.datetime(2022, 3, 9, 14, 51), 13.75, 1.354e05),
            (datetime.datetime(2022, 3, 9, 14, 52), 13.79, 6.730e04),
            (datetime.datetime(2022, 3, 9, 14, 53), 13.8, 6.860e04),
            (datetime.datetime(2022, 3, 9, 14, 54), 13.77, 4.590e04),
            (datetime.datetime(2022, 3, 9, 14, 55), 13.73, 4.590e04),
            (datetime.datetime(2022, 3, 9, 14, 56), 13.77, 5.950e04),
            (datetime.datetime(2022, 3, 9, 14, 57), 13.77, 1.078e05),
            (datetime.datetime(2022, 3, 9, 14, 58), 13.77, 0.000e00),
            (datetime.datetime(2022, 3, 9, 14, 59), 13.77, 0.000e00),
            (datetime.datetime(2022, 3, 9, 15, 0), 13.7, 2.459e05),
            (datetime.datetime(2022, 3, 10, 9, 31), 13.83, 1.458e05),
            (datetime.datetime(2022, 3, 10, 9, 32), 13.73, 1.292e05),
            (datetime.datetime(2022, 3, 10, 9, 33), 13.67, 1.673e05),
            (datetime.datetime(2022, 3, 10, 9, 34), 13.61, 4.070e04),
            (datetime.datetime(2022, 3, 10, 9, 35), 13.57, 5.270e04),
            (datetime.datetime(2022, 3, 10, 9, 36), 13.41, 8.910e04),
            (datetime.datetime(2022, 3, 10, 9, 37), 13.25, 1.452e05),
            (datetime.datetime(2022, 3, 10, 9, 38), 13.12, 1.208e05),
            (datetime.datetime(2022, 3, 10, 9, 39), 13.03, 2.446e05),
            (datetime.datetime(2022, 3, 10, 9, 40), 12.98, 1.279e05),
            (datetime.datetime(2022, 3, 10, 9, 41), 12.85, 1.782e05),
            (datetime.datetime(2022, 3, 10, 9, 42), 12.85, 4.253e05),
            (datetime.datetime(2022, 3, 10, 9, 43), 12.82, 3.670e05),
            (datetime.datetime(2022, 3, 10, 9, 44), 12.84, 2.247e05),
            (datetime.datetime(2022, 3, 10, 9, 45), 12.85, 3.664e05),
            (datetime.datetime(2022, 3, 10, 9, 46), 12.7, 1.661e05),
            (datetime.datetime(2022, 3, 10, 9, 47), 12.72, 1.838e05),
            (datetime.datetime(2022, 3, 10, 9, 48), 12.86, 1.625e05),
            (datetime.datetime(2022, 3, 10, 9, 49), 12.68, 2.124e05),
            (datetime.datetime(2022, 3, 10, 9, 50), 12.67, 3.198e05),
            (datetime.datetime(2022, 3, 10, 9, 51), 12.65, 4.182e05),
            (datetime.datetime(2022, 3, 10, 9, 52), 12.57, 3.381e05),
            (datetime.datetime(2022, 3, 10, 9, 53), 12.44, 2.525e05),
            (datetime.datetime(2022, 3, 10, 9, 54), 12.33, 8.531e05),
            (datetime.datetime(2022, 3, 10, 9, 55), 12.33, 7.730e04),
            (datetime.datetime(2022, 3, 10, 9, 56), 12.33, 3.260e04),
            (datetime.datetime(2022, 3, 10, 9, 57), 12.33, 3.580e04),
            (datetime.datetime(2022, 3, 10, 9, 58), 12.33, 3.640e04),
            (datetime.datetime(2022, 3, 10, 9, 59), 12.33, 3.420e04),
            (datetime.datetime(2022, 3, 10, 10, 0), 12.33, 2.780e04),
            (datetime.datetime(2022, 3, 10, 10, 1), 12.33, 1.710e04),
            (datetime.datetime(2022, 3, 10, 10, 2), 12.33, 6.300e03),
            (datetime.datetime(2022, 3, 10, 10, 3), 12.33, 1.660e04),
            (datetime.datetime(2022, 3, 10, 10, 4), 12.33, 2.120e04),
            (datetime.datetime(2022, 3, 10, 10, 5), 12.33, 3.620e04),
            (datetime.datetime(2022, 3, 10, 10, 6), 12.33, 1.170e04),
            (datetime.datetime(2022, 3, 10, 10, 7), 12.33, 6.900e03),
            (datetime.datetime(2022, 3, 10, 10, 8), 12.33, 1.240e04),
            (datetime.datetime(2022, 3, 10, 10, 9), 12.33, 1.180e04),
            (datetime.datetime(2022, 3, 10, 10, 10), 12.33, 1.410e04),
            (datetime.datetime(2022, 3, 10, 10, 11), 12.33, 8.800e03),
            (datetime.datetime(2022, 3, 10, 10, 12), 12.33, 6.800e03),
            (datetime.datetime(2022, 3, 10, 10, 13), 12.33, 6.100e03),
            (datetime.datetime(2022, 3, 10, 10, 14), 12.33, 2.210e04),
            (datetime.datetime(2022, 3, 10, 10, 15), 12.33, 4.200e03),
            (datetime.datetime(2022, 3, 10, 10, 16), 12.33, 5.000e03),
            (datetime.datetime(2022, 3, 10, 10, 17), 12.33, 5.600e03),
            (datetime.datetime(2022, 3, 10, 10, 18), 12.33, 4.600e03),
            (datetime.datetime(2022, 3, 10, 10, 19), 12.33, 6.200e03),
            (datetime.datetime(2022, 3, 10, 10, 20), 12.33, 4.300e03),
            (datetime.datetime(2022, 3, 10, 10, 21), 12.33, 6.700e03),
            (datetime.datetime(2022, 3, 10, 10, 22), 12.33, 4.100e03),
            (datetime.datetime(2022, 3, 10, 10, 23), 12.33, 5.800e03),
            (datetime.datetime(2022, 3, 10, 10, 24), 12.33, 5.330e04),
            (datetime.datetime(2022, 3, 10, 10, 25), 12.33, 1.840e04),
            (datetime.datetime(2022, 3, 10, 10, 26), 12.33, 1.430e04),
            (datetime.datetime(2022, 3, 10, 10, 27), 12.33, 1.250e04),
            (datetime.datetime(2022, 3, 10, 10, 28), 12.33, 2.500e03),
            (datetime.datetime(2022, 3, 10, 10, 29), 12.33, 8.800e03),
            (datetime.datetime(2022, 3, 10, 10, 30), 12.33, 4.400e03),
            (datetime.datetime(2022, 3, 10, 10, 31), 12.33, 7.800e03),
            (datetime.datetime(2022, 3, 10, 10, 32), 12.33, 4.400e03),
            (datetime.datetime(2022, 3, 10, 10, 33), 12.33, 9.000e03),
            (datetime.datetime(2022, 3, 10, 10, 34), 12.33, 1.090e04),
            (datetime.datetime(2022, 3, 10, 10, 35), 12.33, 5.500e03),
            (datetime.datetime(2022, 3, 10, 10, 36), 12.33, 7.300e03),
            (datetime.datetime(2022, 3, 10, 10, 37), 12.33, 3.600e03),
            (datetime.datetime(2022, 3, 10, 10, 38), 12.33, 1.710e04),
            (datetime.datetime(2022, 3, 10, 10, 39), 12.33, 9.200e03),
            (datetime.datetime(2022, 3, 10, 10, 40), 12.33, 5.500e03),
            (datetime.datetime(2022, 3, 10, 10, 41), 12.33, 5.200e03),
            (datetime.datetime(2022, 3, 10, 10, 42), 12.33, 5.100e03),
            (datetime.datetime(2022, 3, 10, 10, 43), 12.33, 9.700e03),
            (datetime.datetime(2022, 3, 10, 10, 44), 12.33, 1.600e03),
            (datetime.datetime(2022, 3, 10, 10, 45), 12.33, 2.500e03),
            (datetime.datetime(2022, 3, 10, 10, 46), 12.33, 1.400e03),
            (datetime.datetime(2022, 3, 10, 10, 47), 12.33, 2.500e03),
            (datetime.datetime(2022, 3, 10, 10, 48), 12.33, 3.400e03),
            (datetime.datetime(2022, 3, 10, 10, 49), 12.33, 4.900e03),
            (datetime.datetime(2022, 3, 10, 10, 50), 12.33, 4.200e03),
            (datetime.datetime(2022, 3, 10, 10, 51), 12.33, 4.900e03),
            (datetime.datetime(2022, 3, 10, 10, 52), 12.33, 5.200e03),
            (datetime.datetime(2022, 3, 10, 10, 53), 12.33, 7.700e03),
            (datetime.datetime(2022, 3, 10, 10, 54), 12.33, 4.300e03),
            (datetime.datetime(2022, 3, 10, 10, 55), 12.33, 1.720e04),
            (datetime.datetime(2022, 3, 10, 10, 56), 12.33, 5.300e03),
            (datetime.datetime(2022, 3, 10, 10, 57), 12.33, 6.800e03),
            (datetime.datetime(2022, 3, 10, 10, 58), 12.33, 8.700e03),
            (datetime.datetime(2022, 3, 10, 10, 59), 12.33, 1.000e03),
            (datetime.datetime(2022, 3, 10, 11, 0), 12.33, 1.700e03),
            (datetime.datetime(2022, 3, 10, 11, 1), 12.33, 3.800e03),
            (datetime.datetime(2022, 3, 10, 11, 2), 12.33, 8.350e04),
            (datetime.datetime(2022, 3, 10, 11, 3), 12.33, 2.670e04),
            (datetime.datetime(2022, 3, 10, 11, 4), 12.33, 1.700e04),
            (datetime.datetime(2022, 3, 10, 11, 5), 12.33, 9.600e03),
            (datetime.datetime(2022, 3, 10, 11, 6), 12.33, 2.800e03),
            (datetime.datetime(2022, 3, 10, 11, 7), 12.33, 1.040e04),
            (datetime.datetime(2022, 3, 10, 11, 8), 12.33, 1.700e03),
            (datetime.datetime(2022, 3, 10, 11, 9), 12.33, 5.410e04),
            (datetime.datetime(2022, 3, 10, 11, 10), 12.33, 2.200e03),
            (datetime.datetime(2022, 3, 10, 11, 11), 12.33, 2.800e03),
            (datetime.datetime(2022, 3, 10, 11, 12), 12.33, 5.300e03),
            (datetime.datetime(2022, 3, 10, 11, 13), 12.33, 3.200e03),
            (datetime.datetime(2022, 3, 10, 11, 14), 12.33, 2.200e03),
            (datetime.datetime(2022, 3, 10, 11, 15), 12.33, 1.800e03),
            (datetime.datetime(2022, 3, 10, 11, 16), 12.33, 1.270e04),
            (datetime.datetime(2022, 3, 10, 11, 17), 12.33, 4.900e03),
            (datetime.datetime(2022, 3, 10, 11, 18), 12.33, 2.900e03),
            (datetime.datetime(2022, 3, 10, 11, 19), 12.33, 5.300e03),
            (datetime.datetime(2022, 3, 10, 11, 20), 12.33, 1.580e04),
            (datetime.datetime(2022, 3, 10, 11, 21), 12.33, 6.400e03),
            (datetime.datetime(2022, 3, 10, 11, 22), 12.33, 6.600e03),
            (datetime.datetime(2022, 3, 10, 11, 23), 12.33, 9.000e02),
            (datetime.datetime(2022, 3, 10, 11, 24), 12.33, 7.600e03),
            (datetime.datetime(2022, 3, 10, 11, 25), 12.33, 7.500e03),
            (datetime.datetime(2022, 3, 10, 11, 26), 12.33, 1.280e04),
            (datetime.datetime(2022, 3, 10, 11, 27), 12.33, 7.100e03),
            (datetime.datetime(2022, 3, 10, 11, 28), 12.33, 5.600e03),
            (datetime.datetime(2022, 3, 10, 11, 29), 12.33, 6.200e03),
            (datetime.datetime(2022, 3, 10, 11, 30), 12.33, 1.140e04),
            (datetime.datetime(2022, 3, 10, 13, 1), 12.33, 7.770e04),
            (datetime.datetime(2022, 3, 10, 13, 2), 12.33, 8.200e03),
            (datetime.datetime(2022, 3, 10, 13, 3), 12.33, 5.000e02),
            (datetime.datetime(2022, 3, 10, 13, 4), 12.33, 5.500e03),
            (datetime.datetime(2022, 3, 10, 13, 5), 12.33, 1.129e05),
            (datetime.datetime(2022, 3, 10, 13, 6), 12.33, 5.390e04),
            (datetime.datetime(2022, 3, 10, 13, 7), 12.33, 1.152e05),
            (datetime.datetime(2022, 3, 10, 13, 8), 12.33, 1.160e04),
            (datetime.datetime(2022, 3, 10, 13, 9), 12.33, 2.800e03),
            (datetime.datetime(2022, 3, 10, 13, 10), 12.33, 1.150e04),
            (datetime.datetime(2022, 3, 10, 13, 11), 12.33, 2.610e04),
            (datetime.datetime(2022, 3, 10, 13, 12), 12.33, 5.600e03),
            (datetime.datetime(2022, 3, 10, 13, 13), 12.33, 1.150e04),
            (datetime.datetime(2022, 3, 10, 13, 14), 12.33, 1.000e04),
            (datetime.datetime(2022, 3, 10, 13, 15), 12.33, 5.100e03),
            (datetime.datetime(2022, 3, 10, 13, 16), 12.33, 3.800e03),
            (datetime.datetime(2022, 3, 10, 13, 17), 12.33, 4.100e03),
            (datetime.datetime(2022, 3, 10, 13, 18), 12.33, 9.000e02),
            (datetime.datetime(2022, 3, 10, 13, 19), 12.33, 5.900e03),
            (datetime.datetime(2022, 3, 10, 13, 20), 12.33, 1.000e03),
            (datetime.datetime(2022, 3, 10, 13, 21), 12.33, 1.000e04),
            (datetime.datetime(2022, 3, 10, 13, 22), 12.33, 4.300e03),
            (datetime.datetime(2022, 3, 10, 13, 23), 12.33, 1.500e03),
            (datetime.datetime(2022, 3, 10, 13, 24), 12.33, 3.100e03),
            (datetime.datetime(2022, 3, 10, 13, 25), 12.33, 1.300e03),
            (datetime.datetime(2022, 3, 10, 13, 26), 12.33, 4.100e03),
            (datetime.datetime(2022, 3, 10, 13, 27), 12.33, 1.300e03),
            (datetime.datetime(2022, 3, 10, 13, 28), 12.33, 3.000e03),
            (datetime.datetime(2022, 3, 10, 13, 29), 12.33, 1.000e03),
            (datetime.datetime(2022, 3, 10, 13, 30), 12.33, 8.700e03),
            (datetime.datetime(2022, 3, 10, 13, 31), 12.33, 2.100e03),
            (datetime.datetime(2022, 3, 10, 13, 32), 12.33, 6.000e02),
            (datetime.datetime(2022, 3, 10, 13, 33), 12.33, 2.200e03),
            (datetime.datetime(2022, 3, 10, 13, 34), 12.33, 8.000e02),
            (datetime.datetime(2022, 3, 10, 13, 35), 12.33, 3.400e03),
            (datetime.datetime(2022, 3, 10, 13, 36), 12.33, 3.100e03),
            (datetime.datetime(2022, 3, 10, 13, 37), 12.33, 2.300e03),
            (datetime.datetime(2022, 3, 10, 13, 38), 12.33, 1.200e03),
            (datetime.datetime(2022, 3, 10, 13, 39), 12.33, 8.200e03),
            (datetime.datetime(2022, 3, 10, 13, 40), 12.33, 1.100e03),
            (datetime.datetime(2022, 3, 10, 13, 41), 12.33, 2.000e03),
            (datetime.datetime(2022, 3, 10, 13, 42), 12.33, 1.700e03),
            (datetime.datetime(2022, 3, 10, 13, 43), 12.33, 3.500e03),
            (datetime.datetime(2022, 3, 10, 13, 44), 12.33, 8.000e02),
            (datetime.datetime(2022, 3, 10, 13, 45), 12.33, 1.500e03),
            (datetime.datetime(2022, 3, 10, 13, 46), 12.33, 2.000e02),
            (datetime.datetime(2022, 3, 10, 13, 47), 12.33, 2.500e03),
            (datetime.datetime(2022, 3, 10, 13, 48), 12.33, 8.000e02),
            (datetime.datetime(2022, 3, 10, 13, 49), 12.33, 5.500e03),
            (datetime.datetime(2022, 3, 10, 13, 50), 12.33, 2.800e03),
            (datetime.datetime(2022, 3, 10, 13, 51), 12.33, 4.500e03),
            (datetime.datetime(2022, 3, 10, 13, 52), 12.33, 8.200e03),
            (datetime.datetime(2022, 3, 10, 13, 53), 12.33, 2.060e04),
            (datetime.datetime(2022, 3, 10, 13, 54), 12.33, 1.700e03),
            (datetime.datetime(2022, 3, 10, 13, 55), 12.33, 1.300e03),
            (datetime.datetime(2022, 3, 10, 13, 56), 12.33, 2.700e03),
            (datetime.datetime(2022, 3, 10, 13, 57), 12.33, 2.400e03),
            (datetime.datetime(2022, 3, 10, 13, 58), 12.33, 6.200e03),
            (datetime.datetime(2022, 3, 10, 13, 59), 12.33, 8.000e02),
            (datetime.datetime(2022, 3, 10, 14, 0), 12.33, 2.300e03),
            (datetime.datetime(2022, 3, 10, 14, 1), 12.33, 1.030e04),
            (datetime.datetime(2022, 3, 10, 14, 2), 12.33, 5.100e03),
            (datetime.datetime(2022, 3, 10, 14, 3), 12.33, 6.500e03),
            (datetime.datetime(2022, 3, 10, 14, 4), 12.33, 1.000e03),
            (datetime.datetime(2022, 3, 10, 14, 5), 12.33, 1.300e03),
            (datetime.datetime(2022, 3, 10, 14, 6), 12.33, 2.500e03),
            (datetime.datetime(2022, 3, 10, 14, 7), 12.33, 8.000e02),
            (datetime.datetime(2022, 3, 10, 14, 8), 12.33, 2.800e03),
            (datetime.datetime(2022, 3, 10, 14, 9), 12.33, 5.000e03),
            (datetime.datetime(2022, 3, 10, 14, 10), 12.33, 2.700e03),
            (datetime.datetime(2022, 3, 10, 14, 11), 12.33, 1.700e03),
            (datetime.datetime(2022, 3, 10, 14, 12), 12.33, 2.800e03),
            (datetime.datetime(2022, 3, 10, 14, 13), 12.33, 2.200e03),
            (datetime.datetime(2022, 3, 10, 14, 14), 12.33, 4.100e03),
            (datetime.datetime(2022, 3, 10, 14, 15), 12.33, 6.200e03),
            (datetime.datetime(2022, 3, 10, 14, 16), 12.33, 1.100e03),
            (datetime.datetime(2022, 3, 10, 14, 17), 12.33, 2.000e03),
            (datetime.datetime(2022, 3, 10, 14, 18), 12.33, 5.200e03),
            (datetime.datetime(2022, 3, 10, 14, 19), 12.33, 8.300e03),
            (datetime.datetime(2022, 3, 10, 14, 20), 12.33, 1.200e03),
            (datetime.datetime(2022, 3, 10, 14, 21), 12.33, 2.900e03),
            (datetime.datetime(2022, 3, 10, 14, 22), 12.33, 4.800e03),
            (datetime.datetime(2022, 3, 10, 14, 23), 12.33, 2.700e03),
            (datetime.datetime(2022, 3, 10, 14, 24), 12.33, 4.500e03),
            (datetime.datetime(2022, 3, 10, 14, 25), 12.33, 3.200e03),
            (datetime.datetime(2022, 3, 10, 14, 26), 12.33, 3.500e03),
            (datetime.datetime(2022, 3, 10, 14, 27), 12.33, 3.100e03),
            (datetime.datetime(2022, 3, 10, 14, 28), 12.33, 4.200e03),
            (datetime.datetime(2022, 3, 10, 14, 29), 12.33, 2.000e03),
            (datetime.datetime(2022, 3, 10, 14, 30), 12.33, 1.200e03),
            (datetime.datetime(2022, 3, 10, 14, 31), 12.33, 2.000e03),
            (datetime.datetime(2022, 3, 10, 14, 32), 12.33, 1.900e03),
            (datetime.datetime(2022, 3, 10, 14, 33), 12.33, 5.300e03),
            (datetime.datetime(2022, 3, 10, 14, 34), 12.33, 2.100e03),
            (datetime.datetime(2022, 3, 10, 14, 35), 12.33, 6.400e03),
            (datetime.datetime(2022, 3, 10, 14, 36), 12.33, 7.200e03),
            (datetime.datetime(2022, 3, 10, 14, 37), 12.33, 1.400e03),
            (datetime.datetime(2022, 3, 10, 14, 38), 12.33, 2.700e03),
            (datetime.datetime(2022, 3, 10, 14, 39), 12.33, 4.700e03),
            (datetime.datetime(2022, 3, 10, 14, 40), 12.33, 9.700e03),
            (datetime.datetime(2022, 3, 10, 14, 41), 12.33, 1.130e04),
            (datetime.datetime(2022, 3, 10, 14, 42), 12.33, 7.000e03),
            (datetime.datetime(2022, 3, 10, 14, 43), 12.33, 5.200e03),
            (datetime.datetime(2022, 3, 10, 14, 44), 12.33, 2.600e03),
            (datetime.datetime(2022, 3, 10, 14, 45), 12.33, 8.700e03),
            (datetime.datetime(2022, 3, 10, 14, 46), 12.33, 4.000e03),
            (datetime.datetime(2022, 3, 10, 14, 47), 12.33, 7.400e03),
            (datetime.datetime(2022, 3, 10, 14, 48), 12.33, 1.600e03),
            (datetime.datetime(2022, 3, 10, 14, 49), 12.33, 3.300e03),
            (datetime.datetime(2022, 3, 10, 14, 50), 12.33, 7.400e03),
            (datetime.datetime(2022, 3, 10, 14, 51), 12.33, 3.900e03),
            (datetime.datetime(2022, 3, 10, 14, 52), 12.33, 6.200e03),
            (datetime.datetime(2022, 3, 10, 14, 53), 12.33, 3.200e04),
            (datetime.datetime(2022, 3, 10, 14, 54), 12.33, 2.510e04),
            (datetime.datetime(2022, 3, 10, 14, 55), 12.33, 1.120e04),
            (datetime.datetime(2022, 3, 10, 14, 56), 12.33, 1.840e04),
            (datetime.datetime(2022, 3, 10, 14, 57), 12.33, 1.010e04),
            (datetime.datetime(2022, 3, 10, 14, 58), 12.33, 0.000e00),
            (datetime.datetime(2022, 3, 10, 14, 59), 12.33, 0.000e00),
            (datetime.datetime(2022, 3, 10, 15, 0), 12.33, 6.590e04),
        ],
        dtype=[("frame", "O"), ("close", "<f8"), ("volume", "<f8")],
    ),
}

if __name__ == "__main__":
    import pickle

    with open("/apps/backtest/tests/data/bars_match.pkl", "wb") as f:
        pickle.dump(bars_match, f)

    with open("/apps/backtest/tests/data/price_limits.pkl", "wb") as f:
        pickle.dump(limits, f)
