"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Generated by https://github.com/foxglove/schemas"""
import builtins
import collections.abc
from . import Color_pb2 as foxglove_Color_pb2
from . import Point3_pb2 as foxglove_Point3_pb2
from . import Pose_pb2 as foxglove_Pose_pb2
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class LinePrimitive(google.protobuf.message.Message):
    """A primitive representing a series of points connected by lines"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Type:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _TypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[LinePrimitive._Type.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        LINE_STRIP: LinePrimitive._Type.ValueType  # 0
        """0-1, 1-2, ..., (n-1)-n"""
        LINE_LOOP: LinePrimitive._Type.ValueType  # 1
        """0-1, 1-2, ..., (n-1)-n, n-0"""
        LINE_LIST: LinePrimitive._Type.ValueType  # 2
        """0-1, 2-3, 4-5, ..."""

    class Type(_Type, metaclass=_TypeEnumTypeWrapper):
        """An enumeration indicating how input points should be interpreted to create lines"""

    LINE_STRIP: LinePrimitive.Type.ValueType  # 0
    """0-1, 1-2, ..., (n-1)-n"""
    LINE_LOOP: LinePrimitive.Type.ValueType  # 1
    """0-1, 1-2, ..., (n-1)-n, n-0"""
    LINE_LIST: LinePrimitive.Type.ValueType  # 2
    """0-1, 2-3, 4-5, ..."""

    TYPE_FIELD_NUMBER: builtins.int
    POSE_FIELD_NUMBER: builtins.int
    THICKNESS_FIELD_NUMBER: builtins.int
    SCALE_INVARIANT_FIELD_NUMBER: builtins.int
    POINTS_FIELD_NUMBER: builtins.int
    COLOR_FIELD_NUMBER: builtins.int
    COLORS_FIELD_NUMBER: builtins.int
    INDICES_FIELD_NUMBER: builtins.int
    type: global___LinePrimitive.Type.ValueType
    """Drawing primitive to use for lines"""
    @property
    def pose(self) -> foxglove_Pose_pb2.Pose:
        """Origin of lines relative to reference frame"""
    thickness: builtins.float
    """Line thickness"""
    scale_invariant: builtins.bool
    """Indicates whether `thickness` is a fixed size in screen pixels (true), or specified in world coordinates and scales with distance from the camera (false)"""
    @property
    def points(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[foxglove_Point3_pb2.Point3]:
        """Points along the line"""
    @property
    def color(self) -> foxglove_Color_pb2.Color:
        """Solid color to use for the whole line. One of `color` or `colors` must be provided."""
    @property
    def colors(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[foxglove_Color_pb2.Color]:
        """Per-point colors (if specified, must have the same length as `points`). One of `color` or `colors` must be provided."""
    @property
    def indices(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """Indices into the `points` and `colors` attribute arrays, which can be used to avoid duplicating attribute data.

        If omitted or empty, indexing will not be used. This default behavior is equivalent to specifying [0, 1, ..., N-1] for the indices (where N is the number of `points` provided).
        """
    def __init__(
        self,
        *,
        type: global___LinePrimitive.Type.ValueType = ...,
        pose: foxglove_Pose_pb2.Pose | None = ...,
        thickness: builtins.float = ...,
        scale_invariant: builtins.bool = ...,
        points: collections.abc.Iterable[foxglove_Point3_pb2.Point3] | None = ...,
        color: foxglove_Color_pb2.Color | None = ...,
        colors: collections.abc.Iterable[foxglove_Color_pb2.Color] | None = ...,
        indices: collections.abc.Iterable[builtins.int] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["color", b"color", "pose", b"pose"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["color", b"color", "colors", b"colors", "indices", b"indices", "points", b"points", "pose", b"pose", "scale_invariant", b"scale_invariant", "thickness", b"thickness", "type", b"type"]) -> None: ...

global___LinePrimitive = LinePrimitive
