"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Generated by https://github.com/foxglove/schemas"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class CameraCalibration(google.protobuf.message.Message):
    """Camera calibration parameters"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TIMESTAMP_FIELD_NUMBER: builtins.int
    FRAME_ID_FIELD_NUMBER: builtins.int
    WIDTH_FIELD_NUMBER: builtins.int
    HEIGHT_FIELD_NUMBER: builtins.int
    DISTORTION_MODEL_FIELD_NUMBER: builtins.int
    D_FIELD_NUMBER: builtins.int
    K_FIELD_NUMBER: builtins.int
    R_FIELD_NUMBER: builtins.int
    P_FIELD_NUMBER: builtins.int
    @property
    def timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp of calibration data"""
    frame_id: builtins.str
    """Frame of reference for the camera. The origin of the frame is the optical center of the camera. +x points to the right in the image, +y points down, and +z points into the plane of the image."""
    width: builtins.int
    """Image width"""
    height: builtins.int
    """Image height"""
    distortion_model: builtins.str
    """Name of distortion model

    Supported values: `plumb_bob` and `rational_polynomial`
    """
    @property
    def D(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]:
        """Distortion parameters"""
    @property
    def K(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]:
        """Intrinsic camera matrix (3x3 row-major matrix)

        A 3x3 row-major matrix for the raw (distorted) image.

        Projects 3D points in the camera coordinate frame to 2D pixel coordinates using the focal lengths (fx, fy) and principal point (cx, cy).

        ```
            [fx  0 cx]
        K = [ 0 fy cy]
            [ 0  0  1]
        ```
        length 9
        """
    @property
    def R(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]:
        """Rectification matrix (stereo cameras only, 3x3 row-major matrix)

        A rotation matrix aligning the camera coordinate system to the ideal stereo image plane so that epipolar lines in both stereo images are parallel.
        length 9
        """
    @property
    def P(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]:
        """Projection/camera matrix (3x4 row-major matrix)

        ```
            [fx'  0  cx' Tx]
        P = [ 0  fy' cy' Ty]
            [ 0   0   1   0]
        ```

        By convention, this matrix specifies the intrinsic (camera) matrix of the processed (rectified) image. That is, the left 3x3 portion is the normal camera intrinsic matrix for the rectified image.

        It projects 3D points in the camera coordinate frame to 2D pixel coordinates using the focal lengths (fx', fy') and principal point (cx', cy') - these may differ from the values in K.

        For monocular cameras, Tx = Ty = 0. Normally, monocular cameras will also have R = the identity and P[1:3,1:3] = K.

        For a stereo pair, the fourth column [Tx Ty 0]' is related to the position of the optical center of the second camera in the first camera's frame. We assume Tz = 0 so both cameras are in the same stereo image plane. The first camera always has Tx = Ty = 0. For the right (second) camera of a horizontal stereo pair, Ty = 0 and Tx = -fx' * B, where B is the baseline between the cameras.

        Given a 3D point [X Y Z]', the projection (x, y) of the point onto the rectified image is given by:

        ```
        [u v w]' = P * [X Y Z 1]'
               x = u / w
               y = v / w
        ```

        This holds for both images of a stereo pair.
        length 12
        """
    def __init__(
        self,
        *,
        timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        frame_id: builtins.str = ...,
        width: builtins.int = ...,
        height: builtins.int = ...,
        distortion_model: builtins.str = ...,
        D: collections.abc.Iterable[builtins.float] | None = ...,
        K: collections.abc.Iterable[builtins.float] | None = ...,
        R: collections.abc.Iterable[builtins.float] | None = ...,
        P: collections.abc.Iterable[builtins.float] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["timestamp", b"timestamp"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["D", b"D", "K", b"K", "P", b"P", "R", b"R", "distortion_model", b"distortion_model", "frame_id", b"frame_id", "height", b"height", "timestamp", b"timestamp", "width", b"width"]) -> None: ...

global___CameraCalibration = CameraCalibration
