# coding: utf-8

"""
    @weka-api

    <div>The Weka system supports a RESTful API. This is useful when automating the interaction with the Weka system and when integrating it into your workflows or monitoring systems. The API is accessible at port 14000, via the /api/v2 URL, you can explore it via /api/v2/docs when accessing from the cluster (e.g. https://weka01:14000/api/v2/docs).<div style=\"margin-top: 15px;\">Note: Weka uses 64bit numbers. Please take special care when interacting with the API with different program languages (In JS for example you can use \"json-bigint\")</div></div>  # noqa: E501

    OpenAPI spec version: 3.14
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class UidNetdevsBody(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'apply_host': 'bool',
        'device': 'str',
        'gateway': 'str',
        'ips': 'list[str]',
        'ips_type': 'str',
        'name': 'str',
        'netmask': 'float'
    }

    attribute_map = {
        'apply_host': 'apply_host',
        'device': 'device',
        'gateway': 'gateway',
        'ips': 'ips',
        'ips_type': 'ips_type',
        'name': 'name',
        'netmask': 'netmask'
    }

    def __init__(self, apply_host=None, device=None, gateway=None, ips=None, ips_type=None, name=None, netmask=None):  # noqa: E501
        """UidNetdevsBody - a model defined in Swagger"""  # noqa: E501
        self._apply_host = None
        self._device = None
        self._gateway = None
        self._ips = None
        self._ips_type = None
        self._name = None
        self._netmask = None
        self.discriminator = None
        if apply_host is not None:
            self.apply_host = apply_host
        if device is not None:
            self.device = device
        if gateway is not None:
            self.gateway = gateway
        if ips is not None:
            self.ips = ips
        if ips_type is not None:
            self.ips_type = ips_type
        if name is not None:
            self.name = name
        if netmask is not None:
            self.netmask = netmask

    @property
    def apply_host(self):
        """Gets the apply_host of this UidNetdevsBody.  # noqa: E501

        Apply the host after this change  # noqa: E501

        :return: The apply_host of this UidNetdevsBody.  # noqa: E501
        :rtype: bool
        """
        return self._apply_host

    @apply_host.setter
    def apply_host(self, apply_host):
        """Sets the apply_host of this UidNetdevsBody.

        Apply the host after this change  # noqa: E501

        :param apply_host: The apply_host of this UidNetdevsBody.  # noqa: E501
        :type: bool
        """

        self._apply_host = apply_host

    @property
    def device(self):
        """Gets the device of this UidNetdevsBody.  # noqa: E501

        Network device pci-slot/mac-address/interface-name(s)  # noqa: E501

        :return: The device of this UidNetdevsBody.  # noqa: E501
        :rtype: str
        """
        return self._device

    @device.setter
    def device(self, device):
        """Sets the device of this UidNetdevsBody.

        Network device pci-slot/mac-address/interface-name(s)  # noqa: E501

        :param device: The device of this UidNetdevsBody.  # noqa: E501
        :type: str
        """

        self._device = device

    @property
    def gateway(self):
        """Gets the gateway of this UidNetdevsBody.  # noqa: E501

        Default gateway IP. In AWS this value is auto-detected, otherwise the default data networking gateway will be used  # noqa: E501

        :return: The gateway of this UidNetdevsBody.  # noqa: E501
        :rtype: str
        """
        return self._gateway

    @gateway.setter
    def gateway(self, gateway):
        """Sets the gateway of this UidNetdevsBody.

        Default gateway IP. In AWS this value is auto-detected, otherwise the default data networking gateway will be used  # noqa: E501

        :param gateway: The gateway of this UidNetdevsBody.  # noqa: E501
        :type: str
        """

        self._gateway = gateway

    @property
    def ips(self):
        """Gets the ips of this UidNetdevsBody.  # noqa: E501

        IPs to be allocated to cores using the device. If not given - IPs may be set automatically according the interface's IPs, or taken from the default networking IPs pool (format - A.B.C.D-E.F.G.H or A.B.C.D-F.G.H or A.B.C.D-G.H or A.B.C.D-H)  # noqa: E501

        :return: The ips of this UidNetdevsBody.  # noqa: E501
        :rtype: list[str]
        """
        return self._ips

    @ips.setter
    def ips(self, ips):
        """Sets the ips of this UidNetdevsBody.

        IPs to be allocated to cores using the device. If not given - IPs may be set automatically according the interface's IPs, or taken from the default networking IPs pool (format - A.B.C.D-E.F.G.H or A.B.C.D-F.G.H or A.B.C.D-G.H or A.B.C.D-H)  # noqa: E501

        :param ips: The ips of this UidNetdevsBody.  # noqa: E501
        :type: list[str]
        """

        self._ips = ips

    @property
    def ips_type(self):
        """Gets the ips_type of this UidNetdevsBody.  # noqa: E501

        POOL - IPs from the default data networking IP pool would be used, USER - configured by the user  # noqa: E501

        :return: The ips_type of this UidNetdevsBody.  # noqa: E501
        :rtype: str
        """
        return self._ips_type

    @ips_type.setter
    def ips_type(self, ips_type):
        """Sets the ips_type of this UidNetdevsBody.

        POOL - IPs from the default data networking IP pool would be used, USER - configured by the user  # noqa: E501

        :param ips_type: The ips_type of this UidNetdevsBody.  # noqa: E501
        :type: str
        """
        allowed_values = ["POOL", "USER"]  # noqa: E501
        if ips_type not in allowed_values:
            raise ValueError(
                "Invalid value for `ips_type` ({0}), must be one of {1}"  # noqa: E501
                .format(ips_type, allowed_values)
            )

        self._ips_type = ips_type

    @property
    def name(self):
        """Gets the name of this UidNetdevsBody.  # noqa: E501

        If empty, a name will be auto generated  # noqa: E501

        :return: The name of this UidNetdevsBody.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this UidNetdevsBody.

        If empty, a name will be auto generated  # noqa: E501

        :param name: The name of this UidNetdevsBody.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def netmask(self):
        """Gets the netmask of this UidNetdevsBody.  # noqa: E501

        Netmask in bits number. In AWS this value is auto-detected, otherwise the default data networking netmask will be used  # noqa: E501

        :return: The netmask of this UidNetdevsBody.  # noqa: E501
        :rtype: float
        """
        return self._netmask

    @netmask.setter
    def netmask(self, netmask):
        """Sets the netmask of this UidNetdevsBody.

        Netmask in bits number. In AWS this value is auto-detected, otherwise the default data networking netmask will be used  # noqa: E501

        :param netmask: The netmask of this UidNetdevsBody.  # noqa: E501
        :type: float
        """

        self._netmask = netmask

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(UidNetdevsBody, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UidNetdevsBody):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
