# coding: utf-8

"""
    @weka-api

    <div>The Weka system supports a RESTful API. This is useful when automating the interaction with the Weka system and when integrating it into your workflows or monitoring systems. The API is accessible at port 14000, via the /api/v2 URL, you can explore it via /api/v2/docs when accessing from the cluster (e.g. https://weka01:14000/api/v2/docs).<div style=\"margin-top: 15px;\">Note: Weka uses 64bit numbers. Please take special care when interacting with the API with different program languages (In JS for example you can use \"json-bigint\")</div></div>  # noqa: E501

    OpenAPI spec version: 3.14
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class SmbSharesBody(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'acl': 'bool',
        'additional_share_options': 'list[str]',
        'description': 'str',
        'directory_create_mask': 'str',
        'encryption': 'str',
        'file_create_mask': 'str',
        'fs_name': 'str',
        'mount_options': 'str',
        'obs_direct': 'bool',
        'read_only': 'bool',
        'share_name': 'str',
        'sub_path': 'str',
        'user_list_type': 'str',
        'users': 'list[str]'
    }

    attribute_map = {
        'acl': 'acl',
        'additional_share_options': 'additional_share_options',
        'description': 'description',
        'directory_create_mask': 'directory_create_mask',
        'encryption': 'encryption',
        'file_create_mask': 'file_create_mask',
        'fs_name': 'fs_name',
        'mount_options': 'mount_options',
        'obs_direct': 'obs_direct',
        'read_only': 'read_only',
        'share_name': 'share_name',
        'sub_path': 'sub_path',
        'user_list_type': 'user_list_type',
        'users': 'users'
    }

    def __init__(self, acl=None, additional_share_options=None, description=None, directory_create_mask=None, encryption=None, file_create_mask=None, fs_name=None, mount_options=None, obs_direct=None, read_only=None, share_name=None, sub_path=None, user_list_type=None, users=None):  # noqa: E501
        """SmbSharesBody - a model defined in Swagger"""  # noqa: E501
        self._acl = None
        self._additional_share_options = None
        self._description = None
        self._directory_create_mask = None
        self._encryption = None
        self._file_create_mask = None
        self._fs_name = None
        self._mount_options = None
        self._obs_direct = None
        self._read_only = None
        self._share_name = None
        self._sub_path = None
        self._user_list_type = None
        self._users = None
        self.discriminator = None
        if acl is not None:
            self.acl = acl
        if additional_share_options is not None:
            self.additional_share_options = additional_share_options
        if description is not None:
            self.description = description
        if directory_create_mask is not None:
            self.directory_create_mask = directory_create_mask
        if encryption is not None:
            self.encryption = encryption
        if file_create_mask is not None:
            self.file_create_mask = file_create_mask
        self.fs_name = fs_name
        if mount_options is not None:
            self.mount_options = mount_options
        if obs_direct is not None:
            self.obs_direct = obs_direct
        if read_only is not None:
            self.read_only = read_only
        self.share_name = share_name
        if sub_path is not None:
            self.sub_path = sub_path
        if user_list_type is not None:
            self.user_list_type = user_list_type
        if users is not None:
            self.users = users

    @property
    def acl(self):
        """Gets the acl of this SmbSharesBody.  # noqa: E501

        Enable Windows ACLs on the share. Will also be translated (as possible) to POSIX ACL  # noqa: E501

        :return: The acl of this SmbSharesBody.  # noqa: E501
        :rtype: bool
        """
        return self._acl

    @acl.setter
    def acl(self, acl):
        """Sets the acl of this SmbSharesBody.

        Enable Windows ACLs on the share. Will also be translated (as possible) to POSIX ACL  # noqa: E501

        :param acl: The acl of this SmbSharesBody.  # noqa: E501
        :type: bool
        """

        self._acl = acl

    @property
    def additional_share_options(self):
        """Gets the additional_share_options of this SmbSharesBody.  # noqa: E501


        :return: The additional_share_options of this SmbSharesBody.  # noqa: E501
        :rtype: list[str]
        """
        return self._additional_share_options

    @additional_share_options.setter
    def additional_share_options(self, additional_share_options):
        """Sets the additional_share_options of this SmbSharesBody.


        :param additional_share_options: The additional_share_options of this SmbSharesBody.  # noqa: E501
        :type: list[str]
        """

        self._additional_share_options = additional_share_options

    @property
    def description(self):
        """Gets the description of this SmbSharesBody.  # noqa: E501

        A description for samba to show regarding the share  # noqa: E501

        :return: The description of this SmbSharesBody.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this SmbSharesBody.

        A description for samba to show regarding the share  # noqa: E501

        :param description: The description of this SmbSharesBody.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def directory_create_mask(self):
        """Gets the directory_create_mask of this SmbSharesBody.  # noqa: E501

        POSIX mode mask directories will be created with. E.g. \"0755\"  # noqa: E501

        :return: The directory_create_mask of this SmbSharesBody.  # noqa: E501
        :rtype: str
        """
        return self._directory_create_mask

    @directory_create_mask.setter
    def directory_create_mask(self, directory_create_mask):
        """Sets the directory_create_mask of this SmbSharesBody.

        POSIX mode mask directories will be created with. E.g. \"0755\"  # noqa: E501

        :param directory_create_mask: The directory_create_mask of this SmbSharesBody.  # noqa: E501
        :type: str
        """

        self._directory_create_mask = directory_create_mask

    @property
    def encryption(self):
        """Gets the encryption of this SmbSharesBody.  # noqa: E501

        Samba share encryption  # noqa: E501

        :return: The encryption of this SmbSharesBody.  # noqa: E501
        :rtype: str
        """
        return self._encryption

    @encryption.setter
    def encryption(self, encryption):
        """Sets the encryption of this SmbSharesBody.

        Samba share encryption  # noqa: E501

        :param encryption: The encryption of this SmbSharesBody.  # noqa: E501
        :type: str
        """
        allowed_values = ["cluster_default", "desired", "required"]  # noqa: E501
        if encryption not in allowed_values:
            raise ValueError(
                "Invalid value for `encryption` ({0}), must be one of {1}"  # noqa: E501
                .format(encryption, allowed_values)
            )

        self._encryption = encryption

    @property
    def file_create_mask(self):
        """Gets the file_create_mask of this SmbSharesBody.  # noqa: E501

        POSIX mode mask files will be created with. E.g. \"0744\"  # noqa: E501

        :return: The file_create_mask of this SmbSharesBody.  # noqa: E501
        :rtype: str
        """
        return self._file_create_mask

    @file_create_mask.setter
    def file_create_mask(self, file_create_mask):
        """Sets the file_create_mask of this SmbSharesBody.

        POSIX mode mask files will be created with. E.g. \"0744\"  # noqa: E501

        :param file_create_mask: The file_create_mask of this SmbSharesBody.  # noqa: E501
        :type: str
        """

        self._file_create_mask = file_create_mask

    @property
    def fs_name(self):
        """Gets the fs_name of this SmbSharesBody.  # noqa: E501

        Filesystem name to share  # noqa: E501

        :return: The fs_name of this SmbSharesBody.  # noqa: E501
        :rtype: str
        """
        return self._fs_name

    @fs_name.setter
    def fs_name(self, fs_name):
        """Sets the fs_name of this SmbSharesBody.

        Filesystem name to share  # noqa: E501

        :param fs_name: The fs_name of this SmbSharesBody.  # noqa: E501
        :type: str
        """
        if fs_name is None:
            raise ValueError("Invalid value for `fs_name`, must not be `None`")  # noqa: E501

        self._fs_name = fs_name

    @property
    def mount_options(self):
        """Gets the mount_options of this SmbSharesBody.  # noqa: E501

        Option to pass to the mount command when mounting weka. NOTE - This parameter is DANGEROUS, use with caution. Incorrect usage may lead to DATA LOSS  # noqa: E501

        :return: The mount_options of this SmbSharesBody.  # noqa: E501
        :rtype: str
        """
        return self._mount_options

    @mount_options.setter
    def mount_options(self, mount_options):
        """Sets the mount_options of this SmbSharesBody.

        Option to pass to the mount command when mounting weka. NOTE - This parameter is DANGEROUS, use with caution. Incorrect usage may lead to DATA LOSS  # noqa: E501

        :param mount_options: The mount_options of this SmbSharesBody.  # noqa: E501
        :type: str
        """

        self._mount_options = mount_options

    @property
    def obs_direct(self):
        """Gets the obs_direct of this SmbSharesBody.  # noqa: E501

        Mount samba in obs-direct mode  # noqa: E501

        :return: The obs_direct of this SmbSharesBody.  # noqa: E501
        :rtype: bool
        """
        return self._obs_direct

    @obs_direct.setter
    def obs_direct(self, obs_direct):
        """Sets the obs_direct of this SmbSharesBody.

        Mount samba in obs-direct mode  # noqa: E501

        :param obs_direct: The obs_direct of this SmbSharesBody.  # noqa: E501
        :type: bool
        """

        self._obs_direct = obs_direct

    @property
    def read_only(self):
        """Gets the read_only of this SmbSharesBody.  # noqa: E501

        Mount samba as read-only  # noqa: E501

        :return: The read_only of this SmbSharesBody.  # noqa: E501
        :rtype: bool
        """
        return self._read_only

    @read_only.setter
    def read_only(self, read_only):
        """Sets the read_only of this SmbSharesBody.

        Mount samba as read-only  # noqa: E501

        :param read_only: The read_only of this SmbSharesBody.  # noqa: E501
        :type: bool
        """

        self._read_only = read_only

    @property
    def share_name(self):
        """Gets the share_name of this SmbSharesBody.  # noqa: E501

        The name of the share being added  # noqa: E501

        :return: The share_name of this SmbSharesBody.  # noqa: E501
        :rtype: str
        """
        return self._share_name

    @share_name.setter
    def share_name(self, share_name):
        """Sets the share_name of this SmbSharesBody.

        The name of the share being added  # noqa: E501

        :param share_name: The share_name of this SmbSharesBody.  # noqa: E501
        :type: str
        """
        if share_name is None:
            raise ValueError("Invalid value for `share_name`, must not be `None`")  # noqa: E501

        self._share_name = share_name

    @property
    def sub_path(self):
        """Gets the sub_path of this SmbSharesBody.  # noqa: E501

        The path inside the filesystem to share  # noqa: E501

        :return: The sub_path of this SmbSharesBody.  # noqa: E501
        :rtype: str
        """
        return self._sub_path

    @sub_path.setter
    def sub_path(self, sub_path):
        """Sets the sub_path of this SmbSharesBody.

        The path inside the filesystem to share  # noqa: E501

        :param sub_path: The sub_path of this SmbSharesBody.  # noqa: E501
        :type: str
        """

        self._sub_path = sub_path

    @property
    def user_list_type(self):
        """Gets the user_list_type of this SmbSharesBody.  # noqa: E501


        :return: The user_list_type of this SmbSharesBody.  # noqa: E501
        :rtype: str
        """
        return self._user_list_type

    @user_list_type.setter
    def user_list_type(self, user_list_type):
        """Sets the user_list_type of this SmbSharesBody.


        :param user_list_type: The user_list_type of this SmbSharesBody.  # noqa: E501
        :type: str
        """

        self._user_list_type = user_list_type

    @property
    def users(self):
        """Gets the users of this SmbSharesBody.  # noqa: E501

        The list type to which users are added to  # noqa: E501

        :return: The users of this SmbSharesBody.  # noqa: E501
        :rtype: list[str]
        """
        return self._users

    @users.setter
    def users(self, users):
        """Sets the users of this SmbSharesBody.

        The list type to which users are added to  # noqa: E501

        :param users: The users of this SmbSharesBody.  # noqa: E501
        :type: list[str]
        """

        self._users = users

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SmbSharesBody, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SmbSharesBody):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
