# coding: utf-8

"""
    @weka-api

    <div>The Weka system supports a RESTful API. This is useful when automating the interaction with the Weka system and when integrating it into your workflows or monitoring systems. The API is accessible at port 14000, via the /api/v2 URL, you can explore it via /api/v2/docs when accessing from the cluster (e.g. https://weka01:14000/api/v2/docs).<div style=\"margin-top: 15px;\">Note: Weka uses 64bit numbers. Please take special care when interacting with the API with different program languages (In JS for example you can use \"json-bigint\")</div></div>  # noqa: E501

    OpenAPI spec version: 3.12.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ObjectStoresBody(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'obs_site': 'str',
        'protocol': 'str',
        'hostname': 'str',
        'port': 'float',
        'auth_method': 'str',
        'region': 'str',
        'access_key_id': 'str',
        'secret_key': 'str',
        'bandwidth': 'float',
        'max_concurrent_downloads': 'float',
        'max_concurrent_uploads': 'float',
        'max_concurrent_removals': 'float',
        'max_extents_in_data_blob': 'float',
        'max_blocks_in_data_blob': 'float',
        'enable_upload_tags': 'bool'
    }

    attribute_map = {
        'name': 'name',
        'obs_site': 'obs_site',
        'protocol': 'protocol',
        'hostname': 'hostname',
        'port': 'port',
        'auth_method': 'auth_method',
        'region': 'region',
        'access_key_id': 'access_key_id',
        'secret_key': 'secret_key',
        'bandwidth': 'bandwidth',
        'max_concurrent_downloads': 'max_concurrent_downloads',
        'max_concurrent_uploads': 'max_concurrent_uploads',
        'max_concurrent_removals': 'max_concurrent_removals',
        'max_extents_in_data_blob': 'max_extents_in_data_blob',
        'max_blocks_in_data_blob': 'max_blocks_in_data_blob',
        'enable_upload_tags': 'enable_upload_tags'
    }

    def __init__(self, name=None, obs_site=None, protocol=None, hostname=None, port=None, auth_method=None, region=None, access_key_id=None, secret_key=None, bandwidth=None, max_concurrent_downloads=None, max_concurrent_uploads=None, max_concurrent_removals=None, max_extents_in_data_blob=None, max_blocks_in_data_blob=None, enable_upload_tags=None):  # noqa: E501
        """ObjectStoresBody - a model defined in Swagger"""  # noqa: E501
        self._name = None
        self._obs_site = None
        self._protocol = None
        self._hostname = None
        self._port = None
        self._auth_method = None
        self._region = None
        self._access_key_id = None
        self._secret_key = None
        self._bandwidth = None
        self._max_concurrent_downloads = None
        self._max_concurrent_uploads = None
        self._max_concurrent_removals = None
        self._max_extents_in_data_blob = None
        self._max_blocks_in_data_blob = None
        self._enable_upload_tags = None
        self.discriminator = None
        self.name = name
        if obs_site is not None:
            self.obs_site = obs_site
        if protocol is not None:
            self.protocol = protocol
        if hostname is not None:
            self.hostname = hostname
        if port is not None:
            self.port = port
        if auth_method is not None:
            self.auth_method = auth_method
        if region is not None:
            self.region = region
        if access_key_id is not None:
            self.access_key_id = access_key_id
        if secret_key is not None:
            self.secret_key = secret_key
        if bandwidth is not None:
            self.bandwidth = bandwidth
        if max_concurrent_downloads is not None:
            self.max_concurrent_downloads = max_concurrent_downloads
        if max_concurrent_uploads is not None:
            self.max_concurrent_uploads = max_concurrent_uploads
        if max_concurrent_removals is not None:
            self.max_concurrent_removals = max_concurrent_removals
        if max_extents_in_data_blob is not None:
            self.max_extents_in_data_blob = max_extents_in_data_blob
        if max_blocks_in_data_blob is not None:
            self.max_blocks_in_data_blob = max_blocks_in_data_blob
        if enable_upload_tags is not None:
            self.enable_upload_tags = enable_upload_tags

    @property
    def name(self):
        """Gets the name of this ObjectStoresBody.  # noqa: E501

        Name of the Object Store  # noqa: E501

        :return: The name of this ObjectStoresBody.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ObjectStoresBody.

        Name of the Object Store  # noqa: E501

        :param name: The name of this ObjectStoresBody.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def obs_site(self):
        """Gets the obs_site of this ObjectStoresBody.  # noqa: E501

        Site of the Object Store (local/remote)  # noqa: E501

        :return: The obs_site of this ObjectStoresBody.  # noqa: E501
        :rtype: str
        """
        return self._obs_site

    @obs_site.setter
    def obs_site(self, obs_site):
        """Sets the obs_site of this ObjectStoresBody.

        Site of the Object Store (local/remote)  # noqa: E501

        :param obs_site: The obs_site of this ObjectStoresBody.  # noqa: E501
        :type: str
        """

        self._obs_site = obs_site

    @property
    def protocol(self):
        """Gets the protocol of this ObjectStoresBody.  # noqa: E501

        One of - HTTP (default), HTTPS, HTTPS_UNVERIFIED  # noqa: E501

        :return: The protocol of this ObjectStoresBody.  # noqa: E501
        :rtype: str
        """
        return self._protocol

    @protocol.setter
    def protocol(self, protocol):
        """Sets the protocol of this ObjectStoresBody.

        One of - HTTP (default), HTTPS, HTTPS_UNVERIFIED  # noqa: E501

        :param protocol: The protocol of this ObjectStoresBody.  # noqa: E501
        :type: str
        """
        allowed_values = ["HTTP", "HTTPS", "HTTPS_UNVERIFIED"]  # noqa: E501
        if protocol not in allowed_values:
            raise ValueError(
                "Invalid value for `protocol` ({0}), must be one of {1}"  # noqa: E501
                .format(protocol, allowed_values)
            )

        self._protocol = protocol

    @property
    def hostname(self):
        """Gets the hostname of this ObjectStoresBody.  # noqa: E501

        Hostname (or IP) of the entrypoint to the object store  # noqa: E501

        :return: The hostname of this ObjectStoresBody.  # noqa: E501
        :rtype: str
        """
        return self._hostname

    @hostname.setter
    def hostname(self, hostname):
        """Sets the hostname of this ObjectStoresBody.

        Hostname (or IP) of the entrypoint to the object store  # noqa: E501

        :param hostname: The hostname of this ObjectStoresBody.  # noqa: E501
        :type: str
        """

        self._hostname = hostname

    @property
    def port(self):
        """Gets the port of this ObjectStoresBody.  # noqa: E501

        Port of the entrypoint to S3 (single Accesser or Load-Balancer)  # noqa: E501

        :return: The port of this ObjectStoresBody.  # noqa: E501
        :rtype: float
        """
        return self._port

    @port.setter
    def port(self, port):
        """Sets the port of this ObjectStoresBody.

        Port of the entrypoint to S3 (single Accesser or Load-Balancer)  # noqa: E501

        :param port: The port of this ObjectStoresBody.  # noqa: E501
        :type: float
        """

        self._port = port

    @property
    def auth_method(self):
        """Gets the auth_method of this ObjectStoresBody.  # noqa: E501

        Authentication method S3AuthMethod can be None, AWSSignature2 or AWSSignature4  # noqa: E501

        :return: The auth_method of this ObjectStoresBody.  # noqa: E501
        :rtype: str
        """
        return self._auth_method

    @auth_method.setter
    def auth_method(self, auth_method):
        """Sets the auth_method of this ObjectStoresBody.

        Authentication method S3AuthMethod can be None, AWSSignature2 or AWSSignature4  # noqa: E501

        :param auth_method: The auth_method of this ObjectStoresBody.  # noqa: E501
        :type: str
        """
        allowed_values = ["None", "AWSSignature2", "AWSSignature4"]  # noqa: E501
        if auth_method not in allowed_values:
            raise ValueError(
                "Invalid value for `auth_method` ({0}), must be one of {1}"  # noqa: E501
                .format(auth_method, allowed_values)
            )

        self._auth_method = auth_method

    @property
    def region(self):
        """Gets the region of this ObjectStoresBody.  # noqa: E501

        Name of the region we are assigned to work with (usually empty)  # noqa: E501

        :return: The region of this ObjectStoresBody.  # noqa: E501
        :rtype: str
        """
        return self._region

    @region.setter
    def region(self, region):
        """Sets the region of this ObjectStoresBody.

        Name of the region we are assigned to work with (usually empty)  # noqa: E501

        :param region: The region of this ObjectStoresBody.  # noqa: E501
        :type: str
        """

        self._region = region

    @property
    def access_key_id(self):
        """Gets the access_key_id of this ObjectStoresBody.  # noqa: E501

        Access Key ID for AWS Signature authentications  # noqa: E501

        :return: The access_key_id of this ObjectStoresBody.  # noqa: E501
        :rtype: str
        """
        return self._access_key_id

    @access_key_id.setter
    def access_key_id(self, access_key_id):
        """Sets the access_key_id of this ObjectStoresBody.

        Access Key ID for AWS Signature authentications  # noqa: E501

        :param access_key_id: The access_key_id of this ObjectStoresBody.  # noqa: E501
        :type: str
        """

        self._access_key_id = access_key_id

    @property
    def secret_key(self):
        """Gets the secret_key of this ObjectStoresBody.  # noqa: E501

        Secret Key for AWS Signature authentications  # noqa: E501

        :return: The secret_key of this ObjectStoresBody.  # noqa: E501
        :rtype: str
        """
        return self._secret_key

    @secret_key.setter
    def secret_key(self, secret_key):
        """Sets the secret_key of this ObjectStoresBody.

        Secret Key for AWS Signature authentications  # noqa: E501

        :param secret_key: The secret_key of this ObjectStoresBody.  # noqa: E501
        :type: str
        """

        self._secret_key = secret_key

    @property
    def bandwidth(self):
        """Gets the bandwidth of this ObjectStoresBody.  # noqa: E501

        Bandwidth limitation per core (Mbps)  # noqa: E501

        :return: The bandwidth of this ObjectStoresBody.  # noqa: E501
        :rtype: float
        """
        return self._bandwidth

    @bandwidth.setter
    def bandwidth(self, bandwidth):
        """Sets the bandwidth of this ObjectStoresBody.

        Bandwidth limitation per core (Mbps)  # noqa: E501

        :param bandwidth: The bandwidth of this ObjectStoresBody.  # noqa: E501
        :type: float
        """

        self._bandwidth = bandwidth

    @property
    def max_concurrent_downloads(self):
        """Gets the max_concurrent_downloads of this ObjectStoresBody.  # noqa: E501

        Maximum number of downloads we concurrently perform on this object store in a single IO node (format - 1..64)  # noqa: E501

        :return: The max_concurrent_downloads of this ObjectStoresBody.  # noqa: E501
        :rtype: float
        """
        return self._max_concurrent_downloads

    @max_concurrent_downloads.setter
    def max_concurrent_downloads(self, max_concurrent_downloads):
        """Sets the max_concurrent_downloads of this ObjectStoresBody.

        Maximum number of downloads we concurrently perform on this object store in a single IO node (format - 1..64)  # noqa: E501

        :param max_concurrent_downloads: The max_concurrent_downloads of this ObjectStoresBody.  # noqa: E501
        :type: float
        """

        self._max_concurrent_downloads = max_concurrent_downloads

    @property
    def max_concurrent_uploads(self):
        """Gets the max_concurrent_uploads of this ObjectStoresBody.  # noqa: E501

        Maximum number of uploads we concurrently perform on this object store in a single IO node (format - 1..64)  # noqa: E501

        :return: The max_concurrent_uploads of this ObjectStoresBody.  # noqa: E501
        :rtype: float
        """
        return self._max_concurrent_uploads

    @max_concurrent_uploads.setter
    def max_concurrent_uploads(self, max_concurrent_uploads):
        """Sets the max_concurrent_uploads of this ObjectStoresBody.

        Maximum number of uploads we concurrently perform on this object store in a single IO node (format - 1..64)  # noqa: E501

        :param max_concurrent_uploads: The max_concurrent_uploads of this ObjectStoresBody.  # noqa: E501
        :type: float
        """

        self._max_concurrent_uploads = max_concurrent_uploads

    @property
    def max_concurrent_removals(self):
        """Gets the max_concurrent_removals of this ObjectStoresBody.  # noqa: E501

        Maximum number of removals we concurrently perform on this object store in a single IO node (format -  1..64)  # noqa: E501

        :return: The max_concurrent_removals of this ObjectStoresBody.  # noqa: E501
        :rtype: float
        """
        return self._max_concurrent_removals

    @max_concurrent_removals.setter
    def max_concurrent_removals(self, max_concurrent_removals):
        """Sets the max_concurrent_removals of this ObjectStoresBody.

        Maximum number of removals we concurrently perform on this object store in a single IO node (format -  1..64)  # noqa: E501

        :param max_concurrent_removals: The max_concurrent_removals of this ObjectStoresBody.  # noqa: E501
        :type: float
        """

        self._max_concurrent_removals = max_concurrent_removals

    @property
    def max_extents_in_data_blob(self):
        """Gets the max_extents_in_data_blob of this ObjectStoresBody.  # noqa: E501

        Maximum number of extents data to upload to an object store data blob  # noqa: E501

        :return: The max_extents_in_data_blob of this ObjectStoresBody.  # noqa: E501
        :rtype: float
        """
        return self._max_extents_in_data_blob

    @max_extents_in_data_blob.setter
    def max_extents_in_data_blob(self, max_extents_in_data_blob):
        """Sets the max_extents_in_data_blob of this ObjectStoresBody.

        Maximum number of extents data to upload to an object store data blob  # noqa: E501

        :param max_extents_in_data_blob: The max_extents_in_data_blob of this ObjectStoresBody.  # noqa: E501
        :type: float
        """

        self._max_extents_in_data_blob = max_extents_in_data_blob

    @property
    def max_blocks_in_data_blob(self):
        """Gets the max_blocks_in_data_blob of this ObjectStoresBody.  # noqa: E501

        Maximum size to upload to an object store data blob (format - capacity in decimal or binary units - 11B, 1KB, 1MB, 1GB, 1TB, 1PB, 1EB, 1KiB, 1MiB, 1GiB, 1TiB, 1PiB, 1EiB)  # noqa: E501

        :return: The max_blocks_in_data_blob of this ObjectStoresBody.  # noqa: E501
        :rtype: float
        """
        return self._max_blocks_in_data_blob

    @max_blocks_in_data_blob.setter
    def max_blocks_in_data_blob(self, max_blocks_in_data_blob):
        """Sets the max_blocks_in_data_blob of this ObjectStoresBody.

        Maximum size to upload to an object store data blob (format - capacity in decimal or binary units - 11B, 1KB, 1MB, 1GB, 1TB, 1PB, 1EB, 1KiB, 1MiB, 1GiB, 1TiB, 1PiB, 1EiB)  # noqa: E501

        :param max_blocks_in_data_blob: The max_blocks_in_data_blob of this ObjectStoresBody.  # noqa: E501
        :type: float
        """

        self._max_blocks_in_data_blob = max_blocks_in_data_blob

    @property
    def enable_upload_tags(self):
        """Gets the enable_upload_tags of this ObjectStoresBody.  # noqa: E501

        Toggle tagging of uploaded objects in this Object Store  # noqa: E501

        :return: The enable_upload_tags of this ObjectStoresBody.  # noqa: E501
        :rtype: bool
        """
        return self._enable_upload_tags

    @enable_upload_tags.setter
    def enable_upload_tags(self, enable_upload_tags):
        """Sets the enable_upload_tags of this ObjectStoresBody.

        Toggle tagging of uploaded objects in this Object Store  # noqa: E501

        :param enable_upload_tags: The enable_upload_tags of this ObjectStoresBody.  # noqa: E501
        :type: bool
        """

        self._enable_upload_tags = enable_upload_tags

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ObjectStoresBody, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ObjectStoresBody):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
