# coding: utf-8

"""
    @weka-api

    <div>The Weka system supports a RESTful API. This is useful when automating the interaction with the Weka system and when integrating it into your workflows or monitoring systems. The API is accessible at port 14000, via the /api/v2 URL, you can explore it via /api/v2/docs when accessing from the cluster (e.g. https://weka01:14000/api/v2/docs).<div style=\"margin-top: 15px;\">Note: Weka uses 64bit numbers. Please take special care when interacting with the API with different program languages (In JS for example you can use \"json-bigint\")</div></div>  # noqa: E501

    OpenAPI spec version: 3.14
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class LdapBody(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'base_dn': 'str',
        'enabled': 'bool',
        'group_id_attribute': 'str',
        'group_membership_attribute': 'str',
        'group_object_class': 'str',
        'ignore_start_tls_failure': 'bool',
        'protocol_version': 'float',
        'reader_password': 'str',
        'reader_username': 'str',
        'role_groups': 'LdapRoleGroups',
        'server_timeout_secs': 'float',
        'server_uri': 'str',
        'start_tls': 'bool',
        'user_id_attribute': 'str',
        'user_object_class': 'str',
        'user_revocation_attribute': 'str'
    }

    attribute_map = {
        'base_dn': 'base_dn',
        'enabled': 'enabled',
        'group_id_attribute': 'group_id_attribute',
        'group_membership_attribute': 'group_membership_attribute',
        'group_object_class': 'group_object_class',
        'ignore_start_tls_failure': 'ignore_start_tls_failure',
        'protocol_version': 'protocol_version',
        'reader_password': 'reader_password',
        'reader_username': 'reader_username',
        'role_groups': 'role_groups',
        'server_timeout_secs': 'server_timeout_secs',
        'server_uri': 'server_uri',
        'start_tls': 'start_tls',
        'user_id_attribute': 'user_id_attribute',
        'user_object_class': 'user_object_class',
        'user_revocation_attribute': 'user_revocation_attribute'
    }

    def __init__(self, base_dn=None, enabled=None, group_id_attribute=None, group_membership_attribute=None, group_object_class=None, ignore_start_tls_failure=None, protocol_version=None, reader_password=None, reader_username=None, role_groups=None, server_timeout_secs=None, server_uri=None, start_tls=None, user_id_attribute=None, user_object_class=None, user_revocation_attribute=None):  # noqa: E501
        """LdapBody - a model defined in Swagger"""  # noqa: E501
        self._base_dn = None
        self._enabled = None
        self._group_id_attribute = None
        self._group_membership_attribute = None
        self._group_object_class = None
        self._ignore_start_tls_failure = None
        self._protocol_version = None
        self._reader_password = None
        self._reader_username = None
        self._role_groups = None
        self._server_timeout_secs = None
        self._server_uri = None
        self._start_tls = None
        self._user_id_attribute = None
        self._user_object_class = None
        self._user_revocation_attribute = None
        self.discriminator = None
        if base_dn is not None:
            self.base_dn = base_dn
        if enabled is not None:
            self.enabled = enabled
        if group_id_attribute is not None:
            self.group_id_attribute = group_id_attribute
        if group_membership_attribute is not None:
            self.group_membership_attribute = group_membership_attribute
        if group_object_class is not None:
            self.group_object_class = group_object_class
        if ignore_start_tls_failure is not None:
            self.ignore_start_tls_failure = ignore_start_tls_failure
        if protocol_version is not None:
            self.protocol_version = protocol_version
        if reader_password is not None:
            self.reader_password = reader_password
        if reader_username is not None:
            self.reader_username = reader_username
        if role_groups is not None:
            self.role_groups = role_groups
        if server_timeout_secs is not None:
            self.server_timeout_secs = server_timeout_secs
        if server_uri is not None:
            self.server_uri = server_uri
        if start_tls is not None:
            self.start_tls = start_tls
        if user_id_attribute is not None:
            self.user_id_attribute = user_id_attribute
        if user_object_class is not None:
            self.user_object_class = user_object_class
        if user_revocation_attribute is not None:
            self.user_revocation_attribute = user_revocation_attribute

    @property
    def base_dn(self):
        """Gets the base_dn of this LdapBody.  # noqa: E501

        Base DN  # noqa: E501

        :return: The base_dn of this LdapBody.  # noqa: E501
        :rtype: str
        """
        return self._base_dn

    @base_dn.setter
    def base_dn(self, base_dn):
        """Sets the base_dn of this LdapBody.

        Base DN  # noqa: E501

        :param base_dn: The base_dn of this LdapBody.  # noqa: E501
        :type: str
        """

        self._base_dn = base_dn

    @property
    def enabled(self):
        """Gets the enabled of this LdapBody.  # noqa: E501


        :return: The enabled of this LdapBody.  # noqa: E501
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """Sets the enabled of this LdapBody.


        :param enabled: The enabled of this LdapBody.  # noqa: E501
        :type: bool
        """

        self._enabled = enabled

    @property
    def group_id_attribute(self):
        """Gets the group_id_attribute of this LdapBody.  # noqa: E501

        Group ID attribute  # noqa: E501

        :return: The group_id_attribute of this LdapBody.  # noqa: E501
        :rtype: str
        """
        return self._group_id_attribute

    @group_id_attribute.setter
    def group_id_attribute(self, group_id_attribute):
        """Sets the group_id_attribute of this LdapBody.

        Group ID attribute  # noqa: E501

        :param group_id_attribute: The group_id_attribute of this LdapBody.  # noqa: E501
        :type: str
        """

        self._group_id_attribute = group_id_attribute

    @property
    def group_membership_attribute(self):
        """Gets the group_membership_attribute of this LdapBody.  # noqa: E501

        Group membership attribute  # noqa: E501

        :return: The group_membership_attribute of this LdapBody.  # noqa: E501
        :rtype: str
        """
        return self._group_membership_attribute

    @group_membership_attribute.setter
    def group_membership_attribute(self, group_membership_attribute):
        """Sets the group_membership_attribute of this LdapBody.

        Group membership attribute  # noqa: E501

        :param group_membership_attribute: The group_membership_attribute of this LdapBody.  # noqa: E501
        :type: str
        """

        self._group_membership_attribute = group_membership_attribute

    @property
    def group_object_class(self):
        """Gets the group_object_class of this LdapBody.  # noqa: E501

        Group object class  # noqa: E501

        :return: The group_object_class of this LdapBody.  # noqa: E501
        :rtype: str
        """
        return self._group_object_class

    @group_object_class.setter
    def group_object_class(self, group_object_class):
        """Sets the group_object_class of this LdapBody.

        Group object class  # noqa: E501

        :param group_object_class: The group_object_class of this LdapBody.  # noqa: E501
        :type: str
        """

        self._group_object_class = group_object_class

    @property
    def ignore_start_tls_failure(self):
        """Gets the ignore_start_tls_failure of this LdapBody.  # noqa: E501

        Ignore start TLS failure  # noqa: E501

        :return: The ignore_start_tls_failure of this LdapBody.  # noqa: E501
        :rtype: bool
        """
        return self._ignore_start_tls_failure

    @ignore_start_tls_failure.setter
    def ignore_start_tls_failure(self, ignore_start_tls_failure):
        """Sets the ignore_start_tls_failure of this LdapBody.

        Ignore start TLS failure  # noqa: E501

        :param ignore_start_tls_failure: The ignore_start_tls_failure of this LdapBody.  # noqa: E501
        :type: bool
        """

        self._ignore_start_tls_failure = ignore_start_tls_failure

    @property
    def protocol_version(self):
        """Gets the protocol_version of this LdapBody.  # noqa: E501

        LDAP protocol version  # noqa: E501

        :return: The protocol_version of this LdapBody.  # noqa: E501
        :rtype: float
        """
        return self._protocol_version

    @protocol_version.setter
    def protocol_version(self, protocol_version):
        """Sets the protocol_version of this LdapBody.

        LDAP protocol version  # noqa: E501

        :param protocol_version: The protocol_version of this LdapBody.  # noqa: E501
        :type: float
        """

        self._protocol_version = protocol_version

    @property
    def reader_password(self):
        """Gets the reader_password of this LdapBody.  # noqa: E501

        Reader password  # noqa: E501

        :return: The reader_password of this LdapBody.  # noqa: E501
        :rtype: str
        """
        return self._reader_password

    @reader_password.setter
    def reader_password(self, reader_password):
        """Sets the reader_password of this LdapBody.

        Reader password  # noqa: E501

        :param reader_password: The reader_password of this LdapBody.  # noqa: E501
        :type: str
        """

        self._reader_password = reader_password

    @property
    def reader_username(self):
        """Gets the reader_username of this LdapBody.  # noqa: E501

        Reader username  # noqa: E501

        :return: The reader_username of this LdapBody.  # noqa: E501
        :rtype: str
        """
        return self._reader_username

    @reader_username.setter
    def reader_username(self, reader_username):
        """Sets the reader_username of this LdapBody.

        Reader username  # noqa: E501

        :param reader_username: The reader_username of this LdapBody.  # noqa: E501
        :type: str
        """

        self._reader_username = reader_username

    @property
    def role_groups(self):
        """Gets the role_groups of this LdapBody.  # noqa: E501


        :return: The role_groups of this LdapBody.  # noqa: E501
        :rtype: LdapRoleGroups
        """
        return self._role_groups

    @role_groups.setter
    def role_groups(self, role_groups):
        """Sets the role_groups of this LdapBody.


        :param role_groups: The role_groups of this LdapBody.  # noqa: E501
        :type: LdapRoleGroups
        """

        self._role_groups = role_groups

    @property
    def server_timeout_secs(self):
        """Gets the server_timeout_secs of this LdapBody.  # noqa: E501

        LDAP connection timeout in seconds  # noqa: E501

        :return: The server_timeout_secs of this LdapBody.  # noqa: E501
        :rtype: float
        """
        return self._server_timeout_secs

    @server_timeout_secs.setter
    def server_timeout_secs(self, server_timeout_secs):
        """Sets the server_timeout_secs of this LdapBody.

        LDAP connection timeout in seconds  # noqa: E501

        :param server_timeout_secs: The server_timeout_secs of this LdapBody.  # noqa: E501
        :type: float
        """

        self._server_timeout_secs = server_timeout_secs

    @property
    def server_uri(self):
        """Gets the server_uri of this LdapBody.  # noqa: E501

        LDAP server URI ([ldap://]hostname[:port] or ldaps://hostname[:port])  # noqa: E501

        :return: The server_uri of this LdapBody.  # noqa: E501
        :rtype: str
        """
        return self._server_uri

    @server_uri.setter
    def server_uri(self, server_uri):
        """Sets the server_uri of this LdapBody.

        LDAP server URI ([ldap://]hostname[:port] or ldaps://hostname[:port])  # noqa: E501

        :param server_uri: The server_uri of this LdapBody.  # noqa: E501
        :type: str
        """

        self._server_uri = server_uri

    @property
    def start_tls(self):
        """Gets the start_tls of this LdapBody.  # noqa: E501

        Issue StartTLS after connecting (should not be used with ldaps://)  # noqa: E501

        :return: The start_tls of this LdapBody.  # noqa: E501
        :rtype: bool
        """
        return self._start_tls

    @start_tls.setter
    def start_tls(self, start_tls):
        """Sets the start_tls of this LdapBody.

        Issue StartTLS after connecting (should not be used with ldaps://)  # noqa: E501

        :param start_tls: The start_tls of this LdapBody.  # noqa: E501
        :type: bool
        """

        self._start_tls = start_tls

    @property
    def user_id_attribute(self):
        """Gets the user_id_attribute of this LdapBody.  # noqa: E501

        User ID attribute  # noqa: E501

        :return: The user_id_attribute of this LdapBody.  # noqa: E501
        :rtype: str
        """
        return self._user_id_attribute

    @user_id_attribute.setter
    def user_id_attribute(self, user_id_attribute):
        """Sets the user_id_attribute of this LdapBody.

        User ID attribute  # noqa: E501

        :param user_id_attribute: The user_id_attribute of this LdapBody.  # noqa: E501
        :type: str
        """

        self._user_id_attribute = user_id_attribute

    @property
    def user_object_class(self):
        """Gets the user_object_class of this LdapBody.  # noqa: E501

        User object class  # noqa: E501

        :return: The user_object_class of this LdapBody.  # noqa: E501
        :rtype: str
        """
        return self._user_object_class

    @user_object_class.setter
    def user_object_class(self, user_object_class):
        """Sets the user_object_class of this LdapBody.

        User object class  # noqa: E501

        :param user_object_class: The user_object_class of this LdapBody.  # noqa: E501
        :type: str
        """

        self._user_object_class = user_object_class

    @property
    def user_revocation_attribute(self):
        """Gets the user_revocation_attribute of this LdapBody.  # noqa: E501

        User revocation attribute - If provided, updating this attribute in the LDAP server automatically revokes all user tokens  # noqa: E501

        :return: The user_revocation_attribute of this LdapBody.  # noqa: E501
        :rtype: str
        """
        return self._user_revocation_attribute

    @user_revocation_attribute.setter
    def user_revocation_attribute(self, user_revocation_attribute):
        """Sets the user_revocation_attribute of this LdapBody.

        User revocation attribute - If provided, updating this attribute in the LDAP server automatically revokes all user tokens  # noqa: E501

        :param user_revocation_attribute: The user_revocation_attribute of this LdapBody.  # noqa: E501
        :type: str
        """

        self._user_revocation_attribute = user_revocation_attribute

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(LdapBody, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, LdapBody):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
