# coding: utf-8

"""
    @weka-api

    <div>The Weka system supports a RESTful API. This is useful when automating the interaction with the Weka system and when integrating it into your workflows or monitoring systems. The API is accessible at port 14000, via the /api/v2 URL, you can explore it via /api/v2/docs when accessing from the cluster (e.g. https://weka01:14000/api/v2/docs).<div style=\"margin-top: 15px;\">Note: Weka uses 64bit numbers. Please take special care when interacting with the API with different program languages (In JS for example you can use \"json-bigint\")</div></div>  # noqa: E501

    OpenAPI spec version: 3.14
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class InterfaceGroupsBody(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'gateway': 'str',
        'name': 'str',
        'subnet': 'str',
        'type': 'str'
    }

    attribute_map = {
        'gateway': 'gateway',
        'name': 'name',
        'subnet': 'subnet',
        'type': 'type'
    }

    def __init__(self, gateway=None, name=None, subnet=None, type=None):  # noqa: E501
        """InterfaceGroupsBody - a model defined in Swagger"""  # noqa: E501
        self._gateway = None
        self._name = None
        self._subnet = None
        self._type = None
        self.discriminator = None
        if gateway is not None:
            self.gateway = gateway
        self.name = name
        if subnet is not None:
            self.subnet = subnet
        self.type = type

    @property
    def gateway(self):
        """Gets the gateway of this InterfaceGroupsBody.  # noqa: E501

        Gateway ip  # noqa: E501

        :return: The gateway of this InterfaceGroupsBody.  # noqa: E501
        :rtype: str
        """
        return self._gateway

    @gateway.setter
    def gateway(self, gateway):
        """Sets the gateway of this InterfaceGroupsBody.

        Gateway ip  # noqa: E501

        :param gateway: The gateway of this InterfaceGroupsBody.  # noqa: E501
        :type: str
        """

        self._gateway = gateway

    @property
    def name(self):
        """Gets the name of this InterfaceGroupsBody.  # noqa: E501

        Interface group name  # noqa: E501

        :return: The name of this InterfaceGroupsBody.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this InterfaceGroupsBody.

        Interface group name  # noqa: E501

        :param name: The name of this InterfaceGroupsBody.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def subnet(self):
        """Gets the subnet of this InterfaceGroupsBody.  # noqa: E501

        Subnet mask in the 255.255.0.0 format  # noqa: E501

        :return: The subnet of this InterfaceGroupsBody.  # noqa: E501
        :rtype: str
        """
        return self._subnet

    @subnet.setter
    def subnet(self, subnet):
        """Sets the subnet of this InterfaceGroupsBody.

        Subnet mask in the 255.255.0.0 format  # noqa: E501

        :param subnet: The subnet of this InterfaceGroupsBody.  # noqa: E501
        :type: str
        """

        self._subnet = subnet

    @property
    def type(self):
        """Gets the type of this InterfaceGroupsBody.  # noqa: E501

        Group type. cli subnet type can be NFS  # noqa: E501

        :return: The type of this InterfaceGroupsBody.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this InterfaceGroupsBody.

        Group type. cli subnet type can be NFS  # noqa: E501

        :param type: The type of this InterfaceGroupsBody.  # noqa: E501
        :type: str
        """
        if type is None:
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501

        self._type = type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(InterfaceGroupsBody, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, InterfaceGroupsBody):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
