# coding: utf-8

"""
    @weka-api

    <div>The Weka system supports a RESTful API. This is useful when automating the interaction with the Weka system and when integrating it into your workflows or monitoring systems. The API is accessible at port 14000, via the /api/v2 URL, you can explore it via /api/v2/docs when accessing from the cluster (e.g. https://weka01:14000/api/v2/docs).<div style=\"margin-top: 15px;\">Note: Weka uses 64bit numbers. Please take special care when interacting with the API with different program languages (In JS for example you can use \"json-bigint\")</div></div>  # noqa: E501

    OpenAPI spec version: 3.14
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class FileSystemsDownloadBody(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'additional_object_storage': 'str',
        'auth_required': 'bool',
        'group_name': 'str',
        'locator': 'str',
        'name': 'str',
        'object_storage': 'str',
        'ssd_capacity': 'float',
        'total_capacity': 'float'
    }

    attribute_map = {
        'additional_object_storage': 'additional_object_storage',
        'auth_required': 'auth_required',
        'group_name': 'group_name',
        'locator': 'locator',
        'name': 'name',
        'object_storage': 'object_storage',
        'ssd_capacity': 'ssd_capacity',
        'total_capacity': 'total_capacity'
    }

    def __init__(self, additional_object_storage=None, auth_required=None, group_name=None, locator=None, name=None, object_storage=None, ssd_capacity=None, total_capacity=None):  # noqa: E501
        """FileSystemsDownloadBody - a model defined in Swagger"""  # noqa: E501
        self._additional_object_storage = None
        self._auth_required = None
        self._group_name = None
        self._locator = None
        self._name = None
        self._object_storage = None
        self._ssd_capacity = None
        self._total_capacity = None
        self.discriminator = None
        if additional_object_storage is not None:
            self.additional_object_storage = additional_object_storage
        if auth_required is not None:
            self.auth_required = auth_required
        self.group_name = group_name
        self.locator = locator
        self.name = name
        self.object_storage = object_storage
        self.ssd_capacity = ssd_capacity
        self.total_capacity = total_capacity

    @property
    def additional_object_storage(self):
        """Gets the additional_object_storage of this FileSystemsDownloadBody.  # noqa: E501

        Additional object Store name  # noqa: E501

        :return: The additional_object_storage of this FileSystemsDownloadBody.  # noqa: E501
        :rtype: str
        """
        return self._additional_object_storage

    @additional_object_storage.setter
    def additional_object_storage(self, additional_object_storage):
        """Sets the additional_object_storage of this FileSystemsDownloadBody.

        Additional object Store name  # noqa: E501

        :param additional_object_storage: The additional_object_storage of this FileSystemsDownloadBody.  # noqa: E501
        :type: str
        """

        self._additional_object_storage = additional_object_storage

    @property
    def auth_required(self):
        """Gets the auth_required of this FileSystemsDownloadBody.  # noqa: E501

        Require the mounting user to be authenticated for mounting this filesystem. This flag is only effective in the root organization, users in non-root organizations must be authenticated to perform a mount operation  # noqa: E501

        :return: The auth_required of this FileSystemsDownloadBody.  # noqa: E501
        :rtype: bool
        """
        return self._auth_required

    @auth_required.setter
    def auth_required(self, auth_required):
        """Sets the auth_required of this FileSystemsDownloadBody.

        Require the mounting user to be authenticated for mounting this filesystem. This flag is only effective in the root organization, users in non-root organizations must be authenticated to perform a mount operation  # noqa: E501

        :param auth_required: The auth_required of this FileSystemsDownloadBody.  # noqa: E501
        :type: bool
        """

        self._auth_required = auth_required

    @property
    def group_name(self):
        """Gets the group_name of this FileSystemsDownloadBody.  # noqa: E501

        Group name  # noqa: E501

        :return: The group_name of this FileSystemsDownloadBody.  # noqa: E501
        :rtype: str
        """
        return self._group_name

    @group_name.setter
    def group_name(self, group_name):
        """Sets the group_name of this FileSystemsDownloadBody.

        Group name  # noqa: E501

        :param group_name: The group_name of this FileSystemsDownloadBody.  # noqa: E501
        :type: str
        """
        if group_name is None:
            raise ValueError("Invalid value for `group_name`, must not be `None`")  # noqa: E501

        self._group_name = group_name

    @property
    def locator(self):
        """Gets the locator of this FileSystemsDownloadBody.  # noqa: E501

        Locator  # noqa: E501

        :return: The locator of this FileSystemsDownloadBody.  # noqa: E501
        :rtype: str
        """
        return self._locator

    @locator.setter
    def locator(self, locator):
        """Sets the locator of this FileSystemsDownloadBody.

        Locator  # noqa: E501

        :param locator: The locator of this FileSystemsDownloadBody.  # noqa: E501
        :type: str
        """
        if locator is None:
            raise ValueError("Invalid value for `locator`, must not be `None`")  # noqa: E501

        self._locator = locator

    @property
    def name(self):
        """Gets the name of this FileSystemsDownloadBody.  # noqa: E501

        New file system name  # noqa: E501

        :return: The name of this FileSystemsDownloadBody.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this FileSystemsDownloadBody.

        New file system name  # noqa: E501

        :param name: The name of this FileSystemsDownloadBody.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def object_storage(self):
        """Gets the object_storage of this FileSystemsDownloadBody.  # noqa: E501

        Object Store name  # noqa: E501

        :return: The object_storage of this FileSystemsDownloadBody.  # noqa: E501
        :rtype: str
        """
        return self._object_storage

    @object_storage.setter
    def object_storage(self, object_storage):
        """Sets the object_storage of this FileSystemsDownloadBody.

        Object Store name  # noqa: E501

        :param object_storage: The object_storage of this FileSystemsDownloadBody.  # noqa: E501
        :type: str
        """
        if object_storage is None:
            raise ValueError("Invalid value for `object_storage`, must not be `None`")  # noqa: E501

        self._object_storage = object_storage

    @property
    def ssd_capacity(self):
        """Gets the ssd_capacity of this FileSystemsDownloadBody.  # noqa: E501

        SSD capacity (format - capacity in decimal or binary units - 11B, 1KB, 1MB, 1GB, 1TB, 1PB, 1EB, 1KiB, 1MiB, 1GiB, 1TiB, 1PiB, 1EiB)  # noqa: E501

        :return: The ssd_capacity of this FileSystemsDownloadBody.  # noqa: E501
        :rtype: float
        """
        return self._ssd_capacity

    @ssd_capacity.setter
    def ssd_capacity(self, ssd_capacity):
        """Sets the ssd_capacity of this FileSystemsDownloadBody.

        SSD capacity (format - capacity in decimal or binary units - 11B, 1KB, 1MB, 1GB, 1TB, 1PB, 1EB, 1KiB, 1MiB, 1GiB, 1TiB, 1PiB, 1EiB)  # noqa: E501

        :param ssd_capacity: The ssd_capacity of this FileSystemsDownloadBody.  # noqa: E501
        :type: float
        """
        if ssd_capacity is None:
            raise ValueError("Invalid value for `ssd_capacity`, must not be `None`")  # noqa: E501

        self._ssd_capacity = ssd_capacity

    @property
    def total_capacity(self):
        """Gets the total_capacity of this FileSystemsDownloadBody.  # noqa: E501

        Total capacity (format - capacity in decimal or binary units - 11B, 1KB, 1MB, 1GB, 1TB, 1PB, 1EB, 1KiB, 1MiB, 1GiB, 1TiB, 1PiB, 1EiB)  # noqa: E501

        :return: The total_capacity of this FileSystemsDownloadBody.  # noqa: E501
        :rtype: float
        """
        return self._total_capacity

    @total_capacity.setter
    def total_capacity(self, total_capacity):
        """Sets the total_capacity of this FileSystemsDownloadBody.

        Total capacity (format - capacity in decimal or binary units - 11B, 1KB, 1MB, 1GB, 1TB, 1PB, 1EB, 1KiB, 1MiB, 1GiB, 1TiB, 1PiB, 1EiB)  # noqa: E501

        :param total_capacity: The total_capacity of this FileSystemsDownloadBody.  # noqa: E501
        :type: float
        """
        if total_capacity is None:
            raise ValueError("Invalid value for `total_capacity`, must not be `None`")  # noqa: E501

        self._total_capacity = total_capacity

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(FileSystemsDownloadBody, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FileSystemsDownloadBody):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
