# coding: utf-8

"""
    @weka-api

    <div>The Weka system supports a RESTful API. This is useful when automating the interaction with the Weka system and when integrating it into your workflows or monitoring systems. The API is accessible at port 14000, via the /api/v2 URL, you can explore it via /api/v2/docs when accessing from the cluster (e.g. https://weka01:14000/api/v2/docs).<div style=\"margin-top: 15px;\">Note: Weka uses 64bit numbers. Please take special care when interacting with the API with different program languages (In JS for example you can use \"json-bigint\")</div></div>  # noqa: E501

    OpenAPI spec version: 3.14
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ClusterBody1(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'admin_password': 'str',
        'hosts_hostnames': 'list[str]',
        'hosts_ips': 'list[str]',
        'join_secrets': 'list[str]'
    }

    attribute_map = {
        'admin_password': 'admin_password',
        'hosts_hostnames': 'hosts_hostnames',
        'hosts_ips': 'hosts_ips',
        'join_secrets': 'join_secrets'
    }

    def __init__(self, admin_password=None, hosts_hostnames=None, hosts_ips=None, join_secrets=None):  # noqa: E501
        """ClusterBody1 - a model defined in Swagger"""  # noqa: E501
        self._admin_password = None
        self._hosts_hostnames = None
        self._hosts_ips = None
        self._join_secrets = None
        self.discriminator = None
        if admin_password is not None:
            self.admin_password = admin_password
        if hosts_hostnames is not None:
            self.hosts_hostnames = hosts_hostnames
        if hosts_ips is not None:
            self.hosts_ips = hosts_ips
        if join_secrets is not None:
            self.join_secrets = join_secrets

    @property
    def admin_password(self):
        """Gets the admin_password of this ClusterBody1.  # noqa: E501

        The password for the cluster admin user; will be set to the default password if not provided  # noqa: E501

        :return: The admin_password of this ClusterBody1.  # noqa: E501
        :rtype: str
        """
        return self._admin_password

    @admin_password.setter
    def admin_password(self, admin_password):
        """Sets the admin_password of this ClusterBody1.

        The password for the cluster admin user; will be set to the default password if not provided  # noqa: E501

        :param admin_password: The admin_password of this ClusterBody1.  # noqa: E501
        :type: str
        """

        self._admin_password = admin_password

    @property
    def hosts_hostnames(self):
        """Gets the hosts_hostnames of this ClusterBody1.  # noqa: E501

        A list of hostname to be included in the new cluster  # noqa: E501

        :return: The hosts_hostnames of this ClusterBody1.  # noqa: E501
        :rtype: list[str]
        """
        return self._hosts_hostnames

    @hosts_hostnames.setter
    def hosts_hostnames(self, hosts_hostnames):
        """Sets the hosts_hostnames of this ClusterBody1.

        A list of hostname to be included in the new cluster  # noqa: E501

        :param hosts_hostnames: The hosts_hostnames of this ClusterBody1.  # noqa: E501
        :type: list[str]
        """

        self._hosts_hostnames = hosts_hostnames

    @property
    def hosts_ips(self):
        """Gets the hosts_ips of this ClusterBody1.  # noqa: E501

        Management IP addresses; If empty, the hostnames will be resolved; If hosts are highly-available or mixed-networking, use IP set '<ip>+<ip>+...+<ip>';  # noqa: E501

        :return: The hosts_ips of this ClusterBody1.  # noqa: E501
        :rtype: list[str]
        """
        return self._hosts_ips

    @hosts_ips.setter
    def hosts_ips(self, hosts_ips):
        """Sets the hosts_ips of this ClusterBody1.

        Management IP addresses; If empty, the hostnames will be resolved; If hosts are highly-available or mixed-networking, use IP set '<ip>+<ip>+...+<ip>';  # noqa: E501

        :param hosts_ips: The hosts_ips of this ClusterBody1.  # noqa: E501
        :type: list[str]
        """

        self._hosts_ips = hosts_ips

    @property
    def join_secrets(self):
        """Gets the join_secrets of this ClusterBody1.  # noqa: E501

        List of cluster's join secrets, used to prevent unauthorized hosts from joining the cluster  # noqa: E501

        :return: The join_secrets of this ClusterBody1.  # noqa: E501
        :rtype: list[str]
        """
        return self._join_secrets

    @join_secrets.setter
    def join_secrets(self, join_secrets):
        """Sets the join_secrets of this ClusterBody1.

        List of cluster's join secrets, used to prevent unauthorized hosts from joining the cluster  # noqa: E501

        :param join_secrets: The join_secrets of this ClusterBody1.  # noqa: E501
        :type: list[str]
        """

        self._join_secrets = join_secrets

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ClusterBody1, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ClusterBody1):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
