# coding: utf-8

"""
    @weka-api

    <div>The Weka system supports a RESTful API. This is useful when automating the interaction with the Weka system and when integrating it into your workflows or monitoring systems. The API is accessible at port 14000, via the /api/v2 URL, you can explore it via /api/v2/docs when accessing from the cluster (e.g. https://weka01:14000/api/v2/docs).<div style=\"margin-top: 15px;\">Note: Weka uses 64bit numbers. Please take special care when interacting with the API with different program languages (In JS for example you can use \"json-bigint\")</div></div>  # noqa: E501

    OpenAPI spec version: 3.14
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ClusterBody(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'cluster_name': 'str',
        'data_drives': 'float',
        'hotspare_failure_domains': 'float',
        'parity_drives': 'float',
        'scrubber_bytes_per_sec': 'float'
    }

    attribute_map = {
        'cluster_name': 'cluster_name',
        'data_drives': 'data_drives',
        'hotspare_failure_domains': 'hotspare_failure_domains',
        'parity_drives': 'parity_drives',
        'scrubber_bytes_per_sec': 'scrubber_bytes_per_sec'
    }

    def __init__(self, cluster_name=None, data_drives=None, hotspare_failure_domains=None, parity_drives=None, scrubber_bytes_per_sec=None):  # noqa: E501
        """ClusterBody - a model defined in Swagger"""  # noqa: E501
        self._cluster_name = None
        self._data_drives = None
        self._hotspare_failure_domains = None
        self._parity_drives = None
        self._scrubber_bytes_per_sec = None
        self.discriminator = None
        if cluster_name is not None:
            self.cluster_name = cluster_name
        if data_drives is not None:
            self.data_drives = data_drives
        if hotspare_failure_domains is not None:
            self.hotspare_failure_domains = hotspare_failure_domains
        if parity_drives is not None:
            self.parity_drives = parity_drives
        if scrubber_bytes_per_sec is not None:
            self.scrubber_bytes_per_sec = scrubber_bytes_per_sec

    @property
    def cluster_name(self):
        """Gets the cluster_name of this ClusterBody.  # noqa: E501

        Cluster name  # noqa: E501

        :return: The cluster_name of this ClusterBody.  # noqa: E501
        :rtype: str
        """
        return self._cluster_name

    @cluster_name.setter
    def cluster_name(self, cluster_name):
        """Sets the cluster_name of this ClusterBody.

        Cluster name  # noqa: E501

        :param cluster_name: The cluster_name of this ClusterBody.  # noqa: E501
        :type: str
        """

        self._cluster_name = cluster_name

    @property
    def data_drives(self):
        """Gets the data_drives of this ClusterBody.  # noqa: E501

        Number of RAID data drives  # noqa: E501

        :return: The data_drives of this ClusterBody.  # noqa: E501
        :rtype: float
        """
        return self._data_drives

    @data_drives.setter
    def data_drives(self, data_drives):
        """Sets the data_drives of this ClusterBody.

        Number of RAID data drives  # noqa: E501

        :param data_drives: The data_drives of this ClusterBody.  # noqa: E501
        :type: float
        """

        self._data_drives = data_drives

    @property
    def hotspare_failure_domains(self):
        """Gets the hotspare_failure_domains of this ClusterBody.  # noqa: E501


        :return: The hotspare_failure_domains of this ClusterBody.  # noqa: E501
        :rtype: float
        """
        return self._hotspare_failure_domains

    @hotspare_failure_domains.setter
    def hotspare_failure_domains(self, hotspare_failure_domains):
        """Sets the hotspare_failure_domains of this ClusterBody.


        :param hotspare_failure_domains: The hotspare_failure_domains of this ClusterBody.  # noqa: E501
        :type: float
        """

        self._hotspare_failure_domains = hotspare_failure_domains

    @property
    def parity_drives(self):
        """Gets the parity_drives of this ClusterBody.  # noqa: E501

        Number of RAID protection parity drives  # noqa: E501

        :return: The parity_drives of this ClusterBody.  # noqa: E501
        :rtype: float
        """
        return self._parity_drives

    @parity_drives.setter
    def parity_drives(self, parity_drives):
        """Sets the parity_drives of this ClusterBody.

        Number of RAID protection parity drives  # noqa: E501

        :param parity_drives: The parity_drives of this ClusterBody.  # noqa: E501
        :type: float
        """

        self._parity_drives = parity_drives

    @property
    def scrubber_bytes_per_sec(self):
        """Gets the scrubber_bytes_per_sec of this ClusterBody.  # noqa: E501

        Rate of RAID scrubbing in units per second (format - capacity in decimal or binary units - 11B, 1KB, 1MB, 1GB, 1TB, 1PB, 1EB, 1KiB, 1MiB, 1GiB, 1TiB, 1PiB, 1EiB)  # noqa: E501

        :return: The scrubber_bytes_per_sec of this ClusterBody.  # noqa: E501
        :rtype: float
        """
        return self._scrubber_bytes_per_sec

    @scrubber_bytes_per_sec.setter
    def scrubber_bytes_per_sec(self, scrubber_bytes_per_sec):
        """Sets the scrubber_bytes_per_sec of this ClusterBody.

        Rate of RAID scrubbing in units per second (format - capacity in decimal or binary units - 11B, 1KB, 1MB, 1GB, 1TB, 1PB, 1EB, 1KiB, 1MiB, 1GiB, 1TiB, 1PiB, 1EiB)  # noqa: E501

        :param scrubber_bytes_per_sec: The scrubber_bytes_per_sec of this ClusterBody.  # noqa: E501
        :type: float
        """

        self._scrubber_bytes_per_sec = scrubber_bytes_per_sec

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ClusterBody, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ClusterBody):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
