# coding: utf-8

"""
    @weka-api

    <div>The Weka system supports a RESTful API. This is useful when automating the interaction with the Weka system and when integrating it into your workflows or monitoring systems. The API is accessible at port 14000, via the /api/v2 URL, you can explore it via /api/v2/docs when accessing from the cluster (e.g. https://weka01:14000/api/v2/docs).<div style=\"margin-top: 15px;\">Note: Weka uses 64bit numbers. Please take special care when interacting with the API with different program languages (In JS for example you can use \"json-bigint\")</div></div>  # noqa: E501

    OpenAPI spec version: 3.14
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ActiveDirectoryBody(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'domain': 'str',
        'enabled': 'bool',
        'ignore_start_tls_failure': 'bool',
        'reader_password': 'str',
        'reader_username': 'str',
        'role_groups': 'object',
        'server_timeout_secs': 'float',
        'server_uri': 'str',
        'start_tls': 'bool'
    }

    attribute_map = {
        'domain': 'domain',
        'enabled': 'enabled',
        'ignore_start_tls_failure': 'ignore_start_tls_failure',
        'reader_password': 'reader_password',
        'reader_username': 'reader_username',
        'role_groups': 'role_groups',
        'server_timeout_secs': 'server_timeout_secs',
        'server_uri': 'server_uri',
        'start_tls': 'start_tls'
    }

    def __init__(self, domain=None, enabled=None, ignore_start_tls_failure=None, reader_password=None, reader_username=None, role_groups=None, server_timeout_secs=None, server_uri=None, start_tls=None):  # noqa: E501
        """ActiveDirectoryBody - a model defined in Swagger"""  # noqa: E501
        self._domain = None
        self._enabled = None
        self._ignore_start_tls_failure = None
        self._reader_password = None
        self._reader_username = None
        self._role_groups = None
        self._server_timeout_secs = None
        self._server_uri = None
        self._start_tls = None
        self.discriminator = None
        if domain is not None:
            self.domain = domain
        if enabled is not None:
            self.enabled = enabled
        if ignore_start_tls_failure is not None:
            self.ignore_start_tls_failure = ignore_start_tls_failure
        if reader_password is not None:
            self.reader_password = reader_password
        if reader_username is not None:
            self.reader_username = reader_username
        if role_groups is not None:
            self.role_groups = role_groups
        if server_timeout_secs is not None:
            self.server_timeout_secs = server_timeout_secs
        if server_uri is not None:
            self.server_uri = server_uri
        if start_tls is not None:
            self.start_tls = start_tls

    @property
    def domain(self):
        """Gets the domain of this ActiveDirectoryBody.  # noqa: E501

        Domain  # noqa: E501

        :return: The domain of this ActiveDirectoryBody.  # noqa: E501
        :rtype: str
        """
        return self._domain

    @domain.setter
    def domain(self, domain):
        """Sets the domain of this ActiveDirectoryBody.

        Domain  # noqa: E501

        :param domain: The domain of this ActiveDirectoryBody.  # noqa: E501
        :type: str
        """

        self._domain = domain

    @property
    def enabled(self):
        """Gets the enabled of this ActiveDirectoryBody.  # noqa: E501


        :return: The enabled of this ActiveDirectoryBody.  # noqa: E501
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """Sets the enabled of this ActiveDirectoryBody.


        :param enabled: The enabled of this ActiveDirectoryBody.  # noqa: E501
        :type: bool
        """

        self._enabled = enabled

    @property
    def ignore_start_tls_failure(self):
        """Gets the ignore_start_tls_failure of this ActiveDirectoryBody.  # noqa: E501

        Ignore start TLS failure  # noqa: E501

        :return: The ignore_start_tls_failure of this ActiveDirectoryBody.  # noqa: E501
        :rtype: bool
        """
        return self._ignore_start_tls_failure

    @ignore_start_tls_failure.setter
    def ignore_start_tls_failure(self, ignore_start_tls_failure):
        """Sets the ignore_start_tls_failure of this ActiveDirectoryBody.

        Ignore start TLS failure  # noqa: E501

        :param ignore_start_tls_failure: The ignore_start_tls_failure of this ActiveDirectoryBody.  # noqa: E501
        :type: bool
        """

        self._ignore_start_tls_failure = ignore_start_tls_failure

    @property
    def reader_password(self):
        """Gets the reader_password of this ActiveDirectoryBody.  # noqa: E501

        Reader password  # noqa: E501

        :return: The reader_password of this ActiveDirectoryBody.  # noqa: E501
        :rtype: str
        """
        return self._reader_password

    @reader_password.setter
    def reader_password(self, reader_password):
        """Sets the reader_password of this ActiveDirectoryBody.

        Reader password  # noqa: E501

        :param reader_password: The reader_password of this ActiveDirectoryBody.  # noqa: E501
        :type: str
        """

        self._reader_password = reader_password

    @property
    def reader_username(self):
        """Gets the reader_username of this ActiveDirectoryBody.  # noqa: E501

        Reader username  # noqa: E501

        :return: The reader_username of this ActiveDirectoryBody.  # noqa: E501
        :rtype: str
        """
        return self._reader_username

    @reader_username.setter
    def reader_username(self, reader_username):
        """Sets the reader_username of this ActiveDirectoryBody.

        Reader username  # noqa: E501

        :param reader_username: The reader_username of this ActiveDirectoryBody.  # noqa: E501
        :type: str
        """

        self._reader_username = reader_username

    @property
    def role_groups(self):
        """Gets the role_groups of this ActiveDirectoryBody.  # noqa: E501

        user role can be ClusterAdmin, OrgAdmin, ReadOnly or Regular  # noqa: E501

        :return: The role_groups of this ActiveDirectoryBody.  # noqa: E501
        :rtype: object
        """
        return self._role_groups

    @role_groups.setter
    def role_groups(self, role_groups):
        """Sets the role_groups of this ActiveDirectoryBody.

        user role can be ClusterAdmin, OrgAdmin, ReadOnly or Regular  # noqa: E501

        :param role_groups: The role_groups of this ActiveDirectoryBody.  # noqa: E501
        :type: object
        """

        self._role_groups = role_groups

    @property
    def server_timeout_secs(self):
        """Gets the server_timeout_secs of this ActiveDirectoryBody.  # noqa: E501

        LDAP connection timeout in seconds  # noqa: E501

        :return: The server_timeout_secs of this ActiveDirectoryBody.  # noqa: E501
        :rtype: float
        """
        return self._server_timeout_secs

    @server_timeout_secs.setter
    def server_timeout_secs(self, server_timeout_secs):
        """Sets the server_timeout_secs of this ActiveDirectoryBody.

        LDAP connection timeout in seconds  # noqa: E501

        :param server_timeout_secs: The server_timeout_secs of this ActiveDirectoryBody.  # noqa: E501
        :type: float
        """

        self._server_timeout_secs = server_timeout_secs

    @property
    def server_uri(self):
        """Gets the server_uri of this ActiveDirectoryBody.  # noqa: E501

        LDAP server URI ([ldap://]hostname[:port] or ldaps://hostname[:port])  # noqa: E501

        :return: The server_uri of this ActiveDirectoryBody.  # noqa: E501
        :rtype: str
        """
        return self._server_uri

    @server_uri.setter
    def server_uri(self, server_uri):
        """Sets the server_uri of this ActiveDirectoryBody.

        LDAP server URI ([ldap://]hostname[:port] or ldaps://hostname[:port])  # noqa: E501

        :param server_uri: The server_uri of this ActiveDirectoryBody.  # noqa: E501
        :type: str
        """

        self._server_uri = server_uri

    @property
    def start_tls(self):
        """Gets the start_tls of this ActiveDirectoryBody.  # noqa: E501

        Issue StartTLS after connecting (should not be used with ldaps://)  # noqa: E501

        :return: The start_tls of this ActiveDirectoryBody.  # noqa: E501
        :rtype: bool
        """
        return self._start_tls

    @start_tls.setter
    def start_tls(self, start_tls):
        """Sets the start_tls of this ActiveDirectoryBody.

        Issue StartTLS after connecting (should not be used with ldaps://)  # noqa: E501

        :param start_tls: The start_tls of this ActiveDirectoryBody.  # noqa: E501
        :type: bool
        """

        self._start_tls = start_tls

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ActiveDirectoryBody, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ActiveDirectoryBody):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
