# coding: utf-8

"""
    @weka-api

    <div>The Weka system supports a RESTful API. This is useful when automating the interaction with the Weka system and when integrating it into your workflows or monitoring systems. The API is accessible at port 14000, via the /api/v2 URL, you can explore it via /api/v2/docs when accessing from the cluster (e.g. https://weka01:14000/api/v2/docs).<div style=\"margin-top: 15px;\">Note: Weka uses 64bit numbers. Please take special care when interacting with the API with different program languages (In JS for example you can use \"json-bigint\")</div></div>  # noqa: E501

    OpenAPI spec version: 3.14
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from wekarestapi.api_client import ApiClient


class S3Api(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def attach_s3_policy(self, body, **kwargs):  # noqa: E501
        """Attach an S3 IAM policy to a user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.attach_s3_policy(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PoliciesAttachBody body: (required)
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.attach_s3_policy_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.attach_s3_policy_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def attach_s3_policy_with_http_info(self, body, **kwargs):  # noqa: E501
        """Attach an S3 IAM policy to a user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.attach_s3_policy_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PoliciesAttachBody body: (required)
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method attach_s3_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `attach_s3_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/s3/policies/attach', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse200',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_s3_bucket(self, body, **kwargs):  # noqa: E501
        """Create an S3 bucket  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_s3_bucket(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param S3BucketsBody body: (required)
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_s3_bucket_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_s3_bucket_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_s3_bucket_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create an S3 bucket  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_s3_bucket_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param S3BucketsBody body: (required)
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_s3_bucket" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_s3_bucket`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/s3/buckets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse200',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_s3_cluster(self, body, **kwargs):  # noqa: E501
        """Create S3 cluster  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_s3_cluster(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param S3Body1 body: (required)
        :return: InlineResponse400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_s3_cluster_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_s3_cluster_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_s3_cluster_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create S3 cluster  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_s3_cluster_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param S3Body1 body: (required)
        :return: InlineResponse400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_s3_cluster" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_s3_cluster`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/s3', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_s3_policy(self, body, **kwargs):  # noqa: E501
        """Create an S3 IAM policy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_s3_policy(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param S3PoliciesBody body: (required)
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_s3_policy_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_s3_policy_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_s3_policy_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create an S3 IAM policy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_s3_policy_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param S3PoliciesBody body: (required)
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_s3_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_s3_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/s3/policies', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse200',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_s3_cluster(self, **kwargs):  # noqa: E501
        """Delete S3 cluster  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_s3_cluster(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool purge_config: Purge the existing configuraion by default
        :return: InlineResponse400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_s3_cluster_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_s3_cluster_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_s3_cluster_with_http_info(self, **kwargs):  # noqa: E501
        """Delete S3 cluster  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_s3_cluster_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool purge_config: Purge the existing configuraion by default
        :return: InlineResponse400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['purge_config']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_s3_cluster" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'purge_config' in params:
            query_params.append(('purge_config', params['purge_config']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/s3', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_s3_policy(self, policy, **kwargs):  # noqa: E501
        """Delete an S3 IAM policy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_s3_policy(policy, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str policy: policy name (required)
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_s3_policy_with_http_info(policy, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_s3_policy_with_http_info(policy, **kwargs)  # noqa: E501
            return data

    def delete_s3_policy_with_http_info(self, policy, **kwargs):  # noqa: E501
        """Delete an S3 IAM policy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_s3_policy_with_http_info(policy, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str policy: policy name (required)
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['policy']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_s3_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'policy' is set
        if ('policy' not in params or
                params['policy'] is None):
            raise ValueError("Missing the required parameter `policy` when calling `delete_s3_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'policy' in params:
            path_params['policy'] = params['policy']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/s3/policies/{policy}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse200',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def destroy_s3_bucket(self, bucket, **kwargs):  # noqa: E501
        """Destroy an S3 bucket  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.destroy_s3_bucket(bucket, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket: bucket name (required)
        :param bool unlink: unlinks the bucket, but leave the data directory in place
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.destroy_s3_bucket_with_http_info(bucket, **kwargs)  # noqa: E501
        else:
            (data) = self.destroy_s3_bucket_with_http_info(bucket, **kwargs)  # noqa: E501
            return data

    def destroy_s3_bucket_with_http_info(self, bucket, **kwargs):  # noqa: E501
        """Destroy an S3 bucket  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.destroy_s3_bucket_with_http_info(bucket, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket: bucket name (required)
        :param bool unlink: unlinks the bucket, but leave the data directory in place
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bucket', 'unlink']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method destroy_s3_bucket" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bucket' is set
        if ('bucket' not in params or
                params['bucket'] is None):
            raise ValueError("Missing the required parameter `bucket` when calling `destroy_s3_bucket`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bucket' in params:
            path_params['bucket'] = params['bucket']  # noqa: E501

        query_params = []
        if 'unlink' in params:
            query_params.append(('unlink', params['unlink']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/s3/buckets/{bucket}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse200',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def detach_s3_policy(self, body, **kwargs):  # noqa: E501
        """Detach a user's policy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.detach_s3_policy(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PoliciesDetachBody body: (required)
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.detach_s3_policy_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.detach_s3_policy_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def detach_s3_policy_with_http_info(self, body, **kwargs):  # noqa: E501
        """Detach a user's policy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.detach_s3_policy_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PoliciesDetachBody body: (required)
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method detach_s3_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `detach_s3_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/s3/policies/detach', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse200',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_s3_bucket_disk_usage(self, bucket, **kwargs):  # noqa: E501
        """Get the disk usage of an S3 bucket  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_s3_bucket_disk_usage(bucket, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket: bucket name (required)
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_s3_bucket_disk_usage_with_http_info(bucket, **kwargs)  # noqa: E501
        else:
            (data) = self.get_s3_bucket_disk_usage_with_http_info(bucket, **kwargs)  # noqa: E501
            return data

    def get_s3_bucket_disk_usage_with_http_info(self, bucket, **kwargs):  # noqa: E501
        """Get the disk usage of an S3 bucket  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_s3_bucket_disk_usage_with_http_info(bucket, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket: bucket name (required)
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bucket']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_s3_bucket_disk_usage" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bucket' is set
        if ('bucket' not in params or
                params['bucket'] is None):
            raise ValueError("Missing the required parameter `bucket` when calling `get_s3_bucket_disk_usage`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bucket' in params:
            path_params['bucket'] = params['bucket']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/s3/buckets/{bucket}/diskUsage', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse200',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_s3_bucket_policy(self, bucket, **kwargs):  # noqa: E501
        """Get the S3 bucket policy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_s3_bucket_policy(bucket, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket: bucket name (required)
        :return: InlineResponse20058
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_s3_bucket_policy_with_http_info(bucket, **kwargs)  # noqa: E501
        else:
            (data) = self.get_s3_bucket_policy_with_http_info(bucket, **kwargs)  # noqa: E501
            return data

    def get_s3_bucket_policy_with_http_info(self, bucket, **kwargs):  # noqa: E501
        """Get the S3 bucket policy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_s3_bucket_policy_with_http_info(bucket, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket: bucket name (required)
        :return: InlineResponse20058
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bucket']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_s3_bucket_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bucket' is set
        if ('bucket' not in params or
                params['bucket'] is None):
            raise ValueError("Missing the required parameter `bucket` when calling `get_s3_bucket_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bucket' in params:
            path_params['bucket'] = params['bucket']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/s3/buckets/{bucket}/policy', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20058',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_s3_bucket_policy_json(self, bucket, **kwargs):  # noqa: E501
        """Get the S3 bucket policy json  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_s3_bucket_policy_json(bucket, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket: bucket name (required)
        :return: InlineResponse20058
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_s3_bucket_policy_json_with_http_info(bucket, **kwargs)  # noqa: E501
        else:
            (data) = self.get_s3_bucket_policy_json_with_http_info(bucket, **kwargs)  # noqa: E501
            return data

    def get_s3_bucket_policy_json_with_http_info(self, bucket, **kwargs):  # noqa: E501
        """Get the S3 bucket policy json  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_s3_bucket_policy_json_with_http_info(bucket, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket: bucket name (required)
        :return: InlineResponse20058
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bucket']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_s3_bucket_policy_json" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bucket' is set
        if ('bucket' not in params or
                params['bucket'] is None):
            raise ValueError("Missing the required parameter `bucket` when calling `get_s3_bucket_policy_json`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bucket' in params:
            path_params['bucket'] = params['bucket']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/s3/buckets/{bucket}/policyJson', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20058',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_s3_buckets(self, **kwargs):  # noqa: E501
        """Get S3 buckets list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_s3_buckets(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: InlineResponse20055
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_s3_buckets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_s3_buckets_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_s3_buckets_with_http_info(self, **kwargs):  # noqa: E501
        """Get S3 buckets list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_s3_buckets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: InlineResponse20055
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_s3_buckets" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/s3/buckets', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20055',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_s3_cluster(self, **kwargs):  # noqa: E501
        """Get S3 cluster info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_s3_cluster(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: InlineResponse400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_s3_cluster_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_s3_cluster_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_s3_cluster_with_http_info(self, **kwargs):  # noqa: E501
        """Get S3 cluster info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_s3_cluster_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: InlineResponse400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_s3_cluster" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/s3', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_s3_policies(self, **kwargs):  # noqa: E501
        """Get S3 IAM policies list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_s3_policies(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_s3_policies_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_s3_policies_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_s3_policies_with_http_info(self, **kwargs):  # noqa: E501
        """Get S3 IAM policies list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_s3_policies_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_s3_policies" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/s3/policies', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse200',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_s3_policy(self, policy, **kwargs):  # noqa: E501
        """Get the details of an S3 IAM policy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_s3_policy(policy, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str policy: policy name (required)
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_s3_policy_with_http_info(policy, **kwargs)  # noqa: E501
        else:
            (data) = self.get_s3_policy_with_http_info(policy, **kwargs)  # noqa: E501
            return data

    def get_s3_policy_with_http_info(self, policy, **kwargs):  # noqa: E501
        """Get the details of an S3 IAM policy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_s3_policy_with_http_info(policy, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str policy: policy name (required)
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['policy']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_s3_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'policy' is set
        if ('policy' not in params or
                params['policy'] is None):
            raise ValueError("Missing the required parameter `policy` when calling `get_s3_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'policy' in params:
            path_params['policy'] = params['policy']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/s3/policies/{policy}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse200',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def gets3_containers_are_ready(self, **kwargs):  # noqa: E501
        """Get S3 Hosts status  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.gets3_containers_are_ready(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: InlineResponse20059
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.gets3_containers_are_ready_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.gets3_containers_are_ready_with_http_info(**kwargs)  # noqa: E501
            return data

    def gets3_containers_are_ready_with_http_info(self, **kwargs):  # noqa: E501
        """Get S3 Hosts status  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.gets3_containers_are_ready_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: InlineResponse20059
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method gets3_containers_are_ready" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/s3/containersAreReady', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20059',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def s3_create_lifecycle_rule(self, body, bucket, **kwargs):  # noqa: E501
        """Create a new bucket lifecycle rule  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.s3_create_lifecycle_rule(body, bucket, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LifecycleRulesBody body: (required)
        :param str bucket: bucket name (required)
        :return: InlineResponse20056
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.s3_create_lifecycle_rule_with_http_info(body, bucket, **kwargs)  # noqa: E501
        else:
            (data) = self.s3_create_lifecycle_rule_with_http_info(body, bucket, **kwargs)  # noqa: E501
            return data

    def s3_create_lifecycle_rule_with_http_info(self, body, bucket, **kwargs):  # noqa: E501
        """Create a new bucket lifecycle rule  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.s3_create_lifecycle_rule_with_http_info(body, bucket, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LifecycleRulesBody body: (required)
        :param str bucket: bucket name (required)
        :return: InlineResponse20056
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'bucket']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method s3_create_lifecycle_rule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `s3_create_lifecycle_rule`")  # noqa: E501
        # verify the required parameter 'bucket' is set
        if ('bucket' not in params or
                params['bucket'] is None):
            raise ValueError("Missing the required parameter `bucket` when calling `s3_create_lifecycle_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bucket' in params:
            path_params['bucket'] = params['bucket']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/s3/buckets/{bucket}/lifecycle/rules', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20056',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def s3_delete_all_lifecycle_rules(self, bucket, **kwargs):  # noqa: E501
        """Delete all lifecycle rules of a specific bucket  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.s3_delete_all_lifecycle_rules(bucket, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket: bucket name (required)
        :return: InlineResponse20057
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.s3_delete_all_lifecycle_rules_with_http_info(bucket, **kwargs)  # noqa: E501
        else:
            (data) = self.s3_delete_all_lifecycle_rules_with_http_info(bucket, **kwargs)  # noqa: E501
            return data

    def s3_delete_all_lifecycle_rules_with_http_info(self, bucket, **kwargs):  # noqa: E501
        """Delete all lifecycle rules of a specific bucket  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.s3_delete_all_lifecycle_rules_with_http_info(bucket, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket: bucket name (required)
        :return: InlineResponse20057
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bucket']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method s3_delete_all_lifecycle_rules" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bucket' is set
        if ('bucket' not in params or
                params['bucket'] is None):
            raise ValueError("Missing the required parameter `bucket` when calling `s3_delete_all_lifecycle_rules`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bucket' in params:
            path_params['bucket'] = params['bucket']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/s3/buckets/{bucket}/lifecycle/rules', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20057',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def s3_delete_lifecycle_rule(self, bucket, rule, **kwargs):  # noqa: E501
        """Delete a bucket lifecycle rule  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.s3_delete_lifecycle_rule(bucket, rule, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket: bucket name (required)
        :param str rule: rule ID (required)
        :return: InlineResponse20057
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.s3_delete_lifecycle_rule_with_http_info(bucket, rule, **kwargs)  # noqa: E501
        else:
            (data) = self.s3_delete_lifecycle_rule_with_http_info(bucket, rule, **kwargs)  # noqa: E501
            return data

    def s3_delete_lifecycle_rule_with_http_info(self, bucket, rule, **kwargs):  # noqa: E501
        """Delete a bucket lifecycle rule  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.s3_delete_lifecycle_rule_with_http_info(bucket, rule, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket: bucket name (required)
        :param str rule: rule ID (required)
        :return: InlineResponse20057
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bucket', 'rule']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method s3_delete_lifecycle_rule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bucket' is set
        if ('bucket' not in params or
                params['bucket'] is None):
            raise ValueError("Missing the required parameter `bucket` when calling `s3_delete_lifecycle_rule`")  # noqa: E501
        # verify the required parameter 'rule' is set
        if ('rule' not in params or
                params['rule'] is None):
            raise ValueError("Missing the required parameter `rule` when calling `s3_delete_lifecycle_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bucket' in params:
            path_params['bucket'] = params['bucket']  # noqa: E501
        if 'rule' in params:
            path_params['rule'] = params['rule']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/s3/buckets/{bucket}/lifecycle/rules/{rule}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20057',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def s3_list_all_lifecycle_rules(self, bucket, **kwargs):  # noqa: E501
        """List all lifecycle rules of a specific bucket  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.s3_list_all_lifecycle_rules(bucket, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket: bucket name (required)
        :return: InlineResponse20055
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.s3_list_all_lifecycle_rules_with_http_info(bucket, **kwargs)  # noqa: E501
        else:
            (data) = self.s3_list_all_lifecycle_rules_with_http_info(bucket, **kwargs)  # noqa: E501
            return data

    def s3_list_all_lifecycle_rules_with_http_info(self, bucket, **kwargs):  # noqa: E501
        """List all lifecycle rules of a specific bucket  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.s3_list_all_lifecycle_rules_with_http_info(bucket, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket: bucket name (required)
        :return: InlineResponse20055
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bucket']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method s3_list_all_lifecycle_rules" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bucket' is set
        if ('bucket' not in params or
                params['bucket'] is None):
            raise ValueError("Missing the required parameter `bucket` when calling `s3_list_all_lifecycle_rules`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bucket' in params:
            path_params['bucket'] = params['bucket']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/s3/buckets/{bucket}/lifecycle/rules', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20055',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def s3_sts_create(self, body, **kwargs):  # noqa: E501
        """Create an s3 sts token with an assumend role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.s3_sts_create(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param S3StsBody body: (required)
        :return: InlineResponse20060
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.s3_sts_create_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.s3_sts_create_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def s3_sts_create_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create an s3 sts token with an assumend role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.s3_sts_create_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param S3StsBody body: (required)
        :return: InlineResponse20060
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method s3_sts_create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `s3_sts_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/s3/sts', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20060',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_s3_bucket_policy(self, body, bucket, **kwargs):  # noqa: E501
        """Set S3 bucket policy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_s3_bucket_policy(body, bucket, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BucketPolicyBody body: (required)
        :param str bucket: bucket name (required)
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_s3_bucket_policy_with_http_info(body, bucket, **kwargs)  # noqa: E501
        else:
            (data) = self.set_s3_bucket_policy_with_http_info(body, bucket, **kwargs)  # noqa: E501
            return data

    def set_s3_bucket_policy_with_http_info(self, body, bucket, **kwargs):  # noqa: E501
        """Set S3 bucket policy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_s3_bucket_policy_with_http_info(body, bucket, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BucketPolicyBody body: (required)
        :param str bucket: bucket name (required)
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'bucket']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_s3_bucket_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `set_s3_bucket_policy`")  # noqa: E501
        # verify the required parameter 'bucket' is set
        if ('bucket' not in params or
                params['bucket'] is None):
            raise ValueError("Missing the required parameter `bucket` when calling `set_s3_bucket_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bucket' in params:
            path_params['bucket'] = params['bucket']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/s3/buckets/{bucket}/policy', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse200',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_s3_bucket_policy_json(self, body, bucket, **kwargs):  # noqa: E501
        """Set S3 bucket policy json  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_s3_bucket_policy_json(body, bucket, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BucketPolicyJsonBody body: (required)
        :param str bucket: bucket name (required)
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_s3_bucket_policy_json_with_http_info(body, bucket, **kwargs)  # noqa: E501
        else:
            (data) = self.set_s3_bucket_policy_json_with_http_info(body, bucket, **kwargs)  # noqa: E501
            return data

    def set_s3_bucket_policy_json_with_http_info(self, body, bucket, **kwargs):  # noqa: E501
        """Set S3 bucket policy json  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_s3_bucket_policy_json_with_http_info(body, bucket, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BucketPolicyJsonBody body: (required)
        :param str bucket: bucket name (required)
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'bucket']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_s3_bucket_policy_json" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `set_s3_bucket_policy_json`")  # noqa: E501
        # verify the required parameter 'bucket' is set
        if ('bucket' not in params or
                params['bucket'] is None):
            raise ValueError("Missing the required parameter `bucket` when calling `set_s3_bucket_policy_json`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bucket' in params:
            path_params['bucket'] = params['bucket']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/s3/buckets/{bucket}/policyJson', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse200',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_s3_bucket_quota(self, body, bucket, **kwargs):  # noqa: E501
        """Set S3 bucket quota  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_s3_bucket_quota(body, bucket, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BucketQuotaBody body: (required)
        :param str bucket: bucket name (required)
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_s3_bucket_quota_with_http_info(body, bucket, **kwargs)  # noqa: E501
        else:
            (data) = self.set_s3_bucket_quota_with_http_info(body, bucket, **kwargs)  # noqa: E501
            return data

    def set_s3_bucket_quota_with_http_info(self, body, bucket, **kwargs):  # noqa: E501
        """Set S3 bucket quota  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_s3_bucket_quota_with_http_info(body, bucket, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BucketQuotaBody body: (required)
        :param str bucket: bucket name (required)
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'bucket']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_s3_bucket_quota" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `set_s3_bucket_quota`")  # noqa: E501
        # verify the required parameter 'bucket' is set
        if ('bucket' not in params or
                params['bucket'] is None):
            raise ValueError("Missing the required parameter `bucket` when calling `set_s3_bucket_quota`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bucket' in params:
            path_params['bucket'] = params['bucket']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/s3/buckets/{bucket}/quota', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse200',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def unset_s3_bucket_quota(self, bucket, **kwargs):  # noqa: E501
        """Unset S3 bucket quota  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.unset_s3_bucket_quota(bucket, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket: bucket name (required)
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.unset_s3_bucket_quota_with_http_info(bucket, **kwargs)  # noqa: E501
        else:
            (data) = self.unset_s3_bucket_quota_with_http_info(bucket, **kwargs)  # noqa: E501
            return data

    def unset_s3_bucket_quota_with_http_info(self, bucket, **kwargs):  # noqa: E501
        """Unset S3 bucket quota  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.unset_s3_bucket_quota_with_http_info(bucket, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket: bucket name (required)
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bucket']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method unset_s3_bucket_quota" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bucket' is set
        if ('bucket' not in params or
                params['bucket'] is None):
            raise ValueError("Missing the required parameter `bucket` when calling `unset_s3_bucket_quota`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bucket' in params:
            path_params['bucket'] = params['bucket']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/s3/buckets/{bucket}/quota', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse200',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_s3_cluster(self, body, **kwargs):  # noqa: E501
        """Update S3 cluster  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_s3_cluster(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param S3Body body: (required)
        :return: InlineResponse400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_s3_cluster_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.update_s3_cluster_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def update_s3_cluster_with_http_info(self, body, **kwargs):  # noqa: E501
        """Update S3 cluster  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_s3_cluster_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param S3Body body: (required)
        :return: InlineResponse400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_s3_cluster" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_s3_cluster`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/s3', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
