# coding: utf-8

"""
    @weka-api

    <div>The Weka system supports a RESTful API. This is useful when automating the interaction with the Weka system and when integrating it into your workflows or monitoring systems. The API is accessible at port 14000, via the /api/v2 URL, you can explore it via /api/v2/docs when accessing from the cluster (e.g. https://weka01:14000/api/v2/docs).<div style=\"margin-top: 15px;\">Note: Weka uses 64bit numbers. Please take special care when interacting with the API with different program languages (In JS for example you can use \"json-bigint\")</div></div>  # noqa: E501

    OpenAPI spec version: 3.14
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from wekarestapi.api_client import ApiClient


class EventsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_events(self, **kwargs):  # noqa: E501
        """Get events  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_events(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float num_results:
        :param str start_time:
        :param str end_time:
        :param str severity:
        :param list[str] type_list:
        :param list[str] category_list:
        :param str sort_order:
        :param bool show_internal:
        :param str next_token:
        :return: InlineResponse2009
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_events_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_events_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_events_with_http_info(self, **kwargs):  # noqa: E501
        """Get events  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_events_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float num_results:
        :param str start_time:
        :param str end_time:
        :param str severity:
        :param list[str] type_list:
        :param list[str] category_list:
        :param str sort_order:
        :param bool show_internal:
        :param str next_token:
        :return: InlineResponse2009
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['num_results', 'start_time', 'end_time', 'severity', 'type_list', 'category_list', 'sort_order', 'show_internal', 'next_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_events" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'num_results' in params:
            query_params.append(('num_results', params['num_results']))  # noqa: E501
        if 'start_time' in params:
            query_params.append(('start_time', params['start_time']))  # noqa: E501
        if 'end_time' in params:
            query_params.append(('end_time', params['end_time']))  # noqa: E501
        if 'severity' in params:
            query_params.append(('severity', params['severity']))  # noqa: E501
        if 'type_list' in params:
            query_params.append(('type_list', params['type_list']))  # noqa: E501
            collection_formats['type_list'] = 'multi'  # noqa: E501
        if 'category_list' in params:
            query_params.append(('category_list', params['category_list']))  # noqa: E501
            collection_formats['category_list'] = 'multi'  # noqa: E501
        if 'sort_order' in params:
            query_params.append(('sort_order', params['sort_order']))  # noqa: E501
        if 'show_internal' in params:
            query_params.append(('show_internal', params['show_internal']))  # noqa: E501
        if 'next_token' in params:
            query_params.append(('next_token', params['next_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/events', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse2009',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_events_description(self, **kwargs):  # noqa: E501
        """Get events description  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_events_description(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] type: list of categories
        :param list[str] category: list of categories
        :param bool show_internal:
        :return: InlineResponse20010
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_events_description_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_events_description_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_events_description_with_http_info(self, **kwargs):  # noqa: E501
        """Get events description  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_events_description_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] type: list of categories
        :param list[str] category: list of categories
        :param bool show_internal:
        :return: InlineResponse20010
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['type', 'category', 'show_internal']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_events_description" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501
            collection_formats['type'] = 'multi'  # noqa: E501
        if 'category' in params:
            query_params.append(('category', params['category']))  # noqa: E501
            collection_formats['category'] = 'multi'  # noqa: E501
        if 'show_internal' in params:
            query_params.append(('show_internal', params['show_internal']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/events/describe', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20010',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_local_events(self, **kwargs):  # noqa: E501
        """Get events from the targeted host for the API call  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_local_events(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str start_time:
        :param str end_time:
        :param bool stem_mode:
        :param bool show_internal:
        :param str next_token:
        :return: InlineResponse20011
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_local_events_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_local_events_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_local_events_with_http_info(self, **kwargs):  # noqa: E501
        """Get events from the targeted host for the API call  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_local_events_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str start_time:
        :param str end_time:
        :param bool stem_mode:
        :param bool show_internal:
        :param str next_token:
        :return: InlineResponse20011
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['start_time', 'end_time', 'stem_mode', 'show_internal', 'next_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_local_events" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'start_time' in params:
            query_params.append(('start_time', params['start_time']))  # noqa: E501
        if 'end_time' in params:
            query_params.append(('end_time', params['end_time']))  # noqa: E501
        if 'stem_mode' in params:
            query_params.append(('stem_mode', params['stem_mode']))  # noqa: E501
        if 'show_internal' in params:
            query_params.append(('show_internal', params['show_internal']))  # noqa: E501
        if 'next_token' in params:
            query_params.append(('next_token', params['next_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/events/local', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20011',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
