# swagger-client
<div>The Weka system supports a RESTful API. This is useful when automating the interaction with the Weka system and when integrating it into your workflows or monitoring systems. The API is accessible at port 14000, via the /api/v2 URL, you can explore it via /api/v2/docs when accessing from the cluster (e.g. https://weka01:14000/api/v2/docs).<div style=\"margin-top: 15px;\">Note: Weka uses 64bit numbers. Please take special care when interacting with the API with different program languages (In JS for example you can use \"json-bigint\")</div></div>

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 3.14
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:

```python
import wekarestapi 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:

```python
import wekarestapi
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import wekarestapi
from wekarestapi.rest import ApiException
from pprint import pprint


# create an instance of the API class
api_instance = wekarestapi.ActiveDirectoryApi(wekarestapi.ApiClient(configuration))
body = wekarestapi.ActiveDirectoryBody() # ActiveDirectoryBody | 

try:
    # Update active directory
    api_response = api_instance.update_ldap_active_directory(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling ActiveDirectoryApi->update_ldap_active_directory: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to */api/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ActiveDirectoryApi* | [**update_ldap_active_directory**](docs/ActiveDirectoryApi.md#update_ldap_active_directory) | **PUT** /activeDirectory | Update active directory
*AlertsApi* | [**get_alert_description**](docs/AlertsApi.md#get_alert_description) | **GET** /alerts/description | Get alerts description
*AlertsApi* | [**get_alerts**](docs/AlertsApi.md#get_alerts) | **GET** /alerts | Get all alerts
*AlertsApi* | [**get_alerts_types**](docs/AlertsApi.md#get_alerts_types) | **GET** /alerts/types | Get alerts types
*AlertsApi* | [**mute_alert_by_type**](docs/AlertsApi.md#mute_alert_by_type) | **PUT** /alerts/{alert_type}/mute | Mute alerts by type
*AlertsApi* | [**unmute_alert_by_type**](docs/AlertsApi.md#unmute_alert_by_type) | **PUT** /alerts/{alert_type}/unmute | Unmute alerts by type
*ClusterApi* | [**create_cluster**](docs/ClusterApi.md#create_cluster) | **POST** /cluster | Create cluster
*ClusterApi* | [**get_cluster_status**](docs/ClusterApi.md#get_cluster_status) | **GET** /cluster | Get cluster status
*ClusterApi* | [**update_cluster**](docs/ClusterApi.md#update_cluster) | **PUT** /cluster | Update cluster
*DefaultNetworkApi* | [**get_default_network**](docs/DefaultNetworkApi.md#get_default_network) | **GET** /defaultNet | Get default network
*DefaultNetworkApi* | [**reset_default_network**](docs/DefaultNetworkApi.md#reset_default_network) | **DELETE** /defaultNet | Reset default network
*DefaultNetworkApi* | [**set_default_network**](docs/DefaultNetworkApi.md#set_default_network) | **POST** /defaultNet | Set default network
*DefaultNetworkApi* | [**update_default_network**](docs/DefaultNetworkApi.md#update_default_network) | **PUT** /defaultNet | Update default network
*DriveApi* | [**activate_drives**](docs/DriveApi.md#activate_drives) | **POST** /drives/activate | Activate drives
*DriveApi* | [**deactivates_drives**](docs/DriveApi.md#deactivates_drives) | **POST** /drives/deactivate | Deactivate drives
*DriveApi* | [**delete_drive**](docs/DriveApi.md#delete_drive) | **DELETE** /drives/{uid} | Remove drive
*DriveApi* | [**get_drives**](docs/DriveApi.md#get_drives) | **GET** /drives | Get drives list
*DriveApi* | [**get_single_drive**](docs/DriveApi.md#get_single_drive) | **GET** /drives/{uid} | Get single drive
*DriveApi* | [**provision_drives**](docs/DriveApi.md#provision_drives) | **POST** /drives | Provision drives
*EventsApi* | [**get_events**](docs/EventsApi.md#get_events) | **GET** /events | Get events
*EventsApi* | [**get_events_description**](docs/EventsApi.md#get_events_description) | **GET** /events/describe | Get events description
*EventsApi* | [**get_local_events**](docs/EventsApi.md#get_local_events) | **GET** /events/local | Get events from the targeted host for the API call
*FailureDomainsApi* | [**get_failure_domains**](docs/FailureDomainsApi.md#get_failure_domains) | **GET** /failureDomains | Get failure domains
*FailureDomainsApi* | [**get_single_failure_domain**](docs/FailureDomainsApi.md#get_single_failure_domain) | **GET** /failureDomains/{uid} | Get single failure domain
*FileSystemApi* | [**attach_obs_bucket_to_fs**](docs/FileSystemApi.md#attach_obs_bucket_to_fs) | **POST** /fileSystems/{uid}/objectStoreBuckets | Attach object store bucket to file system
*FileSystemApi* | [**attach_obs_to_fs**](docs/FileSystemApi.md#attach_obs_to_fs) | **POST** /fileSystems/{uid}/objectStores | Attach object store bucket to file system
*FileSystemApi* | [**create_file_system**](docs/FileSystemApi.md#create_file_system) | **POST** /fileSystems | Create file system
*FileSystemApi* | [**delete_file_system**](docs/FileSystemApi.md#delete_file_system) | **DELETE** /fileSystems/{uid} | Delete file system
*FileSystemApi* | [**delete_file_systems_thin_provision_reserve**](docs/FileSystemApi.md#delete_file_systems_thin_provision_reserve) | **DELETE** /fileSystems/thinProvisionReserve/{org_uid} | Unset filesystems thin provisioning reserve for Organization
*FileSystemApi* | [**detach_obs_bucket_from_fs**](docs/FileSystemApi.md#detach_obs_bucket_from_fs) | **DELETE** /fileSystems/{uid}/objectStoreBuckets/{obs_uid} | Detach object store bucket from file system
*FileSystemApi* | [**detach_obs_from_fs**](docs/FileSystemApi.md#detach_obs_from_fs) | **DELETE** /fileSystems/{uid}/objectStores/{obs_uid} | Detach object store bucket from file system
*FileSystemApi* | [**download_fs**](docs/FileSystemApi.md#download_fs) | **POST** /fileSystems/download | Download file system from object store
*FileSystemApi* | [**get_file_system**](docs/FileSystemApi.md#get_file_system) | **GET** /fileSystems/{uid} | Get file system
*FileSystemApi* | [**get_file_systems**](docs/FileSystemApi.md#get_file_systems) | **GET** /fileSystems | Get all file systems
*FileSystemApi* | [**get_file_systems_thin_provision_reserve_status**](docs/FileSystemApi.md#get_file_systems_thin_provision_reserve_status) | **GET** /fileSystems/thinProvisionReserve | Filesystems thin provisioning reserve status for Organization
*FileSystemApi* | [**set_file_systems_thin_provision_reserve**](docs/FileSystemApi.md#set_file_systems_thin_provision_reserve) | **PUT** /fileSystems/thinProvisionReserve/{org_uid} | Set filesystems thin provisioning reserve for Organization
*FileSystemApi* | [**update_file_system**](docs/FileSystemApi.md#update_file_system) | **PUT** /fileSystems/{uid} | Update file system
*FileSystemGroupApi* | [**create_file_system_group**](docs/FileSystemGroupApi.md#create_file_system_group) | **POST** /fileSystemGroups | Create file system group
*FileSystemGroupApi* | [**delete_file_system_group**](docs/FileSystemGroupApi.md#delete_file_system_group) | **DELETE** /fileSystemGroups/{uid} | Delete file system group
*FileSystemGroupApi* | [**get_file_system_group**](docs/FileSystemGroupApi.md#get_file_system_group) | **GET** /fileSystemGroups/{uid} | Get file system group
*FileSystemGroupApi* | [**get_file_system_groups**](docs/FileSystemGroupApi.md#get_file_system_groups) | **GET** /fileSystemGroups | Get all file system groups
*FileSystemGroupApi* | [**update_file_system_group**](docs/FileSystemGroupApi.md#update_file_system_group) | **PUT** /fileSystemGroups/{uid} | Update file system group
*HealthApi* | [**get_api_health**](docs/HealthApi.md#get_api_health) | **GET** /healthcheck | Check if API is alive
*HealthApi* | [**get_ui_health**](docs/HealthApi.md#get_ui_health) | **GET** /ui/healthcheck | Check if UI is alive
*HostsApi* | [**activate_host**](docs/HostsApi.md#activate_host) | **POST** /hosts/{uid}/activate | Activate host
*HostsApi* | [**activate_hosts**](docs/HostsApi.md#activate_hosts) | **POST** /hosts/activate | Activate hosts
*HostsApi* | [**add_host**](docs/HostsApi.md#add_host) | **POST** /hosts | Add host to cluster
*HostsApi* | [**apply_host**](docs/HostsApi.md#apply_host) | **POST** /hosts/{uid}/apply | Apply host
*HostsApi* | [**apply_hosts**](docs/HostsApi.md#apply_hosts) | **POST** /hosts/apply | Apply hosts
*HostsApi* | [**clear_host_failure**](docs/HostsApi.md#clear_host_failure) | **DELETE** /hosts/lastFailureReason/{uid} | Clear host last failure
*HostsApi* | [**create_host_network**](docs/HostsApi.md#create_host_network) | **POST** /hosts/{uid}/netdevs | Create host network - Need to apply host after
*HostsApi* | [**deactivate_host**](docs/HostsApi.md#deactivate_host) | **POST** /hosts/{uid}/deactivate | Deactivate host
*HostsApi* | [**deactivate_hosts**](docs/HostsApi.md#deactivate_hosts) | **POST** /hosts/deactivate | Deactivate hosts
*HostsApi* | [**get_all_hosts_network**](docs/HostsApi.md#get_all_hosts_network) | **GET** /hosts/netdevs | Get all hosts network
*HostsApi* | [**get_host_network**](docs/HostsApi.md#get_host_network) | **GET** /hosts/{uid}/netdevs | Get host network
*HostsApi* | [**get_host_resources**](docs/HostsApi.md#get_host_resources) | **GET** /hosts/{uid}/resources | Get host resources
*HostsApi* | [**get_hosts**](docs/HostsApi.md#get_hosts) | **GET** /hosts | Get all hosts
*HostsApi* | [**get_hosts_info**](docs/HostsApi.md#get_hosts_info) | **GET** /hosts/infos | get hosts infos from IPs
*HostsApi* | [**get_single_host**](docs/HostsApi.md#get_single_host) | **GET** /hosts/{uid} | Get single host
*HostsApi* | [**remove_host**](docs/HostsApi.md#remove_host) | **DELETE** /hosts/{uid} | Remove host from cluster
*HostsApi* | [**remove_host_network**](docs/HostsApi.md#remove_host_network) | **DELETE** /hosts/{uid}/netdevs/{netdev_uid} | Remove host network - Need to apply host after
*HostsApi* | [**update_host**](docs/HostsApi.md#update_host) | **PUT** /hosts/{uid} | Configure host - Need to apply host after
*InterfaceGroupApi* | [**add_port_to_interface_group**](docs/InterfaceGroupApi.md#add_port_to_interface_group) | **POST** /interfaceGroups/{uid}/ports/{host_uid} | Add port to interface group
*InterfaceGroupApi* | [**crate_interface_group_ip**](docs/InterfaceGroupApi.md#crate_interface_group_ip) | **POST** /interfaceGroups/{uid}/ips | Add ip range to interface group
*InterfaceGroupApi* | [**create_interface_group**](docs/InterfaceGroupApi.md#create_interface_group) | **POST** /interfaceGroups | Create interface group
*InterfaceGroupApi* | [**delete_interface_group**](docs/InterfaceGroupApi.md#delete_interface_group) | **DELETE** /interfaceGroups/{uid} | delete interface group
*InterfaceGroupApi* | [**delete_ip_range_from_interface_group**](docs/InterfaceGroupApi.md#delete_ip_range_from_interface_group) | **DELETE** /interfaceGroups/{uid}/ips/{ips} | Delete ip range from interface group
*InterfaceGroupApi* | [**delete_port_from_interface_group**](docs/InterfaceGroupApi.md#delete_port_from_interface_group) | **DELETE** /interfaceGroups/{uid}/ports/{host_uid}/{port} | Delete port from interface group
*InterfaceGroupApi* | [**get_interface_group**](docs/InterfaceGroupApi.md#get_interface_group) | **GET** /interfaceGroups/{uid} | Get interface group
*InterfaceGroupApi* | [**get_interface_groups**](docs/InterfaceGroupApi.md#get_interface_groups) | **GET** /interfaceGroups | Get interface groups
*InterfaceGroupApi* | [**get_interface_groups_list_assignment**](docs/InterfaceGroupApi.md#get_interface_groups_list_assignment) | **GET** /interfaceGroups/listAssignment | Get All the floating IPs and their assignment
*InterfaceGroupApi* | [**interface_group_add_port**](docs/InterfaceGroupApi.md#interface_group_add_port) | **POST** /interfaceGroups/port | add port for interface group
*InterfaceGroupApi* | [**update_interface_group**](docs/InterfaceGroupApi.md#update_interface_group) | **PUT** /interfaceGroups/{uid} | Update interface group
*KMSApi* | [**delete_kms**](docs/KMSApi.md#delete_kms) | **DELETE** /kms | Delete kms configuration
*KMSApi* | [**get_kms**](docs/KMSApi.md#get_kms) | **GET** /kms | Get kms configuration
*KMSApi* | [**get_kms_type**](docs/KMSApi.md#get_kms_type) | **GET** /kms/type | Get kms type
*KMSApi* | [**rewrap_kms_key**](docs/KMSApi.md#rewrap_kms_key) | **POST** /kms/rewrap | Rewrap KMS key
*KMSApi* | [**set_kms**](docs/KMSApi.md#set_kms) | **POST** /kms | Set kms vault configuration (base_url,master_key_name,token) or set kms kmip configuration (server_endpoint, key_uid, client_cert_pem, client_key_pem, ca_cert_pem) 
*LDAPApi* | [**delete_ldap**](docs/LDAPApi.md#delete_ldap) | **DELETE** /ldap | Reset LDAP configuration
*LDAPApi* | [**get_ldap**](docs/LDAPApi.md#get_ldap) | **GET** /ldap | Get LDAP configuration
*LDAPApi* | [**update_ldap**](docs/LDAPApi.md#update_ldap) | **PUT** /ldap | Update LDAP configuration
*LicenseApi* | [**get_license**](docs/LicenseApi.md#get_license) | **GET** /license | Get license
*LicenseApi* | [**reset_license**](docs/LicenseApi.md#reset_license) | **DELETE** /license | Reset license
*LicenseApi* | [**set_license**](docs/LicenseApi.md#set_license) | **POST** /license | Set license
*LoginApi* | [**login**](docs/LoginApi.md#login) | **POST** /login | login to system
*LoginApi* | [**refresh_token**](docs/LoginApi.md#refresh_token) | **POST** /login/refresh | get authentication tokens using refresh token
*MachinesApi* | [**get_machines**](docs/MachinesApi.md#get_machines) | **GET** /machines | Get all machines
*NFSApi* | [**add_client_group_rule**](docs/NFSApi.md#add_client_group_rule) | **POST** /nfs/clientGroups/{uid}/rules | create rule for nfs client group
*NFSApi* | [**add_nfs_permission**](docs/NFSApi.md#add_nfs_permission) | **POST** /nfs/permissions | Add NFS permission
*NFSApi* | [**create_client_group**](docs/NFSApi.md#create_client_group) | **POST** /nfs/clientGroups | Create nfs client group
*NFSApi* | [**delete_client_group**](docs/NFSApi.md#delete_client_group) | **DELETE** /nfs/clientGroups/{uid} | Delete nfs client group
*NFSApi* | [**delete_client_group_rule**](docs/NFSApi.md#delete_client_group_rule) | **DELETE** /nfs/clientGroups/{uid}/rules/{rule_uid} | Delete rule for nfs client group
*NFSApi* | [**delete_nfs_permission**](docs/NFSApi.md#delete_nfs_permission) | **DELETE** /nfs/permissions/{uid} | Remove NFS permission
*NFSApi* | [**get_client_group**](docs/NFSApi.md#get_client_group) | **GET** /nfs/clientGroups/{uid} | Get nfs client group
*NFSApi* | [**get_client_groups**](docs/NFSApi.md#get_client_groups) | **GET** /nfs/clientGroups | Get all nfs client groups
*NFSApi* | [**get_nfs_global_config**](docs/NFSApi.md#get_nfs_global_config) | **GET** /nfs/globalConfig | Get NFS global configuration
*NFSApi* | [**get_nfs_permission**](docs/NFSApi.md#get_nfs_permission) | **GET** /nfs/permissions/{uid} | Get NFS permission
*NFSApi* | [**get_nfs_permissions**](docs/NFSApi.md#get_nfs_permissions) | **GET** /nfs/permissions | Get NFS permissions
*NFSApi* | [**update_nfs_global_config**](docs/NFSApi.md#update_nfs_global_config) | **PUT** /nfs/globalConfig | Update NFS global configuration
*NFSApi* | [**update_nfs_permission**](docs/NFSApi.md#update_nfs_permission) | **PUT** /nfs/permissions/{uid} | Update NFS permission
*NodesApi* | [**get_node**](docs/NodesApi.md#get_node) | **GET** /nodes/{uid} | Get node
*NodesApi* | [**get_nodes**](docs/NodesApi.md#get_nodes) | **GET** /nodes | Get all nodes
*ObjectStoreApi* | [**update_obs**](docs/ObjectStoreApi.md#update_obs) | **PUT** /objectStores/{uid} | Update object store
*ObjectStoreBucketApi* | [**create_obs_bucket**](docs/ObjectStoreBucketApi.md#create_obs_bucket) | **POST** /objectStoreBuckets | Create object store bucket
*ObjectStoreBucketApi* | [**delete_obs_bucket**](docs/ObjectStoreBucketApi.md#delete_obs_bucket) | **DELETE** /objectStoreBuckets/{uid} | Delete object store bucket
*ObjectStoreBucketApi* | [**get_all_obs_buckets**](docs/ObjectStoreBucketApi.md#get_all_obs_buckets) | **GET** /objectStoreBuckets | Get all object store buckets
*ObjectStoreBucketApi* | [**get_obs_buckets**](docs/ObjectStoreBucketApi.md#get_obs_buckets) | **GET** /objectStoreBuckets/{uid} | Get object store bucket
*ObjectStoreBucketApi* | [**get_obs_operations**](docs/ObjectStoreBucketApi.md#get_obs_operations) | **GET** /objectStoreBuckets/{uid}/operations | Get object store bucket operations
*ObjectStoreBucketApi* | [**update_obs_bucket**](docs/ObjectStoreBucketApi.md#update_obs_bucket) | **PUT** /objectStoreBuckets/{uid} | Update object store bucket
*OrganizationApi* | [**create_organization**](docs/OrganizationApi.md#create_organization) | **POST** /organizations | Create organization
*OrganizationApi* | [**delete_organization**](docs/OrganizationApi.md#delete_organization) | **DELETE** /organizations/{uid} | Delete organization
*OrganizationApi* | [**get_multiple_org_exist**](docs/OrganizationApi.md#get_multiple_org_exist) | **GET** /organizations/multipleOrgsExist | Get if multiple Organizations Exist
*OrganizationApi* | [**get_organization**](docs/OrganizationApi.md#get_organization) | **GET** /organizations/{uid} | Get organization
*OrganizationApi* | [**get_organizations**](docs/OrganizationApi.md#get_organizations) | **GET** /organizations | Get all organizations
*OrganizationApi* | [**set_organization_limit**](docs/OrganizationApi.md#set_organization_limit) | **PUT** /organizations/{uid}/limits | Set organization capacity limits
*OrganizationApi* | [**update_organization**](docs/OrganizationApi.md#update_organization) | **PUT** /organizations/{uid} | update organization
*QuotaApi* | [**delete_quota**](docs/QuotaApi.md#delete_quota) | **DELETE** /fileSystems/{uid}/quota/{inode_context} | Remove the quota from a directory
*QuotaApi* | [**get_quota**](docs/QuotaApi.md#get_quota) | **GET** /fileSystems/{uid}/quota/{inode_context} | Get the parameters of a specific directory quota
*QuotaApi* | [**get_quota_deprecated**](docs/QuotaApi.md#get_quota_deprecated) | **GET** /quota | Get file system quota
*QuotaApi* | [**list_quotas**](docs/QuotaApi.md#list_quotas) | **GET** /fileSystems/{uid}/quota/ | Get a list of quotas in the file system
*QuotaApi* | [**patch_quota**](docs/QuotaApi.md#patch_quota) | **PATCH** /fileSystems/{uid}/quota/{inode_context} | Patch the parameters of a directory quota
*QuotaApi* | [**put_quota**](docs/QuotaApi.md#put_quota) | **PUT** /fileSystems/{uid}/quota/{inode_context} | Set a quota on a directory
*S3Api* | [**attach_s3_policy**](docs/S3Api.md#attach_s3_policy) | **POST** /s3/policies/attach | Attach an S3 IAM policy to a user
*S3Api* | [**create_s3_bucket**](docs/S3Api.md#create_s3_bucket) | **POST** /s3/buckets | Create an S3 bucket
*S3Api* | [**create_s3_cluster**](docs/S3Api.md#create_s3_cluster) | **POST** /s3 | Create S3 cluster
*S3Api* | [**create_s3_policy**](docs/S3Api.md#create_s3_policy) | **POST** /s3/policies | Create an S3 IAM policy
*S3Api* | [**delete_s3_cluster**](docs/S3Api.md#delete_s3_cluster) | **DELETE** /s3 | Delete S3 cluster
*S3Api* | [**delete_s3_policy**](docs/S3Api.md#delete_s3_policy) | **DELETE** /s3/policies/{policy} | Delete an S3 IAM policy
*S3Api* | [**destroy_s3_bucket**](docs/S3Api.md#destroy_s3_bucket) | **DELETE** /s3/buckets/{bucket} | Destroy an S3 bucket
*S3Api* | [**detach_s3_policy**](docs/S3Api.md#detach_s3_policy) | **POST** /s3/policies/detach | Detach a user&#x27;s policy
*S3Api* | [**get_s3_bucket_disk_usage**](docs/S3Api.md#get_s3_bucket_disk_usage) | **GET** /s3/buckets/{bucket}/diskUsage | Get the disk usage of an S3 bucket
*S3Api* | [**get_s3_bucket_policy**](docs/S3Api.md#get_s3_bucket_policy) | **GET** /s3/buckets/{bucket}/policy | Get the S3 bucket policy
*S3Api* | [**get_s3_bucket_policy_json**](docs/S3Api.md#get_s3_bucket_policy_json) | **GET** /s3/buckets/{bucket}/policyJson | Get the S3 bucket policy json
*S3Api* | [**get_s3_buckets**](docs/S3Api.md#get_s3_buckets) | **GET** /s3/buckets | Get S3 buckets list
*S3Api* | [**get_s3_cluster**](docs/S3Api.md#get_s3_cluster) | **GET** /s3 | Get S3 cluster info
*S3Api* | [**get_s3_policies**](docs/S3Api.md#get_s3_policies) | **GET** /s3/policies | Get S3 IAM policies list
*S3Api* | [**get_s3_policy**](docs/S3Api.md#get_s3_policy) | **GET** /s3/policies/{policy} | Get the details of an S3 IAM policy
*S3Api* | [**gets3_containers_are_ready**](docs/S3Api.md#gets3_containers_are_ready) | **GET** /s3/containersAreReady | Get S3 Hosts status
*S3Api* | [**s3_create_lifecycle_rule**](docs/S3Api.md#s3_create_lifecycle_rule) | **POST** /s3/buckets/{bucket}/lifecycle/rules | Create a new bucket lifecycle rule
*S3Api* | [**s3_delete_all_lifecycle_rules**](docs/S3Api.md#s3_delete_all_lifecycle_rules) | **DELETE** /s3/buckets/{bucket}/lifecycle/rules | Delete all lifecycle rules of a specific bucket
*S3Api* | [**s3_delete_lifecycle_rule**](docs/S3Api.md#s3_delete_lifecycle_rule) | **DELETE** /s3/buckets/{bucket}/lifecycle/rules/{rule} | Delete a bucket lifecycle rule
*S3Api* | [**s3_list_all_lifecycle_rules**](docs/S3Api.md#s3_list_all_lifecycle_rules) | **GET** /s3/buckets/{bucket}/lifecycle/rules | List all lifecycle rules of a specific bucket
*S3Api* | [**s3_sts_create**](docs/S3Api.md#s3_sts_create) | **POST** /s3/sts | Create an s3 sts token with an assumend role
*S3Api* | [**set_s3_bucket_policy**](docs/S3Api.md#set_s3_bucket_policy) | **PUT** /s3/buckets/{bucket}/policy | Set S3 bucket policy
*S3Api* | [**set_s3_bucket_policy_json**](docs/S3Api.md#set_s3_bucket_policy_json) | **PUT** /s3/buckets/{bucket}/policyJson | Set S3 bucket policy json
*S3Api* | [**set_s3_bucket_quota**](docs/S3Api.md#set_s3_bucket_quota) | **PUT** /s3/buckets/{bucket}/quota | Set S3 bucket quota
*S3Api* | [**unset_s3_bucket_quota**](docs/S3Api.md#unset_s3_bucket_quota) | **DELETE** /s3/buckets/{bucket}/quota | Unset S3 bucket quota
*S3Api* | [**update_s3_cluster**](docs/S3Api.md#update_s3_cluster) | **PUT** /s3 | Update S3 cluster
*SMBApi* | [**add_samba_domain**](docs/SMBApi.md#add_samba_domain) | **POST** /smb/domains | Add trusted domain to smb
*SMBApi* | [**add_share_to_samba**](docs/SMBApi.md#add_share_to_samba) | **POST** /smb/shares | add share to smb
*SMBApi* | [**add_user_to_samba**](docs/SMBApi.md#add_user_to_samba) | **POST** /smb/users/{share_uid}/{user_type} | Add user to smb
*SMBApi* | [**clear_samba**](docs/SMBApi.md#clear_samba) | **DELETE** /smb | Clear smb cluster info
*SMBApi* | [**delete_samba_active_directory**](docs/SMBApi.md#delete_samba_active_directory) | **PUT** /smb/activeDirectory | Leave smb active directory
*SMBApi* | [**delete_samba_domain**](docs/SMBApi.md#delete_samba_domain) | **DELETE** /smb/domains/{uid} | Delete smb domain
*SMBApi* | [**delete_samba_share**](docs/SMBApi.md#delete_samba_share) | **DELETE** /smb/shares/{uid} | Delete smb share
*SMBApi* | [**delete_samba_user**](docs/SMBApi.md#delete_samba_user) | **DELETE** /smb/users/{share_uid}/{user_type}/{user} | Delete smb user
*SMBApi* | [**get_samba**](docs/SMBApi.md#get_samba) | **GET** /smb | Get smb cluster info
*SMBApi* | [**get_samba_containers_are_ready**](docs/SMBApi.md#get_samba_containers_are_ready) | **GET** /smb/containersAreReady | Get Samba Hosts status
*SMBApi* | [**reset_samba_users**](docs/SMBApi.md#reset_samba_users) | **DELETE** /smb/users/reset/{share_uid}/{user_type} | Reset smb users
*SMBApi* | [**set_samba**](docs/SMBApi.md#set_samba) | **POST** /smb | Set smb cluster info
*SMBApi* | [**set_samba_active_directory**](docs/SMBApi.md#set_samba_active_directory) | **POST** /smb/activeDirectory | Join smb active directory
*SMBApi* | [**set_samba_debug**](docs/SMBApi.md#set_samba_debug) | **POST** /smb/debug | Set smb debug level
*SMBApi* | [**set_samba_domains**](docs/SMBApi.md#set_samba_domains) | **GET** /smb/domains | Get smb trusted domains
*SMBApi* | [**set_samba_mount_options**](docs/SMBApi.md#set_samba_mount_options) | **GET** /smb/mount | Get smb mount options
*SMBApi* | [**set_samba_shares**](docs/SMBApi.md#set_samba_shares) | **GET** /smb/shares | Get smb shares
*SMBApi* | [**update_samba**](docs/SMBApi.md#update_samba) | **PUT** /smb | Update smb cluster info
*SMBApi* | [**update_samba_share**](docs/SMBApi.md#update_samba_share) | **PUT** /smb/shares/{uid} | Update smb share
*SecurityApi* | [**disable_login_banner**](docs/SecurityApi.md#disable_login_banner) | **POST** /security/banner/disable | Disable login banner
*SecurityApi* | [**enable_login_banner**](docs/SecurityApi.md#enable_login_banner) | **POST** /security/banner/enable | Enable login banner
*SecurityApi* | [**get_login_banner**](docs/SecurityApi.md#get_login_banner) | **GET** /security/banner | Get the login banner
*SecurityApi* | [**get_tokens_expiry**](docs/SecurityApi.md#get_tokens_expiry) | **GET** /security/defaultTokensExpiry | Get tokens default expiry time
*SecurityApi* | [**get_tokens_expiry_deprecated**](docs/SecurityApi.md#get_tokens_expiry_deprecated) | **GET** /security/tokensExpiry | Get tokens default expiry time
*SecurityApi* | [**set_ca_cert**](docs/SecurityApi.md#set_ca_cert) | **PUT** /security/caCert | Set a CA-Cert for the cluster (Vault)
*SecurityApi* | [**set_login_banner**](docs/SecurityApi.md#set_login_banner) | **PUT** /security/banner | Set the login banner
*SecurityApi* | [**show_ca_cert**](docs/SecurityApi.md#show_ca_cert) | **GET** /security/caCert | Show the CA-Cert for the cluster (Vault)
*SecurityApi* | [**unset_ca_cert**](docs/SecurityApi.md#unset_ca_cert) | **DELETE** /security/caCert | Unset a CA-Cert for the cluster (Vault)
*SnapshotsApi* | [**copy_snapshot**](docs/SnapshotsApi.md#copy_snapshot) | **POST** /snapshots/{uid}/copy | Copy snapshot from the same file system
*SnapshotsApi* | [**create_snapshot**](docs/SnapshotsApi.md#create_snapshot) | **POST** /snapshots | Create snapshot
*SnapshotsApi* | [**delete_snapshot**](docs/SnapshotsApi.md#delete_snapshot) | **DELETE** /snapshots/{uid} | Delete snapshot
*SnapshotsApi* | [**get_snapshot**](docs/SnapshotsApi.md#get_snapshot) | **GET** /snapshots/{uid} | Get snapshot
*SnapshotsApi* | [**get_snapshots**](docs/SnapshotsApi.md#get_snapshots) | **GET** /snapshots | Get snapshots
*SnapshotsApi* | [**restore_file_system_from_snapshot**](docs/SnapshotsApi.md#restore_file_system_from_snapshot) | **POST** /snapshots/{fs_uid}/{uid}/restore | Restore file system from snapshot
*SnapshotsApi* | [**update_snapshot**](docs/SnapshotsApi.md#update_snapshot) | **PUT** /snapshots/{uid} | Update snapshot
*SnapshotsApi* | [**upload_snapshot**](docs/SnapshotsApi.md#upload_snapshot) | **POST** /snapshots/{uid}/upload | Upload snapshot to object store
*StatsApi* | [**get_real_time_stats**](docs/StatsApi.md#get_real_time_stats) | **GET** /stats/realtime | Get real time stats
*StatsApi* | [**get_stats**](docs/StatsApi.md#get_stats) | **GET** /stats | Get stats
*StatsApi* | [**get_stats_description**](docs/StatsApi.md#get_stats_description) | **GET** /stats/description | Get stats description
*StatsApi* | [**get_stats_disk_usage**](docs/StatsApi.md#get_stats_disk_usage) | **GET** /stats/retention | Get stats retention and estimated disk usage
*StatsApi* | [**get_stats_retention**](docs/StatsApi.md#get_stats_retention) | **POST** /stats/retention | Set stats retention
*SystemIOApi* | [**start_io**](docs/SystemIOApi.md#start_io) | **POST** /io/start | Start system IO
*SystemIOApi* | [**stop_io**](docs/SystemIOApi.md#stop_io) | **POST** /io/stop | Stop system IO
*TLSApi* | [**disable_tls**](docs/TLSApi.md#disable_tls) | **DELETE** /tls | Disable tls
*TLSApi* | [**enable_tls**](docs/TLSApi.md#enable_tls) | **POST** /tls | Enable TLS
*TLSApi* | [**get_tls**](docs/TLSApi.md#get_tls) | **GET** /tls | Get TLS status
*TasksApi* | [**abort_tasks**](docs/TasksApi.md#abort_tasks) | **POST** /tasks/{uid}/abort | Abort task
*TasksApi* | [**get_tasks**](docs/TasksApi.md#get_tasks) | **GET** /tasks | Get all cluster tasks
*TasksApi* | [**get_tasks_limit**](docs/TasksApi.md#get_tasks_limit) | **GET** /tasks/limits | Get cluster tasks limit
*TasksApi* | [**pause_tasks**](docs/TasksApi.md#pause_tasks) | **POST** /tasks/{uid}/pause | Pause task
*TasksApi* | [**resume_task**](docs/TasksApi.md#resume_task) | **POST** /tasks/{uid}/resume | Resume task
*TasksApi* | [**set_tasks_limit**](docs/TasksApi.md#set_tasks_limit) | **PUT** /tasks/limits | Set cluster tasks limit
*UserApi* | [**create_user**](docs/UserApi.md#create_user) | **POST** /users | Create user
*UserApi* | [**delete_user**](docs/UserApi.md#delete_user) | **DELETE** /users/{uid} | Delete user
*UserApi* | [**get_users**](docs/UserApi.md#get_users) | **GET** /users | Get all users
*UserApi* | [**revoke_user**](docs/UserApi.md#revoke_user) | **DELETE** /users/{uid}/revoke | Revoke user tokens
*UserApi* | [**update_user**](docs/UserApi.md#update_user) | **PUT** /users/{uid} | Update user
*UserApi* | [**update_user_password**](docs/UserApi.md#update_user_password) | **PUT** /users/password | Update user password
*UserApi* | [**who_am_i**](docs/UserApi.md#who_am_i) | **GET** /users/whoami | Get user info
*WekaHomeApi* | [**disable_cloud**](docs/WekaHomeApi.md#disable_cloud) | **POST** /wekaHome/disable | Disable cloud
*WekaHomeApi* | [**enable_cloud**](docs/WekaHomeApi.md#enable_cloud) | **POST** /wekaHome/enable | Enable cloud
*WekaHomeApi* | [**get_cloud**](docs/WekaHomeApi.md#get_cloud) | **GET** /wekaHome | Get cloud config
*WekaHomeApi* | [**get_cloud_proxy**](docs/WekaHomeApi.md#get_cloud_proxy) | **GET** /wekaHome/proxy | Get cloud proxy
*WekaHomeApi* | [**get_cloud_upload_rate**](docs/WekaHomeApi.md#get_cloud_upload_rate) | **GET** /wekaHome/uploadRate | Get cloud upload rate
*WekaHomeApi* | [**get_cloud_url**](docs/WekaHomeApi.md#get_cloud_url) | **GET** /wekaHome/url | Get cloud url
*WekaHomeApi* | [**set_cloud_proxy**](docs/WekaHomeApi.md#set_cloud_proxy) | **POST** /wekaHome/proxy | Set cloud proxy
*WekaHomeApi* | [**update_cloud_upload_rate**](docs/WekaHomeApi.md#update_cloud_upload_rate) | **PUT** /wekaHome/uploadRate | Update cloud upload rate

## Documentation For Models

 - [ActiveDirectoryBody](docs/ActiveDirectoryBody.md)
 - [Alert](docs/Alert.md)
 - [AlertTypeMuteBody](docs/AlertTypeMuteBody.md)
 - [BucketPolicyBody](docs/BucketPolicyBody.md)
 - [BucketPolicyJsonBody](docs/BucketPolicyJsonBody.md)
 - [BucketQuotaBody](docs/BucketQuotaBody.md)
 - [ClientGroup](docs/ClientGroup.md)
 - [ClientGroupRules](docs/ClientGroupRules.md)
 - [ClusterBody](docs/ClusterBody.md)
 - [ClusterBody1](docs/ClusterBody1.md)
 - [DefaultNet](docs/DefaultNet.md)
 - [Drive](docs/Drive.md)
 - [DrivesActivateBody](docs/DrivesActivateBody.md)
 - [DrivesBody](docs/DrivesBody.md)
 - [DrivesDeactivateBody](docs/DrivesDeactivateBody.md)
 - [Event](docs/Event.md)
 - [EventDescription](docs/EventDescription.md)
 - [EventParams](docs/EventParams.md)
 - [FailureDomain](docs/FailureDomain.md)
 - [FileSystem](docs/FileSystem.md)
 - [FileSystemGroup](docs/FileSystemGroup.md)
 - [FileSystemGroupsBody](docs/FileSystemGroupsBody.md)
 - [FileSystemGroupsUidBody](docs/FileSystemGroupsUidBody.md)
 - [FileSystemObjectStorages](docs/FileSystemObjectStorages.md)
 - [FileSystemsBody](docs/FileSystemsBody.md)
 - [FileSystemsDownloadBody](docs/FileSystemsDownloadBody.md)
 - [FileSystemsUidBody](docs/FileSystemsUidBody.md)
 - [Host](docs/Host.md)
 - [HostAws](docs/HostAws.md)
 - [HostOsInfo](docs/HostOsInfo.md)
 - [HostOsInfoDrivers](docs/HostOsInfoDrivers.md)
 - [HostResource](docs/HostResource.md)
 - [HostResourceData](docs/HostResourceData.md)
 - [HostResourceDataBackendEndpoints](docs/HostResourceDataBackendEndpoints.md)
 - [HostResourceDataNodes](docs/HostResourceDataNodes.md)
 - [HostResourceDataNodes0](docs/HostResourceDataNodes0.md)
 - [HostResourceDataNodes1](docs/HostResourceDataNodes1.md)
 - [HostsActivateBody](docs/HostsActivateBody.md)
 - [HostsApplyBody](docs/HostsApplyBody.md)
 - [HostsBody](docs/HostsBody.md)
 - [HostsDeactivateBody](docs/HostsDeactivateBody.md)
 - [HostsUidBody](docs/HostsUidBody.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [InlineResponse2001](docs/InlineResponse2001.md)
 - [InlineResponse20010](docs/InlineResponse20010.md)
 - [InlineResponse20011](docs/InlineResponse20011.md)
 - [InlineResponse20011Data](docs/InlineResponse20011Data.md)
 - [InlineResponse20011EventFields](docs/InlineResponse20011EventFields.md)
 - [InlineResponse20012](docs/InlineResponse20012.md)
 - [InlineResponse20013](docs/InlineResponse20013.md)
 - [InlineResponse20014](docs/InlineResponse20014.md)
 - [InlineResponse20015](docs/InlineResponse20015.md)
 - [InlineResponse20016](docs/InlineResponse20016.md)
 - [InlineResponse20017](docs/InlineResponse20017.md)
 - [InlineResponse20018](docs/InlineResponse20018.md)
 - [InlineResponse20019](docs/InlineResponse20019.md)
 - [InlineResponse2002](docs/InlineResponse2002.md)
 - [InlineResponse20020](docs/InlineResponse20020.md)
 - [InlineResponse20020Data](docs/InlineResponse20020Data.md)
 - [InlineResponse20020Data0x0000092ddf3d00000](docs/InlineResponse20020Data0x0000092ddf3d00000.md)
 - [InlineResponse20021](docs/InlineResponse20021.md)
 - [InlineResponse20022](docs/InlineResponse20022.md)
 - [InlineResponse20022Data](docs/InlineResponse20022Data.md)
 - [InlineResponse20022Data0x0000092ddf3d00000](docs/InlineResponse20022Data0x0000092ddf3d00000.md)
 - [InlineResponse20023](docs/InlineResponse20023.md)
 - [InlineResponse20023Data](docs/InlineResponse20023Data.md)
 - [InlineResponse20023Data0x0000092ddf3d00000](docs/InlineResponse20023Data0x0000092ddf3d00000.md)
 - [InlineResponse20024](docs/InlineResponse20024.md)
 - [InlineResponse20025](docs/InlineResponse20025.md)
 - [InlineResponse20026](docs/InlineResponse20026.md)
 - [InlineResponse20026Data](docs/InlineResponse20026Data.md)
 - [InlineResponse20026DataDisks](docs/InlineResponse20026DataDisks.md)
 - [InlineResponse20026DataNet](docs/InlineResponse20026DataNet.md)
 - [InlineResponse20026DataNetInterfaces](docs/InlineResponse20026DataNetInterfaces.md)
 - [InlineResponse20027](docs/InlineResponse20027.md)
 - [InlineResponse20028](docs/InlineResponse20028.md)
 - [InlineResponse20029](docs/InlineResponse20029.md)
 - [InlineResponse2002Data](docs/InlineResponse2002Data.md)
 - [InlineResponse2003](docs/InlineResponse2003.md)
 - [InlineResponse20030](docs/InlineResponse20030.md)
 - [InlineResponse20031](docs/InlineResponse20031.md)
 - [InlineResponse20031Data](docs/InlineResponse20031Data.md)
 - [InlineResponse20032](docs/InlineResponse20032.md)
 - [InlineResponse20032Data](docs/InlineResponse20032Data.md)
 - [InlineResponse20032DataResult](docs/InlineResponse20032DataResult.md)
 - [InlineResponse20033](docs/InlineResponse20033.md)
 - [InlineResponse20033Data](docs/InlineResponse20033Data.md)
 - [InlineResponse20033DataResult](docs/InlineResponse20033DataResult.md)
 - [InlineResponse20034](docs/InlineResponse20034.md)
 - [InlineResponse20034Data](docs/InlineResponse20034Data.md)
 - [InlineResponse20034DataParams](docs/InlineResponse20034DataParams.md)
 - [InlineResponse20035](docs/InlineResponse20035.md)
 - [InlineResponse20036](docs/InlineResponse20036.md)
 - [InlineResponse20036Data](docs/InlineResponse20036Data.md)
 - [InlineResponse20036DataRoleGroups](docs/InlineResponse20036DataRoleGroups.md)
 - [InlineResponse20037](docs/InlineResponse20037.md)
 - [InlineResponse20037Data](docs/InlineResponse20037Data.md)
 - [InlineResponse20037DataLimits](docs/InlineResponse20037DataLimits.md)
 - [InlineResponse20037DataUsage](docs/InlineResponse20037DataUsage.md)
 - [InlineResponse20038](docs/InlineResponse20038.md)
 - [InlineResponse20039](docs/InlineResponse20039.md)
 - [InlineResponse2004](docs/InlineResponse2004.md)
 - [InlineResponse20040](docs/InlineResponse20040.md)
 - [InlineResponse20041](docs/InlineResponse20041.md)
 - [InlineResponse20042](docs/InlineResponse20042.md)
 - [InlineResponse20042Data](docs/InlineResponse20042Data.md)
 - [InlineResponse20043](docs/InlineResponse20043.md)
 - [InlineResponse20044](docs/InlineResponse20044.md)
 - [InlineResponse20044Data](docs/InlineResponse20044Data.md)
 - [InlineResponse20045](docs/InlineResponse20045.md)
 - [InlineResponse20046](docs/InlineResponse20046.md)
 - [InlineResponse20047](docs/InlineResponse20047.md)
 - [InlineResponse20048](docs/InlineResponse20048.md)
 - [InlineResponse20049](docs/InlineResponse20049.md)
 - [InlineResponse2004Data](docs/InlineResponse2004Data.md)
 - [InlineResponse2004DataActivity](docs/InlineResponse2004DataActivity.md)
 - [InlineResponse2004DataBlockUpgradeTask](docs/InlineResponse2004DataBlockUpgradeTask.md)
 - [InlineResponse2004DataBuckets](docs/InlineResponse2004DataBuckets.md)
 - [InlineResponse2004DataBucketsInfo](docs/InlineResponse2004DataBucketsInfo.md)
 - [InlineResponse2004DataBucketsInfoThinProvisionState](docs/InlineResponse2004DataBucketsInfoThinProvisionState.md)
 - [InlineResponse2004DataBucketsInfoThinProvisionStateShrinkageFactor](docs/InlineResponse2004DataBucketsInfoThinProvisionStateShrinkageFactor.md)
 - [InlineResponse2004DataCapacity](docs/InlineResponse2004DataCapacity.md)
 - [InlineResponse2004DataCloud](docs/InlineResponse2004DataCloud.md)
 - [InlineResponse2004DataDrives](docs/InlineResponse2004DataDrives.md)
 - [InlineResponse2004DataGrimReaper](docs/InlineResponse2004DataGrimReaper.md)
 - [InlineResponse2004DataHangingIos](docs/InlineResponse2004DataHangingIos.md)
 - [InlineResponse2004DataHosts](docs/InlineResponse2004DataHosts.md)
 - [InlineResponse2004DataHostsClients](docs/InlineResponse2004DataHostsClients.md)
 - [InlineResponse2004DataLicensing](docs/InlineResponse2004DataLicensing.md)
 - [InlineResponse2004DataLicensingLimits](docs/InlineResponse2004DataLicensingLimits.md)
 - [InlineResponse2004DataLicensingUsage](docs/InlineResponse2004DataLicensingUsage.md)
 - [InlineResponse2004DataNet](docs/InlineResponse2004DataNet.md)
 - [InlineResponse2004DataNodes](docs/InlineResponse2004DataNodes.md)
 - [InlineResponse2004DataOverlay](docs/InlineResponse2004DataOverlay.md)
 - [InlineResponse2004DataOverlayClientNodesSafetyHistogram](docs/InlineResponse2004DataOverlayClientNodesSafetyHistogram.md)
 - [InlineResponse2004DataRebuild](docs/InlineResponse2004DataRebuild.md)
 - [InlineResponse2004DataRebuildProtectionState](docs/InlineResponse2004DataRebuildProtectionState.md)
 - [InlineResponse2004DataTime](docs/InlineResponse2004DataTime.md)
 - [InlineResponse2005](docs/InlineResponse2005.md)
 - [InlineResponse20050](docs/InlineResponse20050.md)
 - [InlineResponse20050Data](docs/InlineResponse20050Data.md)
 - [InlineResponse20050DataInfo](docs/InlineResponse20050DataInfo.md)
 - [InlineResponse20050DataInfoCounts](docs/InlineResponse20050DataInfoCounts.md)
 - [InlineResponse20050DataInfoExtentSpec](docs/InlineResponse20050DataInfoExtentSpec.md)
 - [InlineResponse20050DataInfoExtentSpecExtentKey](docs/InlineResponse20050DataInfoExtentSpecExtentKey.md)
 - [InlineResponse20050DataInfoStartTime](docs/InlineResponse20050DataInfoStartTime.md)
 - [InlineResponse20050DataNodeId121](docs/InlineResponse20050DataNodeId121.md)
 - [InlineResponse20051](docs/InlineResponse20051.md)
 - [InlineResponse20052](docs/InlineResponse20052.md)
 - [InlineResponse20053](docs/InlineResponse20053.md)
 - [InlineResponse20054](docs/InlineResponse20054.md)
 - [InlineResponse20054Data](docs/InlineResponse20054Data.md)
 - [InlineResponse20054Data0x0000092ddf3d00000](docs/InlineResponse20054Data0x0000092ddf3d00000.md)
 - [InlineResponse20055](docs/InlineResponse20055.md)
 - [InlineResponse20056](docs/InlineResponse20056.md)
 - [InlineResponse20057](docs/InlineResponse20057.md)
 - [InlineResponse20058](docs/InlineResponse20058.md)
 - [InlineResponse20058Data](docs/InlineResponse20058Data.md)
 - [InlineResponse20059](docs/InlineResponse20059.md)
 - [InlineResponse20059Data](docs/InlineResponse20059Data.md)
 - [InlineResponse2005Data](docs/InlineResponse2005Data.md)
 - [InlineResponse2006](docs/InlineResponse2006.md)
 - [InlineResponse20060](docs/InlineResponse20060.md)
 - [InlineResponse20061](docs/InlineResponse20061.md)
 - [InlineResponse20061Data](docs/InlineResponse20061Data.md)
 - [InlineResponse20062](docs/InlineResponse20062.md)
 - [InlineResponse20062Data](docs/InlineResponse20062Data.md)
 - [InlineResponse20063](docs/InlineResponse20063.md)
 - [InlineResponse20063Data](docs/InlineResponse20063Data.md)
 - [InlineResponse20064](docs/InlineResponse20064.md)
 - [InlineResponse20064Data](docs/InlineResponse20064Data.md)
 - [InlineResponse20065](docs/InlineResponse20065.md)
 - [InlineResponse20066](docs/InlineResponse20066.md)
 - [InlineResponse20067](docs/InlineResponse20067.md)
 - [InlineResponse20068](docs/InlineResponse20068.md)
 - [InlineResponse20069](docs/InlineResponse20069.md)
 - [InlineResponse2006Data](docs/InlineResponse2006Data.md)
 - [InlineResponse2007](docs/InlineResponse2007.md)
 - [InlineResponse20070](docs/InlineResponse20070.md)
 - [InlineResponse20071](docs/InlineResponse20071.md)
 - [InlineResponse20072](docs/InlineResponse20072.md)
 - [InlineResponse20073](docs/InlineResponse20073.md)
 - [InlineResponse20073Data](docs/InlineResponse20073Data.md)
 - [InlineResponse20074](docs/InlineResponse20074.md)
 - [InlineResponse20074Data](docs/InlineResponse20074Data.md)
 - [InlineResponse20074DataAll](docs/InlineResponse20074DataAll.md)
 - [InlineResponse20075](docs/InlineResponse20075.md)
 - [InlineResponse20075Data](docs/InlineResponse20075Data.md)
 - [InlineResponse20075DataRESPONSECOUNTLENGTHREQUIRED](docs/InlineResponse20075DataRESPONSECOUNTLENGTHREQUIRED.md)
 - [InlineResponse20076](docs/InlineResponse20076.md)
 - [InlineResponse20076Data](docs/InlineResponse20076Data.md)
 - [InlineResponse20077](docs/InlineResponse20077.md)
 - [InlineResponse20077Data](docs/InlineResponse20077Data.md)
 - [InlineResponse20078](docs/InlineResponse20078.md)
 - [InlineResponse20078Data](docs/InlineResponse20078Data.md)
 - [InlineResponse20078Params](docs/InlineResponse20078Params.md)
 - [InlineResponse20079](docs/InlineResponse20079.md)
 - [InlineResponse20079Data](docs/InlineResponse20079Data.md)
 - [InlineResponse2008](docs/InlineResponse2008.md)
 - [InlineResponse20080](docs/InlineResponse20080.md)
 - [InlineResponse20080Data](docs/InlineResponse20080Data.md)
 - [InlineResponse20081](docs/InlineResponse20081.md)
 - [InlineResponse20082](docs/InlineResponse20082.md)
 - [InlineResponse20083](docs/InlineResponse20083.md)
 - [InlineResponse20083Data](docs/InlineResponse20083Data.md)
 - [InlineResponse20084](docs/InlineResponse20084.md)
 - [InlineResponse20084Data](docs/InlineResponse20084Data.md)
 - [InlineResponse20084DataHosts](docs/InlineResponse20084DataHosts.md)
 - [InlineResponse20084DataHostsHostId0](docs/InlineResponse20084DataHostsHostId0.md)
 - [InlineResponse20085](docs/InlineResponse20085.md)
 - [InlineResponse20085Data](docs/InlineResponse20085Data.md)
 - [InlineResponse20086](docs/InlineResponse20086.md)
 - [InlineResponse20087](docs/InlineResponse20087.md)
 - [InlineResponse2009](docs/InlineResponse2009.md)
 - [InlineResponse400](docs/InlineResponse400.md)
 - [InlineResponse400Data](docs/InlineResponse400Data.md)
 - [InlineResponse401](docs/InlineResponse401.md)
 - [InlineResponse404](docs/InlineResponse404.md)
 - [InterfaceGroup](docs/InterfaceGroup.md)
 - [InterfaceGroupPorts](docs/InterfaceGroupPorts.md)
 - [InterfaceGroupsBody](docs/InterfaceGroupsBody.md)
 - [InterfaceGroupsPortBody](docs/InterfaceGroupsPortBody.md)
 - [InterfaceGroupsUidBody](docs/InterfaceGroupsUidBody.md)
 - [IoStopBody](docs/IoStopBody.md)
 - [KmsBody](docs/KmsBody.md)
 - [KmsRewrapBody](docs/KmsRewrapBody.md)
 - [LdapBody](docs/LdapBody.md)
 - [LdapRoleGroups](docs/LdapRoleGroups.md)
 - [LicenseBody](docs/LicenseBody.md)
 - [LifecycleRulesBody](docs/LifecycleRulesBody.md)
 - [LoginBody](docs/LoginBody.md)
 - [LoginRefreshBody](docs/LoginRefreshBody.md)
 - [Machines](docs/Machines.md)
 - [MachinesDrives](docs/MachinesDrives.md)
 - [MachinesNodes](docs/MachinesNodes.md)
 - [Netdev](docs/Netdev.md)
 - [NetdevAws](docs/NetdevAws.md)
 - [NetdevNetDevices](docs/NetdevNetDevices.md)
 - [NfsClientGroupsBody](docs/NfsClientGroupsBody.md)
 - [NfsGlobalConfigBody](docs/NfsGlobalConfigBody.md)
 - [NfsPermission](docs/NfsPermission.md)
 - [NfsPermissionsBody](docs/NfsPermissionsBody.md)
 - [Node](docs/Node.md)
 - [NodeDpdkPortInfo](docs/NodeDpdkPortInfo.md)
 - [ObjectStore](docs/ObjectStore.md)
 - [ObjectStoreBandwidth](docs/ObjectStoreBandwidth.md)
 - [ObjectStoreBucket](docs/ObjectStoreBucket.md)
 - [ObjectStoreBucketsBody](docs/ObjectStoreBucketsBody.md)
 - [ObjectStoreBucketsUidBody](docs/ObjectStoreBucketsUidBody.md)
 - [ObjectStoreUploadBandwidth](docs/ObjectStoreUploadBandwidth.md)
 - [ObjectStoresUidBody](docs/ObjectStoresUidBody.md)
 - [Organization](docs/Organization.md)
 - [OrganizationsBody](docs/OrganizationsBody.md)
 - [OrganizationsUidBody](docs/OrganizationsUidBody.md)
 - [Param](docs/Param.md)
 - [PermissionsUidBody](docs/PermissionsUidBody.md)
 - [PoliciesAttachBody](docs/PoliciesAttachBody.md)
 - [PoliciesDetachBody](docs/PoliciesDetachBody.md)
 - [PortsHostUidBody](docs/PortsHostUidBody.md)
 - [S3Body](docs/S3Body.md)
 - [S3Body1](docs/S3Body1.md)
 - [S3BucketsBody](docs/S3BucketsBody.md)
 - [S3PoliciesBody](docs/S3PoliciesBody.md)
 - [S3StsBody](docs/S3StsBody.md)
 - [SecurityBannerBody](docs/SecurityBannerBody.md)
 - [SecurityCaCertBody](docs/SecurityCaCertBody.md)
 - [ShareUidUserTypeBody](docs/ShareUidUserTypeBody.md)
 - [SharesUidBody](docs/SharesUidBody.md)
 - [SmbActiveDirectoryBody](docs/SmbActiveDirectoryBody.md)
 - [SmbActiveDirectoryBody1](docs/SmbActiveDirectoryBody1.md)
 - [SmbBody](docs/SmbBody.md)
 - [SmbBody1](docs/SmbBody1.md)
 - [SmbDebugBody](docs/SmbDebugBody.md)
 - [SmbDomain](docs/SmbDomain.md)
 - [SmbDomainsBody](docs/SmbDomainsBody.md)
 - [SmbShare](docs/SmbShare.md)
 - [SmbSharesBody](docs/SmbSharesBody.md)
 - [Snapshot](docs/Snapshot.md)
 - [SnapshotsBody](docs/SnapshotsBody.md)
 - [SnapshotsUidBody](docs/SnapshotsUidBody.md)
 - [StatsRetentionBody](docs/StatsRetentionBody.md)
 - [TasksLimitsBody](docs/TasksLimitsBody.md)
 - [ThinProvisionReserve](docs/ThinProvisionReserve.md)
 - [ThinProvisionReserveOrgUidBody](docs/ThinProvisionReserveOrgUidBody.md)
 - [TlsBody](docs/TlsBody.md)
 - [Tokens](docs/Tokens.md)
 - [UidCopyBody](docs/UidCopyBody.md)
 - [UidIpsBody](docs/UidIpsBody.md)
 - [UidLimitsBody](docs/UidLimitsBody.md)
 - [UidNetdevsBody](docs/UidNetdevsBody.md)
 - [UidObjectStoreBucketsBody](docs/UidObjectStoreBucketsBody.md)
 - [UidObjectStoresBody](docs/UidObjectStoresBody.md)
 - [UidRulesBody](docs/UidRulesBody.md)
 - [UidUploadBody](docs/UidUploadBody.md)
 - [User](docs/User.md)
 - [UsersBody](docs/UsersBody.md)
 - [UsersPasswordBody](docs/UsersPasswordBody.md)
 - [UsersUidBody](docs/UsersUidBody.md)
 - [WekaHomeEnableBody](docs/WekaHomeEnableBody.md)
 - [WekaHomeProxyBody](docs/WekaHomeProxyBody.md)
 - [WekaHomeUploadRateBody](docs/WekaHomeUploadRateBody.md)

## Documentation For Authorization


## bearerAuth



## Author


