import os
import tempfile


class UA:
    UA_API = 'https://oe80gil0wa.execute-api.ap-south-1.amazonaws.com/default/filter_user_agents'
    UA_DIRECTORY = tempfile.gettempdir()
    UA_LOCAL_DB_STORAGE_PATH = os.path.join(
        UA_DIRECTORY, 'cherry_ua_list.json')
    UA_SAVED_FILTER_PATH = os.path.join(UA_DIRECTORY, 'cherry_ua_filters.json')


class UaFilters:
    DEVICE_LIST = ['computer', 'mobile', 'server', 'large-screen', 'vehicle']
    OS_LIST = ['mac-os-x', 'linux', 'ios', 'windows', 'windows-phone', 'android', 'macos'
               'freebsd', 'symbian', 'fire-os', 'sunos', 'chrome-os', 'blackberry-os',
               'netbsd', 'rim-tablet-os', 'os-2-warp', 'bada', 'livearea', 'a-unix-based-os',
               'openbsd', 'mac', 'hp-webos', 'amigaos', 'haiku', 'kaios', 'windows-mobile',
               'webos', 'irix']
    OS_VERSION_LIST = ['10.10.4', '10.10.5', '8.2', 'NT 6.1', 'NT 6.3', 'NT 10.0', 'NT 6.2',
                       '10.6.8', '8.4', 'NT 6.0', '10.10', '8.1', 'NT 5.1', '4.3', '8.3', '8.4.1',
                       '7.1.2', '10.8', '10.9', '10.7.5', '10.10.3', '8.1.3', '7.0.4', '10.10.1', '4.4',
                       '10.10.2', '10.8.5', '10.7', '4.4.2', '10.9.5', '10.9.2', '4.1.2', '8.1.1',
                       '10.10.0', '5.0.2', '10.6', '5.1.1', '10.9.3', '4.2.2', '4.4.4', '10.7.2',
                       '8.1.2', '10.6.3', '4.2', '10.0', '10.90', '10.5.8', '5.0.1', 'NT 5.0', '8.0.2',
                       '2.1', '4.3.2', '3.2', '5.1', '4.0.3', '7.5', '3.0.1', '7.1.1', '10.9.0', '4.1.1',
                       'NT 4.0', '2.3.6', '10.5', '4.1', '10.4', '4.2.1', '10.8.4', '4.0.4', '10.8.3',
                       '5.0', '2.3.4', '10.9.4', '10.8.2', '8.0', '10.11', 'NT 5.2', '10.7.3', '10.5.6',
                       '10.9.1', '7.0', '2.3.5', '6.0', '7077.134.0', '10.7.4', '2.0.1', '7.0.3',
                       '4.0.2', '6.0.1', '5.0.0.681', '6680.64.0', '3.0', '2.3', '7077.111.0',
                       '6.0.0.141', '10.5.4', '10.7.1', '9.0', '4.0', '10.6.6', '7.1', '7.0.6', '14.04',
                       '2.1.0', '10.4.11', '1.0.0', '9.4', '4.5', '8', '6.1.3', '2.2', '10.6.2', 'CE',
                       '2.3.3', '4.3.1', '6946.86.0', '3.1', '10.8.1', '3.2.1', '5.0.0.592', '6.1',
                       '1.0', '3.30', '7.0.2', '4.3.5', '98', '10.11.0', '6812.88.0', '15.04', '2.2.1',
                       '95', '4.3.3', '6680.81.0', '11.10', '3.52', '6.1.2', '5978.81.0', '10.5.7',
                       '9.04', '6.1.6', '5', '2.2.2', '3.2.2', '10.6.1', '2.3.2', '14.10', '2.3.7', '1',
                       '4.4.3', '9x', '10.6.0', '10.6.7', '3.1.3', '3.0.5', '7', '7077.95.0',
                       'NT 5.1 (Cygwin)', '2.0', '4.0.1', '6.1.1', '10', '7.0.1', '6.1.4', 'ME', '3',
                       '10.04', '18', '11.04', '2.4.0b', '10.8.0', '71', '6.3', '2.2.3', '3.0.7', '5.0.0',
                       '6310.68.0', '7262.52.0', '9', '5.0.0.93', '1.6', '19', '8.10', '10.12', '15',
                       '9.1', '6812.75.2', '4.6.0.278', '5.0.0.862', '5.3.0', '6.1.5', '4.1.4', '13',
                       '12.04', '9.10', '15.10', '5978.98.1', '7.10', '7077.123.0', '6310.61.0', '1090',
                       '6457.107.0', '6158.70.0', '6.0.2']
    BROWSER_LIST = ['chrome', 'safari', 'firefox', 'edge', 'internet-explorer',
                    'yahoo-slurp-web-crawler-bot', 'coc-coc', 'linkcheck-analyser',
                    'blackberry-browser', 'internet-explorer-mobile', 'chromium',
                    'webkit-based-browser', 'android-browser', 'googlebot', 'fennec',
                    'facebook-app', 'mercury-browser', 'flock', 'midori',
                    'ahrefs-backlink-research-bot', '360spider', 'openwave-mobile-browser',
                    'majestic-12-distributed-search-bot', 'dragon', 'opera', 'netfront',
                    'google-feedfetcher', 'google-search-app', 'opera-mini',
                    'google-s-media-partners-system-adsense', 'puffin', 'pinterest-bot',
                    'duckduckgo-favicons-bot', 'googlebot-mobile', 'seamonkey',
                    'gigablast-crawler', 'bingbot', 'netscape-navigator', 'pale-moon',
                    'valve-steam-game-overlay', 'lynx', 'iceweasel', 'aol-browser',
                    'nintendo-browser', 'webview-based-browser', 'nerdybot',
                    'google-weblight-proxy', 'yandex-browser', 'silk', 'samsung-browser', 'links',
                    'obigo', 'shiretoko', 'nokia-browser', 'srware-iron', 'kazehakase',
                    'domaintools-surveybot', 'miui-browser', 'proximic-search',
                    'microsoft-windows-http-services', 'maxthon', 'yandex-search-bot',
                    'unknown-bot', 'omniweb', 'dillo', 'dooble', 'elinks', 'vivaldi', 'uc-browser',
                    'comodo-icedragon', 'applebot', 'naver-in-app-search', 'konqueror',
                    'twitterbot', 'java-runtime-environment', 'office', 'w3c-css-validator',
                    'avant-browser', 'ea-origin-browser', 'wyzo', 'pinterest-app', 'word',
                    'qualys-ssl-assessment-scanner', 'playstation-4-browser', 'netcast',
                    'fast-web-crawler', 'playbook-web-browser', 'galeon', 'go-httpclient',
                    'awesomium', 'baidu-spider', 'wechat', 'waterfox', 'python-urllib-library',
                    'netsurf', 'slackbot-link-checker', 'semrush-crawler',
                    'qwantify-search-crawler', 'epiphany', 'alertsite-monitoring-bot', 'light',
                    'rockmelt', 'wget', 'facebook-bot', 'ovi', 'adobe-air', 'meanpath-bot',
                    'qt-based-browser', 'nutch-based-crawler', 'screaming-frog-crawler',
                    'dolfin', 'deepcrawl-bot', 'alexa-site-audit', 'cometbird',
                    'seznambot-crawler', 'exalead-cloudview-crawler', 'tenfourfox', 'powerpoint',
                    'qq-browser', 'excel', 'internet-tv-browser', 'gomezagent',
                    'embedded-web-browser', 'kindle-browser', 'sogou-search-dog',
                    'pro-engineer-wildfire', 'k-meleon', 'admantx-platform-semantic-analyzer',
                    'google-app-engine-software', 'opensite-explorer-crawler', 'arora',
                    'internet-channel', 'valve-steam-tenfoot-display', 'exalead-crawler',
                    'linkdex-crawler', 'w3c-line-mode-browser', 'tesla-browser', 'minefield',
                    'qupzilla', 'winamp', 'catchpoint-analyser', 'daum', 'bing-search-app',
                    'atomic-web-browser', 'go-http-client', 'lunascape',
                    'openlink-profiler-seo-analyser-bot', 'genieo-bot', 'camino', 'icab',
                    'twitter-app', 'comodo-dragon', 'netfront-browser-nx', 'tweetmeme-bot',
                    'thunderbird', 'safepay', 'nexplayer', 'cliqz-com-crawler', 'javafx-platform',
                    'startme-bot', 'netseer-crawler', 'w3c-validator',
                    'commoncrawl-crawler-node', 'iris', 'coolnovo', 'domain-re-animator-bot',
                    'webos-browser', 'msn-bot', 'qihoo-360', 'jakarta-commons-httpclient',
                    'rekonq', 'outlook', 'amaya', 'lb-browser', 'python-requests-library',
                    'library-for-www-in-perl', 'linkchecker', 'curl', 'python-based-software',
                    'httpclient', 'w3c-link-checker', 'google-web-preview-analytics-crawler',
                    'vlc', 'google-lighthouse', 'nook-web-browser', 'secondlife',
                    'google-earth-pro', 'telegrambot', 'webpositive', 'sleipnir', 'firefox-lite',
                    'speedcurve-speed-tester', 'qtwebengine-based-browser',
                    'internet-archiver-bot', 'yahoo-link-preview', '1password', 'elmedia-player',
                    'grapeshot-bot', 'onebrowser', 'f-secure-riddler-crawler',
                    'yandex-metrika-search-bot', 'maxpoint-crawler', 'google-site-verifier-bot',
                    'qq-download-manager', 'tencenttraveler', 'sogou-explorer',
                    'wise-guys-crawler', 'airwatch-browser', 'w3m', 'electron-application',
                    'theworld-browser', 'microsoft-webdav-http-file-request',
                    'eve-in-game-browser', 'mosaic', 'bonecho', 'sony-web-browser', 'raptr',
                    'baidu-box-app', 'orange-com-crawler', 'ltx71-scanner',
                    'delphi-embedded-web-browser']
    BROWSER_ENGINE_LIST = ['Blink', 'WebKit', 'Gecko', 'EdgeHTML', 'Trident', 'NetFront', 'Presto',
                           'KHTML', 'Goanna']
    BROWSER_VERSION_LIST = ['31.3.0', '20.10166', '3.2.0.340', '3.4.3.532', '6.05', '47.0.2501.0', '42.0.2311.252', '8.0.552.224', '14.0.7157', '42.0.2311.111', '2.31', '4.14.6', '4.4.29620', '39.0.2171.90', '8.0.35158', '32.0', '32.0.1700.107', '20.0.1090.0', '0.1', '33.0.1750.5', '5.0.375.55', '1.7.5.0', '9.5.0.449', '14.0.1116.4', '4.2.23453', '15.0.849.0', '4.4.4.2000', '1.0.146.3', '7.1.33553', '7.0.4', '1.0', '28.0.1500.71', '3.0.2', '29.0.1547.41', '3.6.9', '46.0.2461.0', '2.8.6rel.4', '4.1.3', '9.0.1829', '33.0.0.0', '9.60', '40.0.2214.89', '32.0.1700.99', '20.10514', '6.0.2', '37.0.2062.94', '2.0.11', '3.5.4', '31.0.1889.207', '3.0.4.1', '15.2.2214.3645', '4.0b8pre', '12.10', '6.0.472.62', '4.5.33634', '11.0.672.0', '47.0.2492.0', '33.0', '3.6.22', '35.0.7', '4.2.18975', '14.8', '5.1', '15.0a1', '14.0.813.0', '31.0.1889.174', '11.0.696.34', '38.0', '6.2.2', '5.1.1', '1.8.0', '34.0.1847.114', '7.3.1.33', '4.2.1', '40.0.2.0', '1.0.219.53', '10.6.8.635', '9.0.3100.400', '402', '4.2.0.524', '54.0', '4.0.249.78', '7.35.0', '18.0.1', '6.1', '8.0.7', '3.6.1', '12.15', '2.4.3', '4.0.4.600', '1.12', '35.0.1916.38', '15.6.2311.5651', '6.0', '44.0.2357', '28.0.1745.0', '4.4.4.600', '6.0.454.0', '3.1b2', '42.0.2250.1', '7.1.0.714', '43.0', '8.9.4', '2.0.0.6', '2.7', '7.36.0', '1.0.219.50', '3.6.27', '28.0.1500.94', '46.0.2464.0', '12.0.742.100', '9.2.0.336', '9.9.0.543', '7.0.1', '31.0.1889.241', '10.6.5.627', '35.0.1916.122', '15', '6.10.1.27492', '21.0', '16.0.897.0', '30.0.1599.103', '2.10', '4.0.15081', '4.4.34080', '37.0.2049.0', '8.0.6', '4.4.31223', '40.0.2214.45', '26.0.1410.58', '33.0.1750.166', '7.0.517.44', '29.0.1795.41', '4.2.1.37597', '4.4.2', '3.8.4.304605', '45.0.2414.0', '25.3.2', '1.1.8', '31.0.1650.23', '2.32.1', '17.0.963.12', '36.0', '36.0.1985.103', '42.0.2311.11', '9.6', '33.0.1750.136', '9.1.3441.400', '5.0.6', '11.0', '15.0.1147.153', '10.0.648.204', '38.0.2125.122', '32.0.1700.50', '2.8.6rel.5', '33.0.1750.22', '7.1', '11.11', '8.0.35763', '15.10130', '7.5.33725', '41.0.2227.0', '43.0.2357.52', '45.0.2420.0', '0.12', '46.0.2490.0', '10.6.0.586', '10.0.12', '5.5.25151058', '2.385', '4.1.11320', '36.04', '3.6.3', '43.0.2300.0', '35.0.1916.157', '27.0.1453.10', '7.5.35721', '9.7', '45.0.2454.78', '1.6.6', '0.9.58.494', '3.6.13', '4.0b8', '40.0.2214.109', '7.1.8', '3.8.2', '23.0.1271.100', '39.0.7', '3.2.3', '2014', '42.0.2300.2', '34.8', '14.0.835.186', '2.0.0.20', '41.0.2272.87', '2.0.0.1', '3.22', '1.4', '6.5.27431', '3.5.16', '6.5.31494', '4.4.4.3000', '4.5.2', '23.0.1271.97', '1.7', '3.6.6', '3.0.10', '30.0.1599.101', '8.0.4', '40.0.2214.94', '25.0.1364.5', '4.2.22228', '38.0.2125.59', '12.16', '35.0.1900.0', '4.4.32206', '11.51', '6.1.1', '10.4.1.565', '39.0.2100.0', '11.0.696.3', '6.5.29806', '5.4.25151019', '22.0.1229.79', '15.4.2272.3842.0', '1441150727', '49.0', '1.2', '4.0.1.31280', '8.0.35667', '14.0.123.123', '48.0', '27.0.1453.110', '22.0.1471.70', '3.6.16', '28.0.1468.0', '8.8.1.359', '47.0.2510.0', '23.0.1271.91', '34.0.1847.76', '41.0.2272.53', '11.0.1912.95711', '21.0.1180.90', '45.0.2454.89', '34.0.1847.18', '44.0.2403.125', '36.1.1.21', '31.0', '46.0.2490.23', '19.0.1084.60', '25.0.1364.152', '44.0.2403.130', '7.11', '46.0', '8.3.1.4', '3.7.25.299021', '10.1.0.639', '3.13', '4.1.14287', '6.5.27510', '16.0.912.77', '1.16.3', '5.0.4', '42.0.2311.152', '1.0.233.3', '7.1.32444', '4.5.35223', '8.2.4258.400', '4.5.0IP', '14.0.835.202', '4.0', '45.0.2453.0', '31.0.1889.151', '4.0.0.2000', '44.0.2403.128', '1.8.6', '39.0.2171.93', '7.0.2', '3.5.7', '1.0.7.1', '35', '46.0.2481.0', '44.0.2403.156', '2.0.0.16', '4.4.7.3000', '4.5.33869', '45.0.2454.7.742.7', '46.0.2467.2', '8.0.1', '39.0', '9.5.1.494', '24.0.1312.57', '6.0.0.141', '3.5.6', '15.0', '32.0.1700.76', '6.1.4', '2.3.0.0.55', '4.4.32739', '2.19', '9.5.0.360', '6.2.4.51', '22.0', '12.51', '7.8', '17.0', '7.19.7', '47.0.2506.0', '45.0.2424.0', '7.5.35199', '14.0.7153', '1.3', '45.0', '1.9.1', '23.0', '0.32.1', '29.0', '44.0.2403.0', '10.10', '33.0.1750.132', '38.2.0', '31.0.1650.16', '4.0b4pre', '25.0.1614.63', '4.3.1.1943AP', '4.4.6.1000', '4.0.3', '41.0.2272.94', '41.0.2272.101', '20.0.1086.0', '20.10532', '3.0b4', '4.3.25172', '6.2.3.8', '31.0.1650.59', '5.0.1', '4403', '44.0.2403.61', '15.0.874.102', '27.0.1453', '25.0.1614.68', '2.1n', '17.0.1', '32.0.1667.0', '4.2.2', '6.3.3', '31.0.1889.106', '13.10.1500.9323', '3.1', '3.3', '47.0.2494.0', '3.6.12', '31.0.1889.220', '2.8.8dev.12', '38.0.6', '3.0.7', '0.5', '9.1', '4.10', '7.0.32026', '30.0.1835.88', '43.3.3.185', '1441333420', '5.4.0', '12.0.712.0', '47.0', '3.6a1pre', '0.5.3', '47.0.2497.0', '41.0.2227.1', '3.66', '10.5.0.575', '31.0.1623.0', '28.0.1500.72', '9.7.2.53208', '6.1.7601', '2.0.0.11', '9.99', '15.0a2', '4.0b13pre', '45.0.2431.0', '4.4.7.600', '45.0.2454.46', '40.0.3', '3.0.6', '4.2a1pre', '20.10512', '25.0.1364.45', '2.3', '15.4.2272.3842.01', '16.0', '44.0.2367.0', '6.0a2', '6.1.8', '19.0.1326.56', '1441843869', '47.0.2493.0', '43.0.2357.56', '36.0.1985.125', '39.0.6', '4.0.9751', '10.1.5.583', '4.2.23449', '3.6.18', '1.0.7', '35.0.1916.114', '40.0.2214.69', '7.54', '6.1.6', '2.12.1', '37.0.0.0', '15.0.4745', '2.0.0.13', '45.0.2406.0', '46.0.2479.0', '9.0', '7.0.3', '20.0', '2.7.2', '3.1.0.23513', '4.0.2', '12.0.742.5', '46.0.2490.11', '31.0.1889.163', '2.8.3rel.1', '3.5.3', '4.0b12', '4.0.249.4', '2013', '41.0.2220.0', '16.10136', '1.0.162.9', '4.4.7.1000', '9.0.2.389', '41.0.2272.16', '44.0.0.26.142', '3.0.5', '234.83', '12.17', '6.0.3', '27.0.1698.89115', '9.0.0.6', '4.3.1.1943AT', '1.4.5', '42.0.2311.90', '36.0.1985.49', '31.0.1650.63', '18.0.1025.166', '5.1.9', '37.0.2062.124', '8.0', '28.0.1467.0', '7.1.0.825', '1.0.118.19', '20.0.1132.47', '10.0.648.151', '19.0.1042.0', '37.0.0.21.273', '4.1.249.1036', '4.4.31998', '2016', '3.5.5', '35.5', '11.0.696.77', '27.0.1453.93', '0.8.0', '25.0.1364.160', '1.7.0', '30.0.1835.157', '4.79', '1.7610.EU', '1.19', '27.0.1453.94', '12.1.0.0', '2.0.9.20', '74.0', '622.8.0', '7.0.503.0', '4.2.1.541', '6.1.5', '42.0.2311.15', '39.0.2171.71', '22.0.1229.94', '8.0.35676', '4.4.4', '5.666', '4.81', '38.0.2125.114', '7.44.0', '8.0.35638', '10.0.1', '30.0.1599.92', '1.3.10126.EU', '31.8.0', '40.0.2214.85', '30.0.0.0', '25.0.1364.169', '33.0.1729.3', '42.0.2311.135', '7.0.517.43', '11.0.678.0', '3.0.195.24', '38.0.2125.19', '36.1.1.22', '46.0.2489.0', '2.8.5rel.1', '23.247', '31.0.1612.2', '5.1.7', '2.33.1', '2015', '46.0.2480.0', '6.4.2', '38.0.2125.101', '6.2.7', '11.10', '31.4.0', '14.0.1025.52315', '27.0', '42.0.2311.261', '31.0.1889.200', '4.0b12pre', '8.2.3638.400', '16.0.912.75', '9.0.1', '40.0.2176.0', '4.7.3.47323', '6.5.26955', '2.X', '1.0.275.3', '12.0', '26.0.1386.0', '45.0.2454.93', '3.8.3.304115', '2.1pre31', '3.0.3', '23.0.1522.60', '3.0.22.2.23', '15.0.1147.24', '8.50', '2.30', '2.2.1', '25.0.1364.124', '19.0.1061.1', '4.5.40312', '31.0.1650.69', '15.7.2357.2700', '3.5.1', '5.0.2', '35.0.1870.2', '6.0.5', '2.2', '24.0.1312.52', '34.0', '10.1.2.540', '20.0.1396.73172', '38.0.0.6.79', '45.0.2454', '45.0.2423.0', '2.2a1pre', '30.0.1599.105', '45.0.2454.26', '7.1.32445', '43.0.2357.51', '36.0.0.40.231', '33.0.1750.154', '0.13.GIT', '26.0.0.2', '85.3', '43.0.2357.61', '1.14', '43.0.2337.0', '47.0.2504.0', '6.0.0.524', '7.0.5', '47.0.2495.0', '5.1.8', '6.1.27412', '10.2.0.93022', '4.5', '9.9.32890', '3.0.8.2', '41.0.2272.104', '6.0.0.668', '2.38', '22.0.1229.95', '29.0.1795.60', '5.2', '4.7', '3.6.25', '43.0.2357.92', '44.1.81', '7.1.5', '10.68.635', '40.0.2214.93', '40.0.2197.2', '7.1.32451', '46.0.2458.0', '4.4.3.4000', '24.0.1290.0', '44.5.7.269', '4.8C', '12.50', '4.0.249.0', '6.0.1', '13.0.1', '24.0.1558.61', '4.2.14038', '33.0.1750.517', '4.4', '4.1.13572', '11.0.696.16', '14.52', '18.0.1025.308', '3.6.28', '2.0.0.19', '9.1.1.420', '24.0', '2.0d', '5.1.24639', '4.8', '45.0.2444.0', '40.1', '10.1', '4.4.32208', '9.4', '9.8.3.59237', '45.0.0.38.146', '20.0.1105.0', '8.1', '15.9.2403.2805', '2.8', '24.0.1312.60', '15.9.2403.2772.10', '1.5.0.12', '6.7.1.25446', '21.0.1180.89', '26.0.0b2', '8.0.552.200', '3.8.1.3.0723', '19.0.1084.1', '20.0.1092.0', '44.0.2397.0', '30.0.1856.93524', '31.0.0.44.261', '10.1.0.527', '6.2.3.3.c.1.101', '14.0.835.18', '2.0.6', '7.1.33551', '4.0b10', '4.4.1.3000', '31.0.1889.181', '15.4.1', '2.0.12', '34.0.1820.0', '43.0.0.29.147', '41.0.2267.0', '36.0.1985.128', '8', '9.1.3471.400', '9.8.0.534', '1.0.270.16', '46.0.2465.0', '5.0.22349', '1.0.258.3', '8.0.57838', '37.0.2062.119', '10.7.0.634', '37.0.2062.120', '35.0.1916.86', '4.4.31492', '2.1.1', '3.0.8', '3.0.18', '29.0.1809.92697', '38.0.2125.111', '3.6.10', '4.5.33867', '2.4.2', '36.0.1985', '1439401440', '31.2.0', '7.5.35188', '6.01',
                            '2.8.9dev.1', '35.0.1', '42.0.2311.108', '40.0.2214.95', '7.3.1.37', '30.0.1599.82', '25.6.0', '18.0.1284.49', '33.0.1982.0', '35.1.2', '44.0.2403.133', '10.0.1884', '31.6.0', '5.7.950.20150826', '8.3.4769.400', '17.0.963.66', '31.6', '4.0b3pre', '20.10536', '28.0.1754.0', '14.0', '43.0.2357.78', '47.0.2501.3', '13.0.782.215', '44.0.2403.67', '2.0', '40.0.2214.73', '18.0.1003.1', '21.0.1180.75', '10.4.0.641', '36.0.1985.135', '6.2.3', '30.0.1856.95530', '40.0.2214.91', '43.0.2357.132', '37.0.2062.99', '4.0.13574', '4.0b6', '5.5.50480', '27.0.1698.89105', '7.1.0.477', '32.0.1948.31', '2.28', '5.1.3119', '33.0.1750.12', '7.5.33361', '14.0.1', '44.0.2377.0', '46.0.2457.0', '9.63', '5.0.5', '7.1.4', '37.0.2062.103', '29.0.1547.2', '7.0.514.0', '27.0.0.10.12', '7.1.33578', '3.0.195.27', '8.3.4766.400', '8.0.552.18', '4.0b7pre', '8.12', '1.0.257.3', '27.0.1448.0', '50.0.125', '7.0b', '41.0.2200.0', '2.7.1', '4.11', '29.0.1795.47', '27.3', '1.13.4', '7.1.32453', '4.4.28591', '53.0', '6.0.472.63', '29.0.1547.57', '2.8.8pre.4', '4.1', '41.0.2272.96', '44.0.2403.89', '35.0.1849.0', '3.2', '25.4.1', '28.0.1469.0', '10.7.1.655', '36.0.1985.67', '15.7.2357.2877', '40.0.2214.114', '20.0.1396.72047', '10.0.2', '2.8.8dev.3', '10.7.0.636', '39.0.2171.95', '9.8.0.435', '3.16.0', '31.0.1650.57', '42.0.2307.2', '34.0.1848.0', '22.0.1207.1', '8.0.3', '25.5.0', '4.0.212.0', '45.0.2454.68', '14.0.835.94', '0.32.2', '8.5.0', '3.5.6.1', '47.0.2507.0', '29.0.1547.59', '28.0.1500.3', '4.2.0.37439', '2.6.2', '7.0.55539', '9.80', '1437509903', '4.4.31989', '5.0.17443', '33.0.1712.2', '38.0.2125.509', '35.0.0.48.273', '1.17', '31.0.1889.235', '19.0.1061.2', '12.00a', '10.2.0', '11.52', '4.1.249.1064', '6.0.481.0', '4.1.2', '2.0.0.9', '6.2.2.6613', '44.0.2403.117', '15.6.2311.5029', '11.0.696.68', '40.0.2185.0', '47.0.2503.0', '7.1.0.337', '41.0.2231.0', '10.0.601.0', '44.0.2403.18', '19.0.1084.9', '44.2.49', '7.5.32193', '33.0.1750.514', '32.0.1653.0', '15.4.2272.3909', '45.0.2454.87', '7.2.6.1.840', '4.2', '15.4.2272.3911', '3.5.8', '43.0.2357.65', '8.3.4770.400', '6.2.5', '5.0.307.11', '4.4.6.2000', '1.7610.US', '1.1', '4.9', '5.01', '5.1.6', '4.01', '35.0.1916.155', '32.0.1948.4', '43.0.2357.93', '9.0b3', '37.0.2062.52', '25.7.0', '4.0.249.64', '4.4.1IT', '7.6.35843', '35.0.1916.138', '8.2', '7450', '9.0.570.0', '41.0.2272.76', '17.0.963.79', '45.0.2454.31', '2.2.0', '37.0.2062.60', '36.0.1944.0', '27.0.1500.0', '7.6.40125', '10.2.0.584', '20.0.1387.91', '6.0.461.0', '30.0.1835.59', '4.2.18149', '6.2.2.54', '4.2.2.38484', '10.3.0.552', '20.0.1132.57', '6.0.0', '41.0.2272.56', '11.62', '12.0.742.91', '41.0.2272.89', '36.0.1985.57', '8.0.35678', '20.10162', '19.0.2', '7.1.2', '20.0.1387.64', '33.0.1750.170', '25.0.1364.172', '20.10525', '38.1.0', '45.0.2412.0', '7.1.7', '33.0.1750.152', '9.9.0.459', '44.5.7.268', '33.0.1963.0', '4.0.5', '1.5', '27.0.1689.69', '42.0.2302.0', '47.0.2505.0', '17.0.963.83', '0.6', '46.0.2490.6', '6.0.0.480', '10.63', '38.2.1', '9.4.1.377', '9.5', '31.0.1889.161', '3.6.24', '35.0.1916.141', '32.0.0.23.15', '39.0.3', '14.0.1074.58201', '43.0.2357.125', '45.0.2454.8.742.8', '5.1.21219', '42.0.2311.47', '47.0.2508.0', '11', '11.60', '7.5.35613', '47.0.2496.0', '3.5b5pre', '38.0.2078.1', '15.9.2403.2150', '41.0.2228.0', '10.1.2.571', '8.0.2', '38.0.2125.104', '3.2.1.25875', '39.0.0.36.31', '4.0.266.0', '45.0.2454.84', '2.1.2', '2.2.5', '3.67', '30.0.1856.92967', '3.6.17', '1.7.5.1', '23.0.1271.64', '13.0.782.112', '26.0.1450.0', '4.0b7', '35.0', '37.0.2062.117', '4.14.2', '26.0.1656.32', '19.0.1084.52', '8.0.35659', '26.0.1656.20', '24.0.1565.82529', '7.1.6', '7.5.35271', '39.0.2171.65', '1.2.0.12', '8.0.35626', '4.14.1', '9.0.597', '6.2.3.2', '3.4.2.525', '4.4.33576', '32.0.1948.25', '39.0.1', '2.7.0', '2.0.0.14', '1.7455.JP', '46.0.2478.0', '3.6.4.1', '9.0.597.94', '7.1.0.398', '9.4.1.362', '10.3.0.622', '0.10.2', '7.4.2', '37.049.148.218.56', '5.1.3', '4.6.9.42974', '17.0.939.0', '5.0', '31.0.1889.230', '4.1.13907', '19.0.1084.56', '28.0.1478.0', '32.0.1664.3', '4.4.32563', '7.0.517.41', '21.0.1180.18', '15.0.865.0', '6.5.26988', '15.0.874.120', '3.1.2', '5.1.21086', '4.3.0.11224.US', '9.6.0.514', '15.0.875.0', '43.0.2357.130', '45.0.2438.3', '29.0.1547.66', '30.0.1835.151', '24.4.0', '42.0.2311.50', '21.0.1180.83', '46.0.2490.22', '6.2.4', '3.5.19', '4.2.13057', '5.5.0', '41.0.2272.118', '47.0.2499.0', '32.0.1948.12', '20.10240', '6.0.490.1', '28', '39.0.2171.99', '30.0', '3.0.1', '3.6b5', '46.0.2490.15', '28.0.1500.16', '10.0.628.0', '2.0.3.55', '0.07', '29.0.1809.91837', '1.6.0', '5.5', '44.0.2350.0', '28.0.1764.90386', '33.0.1967.0', '9.64', '17.0.963.56', '47.0.2499.1', '1.305.2.12', '38.0.2125.8', '42.0.2311.39', '45.0.2454.62', '45.0.2454.86', '29.0.1600.1', '40.0.2214.111', '6', '5.1.1.0', '35.0.1916.153', '1.1.18', '33.0.1750.149', '11.66', '6.1.3', '40.0.2182.2', '5.1.42378', '9.7.0.520', '4.3.0.1852AP', '3.17', '22.0.1224.0', '40.0', '3.8.1.2.0612', '25.0.1364.97', '49.0.146', '43.0.2357.81', '34.0.1847.118', '41.0.2226.0', '6.2.6', '7.1.0.336', '2.2.0.0.34', '42.0', '38.0.5', '6.8', '26.0.1410.63', '7.1.34814', '16.0.904.0', '10.2.0.535', '3.16.2', '1.0.252.3', '42.0.2311.129', '66.6', '2.9', '33.1.0.0', '3.0.0.6', '8.0.3.107', '1.0.5.3', '9.25', '29.0.1547.76', '27.0.1453.116', '1.8.2', '7.0.531.0', '26.0', '3.0.4', '7.0.6', '39.0.0.0', '39.0.2145.4', '13.0.782.107', '7.1.33133', '26.0.1410.64', '11.4.7', '4.2.0', '4.2.0.11146.EU', '47.0.2509.0', '8.0.5', '28.0.1750.48', '6.2.8', '41.0.2272.58', '7.51', '40.0.0.0', '47.0.2500.0', '11.01', '8.8', '10.6.2.599', '32.0.1948.19', '28.0.0.10.10', '46.0.2456.0', '43.0.2357.59', '42.0.2311.137', '0', '42.1.2.91', '4.4.39001', '12.11', '26.0.1656.60', '19.0.0.10.12', '25.0.1614.71', '4.2.0.4000', '6.2.3.3.g.2.106', '4.0b9pre', '34.0.0.0', '31.0.1650.4', '34.0.1847.116', '11.50', '32.0.1953.95326', '40.0.2', '40.0.2214.38', '29.0.1809.93516', '4.5.0IT', '25.0.2', '7.5.31657', '9.50', '44.0.2403.107', '38.0.2125.110', '3.6.8', '7.4.2.6', '9.3.0.326', '11.64', '25.0', '40.0.2214.115', '2.33', '4.1.15082', '30.0.1599.17', '2.4.0.367', '10.5.2.582', '9.4.0.460', '45.0.2442.0', '3.68', '5.1.2', '8.1.0', '39.1.2', '4.0.0', '41.0.2272.74', '3.6.15', '5.1.5', '12.0.742.112', '6.1.2', '42.0.2311.138', '4.12', '1.7.1', '7.5.32195', '1440016726', '3.8.1.0.5', '6.1.32997', '46.0.2483.0', '4.2.14912', '8.7.0.218', '3.56', '4.2.22230', '7.1.33876', '3.14.1', '6.1.27762', '3.6', '3.5', '33.0.1750.117', '11.0.672.2', '44.0.2403.157', '39.0.2171.94', '28.0', '3.4', '12.02', '16.0.1', '31.0.1889.99', '7.1.3', '3.0.19', '8.0.8', '33.0.1736.2', '30.0.1835.125', '43.0.2357.124', '43.0.2357.134', '5.3.0.201504', '10.0.648.134', '0.4', '1.7.4.2', '31.0.1621.1', '4.2.20464', '5.0.3', '5.2.43972', '7.1.32448', '0.2', '4.3.0.1852AT', '18.0', '45.0.2454.48', '3.10.3', '4.0.4', '26.0.1410.43', '44.0.2403.262', '10.0.648.205', '38.0.2125.112', '2.0.0.2', '4.0.1', '42.0.2311.60', '32.0.1933.0', '8.01', '29.0.1547.11', '5.1.21595', '11.12', '34.0.1847.137', '42.0.2311.87', '24.0.1290.1', '3.1.1', '1.4.4', '18.0.1025.133', '12.01', '24.0.1558.64', '50', '8.7', '7.0', '2.1', '7.0.0.585', '10.6.4.621', '44.0.2379.0', '28.0.1500.73', '10.0.642.2', '14.0.7155', '1.8.5', '4.8.0IT', '46.0.2490.13', '46.0.2471.2', '3.6.20', '9.9.2.467', '7.5.33391', '3.2.1', '12.14', '47.0.2491.0', '28.0.1500.95', '39.0.2171.59', '4.4.5.2000', '2.8.7rel.1', '3.6.23', '7.2.0.0', '44.0.2403.90', '31.0.1650.48', '46.0.2486.0', '16.0.912.36', '23.0.1522.77', '43.0.2357.121', '20.1.0.15.10', '4.1.0.31802', '4.13', '45.0.2454.15', '4.14.9', '9.8', '21.0.1180.91', '45.0.2454.37', '3.8', '19.0.1061.0', '42.0.2311.153', '33.0.1726.0', '6.2', '19.0.1063.0', '42.0.2294.0', '7.0.500.0', '47.0.2498.0', '13.0.782.24', '15.0.1', '45.0.2454.80', '26.0.1656.24', '1.0.264.3', '5.22', '3.16.3', '46.0.2490.4', '41.0', '33.0.1750.146', '4.2.24725', '10', '31.7.0', '1.16', '8.0.552.237', '36.0.1985.143', '9.01', '44.0', '3.6.11', '32.0.1700.77', '10.1.4.573', '34.0.1847.131', '7.9.0.94', '7.60', '8.0.40325', '5.0.342.1', '36.0.1964.4', '2.0.1', '9.0.587.0', '45.0.2454.85', '37.0', '29.0.1531.0', '10.70', '25.0.1349.2', '36.0.0.39.36', '9', '1.10', '37.0.2062.102', '45.0.2454.19', '7.5.33286', '3.0', '3.0.195.25', '45.0.2421.0', '4.2.0.1827AT', '7.2.7.5.708', '32.0.1700.102', '44.0.2403.155', '42.0.0.27.114', '19.0', '2.6.1', '2.35', '10.0', '6.0.51363', '3.0.11', '1.0.1084.5402', '32.0.1700.68', '75.0', '38.0.2125.102', '13.0', '4.14', '30.0.1599.66', '5.4.25151032', '2.5.0.14', '4.4.33943', '11.0.1912', '4.3', '1.0.6', '7.6.40234', '26.0.1410.65', '0.5.6', '0.11.0', '47.0.2502.0', '30.0.1551.0', '1.0.22.153', '4.1.2.1212AP', '39.0.2171.96']
