"""
Программа-лаунчер
После запуска будет выведено приглашение ввести команду.
Поддерживаемые команды:
1. s - Запустить сервер
* Запускает сервер с настройками по умолчанию.
2. k - Запустить клиенты
* Будет выведен запрос на количество тестовых клиентов для запуска.
* Клиенты будут запущены с именами вида **test1 - testX** и паролями **123**
* Тестовых пользователей необходимо предварительно, вручную зарегистрировать на сервере с паролем **123**.
* Если клиенты запускаются впервые, время запуска может быть достаточно продолжительным из-за генерации новых RSA ключей.
3. x - Закрыть все окна.
* Закрывает все активные окна, которые были запущенны из данного модуля.
4. q - Завершить работу модуля.
* Завершает работу модуля
"""

import subprocess
import sys


def main():
    processes = []
    while True:
        action = input('Выберите действие: '
                       'q - выход, '
                       's - запустить сервер, '
                       'k - запустить клиенты, '
                       'x - закрыть все окна: ')

        match action:
            case 'q':
                break
            case 's':
                # Запуск сервера.
                processes.append(subprocess.Popen(f'{sys.executable} server.py',
                                                  creationflags=subprocess.CREATE_NEW_CONSOLE))
            case 'k':
                # Запуск клиентов.
                print('Убедитесь, что на сервере зарегистрировано необходимо количество клиентов с паролем 123456.')
                print('Первый запуск может быть достаточно долгим из-за генерации ключей!')
                clients = int(input('Введите количество клиентов для запуска: '))
                for i in range(clients):
                    processes.append(subprocess.Popen(f'{sys.executable} client.py -n test{i + 1} -p 123456',
                                                      creationflags=subprocess.CREATE_NEW_CONSOLE))
            case 'x':
                while processes:
                    processes.pop().kill()


if __name__ == '__main__':
    main()
