"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebsiteBucket = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cloudfront_1 = require("@aws-cdk/aws-cloudfront");
const aws_s3_1 = require("@aws-cdk/aws-s3");
const aws_s3_deployment_1 = require("@aws-cdk/aws-s3-deployment");
const core_1 = require("@aws-cdk/core");
class WebsiteBucket extends core_1.Construct {
    constructor(scope, id, props = {}) {
        super(scope, id);
        const { bucketName, removalPolicy = core_1.RemovalPolicy.RETAIN, disableUpload = false, source, websiteIndexDocument, websiteErrorDocument } = props;
        const bucket = new aws_s3_1.Bucket(this, 'WebsiteBucket', {
            autoDeleteObjects: removalPolicy === core_1.RemovalPolicy.DESTROY,
            bucketName,
            removalPolicy,
            websiteIndexDocument: websiteIndexDocument || 'index.html',
            websiteErrorDocument: websiteErrorDocument || 'error.html',
        });
        const originAccessIdentity = new aws_cloudfront_1.OriginAccessIdentity(this, 'OriginAccessIdentity', {
            comment: `CloudFront OriginAccessIdentity for ${bucket.bucketName}`,
        });
        this.s3OriginConfig = {
            originAccessIdentity,
            s3BucketSource: bucket,
        };
        if (!disableUpload) {
            const placeHolderSource = path.join(__dirname, '..', 'website');
            new aws_s3_deployment_1.BucketDeployment(this, 'Deployment', {
                sources: [aws_s3_deployment_1.Source.asset(source || placeHolderSource)],
                destinationBucket: bucket,
                retainOnDelete: removalPolicy === core_1.RemovalPolicy.RETAIN,
            });
        }
    }
}
exports.WebsiteBucket = WebsiteBucket;
_a = JSII_RTTI_SYMBOL_1;
WebsiteBucket[_a] = { fqn: "@cloudcomponents/cdk-static-website.WebsiteBucket", version: "1.28.0" };
//# sourceMappingURL=data:application/json;base64,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