"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BudgetNotifier = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_budgets_1 = require("aws-cdk-lib/aws-budgets");
const constructs_1 = require("constructs");
const notificationType_1 = require("./notificationType");
const timeUnit_1 = require("./timeUnit");
class BudgetNotifier extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.validateProperties(props);
        const costFilters = this.createCostFilters(props);
        const subscribers = this.createSubscribers(props);
        new aws_budgets_1.CfnBudget(this, 'MonthlyBudget_' + id, {
            budget: {
                budgetType: 'COST',
                timeUnit: props.timeUnit ? props.timeUnit : timeUnit_1.TimeUnit.MONTHLY,
                budgetLimit: {
                    amount: props.limit,
                    unit: props.unit,
                },
                costFilters: costFilters,
            },
            notificationsWithSubscribers: [
                {
                    notification: {
                        comparisonOperator: 'GREATER_THAN',
                        threshold: props.threshold,
                        thresholdType: 'PERCENTAGE',
                        notificationType: props.notificationType
                            ? props.notificationType
                            : notificationType_1.NotificationType.ACTUAL,
                    },
                    subscribers: subscribers,
                },
            ],
        });
    }
    validateProperties(props) {
        if (props.recipients && props.recipients.length > 10) {
            throw new Error('The maximum number of 10 e-mail recipients is exceeded.');
        }
        if (props.threshold <= 0) {
            throw new Error('Thresholds less than or equal to 0 are not allowed.');
        }
    }
    createSubscribers(props) {
        const subscribers = new Array();
        if (props.recipients) {
            for (const recipient of props.recipients) {
                subscribers.push({
                    address: recipient,
                    subscriptionType: 'EMAIL',
                });
            }
        }
        if (props.topicArn) {
            subscribers.push({
                address: props.topicArn,
                subscriptionType: 'SNS',
            });
        }
        return subscribers;
    }
    createCostFilters(props) {
        const tags = [];
        if (props.application) {
            tags.push('user:Application$' + props.application);
        }
        if (props.costCenter) {
            tags.push('user:Cost Center$' + props.costCenter);
        }
        if (props.service) {
            tags.push('user:Service$' + props.service);
        }
        const costFilters = {};
        if (tags && tags.length > 0) {
            costFilters.TagKeyValue = tags;
        }
        const availabilityZones = [];
        if (props.availabilityZones) {
            for (const az of props.availabilityZones) {
                availabilityZones.push(az);
            }
            costFilters.AZ = availabilityZones;
        }
        return costFilters;
    }
}
exports.BudgetNotifier = BudgetNotifier;
_a = JSII_RTTI_SYMBOL_1;
BudgetNotifier[_a] = { fqn: "aws_budget_notifier.BudgetNotifier", version: "0.3.19" };
//# sourceMappingURL=data:application/json;base64,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