import os
from distutils.command.build import build

from django.core import management
from setuptools import find_packages, setup

from pretix_swap import __version__


try:
    with open(
        os.path.join(os.path.dirname(__file__), "README.rst"), encoding="utf-8"
    ) as f:
        long_description = f.read()
except Exception:
    long_description = ""


class CustomBuild(build):
    def run(self):
        management.call_command("compilemessages", verbosity=1)
        build.run(self)


cmdclass = {"build": CustomBuild}


setup(
    name="pretix-swap",
    version=__version__,
    description="Swap tickets, anonymously or with specific other attendees. Also supports canceling tickets if (and only if) another ticket is purchased.",
    long_description=long_description,
    url="https://github.com/rixx/pretix-swap",
    author="Tobias Kunze",
    author_email="r@rixx.de",
    license="Apache",
    install_requires=[],
    packages=find_packages(exclude=["tests", "tests.*"]),
    include_package_data=True,
    cmdclass=cmdclass,
    entry_points="""
[pretix.plugin]
pretix_swap=pretix_swap:PretixPluginMeta
""",
)
