from .ABC import CHARSET

BIG5 = CHARSET('big5', 'big5_chinese_ci', 2, 'Big5 Traditional Chinese')
DEC8 = CHARSET('dec8', 'dec8_swedish_ci', 1, 'DEC West European')
CP850 = CHARSET('cp850', 'cp850_general_ci', 1, 'DOS West European')
HP8 = CHARSET('hp8', 'hp8_english_ci', 1, 'HP West European')
KOI8R = CHARSET('koi8r', 'koi8r_general_ci', 1, 'KOI8-R Relcom Russian')
LATIN1 = CHARSET('latin1', 'latin1_swedish_ci', 1, 'cp1252 West European')
LATIN2 = CHARSET('latin2', 'latin2_general_ci', 1, 'ISO 8859-2 Central European')
SWE7 = CHARSET('swe7', 'swe7_swedish_ci', 1, '7bit Swedish')
ASCII = CHARSET('ascii', 'ascii_general_ci', 1, 'US ASCII')
UJIS = CHARSET('ujis', 'ujis_japanese_ci', 3, 'EUC-JP Japanese')
SJIS = CHARSET('sjis', 'sjis_japanese_ci', 2, 'Shift-JIS Japanese')
HEBREW = CHARSET('hebrew', 'hebrew_general_ci', 1, 'ISO 8859-8 Hebrew')
TIS620 = CHARSET('tis620', 'tis620_thai_ci', 1, 'TIS620 Thai')
EUCKR = CHARSET('euckr', 'euckr_korean_ci', 2, 'EUC-KR Korean')
KOI8U = CHARSET('koi8u', 'koi8u_general_ci', 1, 'KOI8-U Ukrainian')
GB2312 = CHARSET('gb2312', 'gb2312_chinese_ci', 2, 'GB2312 Simplified Chinese')
GREEK = CHARSET('greek', 'greek_general_ci', 1, 'ISO 8859-7 Greek')
CP1250 = CHARSET('cp1250', 'cp1250_general_ci', 1, 'Windows Central European')
GBK = CHARSET('gbk', 'gbk_chinese_ci', 2, 'GBK Simplified Chinese')
LATIN5 = CHARSET('latin5', 'latin5_turkish_ci', 1, 'ISO 8859-9 Turkish')
ARMSCII8 = CHARSET('armscii8', 'armscii8_general_ci', 1, 'ARMSCII-8 Armenian')
UTF8 = CHARSET('utf8', 'utf8_general_ci', 3, 'UTF-8 Unicode')
UCS2 = CHARSET('ucs2', 'ucs2_general_ci', 2, 'UCS-2 Unicode')
CP866 = CHARSET('cp866', 'cp866_general_ci', 1, 'DOS Russian')
KEYBCS2 = CHARSET('keybcs2', 'keybcs2_general_ci', 1, 'DOS Kamenicky Czech-Slovak')
MACCE = CHARSET('macce', 'macce_general_ci', 1, 'Mac Central European')
MACROMAN = CHARSET('macroman', 'macroman_general_ci', 1, 'Mac West European')
CP852 = CHARSET('cp852', 'cp852_general_ci', 1, 'DOS Central European')
LATIN7 = CHARSET('latin7', 'latin7_general_ci', 1, 'ISO 8859-13 Baltic')
UTF8MB4 = CHARSET('utf8mb4', 'utf8mb4_general_ci', 4, 'UTF-8 Unicode')
CP1251 = CHARSET('cp1251', 'cp1251_general_ci', 1, 'Windows Cyrillic')
UTF16 = CHARSET('utf16', 'utf16_general_ci', 4, 'UTF-16 Unicode')
UTF16LE = CHARSET('utf16le', 'utf16le_general_ci', 4, 'UTF-16LE Unicode')
CP1256 = CHARSET('cp1256', 'cp1256_general_ci', 1, 'Windows Arabic')
CP1257 = CHARSET('cp1257', 'cp1257_general_ci', 1, 'Windows Baltic')
UTF32 = CHARSET('utf32', 'utf32_general_ci', 4, 'UTF-32 Unicode')
BINARY = CHARSET('binary', 'binary', 1, 'Binary pseudo charset')
GEOSTD8 = CHARSET('geostd8', 'geostd8_general_ci', 1, 'GEOSTD8 Georgian')
CP932 = CHARSET('cp932', 'cp932_japanese_ci', 2, 'SJIS for Windows Japanese')
EUCJPMS = CHARSET('eucjpms', 'eucjpms_japanese_ci', 3, 'UJIS for Windows Japanese')