import json
import setuptools

kwargs = json.loads(
    """
{
    "name": "cloudcomponents.cdk-pull-request-check",
    "version": "1.1.9",
    "description": "Cdk component that automatically check pull requests",
    "license": "MIT",
    "url": "https://github.com/cloudcomponents/cdk-constructs",
    "long_description_content_type": "text/markdown",
    "author": "hupe1980",
    "project_urls": {
        "Source": "https://github.com/cloudcomponents/cdk-constructs.git"
    },
    "package_dir": {
        "": "src"
    },
    "packages": [
        "cloudcomponents.cdk_pull_request_check",
        "cloudcomponents.cdk_pull_request_check._jsii"
    ],
    "package_data": {
        "cloudcomponents.cdk_pull_request_check._jsii": [
            "cdk-pull-request-check@1.1.9.jsii.tgz"
        ],
        "cloudcomponents.cdk_pull_request_check": [
            "py.typed"
        ]
    },
    "python_requires": ">=3.6",
    "install_requires": [
        "jsii>=1.10.0, <2.0.0",
        "publication>=0.0.3",
        "aws-cdk.aws-codebuild>=1.59.0, <2.0.0",
        "aws-cdk.aws-codecommit>=1.59.0, <2.0.0",
        "aws-cdk.aws-events>=1.59.0, <2.0.0",
        "aws-cdk.aws-events-targets>=1.59.0, <2.0.0",
        "aws-cdk.aws-iam>=1.59.0, <2.0.0",
        "aws-cdk.aws-lambda>=1.59.0, <2.0.0",
        "aws-cdk.core>=1.59.0, <2.0.0",
        "constructs>=3.0.4, <4.0.0"
    ],
    "classifiers": [
        "Intended Audience :: Developers",
        "Operating System :: OS Independent",
        "Programming Language :: JavaScript",
        "Programming Language :: Python :: 3 :: Only",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Typing :: Typed",
        "License :: OSI Approved"
    ]
}
"""
)

with open("README.md") as fp:
    kwargs["long_description"] = fp.read()


setuptools.setup(**kwargs)
