/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import java.util.ArrayList;
import java.util.List;

public class UnicodeUtilities {
    public static final char LRE = '\u202a';
    public static final char RLE = '\u202b';
    public static final char PDF = '\u202c';
    public static final char LRO = '\u202d';
    public static final char RLO = '\u202e';
    public static final char LRI = '\u2066';
    public static final char RLI = '\u2067';
    public static final char FSI = '\u2068';
    public static final char PDI = '\u2069';
    public static final char LRM = '\u200e';
    public static final char RLM = '\u200f';
    public static final char ALM = '\u061c';
    public static final char PARA = '\n';
    private static CharSet allBiDiChars = new CharSet('\u202a', '\u202b', '\u202c', '\u202d', '\u202e', '\u2066', '\u2067', '\u2068', '\u2069', '\u200e', '\u200f', '\u061c', '\n');

    public static boolean hasBiDiChars(String src) {
        for (char c : src.toCharArray()) {
            if (!allBiDiChars.contains(c)) continue;
            return true;
        }
        return false;
    }

    public static String checkUnicodeWellFormed(String src) {
        StateStack ss = new StateStack();
        block8: for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            if (!allBiDiChars.contains(c)) continue;
            switch (c) {
                case '\n': {
                    ss.clear();
                    continue block8;
                }
                case '\u202d': 
                case '\u202e': {
                    ss.push(c, i);
                    continue block8;
                }
                case '\u202c': {
                    ss.popJustOne(new CharSet('\u202a', '\u202b', '\u202d', '\u202e', '\u200e', '\u200f', '\u061c'));
                    continue block8;
                }
                case '\u2066': 
                case '\u2067': 
                case '\u2068': {
                    ss.push(c, i);
                    continue block8;
                }
                case '\u2069': {
                    ss.popOneAndOthers(new CharSet('\u2066', '\u2067', '\u2068'), new CharSet('\u202a', '\u202b', '\u202d', '\u202e', '\u200e', '\u200f', '\u061c'));
                    continue block8;
                }
                case '\u061c': 
                case '\u200e': 
                case '\u200f': {
                    ss.push(c, i);
                }
            }
        }
        if (ss.empty()) {
            return null;
        }
        return ss.summary();
    }

    public static String describe(char c) {
        switch (c) {
            case '\u202a': {
                return "LRE";
            }
            case '\u202b': {
                return "RLE";
            }
            case '\u202c': {
                return "PDF";
            }
            case '\u202d': {
                return "LRO";
            }
            case '\u202e': {
                return "RLO";
            }
            case '\u2066': {
                return "LRI";
            }
            case '\u2067': {
                return "RLI";
            }
            case '\u2068': {
                return "FSI";
            }
            case '\u2069': {
                return "PDI";
            }
            case '\u200e': {
                return "LRM";
            }
            case '\u200f': {
                return "RLM";
            }
            case '\u061c': {
                return "ALM";
            }
            case '\n': {
                return "PARA";
            }
        }
        return String.valueOf(c);
    }

    public static Object replaceBiDiChars(String s2) {
        if (s2 == null) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        for (char c : s2.toCharArray()) {
            if (allBiDiChars.contains(c)) {
                b.append("|" + UnicodeUtilities.describe(c) + "|");
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    public static class CharSet {
        private char[] chars;

        public CharSet(char ... chars) {
            this.chars = chars;
        }

        public boolean contains(char c) {
            for (char t : this.chars) {
                if (c != t) continue;
                return true;
            }
            return false;
        }
    }

    public static class StateStack {
        private List<StateStackEntry> list = new ArrayList<StateStackEntry>();

        public void clear() {
            this.list.clear();
        }

        public void push(char c, int i) {
            this.list.add(new StateStackEntry(c, i));
        }

        public void popJustOne(CharSet oneSet) {
            if (!this.list.isEmpty() && oneSet.contains(this.list.get(this.list.size() - 1).c)) {
                this.list.remove(this.list.size() - 1);
            }
        }

        public void popOneAndOthers(CharSet oneSet, CharSet otherSet) {
            boolean found = false;
            for (StateStackEntry t : this.list) {
                if (!oneSet.contains(t.c)) continue;
                found = true;
                break;
            }
            if (found) {
                while (!this.list.isEmpty() && (oneSet.contains(this.list.get(this.list.size() - 1).c) || otherSet.contains(this.list.get(this.list.size() - 1).c))) {
                    boolean done = oneSet.contains(this.list.get(this.list.size() - 1).c);
                    this.list.remove(this.list.size() - 1);
                    if (!done) continue;
                    break;
                }
            }
        }

        public boolean empty() {
            return this.list.isEmpty();
        }

        public String summary() {
            return "Unicode Character " + UnicodeUtilities.describe(this.list.get(this.list.size() - 1).c) + " at index " + this.list.get(this.list.size() - 1).i + " has no terminating match";
        }
    }

    public static class StateStackEntry {
        private char c;
        private int i;

        public StateStackEntry(char c, int i) {
            this.c = c;
            this.i = i;
        }
    }
}

