/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.Slotstatus;

public class SlotstatusEnumFactory
implements EnumFactory<Slotstatus> {
    @Override
    public Slotstatus fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("busy".equals(codeString)) {
            return Slotstatus.BUSY;
        }
        if ("free".equals(codeString)) {
            return Slotstatus.FREE;
        }
        if ("busy-unavailable".equals(codeString)) {
            return Slotstatus.BUSYUNAVAILABLE;
        }
        if ("busy-tentative".equals(codeString)) {
            return Slotstatus.BUSYTENTATIVE;
        }
        if ("entered-in-error".equals(codeString)) {
            return Slotstatus.ENTEREDINERROR;
        }
        throw new IllegalArgumentException("Unknown Slotstatus code '" + codeString + "'");
    }

    @Override
    public String toCode(Slotstatus code) {
        if (code == Slotstatus.BUSY) {
            return "busy";
        }
        if (code == Slotstatus.FREE) {
            return "free";
        }
        if (code == Slotstatus.BUSYUNAVAILABLE) {
            return "busy-unavailable";
        }
        if (code == Slotstatus.BUSYTENTATIVE) {
            return "busy-tentative";
        }
        if (code == Slotstatus.ENTEREDINERROR) {
            return "entered-in-error";
        }
        return "?";
    }

    @Override
    public String toSystem(Slotstatus code) {
        return code.getSystem();
    }
}

