/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.OrientationType;

public class OrientationTypeEnumFactory
implements EnumFactory<OrientationType> {
    @Override
    public OrientationType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("sense".equals(codeString)) {
            return OrientationType.SENSE;
        }
        if ("antisense".equals(codeString)) {
            return OrientationType.ANTISENSE;
        }
        throw new IllegalArgumentException("Unknown OrientationType code '" + codeString + "'");
    }

    @Override
    public String toCode(OrientationType code) {
        if (code == OrientationType.SENSE) {
            return "sense";
        }
        if (code == OrientationType.ANTISENSE) {
            return "antisense";
        }
        return "?";
    }

    @Override
    public String toSystem(OrientationType code) {
        return code.getSystem();
    }
}

