/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import org.apache.commons.lang3.StringUtils;

public class ValidateUtil {
    public static void isGreaterThan(long theValue, long theMinimum, String theMessage) {
        if (theValue <= theMinimum) {
            throw new IllegalArgumentException(Msg.code(1762) + theMessage);
        }
    }

    public static void isGreaterThanOrEqualTo(long theValue, long theMinimum, String theMessage) {
        if (theValue < theMinimum) {
            throw new IllegalArgumentException(Msg.code(1763) + theMessage);
        }
    }

    public static void isNotBlankOrThrowIllegalArgument(String theString, String theMessage) {
        if (StringUtils.isBlank(theString)) {
            throw new IllegalArgumentException(Msg.code(1764) + theMessage);
        }
    }

    public static void isNotBlankOrThrowInvalidRequest(String theString, String theMessage) {
        if (StringUtils.isBlank(theString)) {
            throw new InvalidRequestException(Msg.code(1765) + theMessage);
        }
    }

    public static void isNotBlankOrThrowUnprocessableEntity(String theString, String theMessage) {
        if (StringUtils.isBlank(theString)) {
            throw new UnprocessableEntityException(Msg.code(1766) + theMessage);
        }
    }

    public static void isNotNullOrThrowUnprocessableEntity(Object theObject, String theMessage, Object ... theValues) {
        if (theObject == null) {
            throw new UnprocessableEntityException(Msg.code(1767) + String.format(theMessage, theValues));
        }
    }

    public static void isNotTooLongOrThrowIllegalArgument(String theString, int theMaxLength, String theMessage) {
        if (StringUtils.length(theString) > theMaxLength) {
            throw new IllegalArgumentException(Msg.code(1768) + theMessage);
        }
    }

    public static void isTrueOrThrowInvalidRequest(boolean theSuccess, String theMessage, Object ... theValues) {
        if (!theSuccess) {
            throw new InvalidRequestException(Msg.code(1769) + String.format(theMessage, theValues));
        }
    }

    public static void exactlyOneNotNullOrThrowInvalidRequestException(Object[] theObjects, String theMessage) {
        int count = 0;
        for (Object next : theObjects) {
            if (next == null) continue;
            ++count;
        }
        if (count != 1) {
            throw new InvalidRequestException(Msg.code(1770) + theMessage);
        }
    }
}

