/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;

public class PropertyModifyingHelper {
    public static final String GET_PROPERTY_METHOD_NAME = "getProperty";
    public static final String SET_PROPERTY_METHOD_NAME = "setProperty";
    public static final String DEFAULT_DELIMITER = ", ";
    private IBase myBase;
    private String myDelimiter = ", ";
    private FhirContext myFhirContext;

    public PropertyModifyingHelper(FhirContext theFhirContext, IBase theBase) {
        if (this.findGetPropertyMethod(theBase) == null) {
            throw new IllegalArgumentException(Msg.code(1771) + "Specified base instance does not support property retrieval.");
        }
        this.myBase = theBase;
        this.myFhirContext = theFhirContext;
    }

    protected Method getMethod(Object theObject, String theMethodName, Class ... theParamClasses) {
        for (Method m3 : theObject.getClass().getDeclaredMethods()) {
            if (!m3.getName().equals(theMethodName)) continue;
            if (theParamClasses.length == 0) {
                return m3;
            }
            if (m3.getParameterCount() != theParamClasses.length) continue;
            for (int i = 0; i < theParamClasses.length; ++i) {
                if (m3.getParameterTypes()[i].isAssignableFrom(theParamClasses[i])) continue;
            }
            return m3;
        }
        return null;
    }

    public String getFields(String ... theFiledNames) {
        return Arrays.stream(theFiledNames).map(this::get).filter(s2 -> !StringUtils.isBlank(s2)).collect(Collectors.joining(this.getDelimiter()));
    }

    public String get(String thePropertyName) {
        return this.getMultiple(thePropertyName).stream().collect(Collectors.joining(this.getDelimiter()));
    }

    public void set(String thePropertyName, String theValue) {
        if (theValue == null || theValue.isEmpty()) {
            return;
        }
        try {
            Object value = this.myFhirContext.getElementDefinition("string").newInstance(theValue);
            Method setPropertyMethod = this.findSetPropertyMethod(this.myBase, Integer.TYPE, String.class, value.getClass());
            int hashCode = thePropertyName.hashCode();
            setPropertyMethod.invoke((Object)this.myBase, hashCode, thePropertyName, value);
        }
        catch (Exception e) {
            throw new IllegalStateException(Msg.code(1772) + String.format("Unable to set property %s on %s", thePropertyName, this.myBase), e);
        }
    }

    public List<String> getMultiple(String thePropertyName) {
        Object[] values;
        Method getPropertyMethod = this.findGetPropertyMethod(this.myBase);
        try {
            values = (Object[])getPropertyMethod.invoke((Object)this.myBase, thePropertyName.hashCode(), thePropertyName, true);
        }
        catch (Exception e) {
            throw new IllegalStateException(Msg.code(1773) + String.format("Instance %s does not supply property %s", this.myBase, thePropertyName), e);
        }
        return Arrays.stream(values).map(String::valueOf).filter(s2 -> !StringUtils.isEmpty(s2)).collect(Collectors.toList());
    }

    private Method findGetPropertyMethod(IBase theAddress) {
        return this.getMethod(theAddress, GET_PROPERTY_METHOD_NAME, new Class[0]);
    }

    private Method findSetPropertyMethod(IBase theAddress, Class ... theParamClasses) {
        return this.getMethod(theAddress, SET_PROPERTY_METHOD_NAME, theParamClasses);
    }

    public String getDelimiter() {
        return this.myDelimiter;
    }

    public void setDelimiter(String theDelimiter) {
        this.myDelimiter = theDelimiter;
    }

    public IBase getBase() {
        return this.myBase;
    }
}

