/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.gclient;

import ca.uhn.fhir.model.base.composite.BaseIdentifierDt;
import ca.uhn.fhir.rest.gclient.BaseClientParam;
import ca.uhn.fhir.rest.gclient.ICriterion;
import ca.uhn.fhir.rest.gclient.IParam;
import ca.uhn.fhir.rest.gclient.TokenCriterion;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseCoding;

public class TokenClientParam
extends BaseClientParam
implements IParam {
    private static final String[] EMPTY_STRING_LIST = new String[0];
    private String myParamName;

    public TokenClientParam(String theParamName) {
        this.myParamName = theParamName;
    }

    public IMatches exactly() {
        return new IMatches(){

            @Override
            public ICriterion<TokenClientParam> code(String theCode) {
                return new TokenCriterion(TokenClientParam.this.getParamName(), null, theCode);
            }

            @Override
            public ICriterion<?> codes(Collection<String> theCodes) {
                return new TokenCriterion(TokenClientParam.this.getParamName(), theCodes);
            }

            @Override
            public ICriterion<?> codes(String ... theCodes) {
                return new TokenCriterion(TokenClientParam.this.getParamName(), (Collection<String>)this.convertToList(theCodes));
            }

            private List<String> convertToList(String[] theValues) {
                String[] values = ObjectUtils.defaultIfNull(theValues, EMPTY_STRING_LIST);
                return Arrays.asList(values);
            }

            @Override
            public ICriterion<TokenClientParam> identifier(BaseIdentifierDt theIdentifier) {
                return new TokenCriterion(TokenClientParam.this.getParamName(), theIdentifier.getSystemElement().getValueAsString(), (String)theIdentifier.getValueElement().getValue());
            }

            @Override
            public ICriterion<TokenClientParam> identifier(String theIdentifier) {
                return new TokenCriterion(TokenClientParam.this.getParamName(), null, theIdentifier);
            }

            @Override
            public ICriterion<TokenClientParam> identifiers(BaseIdentifierDt ... theIdentifiers) {
                return new TokenCriterion(TokenClientParam.this.getParamName(), Arrays.asList(theIdentifiers));
            }

            @Override
            public ICriterion<TokenClientParam> identifiers(List<BaseIdentifierDt> theIdentifiers) {
                return new TokenCriterion(TokenClientParam.this.getParamName(), theIdentifiers);
            }

            @Override
            public ICriterion<TokenClientParam> systemAndCode(String theSystem, String theCode) {
                return new TokenCriterion(TokenClientParam.this.getParamName(), StringUtils.defaultString(theSystem), theCode);
            }

            @Override
            public ICriterion<TokenClientParam> systemAndIdentifier(String theSystem, String theCode) {
                return new TokenCriterion(TokenClientParam.this.getParamName(), StringUtils.defaultString(theSystem), theCode);
            }

            @Override
            public ICriterion<?> systemAndValues(String theSystem, Collection<String> theValues) {
                return new TokenCriterion(TokenClientParam.this.getParamName(), StringUtils.defaultString(theSystem), theValues);
            }

            @Override
            public ICriterion<?> systemAndValues(String theSystem, String ... theValues) {
                return new TokenCriterion(TokenClientParam.this.getParamName(), StringUtils.defaultString(theSystem), this.convertToList(theValues));
            }

            @Override
            public ICriterion<?> codings(IBaseCoding ... theCodings) {
                return new TokenCriterion(TokenClientParam.this.getParamName(), theCodings);
            }
        };
    }

    @Override
    public String getParamName() {
        return this.myParamName;
    }

    public ICriterion<TokenClientParam> hasSystemWithAnyCode(String theSystem) {
        return new TokenCriterion(this.getParamName(), theSystem, (String)null);
    }

    public static interface IMatches {
        public ICriterion<TokenClientParam> code(String var1);

        public ICriterion<?> codes(Collection<String> var1);

        public ICriterion<?> codes(String ... var1);

        public ICriterion<?> codings(IBaseCoding ... var1);

        public ICriterion<TokenClientParam> identifier(BaseIdentifierDt var1);

        public ICriterion<TokenClientParam> identifier(String var1);

        public ICriterion<TokenClientParam> identifiers(BaseIdentifierDt ... var1);

        public ICriterion<TokenClientParam> identifiers(List<BaseIdentifierDt> var1);

        public ICriterion<TokenClientParam> systemAndCode(String var1, String var2);

        public ICriterion<TokenClientParam> systemAndIdentifier(String var1, String var2);

        public ICriterion<?> systemAndValues(String var1, Collection<String> var2);

        public ICriterion<?> systemAndValues(String var1, String ... var2);
    }
}

