/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.parser.path;

import ca.uhn.fhir.parser.path.EncodeContextPathElement;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class EncodeContextPath {
    private final List<EncodeContextPathElement> myPath;
    private final ArrayList<EncodeContextPathElement> myResourcePath = new ArrayList(10);

    public EncodeContextPath() {
        this(new ArrayList<EncodeContextPathElement>(10));
    }

    public EncodeContextPath(String thePath) {
        this();
        StringTokenizer tok = new StringTokenizer(thePath, ".");
        boolean first = true;
        while (tok.hasMoreTokens()) {
            String next = tok.nextToken();
            if (first && next.equals("*")) {
                this.getPath().add(new EncodeContextPathElement("*", true));
            } else if (StringUtils.isNotBlank(next)) {
                this.getPath().add(new EncodeContextPathElement(next, Character.isUpperCase(next.charAt(0))));
            }
            first = false;
        }
    }

    public EncodeContextPath(List<EncodeContextPathElement> thePath) {
        this.myPath = thePath;
    }

    public String toString() {
        return this.myPath.stream().map(t -> t.toString()).collect(Collectors.joining("."));
    }

    public List<EncodeContextPathElement> getPath() {
        return this.myPath;
    }

    public EncodeContextPath getCurrentResourcePath() {
        EncodeContextPath retVal = null;
        for (int i = this.myPath.size() - 1; i >= 0; --i) {
            if (!this.myPath.get(i).isResource()) continue;
            retVal = new EncodeContextPath(this.myPath.subList(i, this.myPath.size()));
            break;
        }
        Validate.isTrue(retVal != null);
        return retVal;
    }

    public void pushPath(String thePathElement, boolean theResource) {
        assert (StringUtils.isNotBlank(thePathElement));
        assert (!thePathElement.contains("."));
        assert (theResource ^ Character.isLowerCase(thePathElement.charAt(0)));
        EncodeContextPathElement element = new EncodeContextPathElement(thePathElement, theResource);
        this.getPath().add(element);
        if (theResource) {
            this.myResourcePath.add(element);
        }
    }

    public void popPath() {
        EncodeContextPathElement removed = this.getPath().remove(this.getPath().size() - 1);
        if (removed.isResource()) {
            this.myResourcePath.remove(this.myResourcePath.size() - 1);
        }
    }

    public ArrayList<EncodeContextPathElement> getResourcePath() {
        return this.myResourcePath;
    }

    public String getLeafElementName() {
        return this.getPath().get(this.getPath().size() - 1).getName();
    }

    public String getLeafResourceName() {
        return this.myResourcePath.get(this.myResourcePath.size() - 1).getName();
    }

    public String getLeafResourcePathFirstField() {
        String retVal = null;
        for (int i = this.getPath().size() - 1; i >= 0 && !this.getPath().get(i).isResource(); --i) {
            retVal = this.getPath().get(i).getName();
        }
        return retVal;
    }

    public boolean startsWith(EncodeContextPath theCurrentResourcePath, boolean theAllowSymmmetrical) {
        for (int i = 0; i < this.getPath().size(); ++i) {
            EncodeContextPathElement actual;
            if (theCurrentResourcePath.getPath().size() == i) {
                return true;
            }
            EncodeContextPathElement expected = this.getPath().get(i);
            if (expected.matches(actual = theCurrentResourcePath.getPath().get(i))) continue;
            return false;
        }
        if (theAllowSymmmetrical) {
            return true;
        }
        return this.getPath().size() == theCurrentResourcePath.getPath().size();
    }

    public boolean equalsPath(String thePath) {
        EncodeContextPath parsedPath = new EncodeContextPath(thePath);
        return this.getPath().equals(parsedPath.getPath());
    }
}

