/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.narrative2;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.narrative2.INarrativeTemplate;
import ca.uhn.fhir.narrative2.NarrativeTemplateManifest;
import ca.uhn.fhir.narrative2.TemplateTypeEnum;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IBase;

public class NarrativeTemplate
implements INarrativeTemplate {
    private String myTemplateFileName;
    private Set<String> myAppliesToProfiles = new HashSet<String>();
    private Set<String> myAppliesToResourceTypes = new HashSet<String>();
    private Set<String> myAppliesToDataTypes = new HashSet<String>();
    private Set<Class<? extends IBase>> myAppliesToClasses = new HashSet<Class<? extends IBase>>();
    private TemplateTypeEnum myTemplateType = TemplateTypeEnum.THYMELEAF;
    private String myContextPath;
    private String myTemplateName;

    public Set<String> getAppliesToDataTypes() {
        return Collections.unmodifiableSet(this.myAppliesToDataTypes);
    }

    @Override
    public String getContextPath() {
        return this.myContextPath;
    }

    public void setContextPath(String theContextPath) {
        this.myContextPath = theContextPath;
    }

    private String getTemplateFileName() {
        return this.myTemplateFileName;
    }

    void setTemplateFileName(String theTemplateFileName) {
        this.myTemplateFileName = theTemplateFileName;
    }

    @Override
    public Set<String> getAppliesToProfiles() {
        return Collections.unmodifiableSet(this.myAppliesToProfiles);
    }

    void addAppliesToProfile(String theAppliesToProfile) {
        this.myAppliesToProfiles.add(theAppliesToProfile);
    }

    @Override
    public Set<String> getAppliesToResourceTypes() {
        return Collections.unmodifiableSet(this.myAppliesToResourceTypes);
    }

    void addAppliesToResourceType(String theAppliesToResourceType) {
        this.myAppliesToResourceTypes.add(theAppliesToResourceType);
    }

    @Override
    public Set<Class<? extends IBase>> getAppliesToClasses() {
        return Collections.unmodifiableSet(this.myAppliesToClasses);
    }

    void addAppliesToClass(Class<? extends IBase> theAppliesToClass) {
        this.myAppliesToClasses.add(theAppliesToClass);
    }

    @Override
    public TemplateTypeEnum getTemplateType() {
        return this.myTemplateType;
    }

    void setTemplateType(TemplateTypeEnum theTemplateType) {
        this.myTemplateType = theTemplateType;
    }

    @Override
    public String getTemplateName() {
        return this.myTemplateName;
    }

    NarrativeTemplate setTemplateName(String theTemplateName) {
        this.myTemplateName = theTemplateName;
        return this;
    }

    @Override
    public String getTemplateText() {
        try {
            return NarrativeTemplateManifest.loadResource(this.getTemplateFileName());
        }
        catch (IOException e) {
            throw new InternalErrorException(Msg.code(1866) + e);
        }
    }

    void addAppliesToDatatype(String theDataType) {
        this.myAppliesToDataTypes.add(theDataType);
    }
}

