/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.api;

import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;

public enum TemporalPrecisionEnum {
    YEAR(1){

        @Override
        public Date add(Date theInput, int theAmount) {
            return DateUtils.addYears(theInput, theAmount);
        }
    }
    ,
    MONTH(2){

        @Override
        public Date add(Date theInput, int theAmount) {
            return DateUtils.addMonths(theInput, theAmount);
        }
    }
    ,
    DAY(5){

        @Override
        public Date add(Date theInput, int theAmount) {
            return DateUtils.addDays(theInput, theAmount);
        }
    }
    ,
    MINUTE(12){

        @Override
        public Date add(Date theInput, int theAmount) {
            return DateUtils.addMinutes(theInput, theAmount);
        }
    }
    ,
    SECOND(13){

        @Override
        public Date add(Date theInput, int theAmount) {
            return DateUtils.addSeconds(theInput, theAmount);
        }
    }
    ,
    MILLI(14){

        @Override
        public Date add(Date theInput, int theAmount) {
            return DateUtils.addMilliseconds(theInput, theAmount);
        }
    };

    private int myCalendarConstant;

    private TemporalPrecisionEnum(int theCalendarConstant) {
        this.myCalendarConstant = theCalendarConstant;
    }

    public abstract Date add(Date var1, int var2);

    public int getCalendarConstant() {
        return this.myCalendarConstant;
    }

    public int stringLength() {
        switch (this) {
            case YEAR: {
                return 4;
            }
            case MONTH: {
                return 7;
            }
            case DAY: {
                return 10;
            }
            case MINUTE: {
                return 16;
            }
            case SECOND: {
                return 19;
            }
            case MILLI: {
                return 23;
            }
        }
        return 0;
    }
}

