/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.api.definitions;

import au.csiro.pathling.api.definitions.FhirConversionSupport;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Resource;

public class R4FhirConversionSupport
extends FhirConversionSupport {
    private static final long serialVersionUID = -367070946615790595L;

    @Override
    public String fhirType(IBase base) {
        return base.fhirType();
    }

    @Override
    public List<IBaseResource> extractEntryFromBundle(IBaseBundle bundle, String resourceName) {
        Bundle r4Bundle = (Bundle)bundle;
        return r4Bundle.getEntry().stream().map(Bundle.BundleEntryComponent::getResource).filter(resource -> resource != null && resourceName.equalsIgnoreCase(resource.getResourceType().name())).collect(Collectors.toList());
    }

    @Override
    public IBaseBundle wrapInBundle(IBaseResource ... resources) {
        Bundle bundle = new Bundle();
        bundle.setType(Bundle.BundleType.TRANSACTION);
        Stream.of(resources).forEach(baseResource -> {
            Resource resource = (Resource)baseResource;
            Bundle.BundleEntryComponent bundleEntry = bundle.addEntry();
            bundleEntry.setResource(resource);
            Bundle.BundleEntryRequestComponent request = bundleEntry.getRequest();
            request.setMethod(Bundle.HTTPVerb.POST);
            request.setUrl(this.fhirType((IBase)baseResource));
        });
        return bundle;
    }
}

