/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.api;

import au.csiro.pathling.api.definitions.FhirConversionSupport;
import au.csiro.pathling.encoders.FhirEncoders;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.parser.IParser;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import scala.Tuple2;

public class Bundles {
    private final FhirVersionEnum fhirVersion;

    private Bundles(FhirVersionEnum fhirVersion) {
        this.fhirVersion = fhirVersion;
    }

    @Nonnull
    public static Bundles forR4() {
        return new Bundles(FhirVersionEnum.R4);
    }

    @Nonnull
    public JavaRDD<BundleContainer> loadFromDirectory(@Nonnull SparkSession spark, @Nonnull String path, int minPartitions) {
        return spark.sparkContext().wholeTextFiles(path, minPartitions).toJavaRDD().map((Function)new ToBundle(this.fhirVersion));
    }

    @Nonnull
    public JavaRDD<BundleContainer> fromJson(@Nonnull Dataset<Row> jsonBundles, @Nonnull String column) {
        return this.fromJson((Dataset<String>)jsonBundles.select(column, new String[0]).as(Encoders.STRING()));
    }

    @Nonnull
    public JavaRDD<BundleContainer> fromJson(@Nonnull Dataset<String> jsonBundles) {
        return jsonBundles.toJavaRDD().map((Function)new StringToBundle(false, this.fhirVersion));
    }

    @Nonnull
    public JavaRDD<BundleContainer> fromResourceJson(@Nonnull Dataset<Row> jsonBundles, @Nonnull String column) {
        return this.fromResourceJson((Dataset<String>)jsonBundles.select(column, new String[0]).as(Encoders.STRING()));
    }

    @Nonnull
    public JavaRDD<BundleContainer> fromResourceJson(@Nonnull Dataset<String> jsonBundles) {
        return jsonBundles.toJavaRDD().map((Function)new ResourceStringToBundle(false, this.fhirVersion));
    }

    @Nonnull
    public JavaRDD<BundleContainer> fromXml(@Nonnull Dataset<Row> xmlBundles, @Nonnull String column) {
        return this.fromXml((Dataset<String>)xmlBundles.select(column, new String[0]).as(Encoders.STRING()));
    }

    @Nonnull
    public JavaRDD<BundleContainer> fromXml(@Nonnull Dataset<String> xmlBundles) {
        return xmlBundles.toJavaRDD().map((Function)new StringToBundle(true, this.fhirVersion));
    }

    @Nonnull
    public Dataset<Row> extractEntry(@Nonnull SparkSession spark, @Nonnull JavaRDD<BundleContainer> bundles, @Nonnull Class<? extends IBaseResource> resourceClass) {
        RuntimeResourceDefinition definition = FhirEncoders.contextFor(this.fhirVersion).getResourceDefinition(resourceClass);
        return this.extractEntry(spark, bundles, definition.getName());
    }

    @Nonnull
    public Dataset<Row> extractEntry(@Nonnull SparkSession spark, @Nonnull JavaRDD<BundleContainer> bundles, @Nonnull String resourceName) {
        return this.extractEntry(spark, bundles, resourceName, null, null, null);
    }

    @Nonnull
    public Dataset<Row> extractEntry(@Nonnull SparkSession spark, @Nonnull JavaRDD<BundleContainer> bundles, @Nonnull String resourceName, @Nullable Integer maxNestingLevel, @Nullable Boolean enableExtensions, @Nullable List<String> enabledOpenTypes) {
        ToResources bundleToResources = new ToResources(resourceName, this.fhirVersion);
        FhirEncoders.Builder encoderBuilder = FhirEncoders.forR4();
        if (Objects.nonNull(maxNestingLevel)) {
            encoderBuilder = encoderBuilder.withMaxNestingLevel(maxNestingLevel);
        }
        if (Objects.nonNull(enableExtensions)) {
            encoderBuilder = encoderBuilder.withExtensionsEnabled(enableExtensions);
        }
        if (Objects.nonNull(enabledOpenTypes)) {
            encoderBuilder = encoderBuilder.withOpenTypes(enabledOpenTypes.stream().collect(Collectors.toUnmodifiableSet()));
        }
        ExpressionEncoder fhirEncoder = encoderBuilder.getOrCreate().of(resourceName);
        JavaRDD resourceRdd = bundles.flatMap((FlatMapFunction)bundleToResources);
        return spark.createDataset(resourceRdd.rdd(), fhirEncoder).toDF();
    }

    private static class ToResources
    implements FlatMapFunction<BundleContainer, IBaseResource> {
        private static final long serialVersionUID = -4045613071523148731L;
        private transient String resourceName;
        private transient FhirVersionEnum fhirVersion;
        private transient FhirConversionSupport support;

        ToResources(String resourceName, FhirVersionEnum fhirVersion) {
            this.resourceName = resourceName;
            this.fhirVersion = fhirVersion;
            this.support = FhirConversionSupport.supportFor(fhirVersion);
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
            stream.writeUTF(this.resourceName);
            stream.writeObject((Object)this.fhirVersion);
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            this.resourceName = stream.readUTF();
            this.fhirVersion = (FhirVersionEnum)((Object)stream.readObject());
            this.support = FhirConversionSupport.supportFor(this.fhirVersion);
        }

        public Iterator<IBaseResource> call(BundleContainer bundle) {
            return this.support.extractEntryFromBundle(bundle.bundle, this.resourceName).iterator();
        }
    }

    private static class ToBundle
    implements Function<Tuple2<String, String>, BundleContainer> {
        private static final long serialVersionUID = -2968044192169273050L;
        private FhirVersionEnum fhirVersion;
        private transient IParser xmlParser;
        private transient IParser jsonParser;

        ToBundle(FhirVersionEnum fhirVersion) {
            this.fhirVersion = fhirVersion;
            this.xmlParser = FhirEncoders.contextFor(fhirVersion).newXmlParser();
            this.jsonParser = FhirEncoders.contextFor(fhirVersion).newJsonParser();
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            this.xmlParser = FhirEncoders.contextFor(this.fhirVersion).newXmlParser();
            this.jsonParser = FhirEncoders.contextFor(this.fhirVersion).newJsonParser();
        }

        public BundleContainer call(Tuple2<String, String> fileContentTuple) {
            String filePath = ((String)fileContentTuple._1).toLowerCase();
            if (filePath.endsWith(".xml")) {
                return new BundleContainer((IBaseBundle)this.xmlParser.parseResource((String)fileContentTuple._2()), this.fhirVersion);
            }
            if (filePath.endsWith(".json")) {
                return new BundleContainer((IBaseBundle)this.jsonParser.parseResource((String)fileContentTuple._2()), this.fhirVersion);
            }
            throw new RuntimeException("Unrecognized file extension for resource: " + filePath);
        }
    }

    private static class ResourceStringToBundle
    implements Function<String, BundleContainer> {
        private static final long serialVersionUID = -4252301955516679442L;
        private boolean isXml;
        private FhirVersionEnum fhirVersion;
        private transient IParser parser;
        private transient FhirConversionSupport support;

        ResourceStringToBundle(boolean isXml, FhirVersionEnum fhirVersion) {
            this.isXml = isXml;
            this.fhirVersion = fhirVersion;
            this.parser = isXml ? FhirEncoders.contextFor(fhirVersion).newXmlParser() : FhirEncoders.contextFor(fhirVersion).newJsonParser();
            this.support = FhirConversionSupport.supportFor(fhirVersion);
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            this.parser = this.isXml ? FhirEncoders.contextFor(this.fhirVersion).newXmlParser() : FhirEncoders.contextFor(this.fhirVersion).newJsonParser();
            this.support = FhirConversionSupport.supportFor(this.fhirVersion);
        }

        public BundleContainer call(String resourceString) {
            IBaseResource resource = this.parser.parseResource(resourceString);
            IBaseBundle bundle = this.support.wrapInBundle(resource);
            return new BundleContainer(bundle, this.fhirVersion);
        }
    }

    private static class StringToBundle
    implements Function<String, BundleContainer> {
        private static final long serialVersionUID = 1446227753373965483L;
        private boolean isXml;
        private FhirVersionEnum fhirVersion;
        private transient IParser parser;

        StringToBundle(boolean isXml, FhirVersionEnum fhirVersion) {
            this.isXml = isXml;
            this.fhirVersion = fhirVersion;
            this.parser = isXml ? FhirEncoders.contextFor(fhirVersion).newXmlParser() : FhirEncoders.contextFor(fhirVersion).newJsonParser();
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            this.parser = this.isXml ? FhirEncoders.contextFor(this.fhirVersion).newXmlParser() : FhirEncoders.contextFor(this.fhirVersion).newJsonParser();
        }

        public BundleContainer call(String bundleString) {
            IBaseBundle bundle = (IBaseBundle)this.parser.parseResource(bundleString);
            return new BundleContainer(bundle, this.fhirVersion);
        }
    }

    public static class BundleContainer
    implements Serializable {
        private static final long serialVersionUID = -3586519835921650592L;
        private FhirVersionEnum fhirVersion;
        private transient IBaseBundle bundle;

        BundleContainer(IBaseBundle bundle, FhirVersionEnum fhirVersion) {
            this.bundle = bundle;
            this.fhirVersion = fhirVersion;
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
            String encodedBundle = FhirEncoders.contextFor(this.fhirVersion).newJsonParser().encodeResourceToString(this.bundle);
            stream.writeObject(encodedBundle);
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            String encodedBundle = (String)stream.readObject();
            this.bundle = (IBaseBundle)FhirEncoders.contextFor(this.fhirVersion).newJsonParser().parseResource(encodedBundle);
        }

        public List<IBaseResource> extractResource(String name) {
            return FhirConversionSupport.supportFor(this.fhirVersion).extractEntryFromBundle(this.bundle, name);
        }

        public IBaseBundle getBundle() {
            return this.bundle;
        }
    }
}

