"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScalableInstanceCount = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const appscaling = require("aws-cdk-lib/aws-applicationautoscaling");
/**
 * A scalable sagemaker endpoint attribute
 */
class ScalableInstanceCount extends appscaling.BaseScalableAttribute {
    /**
     * Constructs a new instance of the ScalableInstanceCount class.
     */
    constructor(scope, id, props) {
        super(scope, id, props);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_sagemaker_alpha_ScalableInstanceCountProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ScalableInstanceCount);
            }
            throw error;
        }
    }
    /**
     * Scales in or out to achieve a target requests per second per instance.
     */
    scaleOnInvocations(id, props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_sagemaker_alpha_InvocationsScalingProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.scaleOnInvocations);
            }
            throw error;
        }
        const predefinedMetric = appscaling.PredefinedMetric.SAGEMAKER_VARIANT_INVOCATIONS_PER_INSTANCE;
        super.doScaleToTrackMetric(id, {
            policyName: props.policyName,
            disableScaleIn: props.disableScaleIn,
            scaleInCooldown: props.scaleInCooldown,
            scaleOutCooldown: props.scaleOutCooldown,
            targetValue: this.calculateScalingTarget(props),
            predefinedMetric,
        });
    }
    /**
     * Calculate target value based on a ScalableProductionVariant
     *
     * Documentation for the equation is here: https://docs.aws.amazon.com/sagemaker/latest/dg/endpoint-scaling-loadtest.html
     * @param props the scaling properties.
     */
    calculateScalingTarget(props) {
        const safetyFactor = props.safetyFactor ?? 0.5;
        if (safetyFactor <= 0.0 || safetyFactor > 1.0) {
            throw new Error(`Safety factor (${safetyFactor}) must be greater than 0.0 and less than or equal 1.0`);
        }
        return safetyFactor * props.maxRequestsPerSecond * 60;
    }
}
_a = JSII_RTTI_SYMBOL_1;
ScalableInstanceCount[_a] = { fqn: "@aws-cdk/aws-sagemaker-alpha.ScalableInstanceCount", version: "2.79.1-alpha.0" };
exports.ScalableInstanceCount = ScalableInstanceCount;
//# sourceMappingURL=data:application/json;base64,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